/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.energy;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import blackhole.utils.BlackHoleUtils;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Hitboxc;
import mindustry.gen.Shieldc;
import progressed.entities.effect.FlashEffect;
import progressed.entities.effect.WrapDataEffect;
import progressed.graphics.renders.PMRenders;

public class UltraRailgunBulletType
extends BulletType {
    public static final Effect defaultShockwave = new Effect(360.0f, 28800.0f, e -> {
        float radius = ((Float)e.data).floatValue();
        e.lifetime = 3.0f * Mathf.sqrt((float)radius);
        float thinScl = 0.05f;
        float thickScl = 0.5f;
        int sides = Lines.circleVertices((float)(radius *= e.fin((Interp)Interp.pow3Out)));
        float space = 360.0f / (float)sides;
        Draw.color((Color)Color.white, (float)(0.8f * e.fout((Interp)Interp.pow3Out)));
        for (int i = 0; i < sides; ++i) {
            float ang = space * (float)i;
            float ang2 = ang + space;
            float x1 = Mathf.cosDeg((float)ang) * radius * thinScl;
            float y1 = Mathf.sinDeg((float)ang) * radius;
            float x2 = Mathf.cosDeg((float)ang2) * radius * thinScl;
            float y2 = Mathf.sinDeg((float)ang2) * radius;
            float x3 = x2 * thickScl;
            float y3 = y2 * thickScl;
            float x4 = x1 * thickScl;
            float y4 = y1 * thickScl;
            Fill.quad((float)(e.x + Angles.trnsx((float)e.rotation, (float)x1, (float)y1)), (float)(e.y + Angles.trnsy((float)e.rotation, (float)x1, (float)y1)), (float)(e.x + Angles.trnsx((float)e.rotation, (float)x2, (float)y2)), (float)(e.y + Angles.trnsy((float)e.rotation, (float)x2, (float)y2)), (float)(e.x + Angles.trnsx((float)e.rotation, (float)x3, (float)y3)), (float)(e.y + Angles.trnsy((float)e.rotation, (float)x3, (float)y3)), (float)(e.x + Angles.trnsx((float)e.rotation, (float)x4, (float)y4)), (float)(e.y + Angles.trnsy((float)e.rotation, (float)x4, (float)y4)));
        }
    }).layer(99.97f);
    public float accel = 1.0f;
    public float hitSpeedLossPerHitsize = 0.1f;
    public float maxSpeedLoss = 20.0f;
    public float minSpeed;
    public Color[] colors = new Color[]{Color.valueOf((String)"ffffff55"), Color.valueOf((String)"ffffffaa"), Color.white};
    public float strokeFrom = 1.25f;
    public float strokeTo = 0.25f;
    public float width = 8.0f;
    public float glowWidth = 64.0f;
    public float fadeInTime = 15.0f;
    public float fadeOutTime = 120.0f;
    public Effect shockwaveEffect = defaultShockwave;
    public float minSizeThreshold = 15.0f;
    public float maxSizeThreshold = 50.0f;
    public float thresholdDecreaseMaxHealth = 100000.0f;
    public float shockwaveSizeScl = 8.0f;
    public Effect endShockwaveEffect = new FlashEffect((Effect)new WrapDataEffect(defaultShockwave, Float.valueOf(600.0f)), 30.0f);
    public Effect endEffect;

    public UltraRailgunBulletType(float minSpeed, float speed, float damage) {
        super(speed, damage);
        this.minSpeed = Math.max(0.001f, minSpeed);
        this.pierceBuilding = true;
        this.pierce = true;
        this.pierceDamageFactor = 1.0f;
        this.hittable = false;
        this.absorbable = false;
        this.drawSize = 28800.0f;
        this.hitSize = 12.0f;
        this.hitEffect = this.despawnEffect = Fx.none;
    }

    public void init() {
        super.init();
        if (this.endEffect == null) {
            this.endEffect = new Effect(this.fadeOutTime, this.drawSize, e -> {
                Tmp.v1.trns(e.rotation, ((Float)e.data).floatValue());
                this.drawBeam(e.x - Tmp.v1.x, e.y - Tmp.v1.y, e.x, e.y, e.fout() * 0.9f, e.fout());
            });
        }
    }

    public void init(Bullet b) {
        super.init(b);
    }

    public void hitEntity(Bullet b, Hitboxc entity, float health) {
        float shield = 0.0f;
        if (entity instanceof Shieldc) {
            Shieldc s = (Shieldc)entity;
            shield = s.shield();
        }
        super.hitEntity(b, entity, health += shield);
        this.handleShockwave(b, entity.hitSize(), health);
        this.hitSpeedLoss(b, entity.hitSize());
    }

    public void hitTile(Bullet b, Building build, float x, float y, float initialHealth, boolean direct) {
        super.hitTile(b, build, x, y, initialHealth, direct);
        this.handleShockwave(b, build.hitSize(), initialHealth);
        this.hitSpeedLoss(b, build.hitSize());
    }

    protected void hitSpeedLoss(Bullet b, float hitSize) {
        float loss = Math.min(this.maxSpeedLoss, this.hitSpeedLossPerHitsize * hitSize);
        b.vel.setLength(Math.max(this.minSpeed, b.vel.len() - loss));
    }

    protected void handleShockwave(Bullet b, float hitSize, float health) {
        if (b.damage <= 0.0f) {
            this.endShockwaveEffect.at(b.x, b.y, b.rotation());
        } else {
            float thresh = Mathf.lerp((float)this.maxSizeThreshold, (float)this.minSizeThreshold, (float)Mathf.clamp((float)(health / this.thresholdDecreaseMaxHealth)));
            if (hitSize >= thresh) {
                this.shockwaveEffect.at(b.x, b.y, b.rotation(), (Object)Float.valueOf(hitSize * this.shockwaveSizeScl));
            }
        }
    }

    public void update(Bullet b) {
        super.update(b);
        b.vel.setLength(Math.min(this.speed, b.vel.len() + this.accel * Time.delta));
    }

    public void removed(Bullet b) {
        super.removed(b);
        this.endEffect.at(b.x, b.y, Angles.angle((float)b.originX, (float)b.originY, (float)b.x, (float)b.y), (Object)Float.valueOf(Mathf.dst((float)b.originX, (float)b.originY, (float)b.x, (float)b.y)));
    }

    public void draw(Bullet b) {
        this.drawBeam(b.originX, b.originY, b.x, b.y, Mathf.curve((float)b.time, (float)0.0f, (float)this.fadeInTime) * 0.9f, 1.0f);
    }

    protected void drawBeam(float x1, float y1, float x2, float y2, float dim, float scl) {
        if (dim >= 0.0f) {
            PMRenders.dimAlpha(dim);
        }
        PMRenders.dimGlowLine(x1, y1, x2, y2, this.glowWidth, scl);
        for (int i = 0; i < this.colors.length; ++i) {
            Draw.color((Color)this.colors[i]);
            float colorFin = (float)i / (float)(this.colors.length - 1);
            float baseStroke = Mathf.lerp((float)this.strokeFrom, (float)this.strokeTo, (float)colorFin);
            Lines.stroke((float)(baseStroke * this.width * scl));
            Lines.line((float)x1, (float)y1, (float)x2, (float)y2, (boolean)false);
        }
    }

    static {
        BlackHoleUtils.immuneBulletTypes.add(UltraRailgunBulletType.class);
    }
}

