/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.energy;

import arc.audio.Sound;
import arc.math.geom.Position;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import progressed.content.effects.MissileFx;

public class SparkingBulletType
extends BasicBulletType {
    protected static boolean empHit;
    public float empRadius = 24.0f;
    public float empInterval = 20.0f;
    public float empDamage = -1.0f;
    public float slowDown = 0.5f;
    public float slowDownDuration = 600.0f;
    public boolean hitUnits = true;
    public float unitDamageScl = 0.5f;
    public Effect hitPowerEffect = MissileFx.hitEmpSpark;
    public Effect chainEffect = Fx.chainEmp;
    public Sound empSound = Sounds.spark;

    public SparkingBulletType(float speed, float damage, String bulletSprite) {
        super(speed, damage, bulletSprite);
    }

    public SparkingBulletType(float speed, float damage) {
        super(speed, damage);
    }

    public SparkingBulletType() {
    }

    public void load() {
        super.load();
        if (this.empDamage < 0.0f) {
            this.empDamage = this.damage * 2.0f;
        }
    }

    public void update(Bullet b) {
        super.update(b);
        if (b.timer.get(3, this.empInterval)) {
            empHit = false;
            Vars.indexer.allBuildings(b.x, b.y, this.empRadius, other -> {
                if (other.team != b.team && other.power != null) {
                    Building absorber = Damage.findAbsorber((Team)b.team, (float)b.x, (float)b.y, (float)other.x, (float)other.y);
                    if (absorber != null) {
                        other = absorber;
                    }
                    if (other.power != null && other.power.graph.getLastPowerProduced() > 0.0f) {
                        other.applySlowdown(this.slowDown, this.slowDownDuration);
                        other.damage(this.empDamage);
                        this.hitPowerEffect.at(other.x, other.y, b.angleTo((Position)other), this.hitColor);
                        this.chainEffect.at(b.x, b.y, 0.0f, this.hitColor, other);
                        empHit = true;
                    }
                }
            });
            if (this.hitUnits) {
                Units.nearbyEnemies((Team)b.team, (float)b.x, (float)b.y, (float)this.empRadius, other -> {
                    if (other.team != b.team && other.hittable()) {
                        Building absorber = Damage.findAbsorber((Team)b.team, (float)b.x, (float)b.y, (float)other.x, (float)other.y);
                        if (absorber != null) {
                            return;
                        }
                        this.hitPowerEffect.at(other.x, other.y, b.angleTo((Position)other), this.hitColor);
                        this.chainEffect.at(b.x, b.y, 0.0f, this.hitColor, other);
                        other.damage(this.empDamage * this.unitDamageScl);
                        other.apply(this.status, this.statusDuration);
                        empHit = true;
                    }
                });
            }
            if (empHit) {
                this.empSound.at((Position)b);
            }
        }
    }
}

