/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.energy;

import arc.func.Cons;
import arc.graphics.Color;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.struct.IntSeq;
import arc.util.Tmp;
import blackhole.utils.BlackHoleUtils;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Fires;
import mindustry.entities.Puddles;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.world.Tile;
import progressed.content.PMLiquids;
import progressed.content.effects.LightningFx;
import progressed.content.effects.OtherFx;
import progressed.entities.LightningEffect;
import progressed.entities.PMDamage;
import progressed.graphics.PMPal;
import progressed.util.PMMathf;

public class MagmaBulletType
extends BulletType {
    public float radius;
    public float shake;
    public int crackEffects = 1;
    public float crackRadius = -1.0f;
    public float groundRise = 4.0f;
    public Color crackColor = PMPal.darkBrown;
    public LightningEffect crackEffect = LightningFx.groundCrack;

    public MagmaBulletType(float damage, float radius) {
        super(0.001f, damage);
        this.radius = radius;
        this.hitEffect = Fx.fireballsmoke;
        this.shootEffect = this.smokeEffect = Fx.none;
        this.despawnEffect = this.smokeEffect;
        this.lifetime = 16.0f;
        this.hitColor = PMPal.magma;
        this.makeFire = true;
        this.keepVelocity = false;
        this.absorbable = false;
        this.hittable = false;
        this.collidesTiles = false;
        this.collides = false;
        this.collidesGround = true;
        this.collidesAir = false;
        this.puddleLiquid = PMLiquids.magma;
        this.puddleAmount = 250.0f;
        this.displayAmmoMultiplier = false;
        this.status = StatusEffects.melting;
    }

    public float continuousDamage() {
        return this.damage / 5.0f * 60.0f;
    }

    public float estimateDPS() {
        return this.damage * 100.0f / 5.0f * 3.0f;
    }

    public void init() {
        super.init();
        if (this.crackRadius < 0.0f) {
            this.crackRadius = this.radius * 2.0f;
        }
    }

    public void init(Bullet b) {
        super.init(b);
        b.data = new IntSeq();
    }

    public void update(Bullet b) {
        Object object;
        if (b.timer(1, 5.0f) && (object = b.data) instanceof IntSeq) {
            IntSeq tiles = (IntSeq)object;
            Damage.damage((Team)b.team, (float)b.x, (float)b.y, (float)(this.radius * b.fout()), (float)(this.damage * b.damageMultiplier()), (boolean)true, (boolean)this.collidesAir, (boolean)this.collidesGround);
            if (this.status != StatusEffects.none) {
                Damage.status((Team)b.team, (float)b.x, (float)b.y, (float)(this.radius * b.fout()), (StatusEffect)this.status, (float)this.statusDuration, (boolean)this.collidesAir, (boolean)this.collidesGround);
            }
            Tmp.r1.setSize(this.radius * 2.0f * b.fout()).setCenter(b.x, b.y);
            Units.nearbyEnemies((Team)b.team, (Rect)Tmp.r1, u -> {
                if (u.within((Position)b, this.radius * b.fout())) {
                    if (this.puddleLiquid != null) {
                        Puddles.deposit((Tile)u.tileOn(), (Liquid)this.puddleLiquid, (float)this.puddleAmount);
                    }
                    if (this.makeFire) {
                        Fires.create((Tile)u.tileOn());
                    }
                    tiles.add(u.tileOn().pos());
                }
            });
            PMDamage.trueEachBlock(b.x, b.y, this.radius * b.fout(), (Cons<Building>)((Cons)build -> {
                if (build.team == b.team) {
                    return;
                }
                if (this.puddleLiquid != null) {
                    Puddles.deposit((Tile)build.tileOn(), (Liquid)this.puddleLiquid, (float)this.puddleAmount);
                }
                if (this.makeFire) {
                    Fires.create((Tile)build.tileOn());
                }
            }));
            if (b.fout() == 1.0f) {
                for (int i = 0; i < this.crackEffects; ++i) {
                    PMMathf.randomCirclePoint(Tmp.v1, this.crackRadius).add((Position)b);
                    this.crackEffect.at(b.x, b.y, Tmp.v1.x, Tmp.v1.y, this.crackColor);
                }
            }
            if (this.groundRise > 0.0f) {
                PMDamage.trueEachTile(b.x, b.y, this.radius * b.fout(), (Cons<Tile>)((Cons)tile -> {
                    if (tile != null && tiles.addUnique(tile.pos()) && tile.block() == Blocks.air && tile.overlay() == Blocks.air) {
                        OtherFx.groundRise.at((Position)tile, this.groundRise);
                    }
                }));
            }
        }
        if (this.shake > 0.0f) {
            Effect.shake((float)this.shake, (float)this.shake, (Position)b);
        }
    }

    public void draw(Bullet b) {
    }

    static {
        BlackHoleUtils.immuneBulletTypes.add(MagmaBulletType.class);
    }
}

