/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.energy;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Trail;
import progressed.graphics.PMDrawf;

public class LaserBlastBulletType
extends BulletType {
    public float length;
    public float width;

    public LaserBlastBulletType(float speed, float damage) {
        super(speed, damage);
        this.trailWidth = -1.0f;
        this.shootEffect = this.smokeEffect = Fx.none;
        this.displayAmmoMultiplier = false;
    }

    public void init() {
        super.init();
        if (this.trailWidth < 0.0f) {
            this.trailWidth = this.width / 2.0f;
        }
    }

    public void updateTrail(Bullet b) {
        if (!Vars.headless && this.trailLength > 0) {
            if (b.trail == null) {
                b.trail = new Trail(this.trailLength);
            }
            b.trail.length = this.trailLength;
            Tmp.v1.trns(b.rotation() - 180.0f, this.length / 2.0f - this.width / 2.0f);
            b.trail.update(b.x + Tmp.v1.x, b.y + Tmp.v1.y);
        }
    }

    public void draw(Bullet b) {
        this.drawTrail(b);
        Draw.color((Color)this.hitColor);
        PMDrawf.pill(b.x, b.y, b.rotation(), this.length, this.width);
        Draw.color((Color)Color.white);
        PMDrawf.pill(b.x, b.y, b.rotation(), this.length / 2.0f, this.width / 2.0f);
        Draw.color();
    }
}

