/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.energy;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;
import progressed.content.effects.LightningFx;
import progressed.content.effects.MissileFx;
import progressed.entities.LightningEffect;
import progressed.graphics.PMPal;
import progressed.util.PMMathf;

public class EMPCloudBulletType
extends BulletType {
    protected static Rand cloudRand = new Rand();
    public float radius = 160.0f;
    public float growTime = 120.0f;
    public float empInterval = 20.0f;
    public float timeDuration = 600.0f;
    public float powerDamageScl = 2.0f;
    public float powerSclDecrease = 0.2f;
    public boolean hitUnits = true;
    public float unitDamageScl = 0.5f;
    public Color cloudColor = PMPal.nukeEmp.cpy().a(0.125f);
    public int cloudGroups = 15;
    public int cloudsPerGroup = 6;
    public float cloudLifeMin = 0.9f;
    public float cloudRad = 72.0f;
    public float cloudRadRand = -1.0f;
    public Effect hitPowerEffect = MissileFx.hitEmpSpark;
    public float lightningEffectChance = 0.5f;
    public LightningEffect lightningEffect = LightningFx.empLightning;

    public EMPCloudBulletType(float damage) {
        super(0.0f, damage);
        this.absorbable = false;
        this.hittable = false;
        this.collides = false;
        this.hitEffect = this.despawnEffect = Fx.none;
        this.hitColor = PMPal.nukeEmp;
        this.layer = 110.021f;
    }

    public void init() {
        super.init();
        this.drawSize = Math.max(this.drawSize, (this.radius + this.cloudRad + this.cloudRadRand) * 2.0f);
        if (this.cloudRadRand < 0.0f) {
            this.cloudRadRand = this.cloudRad / 2.0f;
        }
    }

    public float continuousDamage() {
        return this.damage / this.empInterval * 60.0f;
    }

    public void draw(Bullet b) {
        Draw.color((Color)this.cloudColor);
        float scl = this.scl(b);
        for (int i = 0; i < this.cloudGroups; ++i) {
            cloudRand.setSeed((long)(b.id + i));
            float lifeScl = cloudRand.random(this.cloudLifeMin, 1.0f);
            float fin = b.fin() / lifeScl;
            if (fin >= 1.0f) continue;
            Angles.randLenVectors((long)(b.id + i + this.cloudGroups), (float)Interp.pow5Out.apply(Mathf.curve((float)(b.time / lifeScl), (float)0.0f, (float)this.growTime)), (int)this.cloudsPerGroup, (float)(scl * this.radius), (x, y, in, out) -> {
                float fout = Interp.pow5Out.apply(1.0f - fin);
                float rad = scl * fout * (this.cloudRad + cloudRand.range(this.cloudRadRand));
                Fill.circle((float)(b.x + x), (float)(b.y + y), (float)rad);
            });
        }
    }

    public void drawLight(Bullet b) {
        if (this.lightOpacity <= 0.0f || this.lightRadius <= 0.0f) {
            return;
        }
        float scl = Interp.pow3Out.apply(Mathf.curve((float)b.time, (float)0.0f, (float)this.growTime));
        Drawf.light((Position)b, (float)(this.lightRadius * scl), (Color)this.lightColor, (float)this.lightOpacity);
    }

    public void update(Bullet b) {
        super.update(b);
        this.updateLightningEffects(b);
        this.updateEmp(b);
    }

    public void updateLightningEffects(Bullet b) {
        if (this.lightningEffectChance > 0.01f && b.time < b.lifetime - this.lightningEffect.lifetime && Mathf.chanceDelta((double)(this.lightningEffectChance * b.fout((Interp)Interp.pow5Out)))) {
            float rad = this.rad(b);
            PMMathf.randomCirclePoint(Tmp.v1, rad);
            Tmp.v1.add((Position)b);
            float x1 = Tmp.v1.x;
            float y1 = Tmp.v1.y;
            PMMathf.randomCirclePoint(Tmp.v1, rad);
            Tmp.v1.add((Position)b);
            this.lightningEffect.at(x1, y1, Tmp.v1.x, Tmp.v1.y, this.hitColor);
        }
    }

    public void updateEmp(Bullet b) {
        if (!b.timer(3, this.empInterval)) {
            return;
        }
        float rad = this.rad(b);
        Vars.indexer.allBuildings(b.x, b.y, rad, other -> {
            if (other.team != b.team && other.power != null && other.power.graph.getLastPowerProduced() > 0.0f) {
                other.applySlowdown(this.powerSclDecrease, this.timeDuration);
                other.damage(b.damage * this.powerDamageScl);
                this.hitPowerEffect.at(other.x, other.y, b.angleTo((Position)other), this.hitColor);
            }
        });
        if (this.hitUnits) {
            Units.nearbyEnemies((Team)b.team, (float)b.x, (float)b.y, (float)this.radius, other -> {
                if (other.team != b.team && other.hittable()) {
                    this.hitPowerEffect.at(other.x, other.y, b.angleTo((Position)other), this.hitColor);
                    other.damage(this.damage * this.unitDamageScl);
                    other.apply(this.status, this.statusDuration);
                }
            });
        }
    }

    public float scl(Bullet b) {
        return Interp.pow5Out.apply(Mathf.curve((float)b.time, (float)0.0f, (float)this.growTime));
    }

    public float rad(Bullet b) {
        return this.scl(b) * this.radius;
    }
}

