/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.energy;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import progressed.content.PMSounds;
import progressed.content.effects.EnergyFx;
import progressed.graphics.PMPal;

public class BitBulletType
extends BulletType {
    public float size;
    public float trailDelay;

    public BitBulletType(float speed, float damage) {
        super(speed, damage);
        this.shootEffect = Fx.none;
        this.smokeEffect = Fx.none;
        this.hitEffect = this.despawnEffect = EnergyFx.bitBurst;
        this.trailEffect = EnergyFx.bitTrail;
        this.hittable = false;
        this.absorbable = false;
        this.hitSound = PMSounds.pixelHit;
        this.displayAmmoMultiplier = false;
    }

    public BitBulletType() {
        this(1.0f, 1.0f);
    }

    public void update(Bullet b) {
        super.update(b);
        if (b.timer(1, this.trailDelay)) {
            this.trailEffect.at(b.x, b.y, this.size / 2.0f);
        }
    }

    public void draw(Bullet b) {
        float offset = Mathf.randomSeed((long)b.id);
        Color c = Tmp.c1.set(PMPal.pixelFront).lerp(PMPal.pixelBack, Mathf.absin((float)(Time.time * 0.05f + offset), (float)1.0f, (float)1.0f));
        Draw.color((Color)c);
        Fill.rect((float)b.x, (float)b.y, (float)this.size, (float)this.size);
    }
}

