/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.energy;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.bullet.ContinuousBulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;
import progressed.entities.PMDamage;
import progressed.graphics.PMDrawf;

public class BeamBulletType
extends ContinuousBulletType {
    public float growTime = 16.0f;
    public float fadeTime = 16.0f;
    public float length = 160.0f;
    public float width = 9.0f;
    public float oscScl = 0.8f;
    public float oscMag = 1.5f;
    public Interp lengthInterp = Interp.pow3In;
    public Color laserColor;
    public String beamSprite;
    public TextureRegion beam;
    public TextureRegion beamStart;
    public TextureRegion beamEnd;

    public BeamBulletType(float damage, String beamSprite) {
        this.lifetime = 32.0f;
        this.optimalLifeFract = 0.5f;
        this.laserAbsorb = false;
        this.pierceCap = 4;
        this.damage = damage;
        this.beamSprite = beamSprite;
    }

    public void load() {
        super.load();
        this.beam = Core.atlas.find(this.beamSprite);
        this.beamStart = Core.atlas.find(this.beamSprite + "-start");
        this.beamEnd = Core.atlas.find(this.beamSprite + "-end");
    }

    public void draw(Bullet b) {
        float lenScl = Mathf.clamp((float)(b.time < this.growTime ? this.lengthInterp.apply(b.time / this.growTime) : 1.0f));
        float fout = Mathf.clamp((float)(b.time > b.lifetime - this.fadeTime ? 1.0f - (b.time - (this.lifetime - this.fadeTime)) / this.fadeTime : 1.0f));
        float realLength = this.pierceCap <= 0 ? this.length : PMDamage.findPierceLength(b, this.pierceCap, this.length * lenScl);
        Color c = this.laserColor == null ? b.team.color : this.laserColor;
        Tmp.v1.trns(b.rotation(), realLength * 1.1f);
        Draw.color((Color)c);
        PMDrawf.laser(this.beam, this.beamStart, this.beamEnd, b.x, b.y, b.x + Tmp.v1.x, b.y + Tmp.v1.y, (this.width + Mathf.absin((float)Time.time, (float)this.oscScl, (float)this.oscMag)) * fout / 12.0f);
        Draw.color();
        Drawf.light((float)b.x, (float)b.y, (float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)(this.width * 1.4f * b.fout()), (Color)c, (float)0.6f);
    }

    public void drawLight(Bullet b) {
    }

    public float currentLength(Bullet b) {
        float lenScl = Mathf.clamp((float)(b.time < this.growTime ? this.lengthInterp.apply(b.time / this.growTime) : 1.0f));
        return this.length * lenScl;
    }
}

