/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.energy;

import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import blackhole.utils.BlackHoleUtils;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import progressed.entities.PMDamage;

public class AbyssBulletType
extends BulletType {
    public float length = 80.0f;
    public int swirlEffects = 10;
    public float maxSwirlDelay = 5.0f;
    public float swirlRad = -1.0f;
    public Effect beamEffect = Fx.none;
    public Effect swirlEffect = Fx.none;
    public Effect growEffect = Fx.none;

    public AbyssBulletType() {
        super(0.01f, 0.0f);
        this.hitEffect = this.despawnEffect = Fx.none;
        this.shootEffect = Fx.hitLancer;
        this.smokeEffect = Fx.none;
        this.keepVelocity = false;
        this.collides = false;
        this.hittable = false;
        this.absorbable = false;
        this.scaledSplashDamage = true;
    }

    public void init() {
        super.init();
        if (this.swirlRad < 0.0f) {
            this.swirlRad = this.splashDamageRadius;
        }
    }

    protected float calculateRange() {
        return Math.max(this.length, this.maxRange);
    }

    public void init(Bullet b) {
        super.init(b);
        Tmp.v1.set(PMDamage.linecast(this.collidesGround, this.collidesAir, b.team, b.x, b.y, b.rotation(), this.length));
        if (this.beamEffect != Fx.none) {
            this.beamEffect.at(b.x, b.y, b.angleTo((Position)Tmp.v1), (Object)new Vec2(Tmp.v1));
        }
        b.set((Position)Tmp.v1);
        if (this.swirlEffect != Fx.none) {
            for (int i = 0; i < this.swirlEffects; ++i) {
                Time.run((float)(Mathf.random() * this.maxSwirlDelay), () -> this.swirlEffect.at(b.x, b.y, this.swirlRad));
            }
        }
        if (this.growEffect != Fx.none) {
            this.growEffect.at(b.x, b.y, b.team.color);
        }
    }

    static {
        BlackHoleUtils.immuneBulletTypes.add(AbyssBulletType.class);
    }
}

