/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet;

import arc.math.Angles;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Bullet;

public class SnakeBulletType
extends BasicBulletType {
    public int length = 3;
    public float spawnDelay = 5.0f;
    public float followPower = 0.85f;
    public boolean setSegments = true;
    public SnakeBulletType head;
    public SnakeBulletType body;
    public SnakeBulletType tail;

    public SnakeBulletType(float speed, float damage, String bulletSprite) {
        super(speed, damage, bulletSprite);
    }

    public void init() {
        super.init();
        if (this.setSegments) {
            if (this.body == null) {
                this.body = (SnakeBulletType)this.copy();
                this.body.setSegments = false;
            }
            if (this.head == null) {
                this.head = (SnakeBulletType)this.body.copy();
                this.head.sprite = this.head.sprite + "-head";
                this.head.setSegments = false;
            }
            if (this.tail == null) {
                this.tail = (SnakeBulletType)this.body.copy();
                this.tail.sprite = this.tail.sprite + "-tail";
                this.head.setSegments = false;
            }
        }
        this.length = Math.max(this.length, 3);
    }

    public void init(Bullet b) {
        super.init(b);
        if (b.data == null) {
            Bullet[] next = new Bullet[]{null};
            float x = b.x;
            float y = b.y;
            for (int i = 0; i < this.length; ++i) {
                int ii = i;
                Time.run((float)((float)i * this.spawnDelay), () -> {
                    Bullet seg;
                    SnakeBulletType bType = this.body;
                    SnakeBulletData.SegmentType sType = SnakeBulletData.SegmentType.body;
                    if (ii == 0) {
                        bType = this.head;
                        sType = SnakeBulletData.SegmentType.head;
                    } else if (ii == this.length - 1) {
                        bType = this.tail;
                        sType = SnakeBulletData.SegmentType.tail;
                    }
                    next[0] = seg = bType.create(b.owner, b.team, x, y, next[0] != null ? next[0].angleTo(x, y) + 180.0f : b.rotation(), -1.0f, 1.0f, 1.0f, new SnakeBulletData(sType, next[0]));
                });
            }
            b.time = b.lifetime;
            b.remove();
        }
    }

    public void despawned(Bullet b) {
        if (b.data == null) {
            return;
        }
        super.despawned(b);
    }

    public void update(Bullet b) {
        this.updateTrail(b);
        SnakeBulletData data = (SnakeBulletData)b.data;
        if (data == null) {
            return;
        }
        if (data.segmentType == SnakeBulletData.SegmentType.head) {
            this.updateHoming(b);
            this.updateWeaving(b);
        } else if (data.followBullet != null) {
            if (data.followBullet.isAdded()) {
                b.vel.setAngle(Angles.moveToward((float)b.rotation(), (float)b.angleTo((Position)data.followBullet), (float)(this.followPower * Time.delta * 50.0f)));
            } else {
                data.followBullet = null;
            }
        }
        this.updateTrailEffects(b);
        this.updateBulletInterval(b);
    }

    public static class SnakeBulletData {
        public SegmentType segmentType;
        public Bullet followBullet;

        public SnakeBulletData(SegmentType type, Bullet b) {
            this.segmentType = type;
            this.followBullet = b;
        }

        public static enum SegmentType {
            head,
            body,
            tail;

        }
    }
}

