/*
 * Decompiled with CFR 0.152.
 */
package progressed.content.effects;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.Effect;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.SteamVent;
import progressed.graphics.PMDrawf;
import progressed.graphics.PMPal;
import progressed.type.unit.SignalFlareUnitType;
import progressed.util.PMUtls;

public class OtherFx {
    public static final Effect groundRise = new Effect(30.0f, e -> {
        Tile t = Vars.world.tileWorld(e.x, e.y);
        if (t == null) {
            return;
        }
        Floor f = t.floor();
        if (f instanceof SteamVent) {
            return;
        }
        TextureRegion region = f.variantRegions[Mathf.randomSeed((long)t.pos(), (int)0, (int)Math.max(0, f.variantRegions.length - 1))];
        float x = t.drawx();
        float y = t.drawy() + e.rotation * e.fout();
        Draw.z((float)(Draw.z() - (float)t.y / (float)Vars.world.height() / 1000.0f));
        for (int i = 0; i < region.width; ++i) {
            PixmapRegion image = Core.atlas.getPixmap(region);
            float c1 = Tmp.c1.set(image.get(i, 0)).toFloatBits();
            float c2 = Tmp.c2.set(Tmp.c1).lerp(Color.black, e.fout() / 4.0f).toFloatBits();
            float px = x - (float)region.width / 4.0f / 2.0f + (float)i / 4.0f;
            float py = y - (float)region.height / 4.0f / 2.0f;
            float by = py - e.rotation * e.fout();
            float p = 0.125f;
            Fill.quad((float)(px - p), (float)by, (float)c2, (float)(px - p), (float)py, (float)c1, (float)(px + p), (float)py, (float)c1, (float)(px + p), (float)by, (float)c2);
        }
        Draw.rect((TextureRegion)region, (float)x, (float)y);
    }).layer(0.01f);
    public static final Effect concretionSlam = new Effect(23.0f, e -> {
        Draw.color((Color)Tmp.c1.set(e.color).mul(1.1f));
        Angles.randLenVectors((long)e.id, (int)6, (float)(10.0f * e.finpow()), (float)e.rotation, (float)15.0f, (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 4.0f + 0.4f)));
    }).layer(0.0f);
    public static final Effect earthquke = new Effect(10.0f, 100.0f, e -> {
        float rad = e.rotation;
        Draw.color((Color)PMPal.darkBrown);
        int points = 3;
        for (int i = 0; i < points; ++i) {
            float angle = Mathf.randomSeedRange((long)(e.id + i), (float)360.0f);
            float length = Mathf.randomSeed((long)((long)e.id * 2L + (long)i), (float)(rad / 6.0f), (float)rad);
            Drawf.tri((float)(e.x + Angles.trnsx((float)angle, (float)rad)), (float)(e.y + Angles.trnsy((float)angle, (float)rad)), (float)6.0f, (float)(length * e.fout() / 4.0f), (float)angle);
            Drawf.tri((float)(e.x + Angles.trnsx((float)angle, (float)rad)), (float)(e.y + Angles.trnsy((float)angle, (float)rad)), (float)6.0f, (float)(length * e.fout()), (float)(angle + 180.0f));
        }
    }).layer(0.0f);
    public static final Effect pillarPlace = new Effect(15.0f, e -> {
        Draw.color((Color)PMPal.darkBrown);
        Angles.randLenVectors((long)e.id, (int)6, (float)(4.0f + 20.0f * e.fin()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(4.0f * e.fout())));
    }).layer(29.5f);
    public static final Effect pillarBlast = new Effect(20.0f, e -> {
        Draw.color((Color)Pal.bulletYellow);
        e.scaled(6.0f, s -> {
            Lines.stroke((float)(3.0f * s.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(3.0f + s.fin() * 6.0f));
        });
        Draw.color((Color)Pal.lightPyraFlame);
        e.scaled(15.0f, s -> Angles.randLenVectors((long)e.id, (int)3, (float)(2.0f + 13.0f * s.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(s.fout() * 3.0f + 0.5f))));
        Draw.color((Color)Color.gray);
        Angles.randLenVectors((long)(e.id + 1), (int)3, (float)(2.0f + 16.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * 3.0f + 0.5f)));
        Draw.color((Color)Pal.lightPyraFlame);
        Lines.stroke((float)e.fout());
        Angles.randLenVectors((long)(e.id + 2), (int)4, (float)(1.0f + 16.0f * e.finpow()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Angles.angle((float)x, (float)y), (float)(1.0f + e.fout() * 3.0f)));
        Drawf.light((float)e.x, (float)e.y, (float)50.0f, (Color)Pal.lightPyraFlame, (float)(0.8f * e.fout()));
    });
    public static final Effect critPierce = new Effect(20.0f, e -> {
        float rot = e.rotation - 90.0f;
        float fin = e.fin((Interp)Interp.pow5Out);
        float end = e.lifetime - 6.0f;
        float fout = 1.0f - Interp.pow2Out.apply(Mathf.curve((float)e.time, (float)end, (float)e.lifetime));
        float width = fin * fout;
        e.scaled(7.0f, s -> {
            Lines.stroke((float)(0.5f + s.fout()));
            Draw.color((Color)Color.white, (Color)e.color, (float)s.fin());
            Lines.circle((float)(e.x + Angles.trnsx((float)rot, (float)0.0f, (float)(5.0f * fin))), (float)(e.y + Angles.trnsy((float)rot, (float)0.0f, (float)(5.0f * fin))), (float)(s.fin() * 6.0f));
        });
        Draw.color((Color)Color.white, (Color)e.color, (float)Mathf.curve((float)e.time, (float)0.0f, (float)end));
        Fill.quad((float)(e.x + Angles.trnsx((float)rot, (float)0.0f, (float)(2.0f * fin))), (float)(e.y + Angles.trnsy((float)rot, (float)0.0f, (float)(2.0f * fin))), (float)(e.x + Angles.trnsx((float)rot, (float)(4.0f * width), (float)(-4.0f * fin))), (float)(e.y + Angles.trnsy((float)rot, (float)(4.0f * width), (float)(-4.0f * fin))), (float)(e.x + Angles.trnsx((float)rot, (float)0.0f, (float)(8.0f * fin))), (float)(e.y + Angles.trnsy((float)rot, (float)0.0f, (float)(8.0f * fin))), (float)(e.x + Angles.trnsx((float)rot, (float)(-4.0f * width), (float)(-4.0f * fin))), (float)(e.y + Angles.trnsy((float)rot, (float)(-4.0f * width), (float)(-4.0f * fin))));
    });
    public static final Effect miniCrit = new Effect(90.0f, e -> {
        Tmp.v1.trns(e.rotation + 90.0f, 0.0f, 32.0f * e.fin((Interp)Interp.pow2Out));
        Draw.color((Color)e.color, (float)e.fout());
        Angles.randLenVectors((long)e.id, (int)2, (float)18.0f, (x, y) -> {
            float rot = Mathf.randomSeed((long)((long)((float)e.id + x + y)), (float)360.0f);
            float tx = x * e.fin((Interp)Interp.pow2Out);
            float ty = y * e.fin((Interp)Interp.pow2Out);
            PMDrawf.plus(e.x + tx + Tmp.v1.x, e.y + ty + Tmp.v1.y, 3.0f, rot);
        });
    });
    public static final Effect crit = new Effect(120.0f, e -> {
        Tmp.v1.trns(e.rotation + 90.0f, 0.0f, 48.0f * e.fin((Interp)Interp.pow2Out));
        Draw.color((Color)e.color, (float)e.fout());
        Angles.randLenVectors((long)e.id, (int)6, (float)24.0f, (x, y) -> {
            float rot = Mathf.randomSeed((long)((long)((float)e.id + x + y)), (float)360.0f);
            float tx = x * e.fin((Interp)Interp.pow2Out);
            float ty = y * e.fin((Interp)Interp.pow2Out);
            PMDrawf.plus(e.x + tx + Tmp.v1.x, e.y + ty + Tmp.v1.y, 4.0f, rot);
        });
    });
    public static final Effect swordStab = new Effect(24.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.crimson, (float)e.fin());
        e.scaled(15.0f, s -> {
            Lines.stroke((float)(s.fout() * 1.5f));
            Lines.circle((float)e.x, (float)e.y, (float)(8.0f * s.fin()));
        });
        Lines.stroke((float)1.0f);
        Angles.randLenVectors((long)e.id, (int)16, (float)(8.0f * e.fin()), (float)e.rotation, (float)180.0f, (x, y) -> {
            float ang = Angles.angle((float)x, (float)y);
            Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fslope() * 4.0f));
        });
    });
    public static final Effect flare = new Effect(50.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.gray, (float)e.fin());
        Angles.randLenVectors((long)e.id, (int)2, (float)(e.fin() * 4.0f * e.rotation), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(0.1f + e.fslope() * 0.6f * e.rotation)));
        Draw.color();
        Drawf.light((float)e.x, (float)e.y, (float)(20.0f * e.fslope()), (Color)Pal.lightFlame, (float)0.5f);
    });
    public static final Effect linkActivation = new Effect(30.0f, e -> {
        Lines.stroke((float)(e.fout() * 1.5f), (Color)e.color);
        Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * 12.0f * 8.0f));
    });
    public static final Effect staticSpark = new Effect(10.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(e.fout() * 1.5f));
        Angles.randLenVectors((long)e.id, (int)7, (float)(e.finpow() * 27.0f), (float)e.rotation, (float)45.0f, (x, y) -> {
            float ang = Angles.angle((float)x, (float)y);
            Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * 4.0f + 1.0f));
        });
    });
    public static final Effect fard = new Effect(30.0f, 500.0f, e -> {
        float intensity = 8.0f;
        float baseLifetime = 25.0f + intensity * 15.0f;
        e.lifetime = 50.0f + intensity * 64.0f;
        Draw.color((Color)Color.brown);
        Draw.alpha((float)0.9f);
        int i = 0;
        while (i < 5) {
            PMUtls.rand.setSeed((long)e.id * 2L + (long)i);
            float lenScl = PMUtls.rand.random(0.25f, 1.0f);
            int fi = i++;
            e.scaled(e.lifetime * lenScl, s -> Angles.randLenVectors((long)(s.id + fi - 1), (float)s.fin((Interp)Interp.pow10Out), (int)((int)(2.8f * intensity)), (float)(25.0f * intensity), (x, y, in, out) -> {
                float fout = s.fout((Interp)Interp.pow5Out) * PMUtls.rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 2.35f);
                Fill.circle((float)(s.x + x), (float)(s.y + y), (float)rad);
                Drawf.light((float)(s.x + x), (float)(s.y + y), (float)(rad * 2.6f), (Color)Draw.getColor(), (float)0.7f);
            }));
        }
        e.scaled(baseLifetime, s -> {
            Draw.color();
            s.scaled(2.0f + intensity * 2.0f, i -> {
                Lines.stroke((float)((3.1f + intensity / 5.0f) * i.fout()));
                Lines.circle((float)s.x, (float)s.y, (float)((3.0f + i.fin() * 14.0f) * intensity));
                Drawf.light((float)s.x, (float)s.y, (float)(i.fin() * 28.0f * 2.0f * intensity), (Color)Draw.getColor(), (float)(0.9f * s.fout()));
            });
            Draw.color((Color)Color.tan, (Color)Color.brick, (float)s.fin());
            Lines.stroke((float)(2.0f * s.fout()));
            Draw.z((float)110.001f);
            Angles.randLenVectors((long)(s.id + 1), (float)(s.finpow() + 0.001f), (int)((int)(8.0f * intensity)), (float)(30.0f * intensity), (x, y, in, out) -> {
                Lines.lineAngle((float)(s.x + x), (float)(s.y + y), (float)Angles.angle((float)x, (float)y), (float)(1.0f + out * 4.0f * (4.0f + intensity)));
                Drawf.light((float)(s.x + x), (float)(s.y + y), (float)(out * 4.0f * (3.0f + intensity) * 3.5f), (Color)Draw.getColor(), (float)0.8f);
            });
        });
    }).layer(59.0f);

    public static Effect flareFallEffect(SignalFlareUnitType flare) {
        return new Effect(1.0f / flare.fallSpeed, e -> {
            float rot = 90.0f * e.fout() - 90.0f;
            flare.drawSoftShadow(e.x, e.y, rot, e.fout());
            Draw.alpha((float)e.fout());
            Draw.rect((TextureRegion)flare.region, (float)e.x, (float)e.y, (float)((float)flare.region.width / 4.0f), (float)((float)flare.region.height / 4.0f * e.rotation), (float)rot);
            Draw.color((Color)e.color, (float)e.fout());
            Draw.rect((TextureRegion)flare.cellRegion, (float)e.x, (float)e.y, (float)((float)flare.cellRegion.width / 4.0f), (float)((float)flare.cellRegion.height / 4.0f * e.rotation), (float)rot);
        }).layer(flare.groundLayer);
    }
}

