/*
 * Decompiled with CFR 0.152.
 */
package progressed.content.bullets;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.abilities.MoveEffectAbility;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.ExplosionBulletType;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.effect.WaveEffect;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.Weapon;
import mindustry.type.unit.MissileUnitType;
import progressed.content.PMSounds;
import progressed.content.PMStatusEffects;
import progressed.content.PMUnitTypes;
import progressed.content.effects.MissileFx;
import progressed.content.effects.Pseudo3DFx;
import progressed.entities.bullet.energy.EMPCloudBulletType;
import progressed.entities.bullet.energy.SlashBlackHoleBulletType;
import progressed.entities.bullet.pseudo3d.ArcBombBulletType;
import progressed.entities.bullet.pseudo3d.ArcMissileBulletType;
import progressed.entities.bullet.unit.SentryBulletType;
import progressed.entities.effect.RepeatEffect;
import progressed.graphics.PMPal;
import progressed.type.unit.RocketUnitType;
import progressed.type.weapons.MissileOwnerWeapon;

public class PayloadBullets {
    public static SentryBulletType barrageLaunch;
    public static SentryBulletType strikedownLaunch;
    public static BulletType arbalestBasic;
    public static BulletType arbalestIncend;
    public static BulletType arbalestSplitter;
    public static ArcMissileBulletType artemisBasic;
    public static ArcMissileBulletType artemisRecursive;
    public static ArcMissileBulletType artemisBombing;
    public static ArcMissileBulletType paragonBasic;
    public static ArcMissileBulletType paragonCluster;
    public static ArcMissileBulletType paragonEMP;
    public static ArcMissileBulletType paragonBlackHole;
    public static ArcMissileBulletType ohno;

    public static void load() {
        barrageLaunch = new SentryBulletType(PMUnitTypes.barrage);
        strikedownLaunch = new SentryBulletType(PMUnitTypes.strikedown);
        arbalestBasic = new BulletType(0.0f, 0.0f){
            {
                this.ammoMultiplier = 1.0f;
                this.shootEffect = this.smokeEffect = Fx.none;
                this.spawnUnit = new RocketUnitType("basic-rocket-b", true){
                    {
                        super(name, addSmokeTrail);
                        this.engineColor = this.trailColor = PMPal.missileBasic;
                        this.weapons.add((Object)new Weapon(){
                            {
                                this.rotate = false;
                                this.shootCone = 360.0f;
                                this.mirror = false;
                                this.reload = 1.0f;
                                deathExplosionEffect = MissileFx.missileExplosion;
                                this.shootOnDeath = true;
                                this.shake = 10.0f;
                                this.shootSound = Sounds.none;
                                this.bullet = new ExplosionBulletType(526.0f, 64.0f){
                                    {
                                        super(splashDamage, splashDamageRadius);
                                        this.hitColor = PMPal.missileBasic;
                                        this.shootEffect = RocketUnitType.rocketShoot;
                                    }
                                };
                            }
                        });
                    }
                };
            }
        };
        arbalestIncend = new BulletType(0.0f, 0.0f){
            {
                this.ammoMultiplier = 1.0f;
                this.shootEffect = this.smokeEffect = Fx.none;
                this.spawnUnit = new RocketUnitType("incendiary-rocket-b", true){
                    {
                        super(name, addSmokeTrail);
                        this.engineColor = this.trailColor = Pal.remove;
                        this.weapons.add((Object)new Weapon(){
                            {
                                this.rotate = false;
                                this.shootCone = 360.0f;
                                this.mirror = false;
                                this.reload = 1.0f;
                                deathExplosionEffect = new MultiEffect(new Effect[]{MissileFx.missileExplosion, MissileFx.flameRing});
                                this.shootOnDeath = true;
                                this.shake = 10.0f;
                                this.shootSound = Sounds.none;
                                this.bullet = new ExplosionBulletType(526.0f, 64.0f){
                                    {
                                        super(splashDamage, splashDamageRadius);
                                        this.hitColor = Pal.remove;
                                        this.shootEffect = RocketUnitType.rocketShoot;
                                        this.makeFire = true;
                                        this.status = PMStatusEffects.incendiaryBurn;
                                    }
                                };
                            }
                        });
                    }
                };
            }
        };
        arbalestSplitter = new BulletType(0.0f, 0.0f){
            {
                this.ammoMultiplier = 1.0f;
                this.shootEffect = this.smokeEffect = Fx.none;
                this.spawnUnit = new RocketUnitType("splitter-rocket-b", true){
                    {
                        super(name, addSmokeTrail);
                        this.engineColor = this.trailColor = Pal.accent;
                        this.weapons.add((Object)new MissileOwnerWeapon(){
                            {
                                this.shootCone = 360.0f;
                                this.rotateSpeed = 0.0f;
                                this.mirror = false;
                                this.reload = 1.0f;
                                deathExplosionEffect = MissileFx.missileExplosion;
                                this.shootOnDeath = true;
                                this.shake = 10.0f;
                                this.shootSound = Sounds.missileLarge;
                                this.bullet = new ExplosionBulletType(150.0f, 64.0f){
                                    {
                                        super(splashDamage, splashDamageRadius);
                                        this.hitColor = Pal.accent;
                                        this.shootEffect = RocketUnitType.rocketShoot;
                                        this.fragBullets = 3;
                                        this.fragAngle = 180.0f;
                                        this.fragRandomSpread = 120.0f;
                                        this.fragBullet = new BulletType(){
                                            {
                                                this.spawnUnit = new RocketUnitType("splitter-rocket-split", false){
                                                    {
                                                        super(name, addSmokeTrail);
                                                        this.health = 120.0f;
                                                        this.engineColor = this.trailColor = Pal.accent;
                                                        this.homingDelay = 20.0f;
                                                        this.missileAccelTime = 30.0f;
                                                        this.targetDelay = 30.0f;
                                                        this.lifetime /= 2.0f;
                                                        this.rotateSpeed = 6.0f;
                                                        this.engineSize = 2.5f;
                                                        this.engineOffset = 8.25f;
                                                        this.loopSoundVolume = 0.3f;
                                                        this.weapons.add((Object)new MissileOwnerWeapon(){
                                                            {
                                                                this.shootCone = 360.0f;
                                                                this.rotateSpeed = 0.0f;
                                                                this.mirror = false;
                                                                this.reload = 1.0f;
                                                                deathExplosionEffect = MissileFx.missileExplosion;
                                                                this.shootOnDeath = true;
                                                                this.shake = 5.0f;
                                                                this.shootSound = Sounds.missileSmall;
                                                                this.bullet = new ExplosionBulletType(150.0f, 64.0f){
                                                                    {
                                                                        super(splashDamage, splashDamageRadius);
                                                                        this.hitColor = Pal.accent;
                                                                        this.fragBullets = 3;
                                                                        this.fragAngle = 180.0f;
                                                                        this.fragRandomSpread = 120.0f;
                                                                        this.fragBullet = new BulletType(){
                                                                            {
                                                                                this.spawnUnit = new RocketUnitType("splitter-rocket-bit", false){
                                                                                    {
                                                                                        super(name, addSmokeTrail);
                                                                                        this.health = 60.0f;
                                                                                        this.engineColor = this.trailColor = Pal.accent;
                                                                                        this.homingDelay = 15.0f;
                                                                                        this.missileAccelTime = 20.0f;
                                                                                        this.targetDelay = 20.0f;
                                                                                        this.lifetime /= 3.0f;
                                                                                        this.rotateSpeed = 10.0f;
                                                                                        this.deathSound = Sounds.explosion;
                                                                                        this.engineSize = 1.75f;
                                                                                        this.engineOffset = 4.75f;
                                                                                        this.loopSoundVolume = 0.1f;
                                                                                        this.weapons.add((Object)new MissileOwnerWeapon(){
                                                                                            {
                                                                                                this.shootCone = 360.0f;
                                                                                                this.rotateSpeed = 0.0f;
                                                                                                this.mirror = false;
                                                                                                this.reload = 1.0f;
                                                                                                deathExplosionEffect = MissileFx.smallBoom;
                                                                                                this.shootOnDeath = true;
                                                                                                this.shake = 1.0f;
                                                                                                this.shootSound = Sounds.none;
                                                                                                this.bullet = new ExplosionBulletType(150.0f, 64.0f){
                                                                                                    {
                                                                                                        super(splashDamage, splashDamageRadius);
                                                                                                        this.hitColor = PMPal.missileFrag;
                                                                                                    }
                                                                                                };
                                                                                            }
                                                                                        });
                                                                                    }
                                                                                };
                                                                            }
                                                                        };
                                                                    }
                                                                };
                                                            }
                                                        });
                                                    }
                                                };
                                            }
                                        };
                                    }
                                };
                            }
                        });
                    }
                };
            }
        };
        artemisBasic = new ArcMissileBulletType("prog-mats-basic-missile"){
            {
                this.splashDamage = 750.0f;
                this.splashDamageRadius = 48.0f;
                this.buildingDamageMultiplier = 0.5f;
                this.hitShake = 5.0f;
                this.gravity = 0.12f;
                this.trailLength = 25;
                this.trailWidth = 1.0f;
                this.targetColor = this.zoneColor = PMPal.missileBasic;
                this.trailColor = this.zoneColor;
            }
        };
        artemisRecursive = new ArcMissileBulletType("prog-mats-recursive-missile"){
            {
                this.status = StatusEffects.none;
                this.zoneRadius = 40.0f;
                this.trailLength = 25;
                this.trailWidth = 1.0f;
                this.targetColor = this.zoneColor = PMPal.missileFrag;
                this.trailColor = this.zoneColor;
                this.hitEffect = this.despawnEffect = Fx.none;
                this.hitSound = this.despawnSound = Sounds.none;
                this.accel = 0.015f;
                this.gravity = 0.05f;
                this.lifetimeScl = 0.33f;
                this.arcFragCone = 0.6f;
                this.fragBullets = 3;
                this.fragBullet = new ArcMissileBulletType("prog-mats-recursive-missile-split"){
                    {
                        super(sprite);
                        this.status = StatusEffects.none;
                        this.zoneRadius = 28.0f;
                        this.trailLength = 20;
                        this.trailWidth = 1.0f;
                        this.targetColor = this.zoneColor = PMPal.missileFrag;
                        this.trailColor = this.zoneColor;
                        this.growTime = 30.0f;
                        this.hitEffect = this.despawnEffect = Fx.none;
                        this.hitSound = this.despawnSound = Sounds.none;
                        this.keepVelocity = true;
                        this.gravity = 0.05f;
                        this.angleDriftDrag = 0.01f;
                        this.lifetimeScl = 0.5f;
                        this.arcFragCone = 0.7f;
                        this.fragBullets = 3;
                        this.fragBullet = new ArcMissileBulletType("prog-mats-recursive-missile-split"){
                            {
                                super(sprite);
                                this.splashDamage = 220.0f;
                                this.splashDamageRadius = 32.0f;
                                this.buildingDamageMultiplier = 0.5f;
                                this.hitShake = 5.0f;
                                this.hitEffect = MissileFx.smallBoom;
                                this.hitSound = Sounds.explosion;
                                this.drawZone = false;
                                this.growTime = 30.0f;
                                this.keepVelocity = true;
                                this.gravity = 0.05f;
                                this.angleDriftDrag = 0.01f;
                                this.trailLength = 15;
                                this.trailWidth = 1.0f;
                                this.targetColor = this.zoneColor = PMPal.missileFrag;
                                this.trailColor = this.zoneColor;
                                this.absorbEffect = Pseudo3DFx.absorbedSmall;
                            }
                        };
                    }
                };
            }
        };
        artemisBombing = new ArcMissileBulletType("prog-mats-bombing-missile"){
            {
                this.splashDamage = 200.0f;
                this.splashDamageRadius = 32.0f;
                this.buildingDamageMultiplier = 0.5f;
                this.hitShake = 5.0f;
                this.lifetime = 240.0f;
                this.scaleLife = false;
                this.trailLength = 25;
                this.trailWidth = 1.0f;
                this.targetColor = this.zoneColor = Pal.suppress;
                this.trailColor = this.zoneColor;
                this.accel = 0.03f;
                this.gravity = 0.05f;
                this.bulletInterval = 20.0f;
                this.intervalDelay = 45.0f;
                this.intervalRandomSpread = 0.0f;
                this.intervalBullet = new ArcBombBulletType(300.0f, 24.0f, "prog-mats-bombing-missile-bomb"){
                    {
                        super(damage, radius, sprite);
                        this.accel = 0.0f;
                        this.buildingDamageMultiplier = 0.5f;
                        this.homingPower = 8.0f;
                        this.drawZone = false;
                        this.growTime = 6.0f;
                        this.targetColor = this.zoneColor = Pal.suppress;
                        this.trailColor = this.zoneColor;
                        this.trailLength = 12;
                        this.trailWidth = 1.0f;
                    }
                };
            }
        };
        paragonBasic = new ArcMissileBulletType("prog-mats-basic-nuke"){
            {
                this.splashDamage = 27000.0f;
                this.splashDamageRadius = 192.0f;
                this.buildingDamageMultiplier = 0.5f;
                this.lifetime = 180.0f;
                this.hitSound = PMSounds.nuclearExplosion;
                this.hitShake = 30.0f;
                this.growTime = 30.0f;
                this.despawnEffect = MissileFx.nuclearExplosion;
                this.absorbEffect = Pseudo3DFx.absorbedLarge;
                this.accel = 0.01f;
                this.gravity = 0.02f;
                this.zoneRadius = 64.0f;
                this.trailLength = 35;
                this.trailWidth = 2.5f;
                this.targetColor = this.zoneColor = PMPal.missileBasic;
                this.trailColor = this.zoneColor;
            }
        };
        paragonCluster = new ArcMissileBulletType("prog-mats-cluster-nuke"){
            {
                this.status = StatusEffects.none;
                this.lifetime = 300.0f;
                this.zoneRadius = 96.0f;
                this.trailLength = 35;
                this.trailWidth = 2.5f;
                this.targetColor = this.zoneColor = PMPal.missileFrag;
                this.trailColor = this.zoneColor;
                this.growTime = 40.0f;
                this.hitEffect = this.despawnEffect = Fx.none;
                this.hitSound = this.despawnSound = Sounds.none;
                this.accel = 0.008f;
                this.gravity = 0.025f;
                this.lifetimeScl = 0.5f;
                this.arcFragCone = 0.5f;
                this.fragBullets = 20;
                this.fragBullet = new ArcMissileBulletType("prog-mats-cluster-nuke-split"){
                    {
                        super(sprite);
                        this.splashDamage = 3500.0f;
                        this.splashDamageRadius = 32.0f;
                        this.buildingDamageMultiplier = 0.5f;
                        this.homingPower = 0.5f;
                        this.homingRange = 512.0f;
                        this.angleDriftDrag = 0.01f;
                        this.hitShake = 5.0f;
                        this.growTime = 120.0f;
                        this.despawnEffect = MissileFx.missileExplosion;
                        this.absorbEffect = Pseudo3DFx.absorbed;
                        this.gravity = 0.025f;
                        this.trailLength = 35;
                        this.trailWidth = 1.0f;
                        this.targetColor = this.zoneColor = PMPal.missileFrag;
                        this.trailColor = this.zoneColor;
                    }
                };
            }
        };
        paragonEMP = new ArcMissileBulletType("prog-mats-emp-nuke"){
            {
                this.lifetime = 180.0f;
                this.status = StatusEffects.none;
                this.hitSound = PMSounds.nuclearExplosion;
                this.hitShake = 30.0f;
                this.despawnEffect = Fx.none;
                this.absorbEffect = Pseudo3DFx.absorbedLarge;
                this.zoneRadius = 64.0f;
                this.growTime = 20.0f;
                this.trailLength = 35;
                this.trailWidth = 2.5f;
                this.targetColor = this.zoneColor = PMPal.nukeEmp;
                this.trailColor = this.zoneColor;
                this.accel = 0.01f;
                this.gravity = 0.02f;
                this.fragBullets = 1;
                this.fragRandomSpread = 0.0f;
                this.fragBullet = new EMPCloudBulletType(1500.0f){
                    {
                        super(damage);
                        this.lifetime = 900.0f;
                        this.status = PMStatusEffects.empStun;
                        this.suppressionRange = 320.0f;
                        this.radius = 320.0f;
                        this.suppressionDuration = 420.0f;
                        this.statusDuration = 420.0f;
                    }
                };
            }
        };
        paragonBlackHole = new ArcMissileBulletType("prog-mats-black-hole-nuke"){
            {
                this.lifetime = 180.0f;
                this.status = StatusEffects.none;
                this.hitSound = Sounds.dullExplosion;
                this.hitShake = 30.0f;
                this.despawnEffect = Fx.none;
                this.absorbEffect = Pseudo3DFx.absorbedLarge;
                this.zoneRadius = 64.0f;
                this.trailLength = 35;
                this.trailWidth = 2.5f;
                this.zoneColor = this.trailColor = Pal.sapBulletBack;
                this.targetColor = this.trailColor;
                this.accel = 0.01f;
                this.gravity = 0.02f;
                this.fragBullets = 1;
                this.fragBullet = new SlashBlackHoleBulletType(0.0f, 146.66667f){
                    {
                        super(speed, damage);
                        this.growTime = 240.0f;
                        this.slashTime = 240.0f;
                        this.lifetime = this.growTime + this.slashTime;
                        this.shrinkTime = 12.0f;
                        this.swirlEffect = MissileFx.bigBlackHoleSwirl;
                        this.loopSoundVolume = 6.0f;
                        this.damageRadius = 64.0f;
                        this.horizonRadius = this.damageRadius + 16.0f;
                        this.suctionRadius = 512.0f;
                        this.force = 20.0f;
                        this.scaledForce = 3600.0f;
                        this.bulletForce = 0.15f;
                        this.scaledBulletForce = 1.5f;
                        this.despawnHit = true;
                        this.splashDamage = 17000.0f;
                        this.splashDamageRadius = 192.0f;
                        this.splashDamagePierce = true;
                        this.scaledSplashDamage = true;
                        this.buildingDamageMultiplier = 0.5f;
                        this.despawnSound = PMSounds.nuclearExplosion;
                        this.despawnEffect = new MultiEffect(new Effect[]{MissileFx.blackHoleNukeWaves, new RepeatEffect(MissileFx.blackHoleNukeParticle, 1.0f, 60)});
                        this.hitEffect = Fx.none;
                        this.starIn = Color.white;
                        this.starWidth = 64.0f;
                        this.starHeight = 24.0f;
                        this.slashOffsetStart = 24.0f;
                        this.slashOffsetEnd = 32.0f;
                        this.slashWidthTo = 2.0f;
                    }
                };
            }
        };
        final ArcMissileBulletType stop = (ArcMissileBulletType)artemisRecursive.copy();
        ArcMissileBulletType why = (ArcMissileBulletType)stop.fragBullet.copy();
        ArcMissileBulletType tooFar = (ArcMissileBulletType)stop.fragBullet.fragBullet.copy();
        tooFar.buildingDamageMultiplier = 1.0f;
        stop.fragBullet = why;
        stop.fragBullet.fragBullet = tooFar;
        BulletType cease = arbalestIncend.copy();
        cease.spawnUnit = new MissileUnitType("mistake-rocket-b"){
            {
                super(name);
                this.speed = 8.0f;
                this.maxRange = 6.0f;
                this.lifetime = 186.0f;
                this.engineColor = this.trailColor = Pal.remove;
                this.engineLayer = 110.0f;
                this.engineSize = 3.1f;
                this.engineOffset = 10.0f;
                this.rotateSpeed = 0.5f;
                this.trailLength = 18;
                this.missileAccelTime = 120.0f;
                this.lowAltitude = true;
                this.loopSound = Sounds.missileTrail;
                this.loopSoundVolume = 0.6f;
                this.deathSound = Sounds.largeExplosion;
                this.fogRadius = 6.0f;
                this.health = 210.0f;
                this.weapons.add((Object)new Weapon(){
                    {
                        this.shootCone = 360.0f;
                        this.mirror = false;
                        this.reload = 1.0f;
                        deathExplosionEffect = new MultiEffect(new Effect[]{MissileFx.missileExplosion, MissileFx.flameRing});
                        this.shootOnDeath = true;
                        this.shake = 10.0f;
                        this.bullet = new ExplosionBulletType(526.0f, 64.0f){
                            float fragMinRange;
                            float fragMaxRange;
                            {
                                super(splashDamage, splashDamageRadius);
                                this.fragMinRange = 160.0f;
                                this.fragMaxRange = 400.0f;
                                this.hitColor = Pal.remove;
                                this.shootEffect = new MultiEffect(new Effect[]{Fx.massiveExplosion, Fx.scatheExplosion, Fx.scatheLight, new WaveEffect(){
                                    {
                                        this.lifetime = 10.0f;
                                        this.strokeFrom = 4.0f;
                                        this.sizeTo = 130.0f;
                                    }
                                }});
                                this.makeFire = true;
                                this.status = PMStatusEffects.incendiaryBurn;
                                this.fragBullets = 1;
                                this.fragBullet = stop;
                            }

                            public void createFrags(Bullet b, float x, float y) {
                                ArcMissileBulletType aType = (ArcMissileBulletType)this.fragBullet;
                                for (int i = 0; i < this.fragBullets; ++i) {
                                    float dst = Mathf.randomSeed((long)(b.id + 2 * i), (float)this.fragMinRange, (float)this.fragMaxRange);
                                    float a = Mathf.randomSeed((long)(b.id + (2 * i + 1)), (float)360.0f);
                                    float time = Mathf.sqrt((float)(2.0f * dst / aType.accel));
                                    float zVel = -0.5f * -aType.gravity * time;
                                    Tmp.v1.set(a, dst);
                                    float tx = Tmp.v1.x + x;
                                    float ty = Tmp.v1.y + y;
                                    aType.create3DVel(b.owner, b.team, b.x, b.y, 0.0f, a, zVel, aType.accel, tx, ty);
                                }
                            }
                        };
                    }
                });
                this.abilities.add((Object)new MoveEffectAbility(){
                    {
                        this.effect = MissileFx.rocketTrailSmoke;
                        this.rotateEffect = true;
                        this.y = -9.0f;
                        this.color = Color.grays((float)0.6f).lerp(Pal.redLight, 0.5f).a(0.4f);
                        this.interval = 4.0f;
                    }
                });
            }
        };
        ArcMissileBulletType enough = (ArcMissileBulletType)paragonBasic.copy();
        enough.buildingDamageMultiplier = 1.0f;
        enough.fragBullets = 10;
        enough.fragBullet = cease;
        enough.growTime = 30.0f;
        enough.angleDriftDrag = 0.015f;
        ohno = (ArcMissileBulletType)paragonCluster.copy();
        PayloadBullets.ohno.sprite = "prog-mats-sandbox-nuke";
        PayloadBullets.ohno.trailColor = PayloadBullets.ohno.zoneColor = Pal.remove;
        PayloadBullets.ohno.targetColor = PayloadBullets.ohno.zoneColor;
        PayloadBullets.ohno.rangeChange = 4000.0f;
        PayloadBullets.ohno.gravity = 0.015f;
        PayloadBullets.ohno.fragBullet = enough;
    }
}

