/*
 * Decompiled with CFR 0.152.
 */
package progressed.content.blocks;

import mindustry.content.Items;
import mindustry.type.ItemStack;
import mindustry.type.Weapon;
import progressed.content.PMItems;
import progressed.content.PMUnitTypes;
import progressed.content.bullets.PayloadBullets;
import progressed.world.blocks.payloads.Missile;
import progressed.world.blocks.payloads.Sentry;

public class PMPayloads {
    public static Missile emptyCruiseMissile;
    public static Missile basicCruiseMissile;
    public static Missile incendiaryCruiseMissile;
    public static Missile splitterCruiseMissile;
    public static Missile emptyBallisticMissile;
    public static Missile basicBallisticMissile;
    public static Missile recursiveBallisticMissile;
    public static Missile bombingBallisticMissile;
    public static Missile emptyNuke;
    public static Missile basicNuke;
    public static Missile clusterNuke;
    public static Missile empNuke;
    public static Missile blackHoleNuke;
    public static Missile sandboxNuke;
    public static Missile basicSentry;
    public static Missile missileSentry;

    public static void load() {
        emptyCruiseMissile = new Missile("empty-rocket"){
            {
                this.buildCost(Items.copper, 1, Items.lead, 1, Items.titanium, 2);
                this.size = 3;
                this.powerUse = 0.5f;
                this.constructTime = 120.0f;
                this.elevation = 0.6666667f;
                this.outlineIcon = true;
                this.outlinedIcon = 0;
            }
        };
        basicCruiseMissile = new Missile("basic-rocket"){
            {
                this.buildCost(Items.titanium, 1, Items.blastCompound, 3);
                this.prev = emptyCruiseMissile;
                this.size = 3;
                this.powerUse = 1.0f;
                this.constructTime = 240.0f;
                this.elevation = 0.6666667f;
                this.outlined = true;
                this.explosionBullet = PayloadBullets.arbalestBasic;
            }
        };
        incendiaryCruiseMissile = new Missile("incendiary-rocket"){
            {
                this.buildCost(Items.titanium, 2, Items.pyratite, 4);
                this.prev = emptyCruiseMissile;
                this.size = 3;
                this.powerUse = 1.2f;
                this.constructTime = 270.0f;
                this.elevation = 0.6666667f;
                this.outlined = true;
                this.explosionBullet = PayloadBullets.arbalestIncend;
            }
        };
        splitterCruiseMissile = new Missile("splitter-rocket"){
            {
                this.buildCost(Items.titanium, 2, Items.silicon, 2, Items.blastCompound, 5);
                this.prev = emptyCruiseMissile;
                this.size = 3;
                this.powerUse = 1.1f;
                this.constructTime = 300.0f;
                this.elevation = 0.6666667f;
                this.outlined = true;
                this.explosionBullet = ((Weapon)((Weapon)PayloadBullets.arbalestSplitter.spawnUnit.weapons.first()).bullet.fragBullet.spawnUnit.weapons.first()).bullet.fragBullet;
                this.explosions = 18;
                this.explosionArea = -1.0f;
                this.maxDelay = 20.0f;
            }
        };
        emptyBallisticMissile = new Missile("empty-missile"){
            {
                this.buildCost(Items.copper, 1, Items.lead, 1, Items.titanium, 2);
                this.size = 2;
                this.powerUse = 0.6f;
                this.constructTime = 120.0f;
            }
        };
        basicBallisticMissile = new Missile("basic-missile"){
            {
                this.buildCost(Items.titanium, 1, Items.blastCompound, 3);
                this.prev = emptyBallisticMissile;
                this.size = 2;
                this.powerUse = 1.1f;
                this.constructTime = 240.0f;
                this.explosionBullet = PayloadBullets.artemisBasic;
            }
        };
        recursiveBallisticMissile = new Missile("recursive-missile"){
            {
                this.buildCost(Items.plastanium, 2, Items.silicon, 3, Items.blastCompound, 5);
                this.prev = emptyBallisticMissile;
                this.size = 2;
                this.powerUse = 1.25f;
                this.constructTime = 450.0f;
                this.explosionBullet = PayloadBullets.artemisRecursive.fragBullet.fragBullet;
                this.explosions = PayloadBullets.artemisRecursive.fragBullets * PayloadBullets.artemisRecursive.fragBullet.fragBullets;
                this.explosionArea = -1.0f;
                this.maxDelay = 20.0f;
            }
        };
        bombingBallisticMissile = new Missile("bombing-missile"){
            {
                this.buildCost(Items.silicon, 5, Items.blastCompound, 6);
                this.prev = emptyBallisticMissile;
                this.size = 2;
                this.powerUse = 1.2f;
                this.constructTime = 420.0f;
                this.explosionBullet = PayloadBullets.artemisBombing.intervalBullet;
                this.explosions = 13;
                this.explosionArea = -1.0f;
                this.maxDelay = 20.0f;
            }
        };
        emptyNuke = new Missile("empty-nuke"){
            {
                this.buildCost(Items.titanium, 30, Items.surgeAlloy, 20, PMItems.tenelium, 25);
                this.size = 3;
                this.powerUse = 5.0f;
                this.constructTime = 720.0f;
            }
        };
        basicNuke = new Missile("basic-nuke"){
            {
                this.buildCost(Items.lead, 100, Items.titanium, 80, Items.thorium, 120);
                this.prev = emptyNuke;
                this.size = 3;
                this.powerUse = 9.5f;
                this.constructTime = 2700.0f;
                this.explosionBullet = PayloadBullets.paragonBasic;
            }
        };
        clusterNuke = new Missile("cluster-nuke"){
            {
                this.buildCost(Items.plastanium, 80, PMItems.tenelium, 90, Items.blastCompound, 110);
                this.prev = emptyNuke;
                this.size = 3;
                this.powerUse = 10.0f;
                this.constructTime = 3180.0f;
                this.explosionArea = -1.0f;
                this.explosionBullet = PayloadBullets.paragonCluster.fragBullet;
                this.explosions = PayloadBullets.paragonCluster.fragBullets;
                this.maxDelay = 20.0f;
            }
        };
        empNuke = new Missile("emp-nuke"){
            {
                this.buildCost(PMItems.tenelium, 110, Items.surgeAlloy, 65, Items.silicon, 80);
                this.prev = emptyNuke;
                this.size = 3;
                this.powerUse = 15.0f;
                this.constructTime = 2940.0f;
                this.explosionBullet = PayloadBullets.paragonEMP;
            }
        };
        blackHoleNuke = new Missile("black-hole-nuke"){
            {
                this.buildCost(PMItems.tenelium, 110, Items.phaseFabric, 90, Items.silicon, 80);
                this.prev = emptyNuke;
                this.size = 3;
                this.powerUse = 30.0f;
                this.constructTime = 3300.0f;
                this.explosionBullet = PayloadBullets.paragonBlackHole;
            }
        };
        sandboxNuke = new Missile("sandbox-nuke"){
            {
                this.requirements = ItemStack.empty;
                this.displayCampaign = false;
                this.size = 3;
                this.explosionArea = -1.0f;
                this.explosionBullet = PayloadBullets.ohno.fragBullet;
                this.explosions = PayloadBullets.ohno.fragBullets;
                this.maxDelay = 20.0f;
            }
        };
        basicSentry = new Sentry("basic-sentry"){
            {
                this.buildCost(Items.graphite, 12, Items.tungsten, 7, Items.silicon, 7);
                this.size = 2;
                this.powerUse = 1.75f;
                this.constructTime = 720.0f;
                this.unit = PMUnitTypes.barrage;
            }
        };
        missileSentry = new Sentry("missile-sentry"){
            {
                this.buildCost(Items.graphite, 15, Items.tungsten, 10, Items.oxide, 5, Items.silicon, 10);
                this.size = 2;
                this.baseExplosiveness = 100.0f;
                this.powerUse = 2.0f;
                this.constructTime = 960.0f;
                this.unit = PMUnitTypes.strikedown;
            }
        };
    }
}

