/*
 * Decompiled with CFR 0.152.
 */
package progressed.content.blocks;

import arc.Core;
import arc.graphics.Color;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.ObjectMap;
import arc.util.OS;
import arc.util.Tmp;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.entities.Effect;
import mindustry.entities.UnitSorts;
import mindustry.entities.bullet.PointLaserBulletType;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.RegionPart;
import mindustry.entities.pattern.ShootBarrel;
import mindustry.entities.pattern.ShootSpread;
import mindustry.gen.Healthc;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawFlame;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawRegion;
import mindustry.world.draw.DrawTurret;
import mindustry.world.meta.BuildVisibility;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import progressed.content.PMItems;
import progressed.content.PMSounds;
import progressed.content.PMStatusEffects;
import progressed.content.PMUnitTypes;
import progressed.content.blocks.PMErekirBlocks;
import progressed.content.blocks.PMModules;
import progressed.content.blocks.PMPayloads;
import progressed.content.bullets.MinigunBullets;
import progressed.content.bullets.PMBullets;
import progressed.content.bullets.PayloadBullets;
import progressed.content.bullets.SniperBullets;
import progressed.content.effects.CrafterFx;
import progressed.content.effects.EnergyFx;
import progressed.content.effects.LightningFx;
import progressed.entities.bullet.PillarFieldBulletType;
import progressed.entities.bullet.energy.MagmaBulletType;
import progressed.entities.bullet.energy.UltraRailgunBulletType;
import progressed.entities.effect.FlashEffect;
import progressed.entities.effect.WrapDataEffect;
import progressed.entities.part.SpacePart;
import progressed.type.unit.SwordUnitType;
import progressed.util.PMUtls;
import progressed.world.blocks.crafting.AccelerationCrafter;
import progressed.world.blocks.crafting.FuelCrafter;
import progressed.world.blocks.defence.EffectZone;
import progressed.world.blocks.defence.IgneousPillar;
import progressed.world.blocks.defence.ShieldProjector;
import progressed.world.blocks.defence.StaticNode;
import progressed.world.blocks.defence.turret.BitTurret;
import progressed.world.blocks.defence.turret.BlackHoleTurret;
import progressed.world.blocks.defence.turret.EruptorTurret;
import progressed.world.blocks.defence.turret.GeomancyTurret;
import progressed.world.blocks.defence.turret.MinigunTurret;
import progressed.world.blocks.defence.turret.SignalFlareTurret;
import progressed.world.blocks.defence.turret.SwingContinuousTurret;
import progressed.world.blocks.defence.turret.SwordTurret;
import progressed.world.blocks.defence.turret.TeslaTurret;
import progressed.world.blocks.defence.turret.nexus.NexusTurret;
import progressed.world.blocks.defence.turret.payload.ArcMissileTurret;
import progressed.world.blocks.defence.turret.payload.SinglePayloadAmmoTurret;
import progressed.world.blocks.defence.turret.testing.ArcBulletScatterTestTurret;
import progressed.world.blocks.defence.turret.testing.ArcBulletTestTurret;
import progressed.world.blocks.defence.turret.testing.FreeTurret;
import progressed.world.blocks.defence.turret.testing.SkyLaserTestTurret;
import progressed.world.blocks.distribution.BurstDriver;
import progressed.world.blocks.distribution.SandDriver;
import progressed.world.blocks.payloads.PayloadCrafter;
import progressed.world.blocks.payloads.Recipe;
import progressed.world.blocks.production.SmartDrill;
import progressed.world.blocks.production.UnitMinerDepot;
import progressed.world.blocks.storage.CoreLink;
import progressed.world.blocks.storage.CrashCore;
import progressed.world.draw.DrawPayloadAmmo;
import progressed.world.draw.DrawPayloadTurret;
import progressed.world.draw.DrawSpeedPlasma;
import progressed.world.draw.DrawSwingTurret;
import progressed.world.meta.PMStatValues;

public class PMBlocks {
    public static Block minigun;
    public static Block miinigun;
    public static Block mivnigun;
    public static Block shock;
    public static Block spark;
    public static Block storm;
    public static Block concretion;
    public static Block flame;
    public static Block blaze;
    public static Block bit;
    public static Block magnet;
    public static Block caliber;
    public static Block pheromone;
    public static Block vaccinator;
    public static Block pinpoint;
    public static Block dance;
    public static Block masquerade;
    public static Block kugelblitz;
    public static Block excalibur;
    public static Block javelin;
    public static Block artemis;
    public static Block paragon;
    public static Block judgement;
    public static Block testTurret0;
    public static Block testTurret1;
    public static Block testTurret2;
    public static Block testTurret3;
    public static Block smartDrill;
    public static Block unitMinerDepot;
    public static Block burstDriver;
    public static Block sandDriver;
    public static Block mindronCollider;
    public static Block pyroclastForge;
    public static Block shellPress;
    public static Block missileFactory;
    public static Block igneousPillar;
    public static Block healZone;
    public static Block speedZone;
    public static Block strengthZone;
    public static Block harmacist;
    public static Block coreShatter;
    public static Block coreCovalence;
    public static Block fence;
    public static Block web;
    public static Block ballisticProjector;

    public static BuildVisibility incompleteVisibility() {
        return OS.username.equals("MEEPM") ? BuildVisibility.sandboxOnly : BuildVisibility.hidden;
    }

    public static void load() {
        PMPayloads.load();
        PMModules.load();
        minigun = new MinigunTurret("minigun"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 200, Items.graphite, 175, Items.titanium, 100, Items.thorium, 80}));
                this.ammo(new Object[]{Items.copper, MinigunBullets.standardCopperMini, Items.graphite, MinigunBullets.standardDenseMini, Items.silicon, MinigunBullets.standardHomingMini, Items.pyratite, MinigunBullets.standardIncendiaryMini, Items.thorium, MinigunBullets.standardThoriumMini});
                this.size = 4;
                this.range = 255.0f;
                this.scaledHealth = 140.0f;
                this.shootCone = 35.0f;
                this.shootSound = Sounds.shootBig;
                this.targetGround = true;
                this.targetAir = true;
                this.recoil = 3.0f;
                this.recoilTime = 90.0f;
                this.cooldownTime = 10.0f;
                this.inaccuracy = 3.0f;
                this.smokeEffect = this.ammoUseEffect = Fx.none;
                this.shootEffect = this.ammoUseEffect;
                this.heatColor = Pal.turretHeat;
                this.barX = 4.0f;
                this.barY = -10.0f;
                this.barStroke = 1.0f;
                this.barLength = 9.0f;
                this.coolant = this.consumeCoolant(0.2f);
            }
        };
        miinigun = new MinigunTurret("miinigun"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 350, Items.graphite, 300, Items.titanium, 150, Items.plastanium, 175, Items.thorium, 170, PMItems.tenelium, 120}));
                this.ammo(new Object[]{Items.copper, MinigunBullets.standardCopperMini, Items.graphite, MinigunBullets.standardDenseMini, Items.silicon, MinigunBullets.standardHomingMini, Items.pyratite, MinigunBullets.standardIncendiaryMini, Items.thorium, MinigunBullets.standardThoriumMini});
                this.size = 4;
                this.range = 255.0f;
                this.maxSpeed = 27.0f;
                this.scaledHealth = 150.0f;
                this.shootCone = 35.0f;
                this.shootSound = Sounds.shootBig;
                this.targetGround = true;
                this.targetAir = true;
                this.recoil = 3.0f;
                this.recoilTime = 90.0f;
                this.cooldownTime = 10.0f;
                this.inaccuracy = 3.0f;
                this.smokeEffect = this.ammoUseEffect = Fx.none;
                this.shootEffect = this.ammoUseEffect;
                this.heatColor = Pal.turretHeat;
                this.barX = 4.0f;
                this.barY = -10.0f;
                this.barStroke = 1.0f;
                this.barLength = 9.0f;
                this.shoot = new ShootBarrel(){
                    {
                        this.shots = 2;
                        this.barrels = new float[]{-4.0f, 0.0f, 0.0f, 4.0f, 0.0f, 0.0f};
                    }
                };
                this.coolant = this.consumeCoolant(0.2f);
            }
        };
        mivnigun = new MinigunTurret("mivnigun"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 650, Items.graphite, 600, Items.titanium, 370, Items.thorium, 340, Items.plastanium, 325, Items.surgeAlloy, 220, PMItems.tenelium, 270}));
                this.ammo(new Object[]{Items.copper, MinigunBullets.standardCopperMini, Items.graphite, MinigunBullets.standardDenseMini, Items.silicon, MinigunBullets.standardHomingMini, Items.pyratite, MinigunBullets.standardIncendiaryMini, Items.thorium, MinigunBullets.standardThoriumMini});
                this.size = 4;
                this.hideDetails = false;
                this.range = 255.0f;
                this.maxSpeed = 24.0f;
                this.scaledHealth = 160.0f;
                this.shootCone = 35.0f;
                this.shootSound = Sounds.shootBig;
                this.targetGround = true;
                this.targetAir = true;
                this.recoil = 3.0f;
                this.recoilTime = 90.0f;
                this.cooldownTime = 10.0f;
                this.inaccuracy = 3.0f;
                this.shootEffect = Fx.shootSmall;
                this.smokeEffect = Fx.shootSmallSmoke;
                this.ammoUseEffect = Fx.none;
                this.heatColor = Pal.turretHeat;
                this.barX = 5.0f;
                this.barY = -10.0f;
                this.barStroke = 1.0f;
                this.barLength = 9.0f;
                this.shoot = new ShootBarrel(){
                    {
                        this.shots = 4;
                        this.barrels = new float[]{-9.0f, -0.75f, 0.0f, -3.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 9.0f, -0.75f, 0.0f};
                    }
                };
                this.coolant = this.consumeCoolant(0.2f);
            }
        };
        shock = new TeslaTurret("shock"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 45, Items.lead, 60, Items.silicon, 25, Items.titanium, 25}));
                this.rings.add((Object)new TeslaTurret.TeslaRing(0.75f), (Object)new TeslaTurret.TeslaRing(2.5f));
                this.size = 1;
                this.health = 310;
                this.reload = 30.0f;
                this.range = 72.0f;
                this.maxTargets = 6;
                this.damage = 20.0f;
                this.status = StatusEffects.shocked;
                this.consumePower(3.6f);
                this.coolant = this.consumeCoolant(0.2f);
            }
        };
        spark = new TeslaTurret("spark"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 60, Items.lead, 85, Items.graphite, 40, Items.silicon, 55, Items.titanium, 80}));
                this.rings.add((Object)new TeslaTurret.TeslaRing(2.0f), (Object)new TeslaTurret.TeslaRing(6.0f));
                this.size = 2;
                this.scaledHealth = 200.0f;
                this.reload = 20.0f;
                this.range = 130.0f;
                this.maxTargets = 5;
                this.damage = 23.0f;
                this.status = StatusEffects.shocked;
                this.consumePower(4.8f);
                this.coolant = this.consumeCoolant(0.2f);
            }
        };
        storm = new TeslaTurret("storm"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 120, Items.lead, 150, Items.graphite, 55, Items.silicon, 105, Items.titanium, 90, Items.surgeAlloy, 40, PMItems.tenelium, 50}));
                final float spinSpeed = 12.0f;
                this.rings.addAll((Object[])new TeslaTurret.TeslaRing[]{new TeslaTurret.TeslaRing(1.0f), new TeslaTurret.TeslaRing(3.25f), new TeslaTurret.TeslaRing(6.5f), new TeslaTurret.TeslaRing(4.25f){
                    {
                        super(radius);
                        this.hasSprite = true;
                        this.drawUnder = true;
                        this.xOffset = -8.625f;
                        this.yOffset = 8.625f;
                        this.rotationMul = spinSpeed;
                    }
                }, new TeslaTurret.TeslaRing(4.25f){
                    {
                        super(radius);
                        this.drawUnder = true;
                        this.yOffset = 8.625f;
                        this.xOffset = 8.625f;
                        this.rotationMul = spinSpeed;
                    }
                }, new TeslaTurret.TeslaRing(4.25f){
                    {
                        super(radius);
                        this.drawUnder = true;
                        this.yOffset = -8.625f;
                        this.xOffset = -8.625f;
                        this.rotationMul = spinSpeed;
                    }
                }, new TeslaTurret.TeslaRing(4.25f){
                    {
                        super(radius);
                        this.drawUnder = true;
                        this.xOffset = 8.625f;
                        this.yOffset = -8.625f;
                        this.rotationMul = spinSpeed;
                    }
                }, new TeslaTurret.TeslaRing(1.0f){
                    {
                        super(radius);
                        this.hasSprite = true;
                        this.drawUnder = true;
                        this.xOffset = -7.625f;
                        this.yOffset = 7.625f;
                        this.rotationMul = -spinSpeed;
                    }
                }, new TeslaTurret.TeslaRing(1.0f){
                    {
                        super(radius);
                        this.drawUnder = true;
                        this.yOffset = 7.625f;
                        this.xOffset = 7.625f;
                        this.rotationMul = -spinSpeed;
                    }
                }, new TeslaTurret.TeslaRing(1.0f){
                    {
                        super(radius);
                        this.drawUnder = true;
                        this.yOffset = -7.625f;
                        this.xOffset = -7.625f;
                        this.rotationMul = -spinSpeed;
                    }
                }, new TeslaTurret.TeslaRing(1.0f){
                    {
                        super(radius);
                        this.drawUnder = true;
                        this.xOffset = 7.625f;
                        this.yOffset = -7.625f;
                        this.rotationMul = -spinSpeed;
                    }
                }});
                this.size = 3;
                this.scaledHealth = 180.0f;
                this.reload = 10.0f;
                this.range = 315.0f;
                this.maxTargets = 16;
                this.coolantMultiplier = 1.0f;
                this.hasSpinners = true;
                this.damage = 27.0f;
                this.status = StatusEffects.shocked;
                this.consumePower(8.9f);
                this.coolant = this.consumeCoolant(0.2f);
            }
        };
        concretion = new GeomancyTurret("concretion"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 100, Items.lead, 120, Items.silicon, 75, Items.titanium, 60}));
                this.size = 2;
                this.scaledHealth = 310.0f;
                this.reload = 120.0f;
                this.shootSound = Sounds.rockBreak;
                this.range = 280.0f;
                this.recoil = -6.25f;
                this.shootY = 11.75f;
                this.targetAir = false;
                this.cooldownTime = 300.0f;
                this.shootType = PMBullets.pillarField;
                this.shoot.firstShotDelay = 10.0f;
                this.armX = 3.75f;
                this.armY = -0.5f;
                this.consumePower(2.0f);
                this.coolant = this.consumeCoolant(0.2f);
            }
        };
        flame = new EruptorTurret("flame"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 200, Items.lead, 300, Items.graphite, 300, Items.silicon, 325, Items.titanium, 200, Items.thorium, 200}));
                this.size = 3;
                this.scaledHealth = 210.0f;
                this.shootDuration = 90.0f;
                this.range = 240.0f;
                this.reload = 90.0f;
                this.shootY = -0.25f;
                this.recoil = 3.0f;
                this.shootType = new MagmaBulletType(62.0f, 14.0f){
                    {
                        super(damage, radius);
                        this.shake = 1.0f;
                        this.crackEffects = 4;
                    }
                };
                this.consumePower(14.0f);
                this.coolant = this.consumeCoolant(0.2f);
            }
        };
        blaze = new EruptorTurret("blaze"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 350, Items.lead, 550, Items.graphite, 550, Items.silicon, 600, Items.titanium, 350, Items.surgeAlloy, 200, PMItems.tenelium, 200}));
                this.size = 4;
                this.scaledHealth = 190.0f;
                this.shootDuration = 120.0f;
                this.range = 280.0f;
                this.reload = 150.0f;
                this.shootY = 0.25f;
                this.rotateSpeed = 3.5f;
                this.recoil = 4.0f;
                this.beamEffect = LightningFx.blazeBeam;
                this.shootType = new MagmaBulletType(76.0f, 24.0f){
                    {
                        super(damage, radius);
                        this.shake = 2.0f;
                        this.crackEffects = 6;
                    }
                };
                this.consumePower(17.0f);
                this.coolant = this.consumeCoolant(0.2f);
            }
        };
        bit = new BitTurret("bit"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 50, Items.lead, 60, Items.silicon, 40, Items.titanium, 30}));
                this.size = 2;
                this.scaledHealth = 300.0f;
                this.reload = 70.0f;
                this.rotateSpeed = 10.0f;
                this.recoil = 4.0f;
                this.inaccuracy = 15.0f;
                this.range = 140.0f;
                this.shootType = PMBullets.pixel;
                this.consumePower(1.35f);
                this.coolant = this.consumeCoolant(0.2f);
            }
        };
        magnet = new ItemTurret("attraction"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 115, Items.lead, 80, Items.graphite, 30, Items.titanium, 25}));
                this.ammo(new Object[]{Items.copper, PMBullets.magnetCopper, Items.titanium, PMBullets.magnetTitanium, PMItems.tenelium, PMBullets.magenetTenelium});
                this.size = 3;
                this.scaledHealth = 90.0f;
                this.range = 184.0f;
                this.reload = 200.0f;
                this.inaccuracy = 30.0f;
                this.velocityRnd = 0.2f;
                this.shoot.shots = 4;
                this.shoot.shotDelay = 5.0f;
                this.coolant = this.consumeCoolant(0.2f);
            }

            public void setStats() {
                super.setStats();
                this.stats.remove(Stat.ammo);
                this.stats.add(Stat.ammo, PMStatValues.ammo(this.ammoTypes));
            }

            public void setBars() {
                super.setBars();
                this.addBar("pm-reload", entity -> new Bar(() -> Core.bundle.format("bar.pm-reload", new Object[]{PMUtls.stringsFixed(Mathf.clamp((float)(entity.reloadCounter / this.reload)) * 100.0f)}), () -> entity.team.color, () -> Mathf.clamp((float)(entity.reloadCounter / this.reload))));
            }
        };
        caliber = new ItemTurret("caliber"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 220, Items.titanium, 200, Items.thorium, 150, Items.plastanium, 110, PMItems.tenelium, 60}));
                this.ammo(new Object[]{Items.titanium, SniperBullets.sniperBoltTitanium, Items.thorium, SniperBullets.sniperBoltThorium, Items.silicon, SniperBullets.sniperBoltSilicon, PMItems.tenelium, SniperBullets.sniperBoltTenelium, Items.surgeAlloy, SniperBullets.sniperBoltSurge});
                this.size = 3;
                this.hideDetails = false;
                this.scaledHealth = 120.0f;
                this.reload = 150.0f;
                this.range = 544.0f;
                this.rotateSpeed = 2.5f;
                this.recoil = 5.0f;
                this.cooldownTime = 300.0f;
                this.shootSound = Sounds.cannon;
                this.coolant = this.consumeCoolant(0.2f);
            }

            public void setStats() {
                super.setStats();
                this.stats.remove(Stat.ammo);
                this.stats.add(Stat.ammo, PMStatValues.ammo(this.ammoTypes));
            }
        };
        pheromone = new SignalFlareTurret("signal"){
            {
                this.requirements(Category.defense, ItemStack.with((Object[])new Object[]{Items.lead, 80, Items.silicon, 130, Items.plastanium, 110, PMItems.tenelium, 90}));
                this.ammo(new Object[]{Items.silicon, PMBullets.smallFlare, PMItems.tenelium, PMBullets.mediumFlare, Items.surgeAlloy, PMBullets.largeFlare});
                this.size = 2;
                this.scaledHealth = 250.0f;
                this.minRange = 40.0f;
                this.range = 480.0f;
                this.shootY = 5.75f;
                this.reload = 120.0f;
                this.inaccuracy = 10.0f;
                this.velocityRnd = 0.2f;
                this.shootSound = Sounds.shootSnap;
                this.maxAmmo = 30;
                this.ammoPerShot = 10;
                this.coolant = this.consumeCoolant(0.2f);
            }
        };
        vaccinator = new ItemTurret("vaccinator"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.lead, 70, Items.titanium, 50, Items.silicon, 80, Items.plastanium, 20}));
                this.ammo(new Object[]{Items.plastanium, PMBullets.syringe});
                this.size = 2;
                this.hideDetails = false;
                this.scaledHealth = 80.0f;
                this.range = 136.0f;
                this.shootY = 5.25f;
                this.reload = 120.0f;
                this.buildingFilter = b -> false;
                this.shoot = new ShootSpread(){
                    {
                        this.shots = 4;
                        this.shotDelay = 3.0f;
                        this.spread = 15.0f;
                    }
                };
                this.shootSound = Sounds.shootSnap;
                this.coolant = this.consumeCoolant(0.2f);
            }

            public void setStats() {
                super.setStats();
                this.stats.remove(Stat.ammo);
                this.stats.add(Stat.ammo, PMStatValues.ammo(this.ammoTypes));
            }
        };
        pinpoint = new SwingContinuousTurret("pinpoint"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 200, Items.titanium, 150, Items.plastanium, 125, Items.silicon, 180, PMItems.tenelium, 150}));
                this.shootType = new PointLaserBulletType(){
                    {
                        this.damage = 200.0f;
                        this.sprite = "prog-mats-swing-laser";
                        this.beamEffect = Fx.none;
                        this.trailLength = 6;
                        this.trailColor = this.hitColor = Color.valueOf((String)"fd4f60");
                        this.trailWidth = 3.0f;
                        this.trailSinMag = this.oscMag;
                        this.trailSinScl = this.oscScl;
                    }
                };
                this.drawer = new DrawSwingTurret(){
                    {
                        this.parts.add((Object)new RegionPart("-break"){
                            {
                                super(region);
                                this.x = 4.75f;
                                this.y = 4.25f;
                                this.moveRot = 90.0f;
                                this.progress = DrawPart.PartProgress.life;
                                this.mirror = true;
                                this.under = true;
                            }
                        });
                    }
                };
                this.shootSound = Sounds.none;
                this.loopSoundVolume = 1.0f;
                this.loopSound = Sounds.laserbeam;
                this.rotateSpeed = 6.0f;
                this.rotateSpeedAccel = 0.2f;
                this.rotateSpeedDrag = 0.02f;
                this.aimChangeSpeed = 6.0f;
                this.aimChangeSpeedAccel = 0.5f;
                this.aimChangeSpeedDrag = 0.06f;
                this.size = 3;
                this.range = 128.0f;
                this.scaledHealth = 140.0f;
                this.shootY = 8.5f;
                this.shootCone = 360.0f;
                this.unitSort = UnitSorts.strongest;
                this.consumePower(1.5f);
            }
        };
        dance = new SwordTurret("dance"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 500, Items.graphite, 250, Items.silicon, 350, Items.titanium, 200, Items.phaseFabric, 50, PMItems.tenelium, 150}));
                this.size = 3;
                this.hideDetails = false;
                this.scaledHealth = 340.0f;
                this.range = 180.0f;
                this.maxSwords = 3;
                this.unitSort = UnitSorts.weakest;
                this.targetY = 8.75f;
                this.targetColor = Pal.remove;
                this.buildPowerUse = 4.0f;
                this.attackPowerUse = 6.5f;
                this.buildY = 3.25f;
            }
        };
        masquerade = new SwordTurret("ball"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 1400, Items.graphite, 350, Items.silicon, 400, Items.surgeAlloy, 400, Items.phaseFabric, 200, PMItems.tenelium, 450}));
                this.size = 5;
                this.hideDetails = false;
                this.scaledHealth = 230.0f;
                this.range = 260.0f;
                this.swordType = (SwordUnitType)PMUnitTypes.masqueradeSword;
                this.maxSwords = 5;
                this.unitSort = UnitSorts.weakest;
                this.targetY = 16.75f;
                this.targetRad = 6.0f;
                this.targetColor = Pal.remove;
                this.buildPowerUse = 6.0f;
                this.attackPowerUse = 13.5f;
                this.buildY = 7.75f;
                this.buildWaveOffset = 0.05f;
            }
        };
        kugelblitz = new BlackHoleTurret("blackhole"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.titanium, 100, Items.thorium, 150, Items.plastanium, 250, Items.surgeAlloy, 250, Items.silicon, 800, Items.phaseFabric, 500, PMItems.tenelium, 500}));
                this.size = 4;
                this.hideDetails = false;
                this.scaledHealth = 230.0f;
                this.reload = 520.0f;
                this.range = 256.0f;
                this.shootEffect = this.smokeEffect = Fx.none;
                this.linearWarmup = true;
                this.minWarmup = 1.0f;
                this.shootWarmupSpeed = 0.011111111f;
                this.warmupMaintainTime = 60.0f;
                this.shoot.firstShotDelay = EnergyFx.kugelblitzGrow.lifetime - 1.0f;
                this.rotateSpeed = 2.0f;
                this.recoil = 2.0f;
                this.recoilTime = 240.0f;
                this.cooldownTime = 300.0f;
                this.shootY = -2.75f;
                this.shootSound = Sounds.dullExplosion;
                this.shootType = PMBullets.blackHole;
                this.consumePower(35.0f);
                this.coolant = this.consumeCoolant(0.2f);
                this.drawer = new DrawTurret(){
                    {
                        final DrawPart.PartProgress push = DrawPart.PartProgress.warmup.shorten(0.6f).clamp().curve(Interp.smooth);
                        final DrawPart.PartProgress pull = DrawPart.PartProgress.warmup.delay(0.6f).clamp().curve(Interp.smooth);
                        this.parts.addAll((Object[])new DrawPart[]{new RegionPart("-bottom"), new SpacePart("-space"), new RegionPart("-front"){
                            {
                                super(region);
                                this.mirror = true;
                                this.moves.addAll((Object[])new DrawPart.PartMove[]{new DrawPart.PartMove(push, 0.0f, 2.5f, 0.0f), new DrawPart.PartMove(pull, 3.5f, -2.0f, 0.0f)});
                                this.layerOffset = 0.001f;
                                this.outlineLayerOffset -= this.layerOffset;
                            }
                        }, new RegionPart("-back"){
                            {
                                super(region);
                                this.mirror = true;
                                this.moves.addAll((Object[])new DrawPart.PartMove[]{new DrawPart.PartMove(push, 0.0f, -2.5f, 0.0f), new DrawPart.PartMove(pull, 3.5f, 2.0f, 0.0f)});
                                this.layerOffset = 0.001f;
                                this.outlineLayerOffset -= this.layerOffset;
                            }
                        }, new RegionPart("-cover"){
                            {
                                super(region);
                                this.mirror = true;
                                this.progress = DrawPart.PartProgress.warmup.curve(0.4f, 0.4f).clamp().curve(Interp.smooth);
                                this.moveX = 5.0f;
                                this.layerOffset = 0.001f;
                                this.outlineLayerOffset -= this.layerOffset;
                            }
                        }, new RegionPart("-side-cover"){
                            {
                                super(region);
                                this.mirror = true;
                                this.progress = pull;
                                this.moveY = 1.75f;
                                this.layerOffset = 0.001f;
                                this.outlineLayerOffset -= this.layerOffset;
                            }
                        }, new RegionPart("-over"){
                            {
                                super(region);
                                this.layerOffset = 0.002f;
                                this.outlineLayerOffset -= this.layerOffset;
                            }
                        }});
                    }
                };
            }
        };
        excalibur = new PowerTurret("excalibur"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 1200, Items.lead, 1100, Items.graphite, 800, Items.silicon, 1500, Items.titanium, 800, Items.thorium, 700, Items.plastanium, 350, Items.surgeAlloy, 450, PMItems.tenelium, 800}));
                this.size = 6;
                this.hideDetails = false;
                this.scaledHealth = 140.0f;
                this.reload = 450.0f;
                this.range = 740.0f;
                this.shootEffect = this.smokeEffect = Fx.none;
                this.shootY = 0.0f;
                this.cooldownTime = 300.0f;
                this.shootWarmupSpeed = 0.05f;
                this.minWarmup = 0.9f;
                this.heatColor = Pal.surge;
                this.shootSound = Sounds.malignShoot;
                this.rotateSpeed = 2.0f;
                this.recoil = 8.0f;
                this.recoilTime = 300.0f;
                this.shootType = PMBullets.excaliburLaser;
                this.consumePower(30.0f);
                this.coolant = this.consumeCoolant(0.2f);
                final Color transSurge = Pal.surge.cpy().a(0.0f);
                final DrawPart.PartProgress[] p = new DrawPart.PartProgress[]{DrawPart.PartProgress.reload.inv().curve(0.0f, 0.3f), DrawPart.PartProgress.reload.inv().curve(0.3f, 0.3f), DrawPart.PartProgress.reload.inv().curve(0.7f, 0.1f), DrawPart.PartProgress.reload.inv().curve(0.8f, 0.1f), DrawPart.PartProgress.reload.inv().curve(0.9f, 0.1f)};
                this.drawer = new DrawTurret(){
                    {
                        int i = 0;
                        while (i < 5) {
                            final int ii = i++;
                            this.parts.add((Object)new RegionPart("-cell-" + ii){
                                {
                                    super(region);
                                    this.outline = false;
                                    this.progress = this.heatProgress = p[ii];
                                    this.color = transSurge;
                                    this.colorTo = this.heatColor = Pal.surge;
                                }
                            });
                        }
                        this.parts.addAll((Object[])new DrawPart[]{new RegionPart("-side"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup.curve((Interp)Interp.pow2Out);
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.warmup.curve((Interp)Interp.pow5In), 0.0f, -3.0f, 0.0f));
                                this.moveX = -2.25f;
                                this.mirror = true;
                                int i = 2;
                                while (i < 5) {
                                    final int ii = i++;
                                    this.children.add((Object)new RegionPart("-side-cell-" + (ii - 2)){
                                        {
                                            super(region);
                                            this.outline = false;
                                            this.progress = this.heatProgress = p[ii];
                                            this.color = transSurge;
                                            this.colorTo = this.heatColor = Pal.surge;
                                        }
                                    });
                                }
                            }
                        }, new RegionPart("-cross"){
                            {
                                super(region);
                                this.heatColor = Pal.surge;
                            }
                        }});
                    }
                };
            }
        };
        javelin = new SinglePayloadAmmoTurret("arbalest"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 150, Items.graphite, 300, Items.silicon, 325, Items.titanium, 350, PMItems.tenelium, 160}));
                this.ammo(new Object[]{PMPayloads.basicCruiseMissile, PayloadBullets.arbalestBasic, PMPayloads.incendiaryCruiseMissile, PayloadBullets.arbalestIncend, PMPayloads.splitterCruiseMissile, PayloadBullets.arbalestSplitter});
                final DrawPart.PartProgress baseProgress = DrawPart.PartProgress.warmup.shorten(0.3f);
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawPayloadTurret(true){
                    {
                        super(drawTurret);
                        this.parts.add((Object)new RegionPart("-doors"){
                            {
                                super(region);
                                this.progress = baseProgress.shorten(0.3f).clamp().curve(Interp.smooth);
                                this.mirror = true;
                                this.moveX = 6.0f;
                            }
                        });
                    }
                }, new DrawPayloadAmmo(){
                    {
                        this.progress = this.matProgress = baseProgress.delay(0.7f);
                        this.layer = 51.0f;
                        this.materialize = false;
                        this.rotation = 90.0f;
                        this.yScl = 0.8f;
                        this.xScl = 0.8f;
                        this.growY = 0.2f;
                        this.growX = 0.2f;
                    }
                }});
                this.size = 5;
                this.hideDetails = false;
                this.scaledHealth = 180.0f;
                this.reload = 120.0f;
                this.setWarmupTime(1.5f);
                this.shootCone = 1.0f;
                this.shootY = 0.0f;
                this.range = 800.0f;
                this.recoil = 0.5f;
                this.rotateSpeed = 0.9f;
                this.shootSound = Sounds.missileLaunch;
                this.shootEffect = Fx.none;
                this.smokeEffect = Fx.shootSmokeMissile;
                this.unitSort = UnitSorts.strongest;
                this.coolant = this.consumeCoolant(0.2f);
                this.limitRange();
                this.setUsers();
            }
        };
        artemis = new ArcMissileTurret("artemis"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 70, Items.lead, 350, Items.graphite, 300, Items.silicon, 300, Items.titanium, 250, PMItems.tenelium, 120}));
                this.ammo(new Object[]{PMPayloads.basicBallisticMissile, PayloadBullets.artemisBasic, PMPayloads.recursiveBallisticMissile, PayloadBullets.artemisRecursive, PMPayloads.bombingBallisticMissile, PayloadBullets.artemisBombing});
                this.size = 5;
                this.scaledHealth = 160.0f;
                this.reload = 90.0f;
                this.range = 680.0f;
                this.minRange = 200.0f;
                this.shootY = 0.0f;
                this.shootSound = Sounds.missileLaunch;
                this.cooldownTime = 210.0f;
                this.shake = 5.0f;
                this.unitSort = UnitSorts.strongest;
                this.coolant = this.consumeCoolant(0.2f);
                this.limitRange();
                this.setUsers();
            }
        };
        paragon = new ArcMissileTurret("paragon"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.copper, 6000, Items.graphite, 5200, Items.silicon, 3500, Items.titanium, 2500, Items.thorium, 1250, Items.surgeAlloy, 1000, PMItems.tenelium, 1800}));
                this.ammo(new Object[]{PMPayloads.basicNuke, PayloadBullets.paragonBasic, PMPayloads.clusterNuke, PayloadBullets.paragonCluster, PMPayloads.empNuke, PayloadBullets.paragonEMP, PMPayloads.blackHoleNuke, PayloadBullets.paragonBlackHole, PMPayloads.sandboxNuke, PayloadBullets.ohno});
                this.size = 7;
                this.scaledHealth = 170.0f;
                this.reload = 720.0f;
                this.range = 1920.0f;
                this.minRange = 400.0f;
                this.shootY = 0.0f;
                this.shootSound = Sounds.missileLaunch;
                this.cooldownTime = 360.0f;
                this.shake = 10.0f;
                this.unitSort = UnitSorts.strongest;
                this.coolant = this.consumeCoolant(0.2f);
                this.limitRange();
                this.setUsers();
            }
        };
        judgement = new NexusTurret("judgement"){
            {
                this.requirements(Category.turret, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
                this.size = 9;
            }
        };
        testTurret0 = new ArcBulletTestTurret("test-turret0");
        testTurret1 = new SkyLaserTestTurret("test-turret1");
        testTurret2 = new ArcBulletScatterTestTurret("test-turret2");
        testTurret3 = new FreeTurret("test-turret3"){
            {
                this.shootType = new UltraRailgunBulletType(0.0f, 40.0f, 1.5E7f){
                    {
                        super(minSpeed, speed, damage);
                        this.lifetime = 90.0f;
                        this.width *= 4.0f;
                        this.glowWidth *= 4.0f;
                        this.hitSize = this.width * 2.0f;
                        this.strokeTo = 0.5f;
                        this.colors = new Color[6];
                        for (int i = 0; i < this.colors.length; ++i) {
                            this.colors[i] = Color.white.cpy().a(((float)i + 1.0f) / (float)this.colors.length);
                        }
                    }
                };
                this.shootEffect = new FlashEffect((Effect)new WrapDataEffect(UltraRailgunBulletType.defaultShockwave, Float.valueOf(1200.0f)), 60.0f);
            }
        };
        smartDrill = new SmartDrill("smart-drill"){
            {
                this.requirements(Category.production, ItemStack.with((Object[])new Object[]{Items.copper, 45, Items.graphite, 40, Items.silicon, 45, PMItems.tenelium, 35}));
                this.size = 3;
                this.drillTime = 260.0f;
                this.hasPower = true;
                this.tier = 5;
                this.updateEffect = Fx.pulverizeMedium;
                this.drillEffect = Fx.mineBig;
                this.rotateSpeed = -4.0f;
                this.consumePower(1.8f);
                this.consumeLiquid(Liquids.water, 0.09f).boost();
            }
        };
        unitMinerDepot = new UnitMinerDepot("unit-miner-depot"){
            {
                this.requirements(Category.production, BuildVisibility.sandboxOnly, ItemStack.with((Object[])new Object[0]));
                this.size = 3;
                this.buildTime = 480.0f;
                this.consumePower(0.13333334f);
                this.consumeLiquid(Liquids.nitrogen, 0.16666667f);
                this.itemCapacity = 100;
            }
        };
        burstDriver = new BurstDriver("burst-driver"){
            {
                this.requirements(Category.distribution, ItemStack.with((Object[])new Object[]{Items.titanium, 275, Items.silicon, 200, Items.lead, 350, Items.thorium, 125, PMItems.tenelium, 75}));
                this.size = 3;
                this.itemCapacity = 180;
                this.reload = 120.0f;
                this.shots = 90;
                this.delay = 0.75f;
                this.range = 560.0f;
                this.consumePower(2.75f);
            }
        };
        sandDriver = new SandDriver("sand-driver"){
            {
                this.size = 3;
                this.itemCapacity = 180;
                this.reload = 120.0f;
                this.shots = 90;
                this.delay = 0.75f;
                this.range = 560.0f;
                this.consumePower(0.1f);
            }
        };
        mindronCollider = new AccelerationCrafter("mindron-collider"){
            {
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{Items.silicon, 150, Items.metaglass, 50, Items.plastanium, 80, Items.thorium, 100}));
                this.size = 3;
                this.craftTime = 60.0f;
                this.hasLiquids = true;
                this.hasPower = true;
                this.liquidCapacity = 50.0f;
                this.accelerationSpeed = 4.0E-4f;
                this.decelerationSpeed = 0.003125f;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawSpeedPlasma(){
                    {
                        this.plasma1 = Items.titanium.color;
                        this.plasma2 = Items.thorium.color;
                    }
                }, new DrawDefault()});
                this.onCraft = tile -> {
                    Tmp.v1.setToRandomDirection().setLength(7.0f);
                    CrafterFx.colliderFusion.at(tile.x + Tmp.v1.x, tile.y + Tmp.v1.y);
                };
                this.consumePower(6.0f);
                this.consumeItems(ItemStack.with((Object[])new Object[]{Items.titanium, 2, Items.thorium, 2}));
                this.consumeLiquid(Liquids.cryofluid, 0.2f);
                this.outputItem = new ItemStack(PMItems.tenelium, 2);
            }
        };
        pyroclastForge = new FuelCrafter("forge"){
            {
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{Items.titanium, 600, Items.metaglass, 150, Items.plastanium, 175, Items.silicon, 370, Items.surgeAlloy, 150, PMItems.tenelium, 250}));
                this.size = 5;
                this.itemCapacity = 32;
                this.craftTime = 75.0f;
                this.hasPower = true;
                this.hasLiquids = false;
                this.craftEffect = CrafterFx.superSmeltsmoke;
                this.ambientSound = Sounds.smelter;
                this.ambientSoundVolume = 1.0f;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawDefault(), new DrawFlame(Color.valueOf((String)"ffef99")){
                    {
                        super(flameColor);
                        this.flameRadiusIn = 4.0f;
                        this.flameRadius = 7.5f;
                        this.flameRadiusMag = 2.5f;
                        this.flameRadiusScl = 8.0f;
                    }
                }});
                this.fuelItem = Items.pyratite;
                this.fuelPerItem = 3;
                this.fuelPerCraft = 12;
                this.fuelCapacity = 48;
                this.fuelUseReduction = 0.8f;
                this.consumePower(9.0f);
                this.consumeItems(ItemStack.with((Object[])new Object[]{Items.lead, 4, Items.sand, 10, Items.coal, 6}));
                this.outputItems = ItemStack.with((Object[])new Object[]{Items.silicon, 14, Items.metaglass, 6});
            }
        };
        shellPress = new PayloadCrafter("shell-press"){
            {
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{Items.copper, 75, Items.lead, 100, Items.titanium, 100, Items.silicon, 80}));
                this.size = 5;
                this.ambientSound = Sounds.machine;
                this.recipes(PMPayloads.emptyCruiseMissile, PMPayloads.emptyBallisticMissile, PMPayloads.emptyNuke);
                this.recipes.each(r -> {
                    r.centerBuild = true;
                });
                this.setRecipeProductionStats();
            }
        };
        missileFactory = new PayloadCrafter("missile-factory"){
            {
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{Items.copper, 350, Items.lead, 250, Items.silicon, 220, Items.plastanium, 160, Items.thorium, 110}));
                this.size = 5;
                this.hideDetails = false;
                this.ambientSound = Sounds.machine;
                this.liquidCapacity = 80.0f;
                this.recipes(PMPayloads.basicCruiseMissile, PMPayloads.incendiaryCruiseMissile, PMPayloads.splitterCruiseMissile, PMPayloads.basicBallisticMissile, PMPayloads.recursiveBallisticMissile, PMPayloads.bombingBallisticMissile, PMPayloads.basicNuke, PMPayloads.clusterNuke, PMPayloads.empNuke, PMPayloads.blackHoleNuke);
                ((Recipe)this.recipes.get((int)1)).liquidRequirements = new LiquidStack(Liquids.slag, 40.0f);
                this.setRecipeProductionStats();
            }
        };
        igneousPillar = new IgneousPillar("igneous-pillar"){
            {
                this.health = 120;
                this.destroySound = PMSounds.rockExplode;
                this.glowVariants = 5;
                this.glowWeights = new int[]{1, 4, 4, 5, 5};
            }
        };
        ((PillarFieldBulletType)PMBullets.pillarField).pillar = (IgneousPillar)igneousPillar;
        healZone = new EffectZone("rejuvenation-beacon"){
            final float healing = 60.0f;
            {
                this.requirements(Category.units, ItemStack.with((Object[])new Object[]{Items.silicon, 60, Items.plastanium, 35, PMItems.tenelium, 50}));
                this.size = 2;
                this.range = 128.0f;
                this.baseColor = Pal.heal;
                this.reload = 40.0f;
                this.zoneEffect = tile -> {
                    if (!all.contains(Healthc::damaged)) {
                        return;
                    }
                    all.each(u -> {
                        if (!u.damaged()) {
                            return;
                        }
                        u.heal(60.0f * tile.heat);
                        Fx.heal.at((Position)u);
                    });
                    Fx.healWaveDynamic.at((Position)tile, this.range);
                };
                this.activate = () -> all.contains(Healthc::damaged);
                this.consumePower(7.0f);
            }

            @Override
            public void setStats() {
                super.setStats();
                this.stats.add(Stat.repairSpeed, 60.0f * (60.0f / this.reload), StatUnit.perSecond);
            }
        };
        speedZone = new EffectZone("speed-field"){
            {
                this.requirements(Category.units, ItemStack.with((Object[])new Object[]{Items.silicon, 25, Items.titanium, 30, Items.lead, 30}));
                this.size = 2;
                this.range = 128.0f;
                this.zoneEffect = tile -> all.each(u -> u.apply(PMStatusEffects.speedBoost, 22.0f * tile.heat));
                this.consumePower(3.0f);
            }

            @Override
            public void setStats() {
                super.setStats();
                this.stats.add(Stat.output, PMStatValues.statusEffect(PMStatusEffects.speedBoost));
            }
        };
        strengthZone = new EffectZone("strength-emitter"){
            {
                this.requirements(Category.units, ItemStack.with((Object[])new Object[]{Items.silicon, 40, PMItems.tenelium, 35, Items.lead, 35, Items.phaseFabric, 20}));
                this.size = 2;
                this.range = 128.0f;
                this.baseColor = Pal.redderDust;
                this.zoneEffect = tile -> all.each(u -> u.apply(PMStatusEffects.strengthBoost, 22.0f * tile.heat));
                this.consumePower(10.0f);
            }

            @Override
            public void setStats() {
                super.setStats();
                this.stats.add(Stat.output, PMStatValues.statusEffect(PMStatusEffects.strengthBoost));
            }
        };
        harmacist = new EffectZone("harmacist"){
            {
                this.requirements(Category.units, BuildVisibility.sandboxOnly, ItemStack.with((Object[])new Object[0]));
                this.alwaysUnlocked = true;
                this.size = 2;
                this.range = 256.0f;
                this.baseColor = Color.red;
                this.reload = 2.0f;
                this.affectOwnTeam = false;
                this.affectEnemyTeam = true;
                this.zoneEffect = tile -> all.each(u -> {
                    Tmp.v1.set((Position)u).mulAdd(u.vel, PMBullets.harmanuke.lifetime);
                    if (!Tmp.v1.within((Position)tile, this.range)) {
                        return;
                    }
                    PMBullets.harmanuke.create((Teamc)tile, Tmp.v1.x, Tmp.v1.y, 0.0f);
                });
            }

            @Override
            public void setStats() {
                super.setStats();
                this.stats.add(Stat.reload, 60.0f / this.reload, StatUnit.perSecond);
                this.stats.add(Stat.ammo, StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{this, PMBullets.harmanuke})));
            }
        };
        coreShatter = new CrashCore("core-cripple"){
            {
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{Items.copper, 400, Items.lead, 150}));
                this.isFirstTier = true;
                this.unitType = UnitTypes.alpha;
                this.health = 500;
                this.itemCapacity = 1500;
                this.size = 2;
                this.explosionSoundVolume = 4.0f;
                this.thrusterLength = 2.0f;
                this.unitCapModifier = 3;
            }
        };
        Blocks.coreShard.buildVisibility = BuildVisibility.shown;
        ((CoreBlock)Blocks.coreShard).isFirstTier = false;
        coreCovalence = new CoreLink("core-covalence"){
            {
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{Items.copper, 6000, Items.lead, 6000, Items.silicon, 3000, Items.thorium, 2000, Items.phaseFabric, 1000, PMItems.tenelium, 3000}));
                this.size = 4;
                this.portalRad = 7.5f;
                this.clouds = 15;
                this.minCloudSize = 0.5f;
                this.maxCloudSize = 1.25f;
                this.consumePower(42.5f);
            }
        };
        fence = new StaticNode("fence"){
            {
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{Items.copper, 60, Items.lead, 50, Items.silicon, 20}));
                this.size = 1;
                this.health = 90;
                this.laserRange = 35;
                this.damage = 7.0f;
                this.powerPerLink = 1.2f;
            }
        };
        web = new StaticNode("web"){
            {
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{Items.copper, 70, Items.lead, 35, Items.silicon, 25}));
                this.size = 1;
                this.health = 110;
                this.laserRange = 17;
                this.maxNodes = 6;
                this.damage = 4.0f;
                this.powerPerLink = 0.5f;
            }
        };
        ballisticProjector = new ShieldProjector("shield-projector"){
            {
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{Items.lead, 325, Items.titanium, 225, Items.surgeAlloy, 75, PMItems.tenelium, 125}));
                this.size = 4;
                this.sides = 4;
                this.radius = 64.5f;
                this.phaseRadiusBoost = 27.5f;
                this.height = 64.0f;
                this.phaseHeightBoost = 32.0f;
                this.shieldHealth = 3600.0f;
                this.phaseShieldBoost = 2000.0f;
                this.shieldCharge = 700.0f;
                this.phaseShieldCharge = 400.0f;
                this.chargeTime = 450.0f;
                this.cooldownBrokenBase *= 2.0f;
                this.hideDetails = false;
                this.consumePower(7.0f);
                this.itemConsumer = this.consumeItems(ItemStack.with((Object[])new Object[]{Items.phaseFabric, 1, PMItems.tenelium, 1})).boost();
            }
        };
        PMErekirBlocks.load();
    }
}

