/*
 * Decompiled with CFR 0.152.
 */
package progressed.ai;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.units.AIController;
import progressed.gen.entities.SwordUnitc;
import progressed.type.unit.SwordUnitType;
import progressed.world.blocks.defence.turret.SwordTurret;

public class SwordAI
extends AIController {
    Rand curveRand = new Rand();
    float curveScl;
    float attackTimer;
    boolean curving;
    boolean rotating;
    boolean inRange;

    public void init() {
        this.curveRand.setSeed((long)this.unit.id);
    }

    public void updateMovement() {
        SwordTurret.SwordTurretBuild swordTurret = this.sturret();
        if (swordTurret == null) {
            return;
        }
        if (swordTurret.isActive()) {
            this.attackTimer += Time.delta;
            if (this.attackTimer >= (float)this.sunit().orbitPos() * this.stype().attackTimeOffset) {
                this.attackTimer = (float)this.sunit().orbitPos() * this.stype().attackTimeOffset + 60.0f;
            }
        } else {
            this.attackTimer -= Time.delta;
            if (this.attackTimer <= 0.0f) {
                this.attackTimer = 0.0f;
                this.inRange = false;
                this.rotating = false;
                this.curving = false;
            }
        }
        if (this.shouldAttack()) {
            this.attack((Position)swordTurret.targetPos, this.stype().attackRadius);
        } else {
            float count = Math.max(swordTurret.swordCount(), 1);
            float pos = 360.0f / count * (float)this.sunit().orbitPos() - Time.time * this.stype().orbitSpeed + swordTurret.rotation + Mathf.randomSeed((long)swordTurret.id, (float)360.0f);
            Tmp.v1.trns(Mathf.mod((float)pos, (float)360.0f), this.stype().orbitRadius).add((Position)swordTurret);
            this.moveTo((Position)Tmp.v1, 1.0f, 20.0f);
            this.unit.lookAt(swordTurret.rotation);
        }
    }

    public void updateVisuals() {
    }

    public void attack(Position target, float circleLength) {
        vec.set(target).sub((Position)this.unit);
        float ang = this.unit.angleTo(target);
        float diff = Angles.angleDist((float)ang, (float)this.unit.rotation());
        if (vec.len() < circleLength) {
            this.inRange = true;
        }
        if (diff > 70.0f && vec.len() < circleLength) {
            this.curving = true;
        }
        if (this.curving) {
            if (vec.len() < circleLength) {
                this.unit.rotation += this.curveScl;
            } else {
                this.rotating = true;
                this.unit.lookAt(target);
                if (Angles.within((float)this.unit.rotation, (float)this.unit.angleTo(target), (float)15.0f)) {
                    this.rotating = false;
                    this.curving = false;
                    this.curveScl = this.curveRand.range(this.stype().curveRnd);
                    this.sunit().clearCollided();
                }
            }
        } else {
            this.unit.lookAt(target);
        }
        vec.trns(this.unit.rotation, this.unit.speed());
        this.unit.moveAt(vec);
    }

    public float speed() {
        return this.rotating ? this.stype().neutralSpeed : (this.inRange ? this.stype().speed * this.sturret().efficiency : (this.shouldAttack() ? this.stype().travelSpeed * this.sturret().efficiency : this.stype().neutralSpeed));
    }

    public boolean shouldAttack() {
        return this.attackTimer > (float)this.sunit().orbitPos() * this.stype().attackTimeOffset;
    }

    public boolean shouldDamage() {
        return this.shouldAttack() && !this.rotating;
    }

    public SwordUnitType stype() {
        return this.sunit().stype();
    }

    public SwordUnitc sunit() {
        return (SwordUnitc)this.unit;
    }

    public SwordTurret.SwordTurretBuild sturret() {
        return (SwordTurret.SwordTurretBuild)this.sunit().building();
    }
}

