/*
 * Decompiled with CFR 0.152.
 */
package progressed.ai;

import arc.math.geom.Position;
import arc.math.geom.Vec2;
import mindustry.Vars;
import mindustry.entities.units.AIController;
import mindustry.gen.Building;
import mindustry.gen.BuildingTetherc;
import mindustry.gen.Call;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.world.Tile;
import progressed.world.blocks.production.UnitMinerDepot;

public class DepotMinerAI
extends AIController {
    protected final Vec2 targetPos = new Vec2();
    protected final Vec2 vecOut = new Vec2();
    protected final Vec2 vecMovePos = new Vec2();
    protected static final boolean[] noFound = new boolean[]{false};
    public boolean mining = true;
    public Tile targetTile;

    public void updateMovement() {
        if (!this.unit.canMine()) {
            return;
        }
        if (this.unit.mineTile != null && !this.unit.mineTile.within((Position)this.unit, this.unit.type.mineRange)) {
            this.unit.mineTile(null);
        }
        UnitMinerDepot.UnitMinerDepotBuild home = this.home();
        if (this.mining) {
            if (this.targetItem() == null || home.oreTiles.getNull((Object)this.targetItem()) == null || this.unit.stack.amount >= this.unit.type.itemCapacity || this.targetItem() != null && !this.unit.acceptsItem(this.targetItem()) || home.acceptStack(this.targetItem(), 1, (Teamc)this.unit) == 0) {
                this.mining = false;
            } else {
                Tile ore;
                if (!home.targetSet && this.timer.get(0, 40.0f) && (ore = Vars.indexer.findClosestOre(this.unit, this.targetItem())) != this.targetTile && this.unit.within(ore.worldx(), ore.worldy(), this.unit.type.mineRange)) {
                    home.oreTiles.put((Object)this.targetItem(), (Object)ore);
                }
                if (this.targetTile != home.oreTiles.get((Object)this.targetItem())) {
                    this.targetTile = (Tile)home.oreTiles.get((Object)this.targetItem());
                    this.targetPos.set(this.targetTile.worldx(), this.targetTile.worldy());
                }
                if (this.unit.within((Position)this.targetTile, this.unit.type.mineRange)) {
                    this.unit.mineTile = this.targetTile;
                }
            }
        } else {
            this.unit.mineTile = null;
            if (this.unit.stack.amount == 0 && this.targetItem() != null) {
                this.mining = true;
                return;
            }
            if (this.targetTile != home.tile) {
                this.targetTile = home.tile;
                this.targetPos.set((Position)home);
            }
            if (this.unit.within((Position)home, this.unit.type.range)) {
                if (home.acceptStack(this.unit.stack.item, this.unit.stack.amount, (Teamc)this.unit) > 0) {
                    Call.transferItemTo((Unit)this.unit, (Item)this.unit.stack.item, (int)this.unit.stack.amount, (float)this.unit.x, (float)this.unit.y, (Building)home);
                }
                this.unit.clearItem();
                this.mining = true;
            }
        }
        this.move();
        this.faceMovement();
        if (!this.unit.moving() && this.unit.mineTile != null) {
            this.unit.lookAt((Position)this.unit.mineTile);
        }
    }

    public void move() {
        if (this.unit.type.flying) {
            this.moveTo((Position)this.targetPos, this.mining ? this.unit.type.mineRange / 2.0f : 0.0f, 20.0f);
        } else {
            this.vecOut.set(this.targetPos);
            boolean move = Vars.controlPath.getPathPosition(this.unit, this.vecMovePos, this.targetPos, this.vecOut, noFound);
            if (move) {
                this.moveTo((Position)this.vecOut, this.mining && this.unit.within((Position)this.targetPos, this.unit.type.mineRange / 2.0f) ? this.unit.type.mineRange : 0.5f, 8.0f);
            }
        }
    }

    public UnitMinerDepot.UnitMinerDepotBuild home() {
        return (UnitMinerDepot.UnitMinerDepotBuild)((BuildingTetherc)this.unit).building();
    }

    public Item targetItem() {
        return this.home().targetItem;
    }
}

