﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// NOTE: This file was generated by $(WpfCodeGenDir)AvTrace\AvTraceMessages.tt.
// Any manual updates to this file will overwritten.

namespace MS.Internal
{
    internal static partial class TraceData
    {
        private static AvTrace _avTrace = new AvTrace(
                delegate() { return PresentationTraceSources.DataBindingSource; },
                delegate() { PresentationTraceSources._DataBindingSource = null; }
                );
        private static AvTraceDetails _CannotCreateDefaultValueConverter;
        public static AvTraceDetails CannotCreateDefaultValueConverter(params object[] args)
        {
            if ( _CannotCreateDefaultValueConverter == null )
            {
                _CannotCreateDefaultValueConverter = new AvTraceDetails(1, new string[] { "Cannot create default converter to perform '{2}' conversions between types '{0}' and '{1}'. Consider using Converter property of Binding." } );
            }
            return new AvTraceFormat(_CannotCreateDefaultValueConverter, args);
        }

        private static AvTraceDetails _NoMentor;
		public static AvTraceDetails NoMentor
        {
            get
            {
                if ( _NoMentor == null )
                {
                    _NoMentor = new AvTraceDetails(2, new string[] { "Cannot find governing FrameworkElement or FrameworkContentElement for target element." } );
                }

                return _NoMentor;
            }
        }

        private static AvTraceDetails _NoDataContext;
		public static AvTraceDetails NoDataContext
        {
            get
            {
                if ( _NoDataContext == null )
                {
                    _NoDataContext = new AvTraceDetails(3, new string[] { "UpdateCannot find element that provides DataContext." } );
                }

                return _NoDataContext;
            }
        }

        private static AvTraceDetails _NoSource;
        public static AvTraceDetails NoSource(params object[] args)
        {
            if ( _NoSource == null )
            {
                _NoSource = new AvTraceDetails(4, new string[] { "Cannot find source for binding with reference '{0}'." } );
            }
            return new AvTraceFormat(_NoSource, args);
        }

        private static AvTraceDetails _BadValueAtTransfer;
		public static AvTraceDetails BadValueAtTransfer
        {
            get
            {
                if ( _BadValueAtTransfer == null )
                {
                    _BadValueAtTransfer = new AvTraceDetails(5, new string[] { "Value produced by BindingExpression is not valid for target property." } );
                }

                return _BadValueAtTransfer;
            }
        }

        private static AvTraceDetails _BadConverterForTransfer;
        public static AvTraceDetails BadConverterForTransfer(params object[] args)
        {
            if ( _BadConverterForTransfer == null )
            {
                _BadConverterForTransfer = new AvTraceDetails(6, new string[] { "'{0}' converter failed to convert value '{1}' (type '{2}'); fallback value will be used, if available." } );
            }
            return new AvTraceFormat(_BadConverterForTransfer, args);
        }

        private static AvTraceDetails _BadConverterForUpdate;
        public static AvTraceDetails BadConverterForUpdate(params object[] args)
        {
            if ( _BadConverterForUpdate == null )
            {
                _BadConverterForUpdate = new AvTraceDetails(7, new string[] { "ConvertBack cannot convert value '{0}' (type '{1}')." } );
            }
            return new AvTraceFormat(_BadConverterForUpdate, args);
        }

        private static AvTraceDetails _WorkerUpdateFailed;
		public static AvTraceDetails WorkerUpdateFailed
        {
            get
            {
                if ( _WorkerUpdateFailed == null )
                {
                    _WorkerUpdateFailed = new AvTraceDetails(8, new string[] { "Cannot save value from target back to source." } );
                }

                return _WorkerUpdateFailed;
            }
        }

        private static AvTraceDetails _RequiresExplicitCulture;
		public static AvTraceDetails RequiresExplicitCulture
        {
            get
            {
                if ( _RequiresExplicitCulture == null )
                {
                    _RequiresExplicitCulture = new AvTraceDetails(9, new string[] { "Binding for property cannot use the target element's Language for conversion; if a culture is required, ConverterCulture must be explicitly specified on the Binding." } );
                }

                return _RequiresExplicitCulture;
            }
        }

        private static AvTraceDetails _NoValueToTransfer;
		public static AvTraceDetails NoValueToTransfer
        {
            get
            {
                if ( _NoValueToTransfer == null )
                {
                    _NoValueToTransfer = new AvTraceDetails(10, new string[] { "Cannot retrieve value using the binding and no valid fallback value exists; using default instead." } );
                }

                return _NoValueToTransfer;
            }
        }

        private static AvTraceDetails _FallbackConversionFailed;
        public static AvTraceDetails FallbackConversionFailed(params object[] args)
        {
            if ( _FallbackConversionFailed == null )
            {
                _FallbackConversionFailed = new AvTraceDetails(11, new string[] { "Fallback value '{0}' (type '{1}') cannot be converted for use in '{2}' (type '{3}')." } );
            }
            return new AvTraceFormat(_FallbackConversionFailed, args);
        }

        private static AvTraceDetails _TargetNullValueConversionFailed;
        public static AvTraceDetails TargetNullValueConversionFailed(params object[] args)
        {
            if ( _TargetNullValueConversionFailed == null )
            {
                _TargetNullValueConversionFailed = new AvTraceDetails(12, new string[] { "TargetNullValue '{0}' (type '{1}') cannot be converted for use in '{2}' (type '{3}')." } );
            }
            return new AvTraceFormat(_TargetNullValueConversionFailed, args);
        }

        private static AvTraceDetails _BindingGroupNameMatchFailed;
        public static AvTraceDetails BindingGroupNameMatchFailed(params object[] args)
        {
            if ( _BindingGroupNameMatchFailed == null )
            {
                _BindingGroupNameMatchFailed = new AvTraceDetails(13, new string[] { "No BindingGroup found with name matching '{0}'." } );
            }
            return new AvTraceFormat(_BindingGroupNameMatchFailed, args);
        }

        private static AvTraceDetails _BindingGroupWrongProperty;
        public static AvTraceDetails BindingGroupWrongProperty(params object[] args)
        {
            if ( _BindingGroupWrongProperty == null )
            {
                _BindingGroupWrongProperty = new AvTraceDetails(14, new string[] { "BindingGroup used as a value of property '{0}' on object of type '{1}'.  This may disable its normal behavior." } );
            }
            return new AvTraceFormat(_BindingGroupWrongProperty, args);
        }

        private static AvTraceDetails _BindingGroupMultipleInheritance;
		public static AvTraceDetails BindingGroupMultipleInheritance
        {
            get
            {
                if ( _BindingGroupMultipleInheritance == null )
                {
                    _BindingGroupMultipleInheritance = new AvTraceDetails(15, new string[] { "BindingGroup used as a value of multiple properties.  This disables its normal behavior." } );
                }

                return _BindingGroupMultipleInheritance;
            }
        }

        private static AvTraceDetails _SharesProposedValuesRequriesImplicitBindingGroup;
        public static AvTraceDetails SharesProposedValuesRequriesImplicitBindingGroup(params object[] args)
        {
            if ( _SharesProposedValuesRequriesImplicitBindingGroup == null )
            {
                _SharesProposedValuesRequriesImplicitBindingGroup = new AvTraceDetails(16, new string[] { "Binding expression '{0}' with BindingGroupName '{1}' has joined BindingGroup '{2}' with SharesProposedValues='true'.  The SharesProposedValues feature only works for binding expressions that implicitly join a binding group." } );
            }
            return new AvTraceFormat(_SharesProposedValuesRequriesImplicitBindingGroup, args);
        }

        private static AvTraceDetails _CannotGetClrRawValue;
        public static AvTraceDetails CannotGetClrRawValue(params object[] args)
        {
            if ( _CannotGetClrRawValue == null )
            {
                _CannotGetClrRawValue = new AvTraceDetails(17, new string[] { "Cannot get '{0}' value (type '{1}') from '{2}' (type '{3}')." } );
            }
            return new AvTraceFormat(_CannotGetClrRawValue, args);
        }

        private static AvTraceDetails _CannotSetClrRawValue;
        public static AvTraceDetails CannotSetClrRawValue(params object[] args)
        {
            if ( _CannotSetClrRawValue == null )
            {
                _CannotSetClrRawValue = new AvTraceDetails(18, new string[] { "'{3}' is not a valid value for '{0}' of '{2}'." } );
            }
            return new AvTraceFormat(_CannotSetClrRawValue, args);
        }

        private static AvTraceDetails _MissingDataItem;
		public static AvTraceDetails MissingDataItem
        {
            get
            {
                if ( _MissingDataItem == null )
                {
                    _MissingDataItem = new AvTraceDetails(19, new string[] { "BindingExpression has no source data item. This could happen when currency is moved to a null data item or moved off the list." } );
                }

                return _MissingDataItem;
            }
        }

        private static AvTraceDetails _MissingInfo;
		public static AvTraceDetails MissingInfo
        {
            get
            {
                if ( _MissingInfo == null )
                {
                    _MissingInfo = new AvTraceDetails(20, new string[] { "BindingExpression cannot retrieve value due to missing information." } );
                }

                return _MissingInfo;
            }
        }

        private static AvTraceDetails _NullDataItem;
		public static AvTraceDetails NullDataItem
        {
            get
            {
                if ( _NullDataItem == null )
                {
                    _NullDataItem = new AvTraceDetails(21, new string[] { "BindingExpression cannot retrieve value from null data item. This could happen when binding is detached or when binding to a Nullable type that has no value." } );
                }

                return _NullDataItem;
            }
        }

        private static AvTraceDetails _DefaultValueConverterFailed;
        public static AvTraceDetails DefaultValueConverterFailed(params object[] args)
        {
            if ( _DefaultValueConverterFailed == null )
            {
                _DefaultValueConverterFailed = new AvTraceDetails(22, new string[] { "Cannot convert '{0}' from type '{1}' to type '{2}' with default conversions; consider using Converter property of Binding." } );
            }
            return new AvTraceFormat(_DefaultValueConverterFailed, args);
        }

        private static AvTraceDetails _DefaultValueConverterFailedForCulture;
        public static AvTraceDetails DefaultValueConverterFailedForCulture(params object[] args)
        {
            if ( _DefaultValueConverterFailedForCulture == null )
            {
                _DefaultValueConverterFailedForCulture = new AvTraceDetails(23, new string[] { "Cannot convert '{0}' from type '{1}' to type '{2}' for '{3}' culture with default conversions; consider using Converter property of Binding." } );
            }
            return new AvTraceFormat(_DefaultValueConverterFailedForCulture, args);
        }

        private static AvTraceDetails _StyleAndStyleSelectorDefined;
        public static AvTraceDetails StyleAndStyleSelectorDefined(params object[] args)
        {
            if ( _StyleAndStyleSelectorDefined == null )
            {
                _StyleAndStyleSelectorDefined = new AvTraceDetails(24, new string[] { "Both '{0}Style' and '{0}StyleSelector' are set;  '{0}StyleSelector' will be ignored." } );
            }
            return new AvTraceFormat(_StyleAndStyleSelectorDefined, args);
        }

        private static AvTraceDetails _TemplateAndTemplateSelectorDefined;
        public static AvTraceDetails TemplateAndTemplateSelectorDefined(params object[] args)
        {
            if ( _TemplateAndTemplateSelectorDefined == null )
            {
                _TemplateAndTemplateSelectorDefined = new AvTraceDetails(25, new string[] { "Both '{0}Template' and '{0}TemplateSelector' are set;  '{0}TemplateSelector' will be ignored." } );
            }
            return new AvTraceFormat(_TemplateAndTemplateSelectorDefined, args);
        }

        private static AvTraceDetails _ItemTemplateForDirectItem;
		public static AvTraceDetails ItemTemplateForDirectItem
        {
            get
            {
                if ( _ItemTemplateForDirectItem == null )
                {
                    _ItemTemplateForDirectItem = new AvTraceDetails(26, new string[] { "ItemTemplate and ItemTemplateSelector are ignored for items already of the ItemsControl's container type" } );
                }

                return _ItemTemplateForDirectItem;
            }
        }

        private static AvTraceDetails _BadMultiConverterForUpdate;
        public static AvTraceDetails BadMultiConverterForUpdate(params object[] args)
        {
            if ( _BadMultiConverterForUpdate == null )
            {
                _BadMultiConverterForUpdate = new AvTraceDetails(27, new string[] { "'{0}' MultiValueConverter failed to convert back value '{1}' (type '{2}'). Check the converter's ConvertBack method." } );
            }
            return new AvTraceFormat(_BadMultiConverterForUpdate, args);
        }

        private static AvTraceDetails _MultiValueConverterMissingForTransfer;
		public static AvTraceDetails MultiValueConverterMissingForTransfer
        {
            get
            {
                if ( _MultiValueConverterMissingForTransfer == null )
                {
                    _MultiValueConverterMissingForTransfer = new AvTraceDetails(28, new string[] { "MultiBinding failed because it has no valid Converter." } );
                }

                return _MultiValueConverterMissingForTransfer;
            }
        }

        private static AvTraceDetails _MultiValueConverterMissingForUpdate;
		public static AvTraceDetails MultiValueConverterMissingForUpdate
        {
            get
            {
                if ( _MultiValueConverterMissingForUpdate == null )
                {
                    _MultiValueConverterMissingForUpdate = new AvTraceDetails(29, new string[] { "MultiBinding cannot update value on source item because there is no valid Converter." } );
                }

                return _MultiValueConverterMissingForUpdate;
            }
        }

        private static AvTraceDetails _MultiValueConverterMismatch;
		public static AvTraceDetails MultiValueConverterMismatch
        {
            get
            {
                if ( _MultiValueConverterMismatch == null )
                {
                    _MultiValueConverterMismatch = new AvTraceDetails(30, new string[] { "MultiValueConverter did not return the same number of values as the count of inner bindings." } );
                }

                return _MultiValueConverterMismatch;
            }
        }

        private static AvTraceDetails _MultiBindingHasNoConverter;
		public static AvTraceDetails MultiBindingHasNoConverter
        {
            get
            {
                if ( _MultiBindingHasNoConverter == null )
                {
                    _MultiBindingHasNoConverter = new AvTraceDetails(31, new string[] { "Cannot set MultiBinding because MultiValueConverter must be specified." } );
                }

                return _MultiBindingHasNoConverter;
            }
        }

        private static AvTraceDetails _UnsetValueInMultiBindingExpressionUpdate;
        public static AvTraceDetails UnsetValueInMultiBindingExpressionUpdate(params object[] args)
        {
            if ( _UnsetValueInMultiBindingExpressionUpdate == null )
            {
                _UnsetValueInMultiBindingExpressionUpdate = new AvTraceDetails(32, new string[] { "'{0}' MultiValueConverter returned UnsetValue after converting '{1}' for source binding '{2}' (type '{3}')." } );
            }
            return new AvTraceFormat(_UnsetValueInMultiBindingExpressionUpdate, args);
        }

        private static AvTraceDetails _ObjectDataProviderHasNoSource;
		public static AvTraceDetails ObjectDataProviderHasNoSource
        {
            get
            {
                if ( _ObjectDataProviderHasNoSource == null )
                {
                    _ObjectDataProviderHasNoSource = new AvTraceDetails(33, new string[] { "ObjectDataProvider needs either an ObjectType or ObjectInstance." } );
                }

                return _ObjectDataProviderHasNoSource;
            }
        }

        private static AvTraceDetails _ObjDPCreateFailed;
		public static AvTraceDetails ObjDPCreateFailed
        {
            get
            {
                if ( _ObjDPCreateFailed == null )
                {
                    _ObjDPCreateFailed = new AvTraceDetails(34, new string[] { "ObjectDataProvider cannot create object" } );
                }

                return _ObjDPCreateFailed;
            }
        }

        private static AvTraceDetails _ObjDPInvokeFailed;
		public static AvTraceDetails ObjDPInvokeFailed
        {
            get
            {
                if ( _ObjDPInvokeFailed == null )
                {
                    _ObjDPInvokeFailed = new AvTraceDetails(35, new string[] { "ObjectDataProvider: Failure trying to invoke method on type" } );
                }

                return _ObjDPInvokeFailed;
            }
        }

        private static AvTraceDetails _RefPreviousNotInContext;
		public static AvTraceDetails RefPreviousNotInContext
        {
            get
            {
                if ( _RefPreviousNotInContext == null )
                {
                    _RefPreviousNotInContext = new AvTraceDetails(36, new string[] { "Cannot find previous element for use as RelativeSource because there is no parent in generated context." } );
                }

                return _RefPreviousNotInContext;
            }
        }

        private static AvTraceDetails _RefNoWrapperInChildren;
		public static AvTraceDetails RefNoWrapperInChildren
        {
            get
            {
                if ( _RefNoWrapperInChildren == null )
                {
                    _RefNoWrapperInChildren = new AvTraceDetails(37, new string[] { "Cannot find previous element for use as RelativeSource because children cannot be found for parent element." } );
                }

                return _RefNoWrapperInChildren;
            }
        }

        private static AvTraceDetails _RefAncestorTypeNotSpecified;
		public static AvTraceDetails RefAncestorTypeNotSpecified
        {
            get
            {
                if ( _RefAncestorTypeNotSpecified == null )
                {
                    _RefAncestorTypeNotSpecified = new AvTraceDetails(38, new string[] { "Reference error: cannot find ancestor element; no AncestorType was specified on RelativeSource." } );
                }

                return _RefAncestorTypeNotSpecified;
            }
        }

        private static AvTraceDetails _RefAncestorLevelInvalid;
		public static AvTraceDetails RefAncestorLevelInvalid
        {
            get
            {
                if ( _RefAncestorLevelInvalid == null )
                {
                    _RefAncestorLevelInvalid = new AvTraceDetails(39, new string[] { "Reference error: cannot find ancestor element; AncestorLevel on RelativeSource must be greater than 0." } );
                }

                return _RefAncestorLevelInvalid;
            }
        }

        private static AvTraceDetails _ClrReplaceItem;
        public static AvTraceDetails ClrReplaceItem(params object[] args)
        {
            if ( _ClrReplaceItem == null )
            {
                _ClrReplaceItem = new AvTraceDetails(40, new string[] { "BindingExpression path error: '{0}' property not found on '{2}' '{1}'." } );
            }
            return new AvTraceFormat(_ClrReplaceItem, args);
        }

        private static AvTraceDetails _NullItem;
        public static AvTraceDetails NullItem(params object[] args)
        {
            if ( _NullItem == null )
            {
                _NullItem = new AvTraceDetails(41, new string[] { "BindingExpression path error: '{0}' property not found for '{1}' because data item is null. This could happen because the data provider has not produced any data yet." } );
            }
            return new AvTraceFormat(_NullItem, args);
        }

        private static AvTraceDetails _PlaceholderItem;
        public static AvTraceDetails PlaceholderItem(params object[] args)
        {
            if ( _PlaceholderItem == null )
            {
                _PlaceholderItem = new AvTraceDetails(42, new string[] { "BindingExpression path error: '{0}' property not found for '{1}' because data item is the NewItemPlaceholder." } );
            }
            return new AvTraceFormat(_PlaceholderItem, args);
        }

        private static AvTraceDetails _DataErrorInfoFailed;
        public static AvTraceDetails DataErrorInfoFailed(params object[] args)
        {
            if ( _DataErrorInfoFailed == null )
            {
                _DataErrorInfoFailed = new AvTraceDetails(43, new string[] { "Cannot obtain IDataErrorInfo.Error[{0}] from source of type {1} - {2} '{3}'" } );
            }
            return new AvTraceFormat(_DataErrorInfoFailed, args);
        }

        private static AvTraceDetails _DisallowTwoWay;
        public static AvTraceDetails DisallowTwoWay(params object[] args)
        {
            if ( _DisallowTwoWay == null )
            {
                _DisallowTwoWay = new AvTraceDetails(44, new string[] { "Binding mode has been changed to OneWay because source property '{0}.{1}' has a non-public setter." } );
            }
            return new AvTraceFormat(_DisallowTwoWay, args);
        }

        private static AvTraceDetails _XmlBindingToNonXml;
		public static AvTraceDetails XmlBindingToNonXml
        {
            get
            {
                if ( _XmlBindingToNonXml == null )
                {
                    _XmlBindingToNonXml = new AvTraceDetails(45, new string[] { "BindingExpression with XPath cannot bind to non-XML object." } );
                }

                return _XmlBindingToNonXml;
            }
        }

        private static AvTraceDetails _XmlBindingToNonXmlCollection;
		public static AvTraceDetails XmlBindingToNonXmlCollection
        {
            get
            {
                if ( _XmlBindingToNonXmlCollection == null )
                {
                    _XmlBindingToNonXmlCollection = new AvTraceDetails(46, new string[] { "BindingExpression with XPath cannot bind to a collection with non-XML objects." } );
                }

                return _XmlBindingToNonXmlCollection;
            }
        }

        private static AvTraceDetails _CannotGetXmlNodeCollection;
		public static AvTraceDetails CannotGetXmlNodeCollection
        {
            get
            {
                if ( _CannotGetXmlNodeCollection == null )
                {
                    _CannotGetXmlNodeCollection = new AvTraceDetails(47, new string[] { "XML binding failed. Cannot obtain result node collection because of bad source node or bad Path." } );
                }

                return _CannotGetXmlNodeCollection;
            }
        }

        private static AvTraceDetails _BadXPath;
        public static AvTraceDetails BadXPath(params object[] args)
        {
            if ( _BadXPath == null )
            {
                _BadXPath = new AvTraceDetails(48, new string[] { "XPath '{0}' returned no results on XmlNode '{1}'" } );
            }
            return new AvTraceFormat(_BadXPath, args);
        }

        private static AvTraceDetails _XmlDPInlineDocError;
		public static AvTraceDetails XmlDPInlineDocError
        {
            get
            {
                if ( _XmlDPInlineDocError == null )
                {
                    _XmlDPInlineDocError = new AvTraceDetails(49, new string[] { "XmlDataProvider cannot load inline document because of load or parse error in XML." } );
                }

                return _XmlDPInlineDocError;
            }
        }

        private static AvTraceDetails _XmlNamespaceNotSet;
		public static AvTraceDetails XmlNamespaceNotSet
        {
            get
            {
                if ( _XmlNamespaceNotSet == null )
                {
                    _XmlNamespaceNotSet = new AvTraceDetails(50, new string[] { "XmlDataProvider has inline XML that does not explicitly set its XmlNamespace (xmlns='')." } );
                }

                return _XmlNamespaceNotSet;
            }
        }

        private static AvTraceDetails _XmlDPAsyncDocError;
		public static AvTraceDetails XmlDPAsyncDocError
        {
            get
            {
                if ( _XmlDPAsyncDocError == null )
                {
                    _XmlDPAsyncDocError = new AvTraceDetails(51, new string[] { "XmlDataProvider cannot load asynchronous document from Source because of load or parse error in XML stream." } );
                }

                return _XmlDPAsyncDocError;
            }
        }

        private static AvTraceDetails _XmlDPSelectNodesFailed;
		public static AvTraceDetails XmlDPSelectNodesFailed
        {
            get
            {
                if ( _XmlDPSelectNodesFailed == null )
                {
                    _XmlDPSelectNodesFailed = new AvTraceDetails(52, new string[] { "Cannot select nodes because XPath for Binding is not valid" } );
                }

                return _XmlDPSelectNodesFailed;
            }
        }

        private static AvTraceDetails _CollectionViewIsUnsupported;
		public static AvTraceDetails CollectionViewIsUnsupported
        {
            get
            {
                if ( _CollectionViewIsUnsupported == null )
                {
                    _CollectionViewIsUnsupported = new AvTraceDetails(53, new string[] { "Using CollectionView directly is not fully supported. The basic features work, although with some inefficiencies, but advanced features may encounter known bugs. Consider using a derived class to avoid these problems." } );
                }

                return _CollectionViewIsUnsupported;
            }
        }

        private static AvTraceDetails _CollectionChangedWithoutNotification;
        public static AvTraceDetails CollectionChangedWithoutNotification(params object[] args)
        {
            if ( _CollectionChangedWithoutNotification == null )
            {
                _CollectionChangedWithoutNotification = new AvTraceDetails(54, new string[] { "Collection of type '{0}' has been changed without raising a CollectionChanged event. Support for this is incomplete and inconsistent, and will be removed completely in a future version of WPF. Consider either (a) implementing INotifyCollectionChanged, or (b) avoiding changes to this type of collection." } );
            }
            return new AvTraceFormat(_CollectionChangedWithoutNotification, args);
        }

        private static AvTraceDetails _CannotSort;
        public static AvTraceDetails CannotSort(params object[] args)
        {
            if ( _CannotSort == null )
            {
                _CannotSort = new AvTraceDetails(55, new string[] { "Cannot sort by '{0}'" } );
            }
            return new AvTraceFormat(_CannotSort, args);
        }

        private static AvTraceDetails _CreatedExpression;
        public static AvTraceDetails CreatedExpression(params object[] args)
        {
            if ( _CreatedExpression == null )
            {
                _CreatedExpression = new AvTraceDetails(56, new string[] { "Created {0} for {1}" } );
            }
            return new AvTraceFormat(_CreatedExpression, args);
        }

        private static AvTraceDetails _CreatedExpressionInParent;
        public static AvTraceDetails CreatedExpressionInParent(params object[] args)
        {
            if ( _CreatedExpressionInParent == null )
            {
                _CreatedExpressionInParent = new AvTraceDetails(57, new string[] { "Created {0} for {1} within {2}" } );
            }
            return new AvTraceFormat(_CreatedExpressionInParent, args);
        }

        private static AvTraceDetails _BindingPath;
        public static AvTraceDetails BindingPath(params object[] args)
        {
            if ( _BindingPath == null )
            {
                _BindingPath = new AvTraceDetails(58, new string[] { " Path: {0}" } );
            }
            return new AvTraceFormat(_BindingPath, args);
        }

        private static AvTraceDetails _BindingXPathAndPath;
        public static AvTraceDetails BindingXPathAndPath(params object[] args)
        {
            if ( _BindingXPathAndPath == null )
            {
                _BindingXPathAndPath = new AvTraceDetails(59, new string[] { " XPath: {0} Path: {1}" } );
            }
            return new AvTraceFormat(_BindingXPathAndPath, args);
        }

        private static AvTraceDetails _ResolveDefaultMode;
        public static AvTraceDetails ResolveDefaultMode(params object[] args)
        {
            if ( _ResolveDefaultMode == null )
            {
                _ResolveDefaultMode = new AvTraceDetails(60, new string[] { "{0}: Default mode resolved to {1}" } );
            }
            return new AvTraceFormat(_ResolveDefaultMode, args);
        }

        private static AvTraceDetails _ResolveDefaultUpdate;
        public static AvTraceDetails ResolveDefaultUpdate(params object[] args)
        {
            if ( _ResolveDefaultUpdate == null )
            {
                _ResolveDefaultUpdate = new AvTraceDetails(61, new string[] { "{0}: Default update trigger resolved to {1}" } );
            }
            return new AvTraceFormat(_ResolveDefaultUpdate, args);
        }

        private static AvTraceDetails _AttachExpression;
        public static AvTraceDetails AttachExpression(params object[] args)
        {
            if ( _AttachExpression == null )
            {
                _AttachExpression = new AvTraceDetails(62, new string[] { "{0}: Attach to {1}.{2} (hash={3})" } );
            }
            return new AvTraceFormat(_AttachExpression, args);
        }

        private static AvTraceDetails _DetachExpression;
        public static AvTraceDetails DetachExpression(params object[] args)
        {
            if ( _DetachExpression == null )
            {
                _DetachExpression = new AvTraceDetails(63, new string[] { "{0}: Detach" } );
            }
            return new AvTraceFormat(_DetachExpression, args);
        }

        private static AvTraceDetails _UseMentor;
        public static AvTraceDetails UseMentor(params object[] args)
        {
            if ( _UseMentor == null )
            {
                _UseMentor = new AvTraceDetails(64, new string[] { "{0}: Use Framework mentor {1}" } );
            }
            return new AvTraceFormat(_UseMentor, args);
        }

        private static AvTraceDetails _DeferAttachToContext;
        public static AvTraceDetails DeferAttachToContext(params object[] args)
        {
            if ( _DeferAttachToContext == null )
            {
                _DeferAttachToContext = new AvTraceDetails(65, new string[] { "{0}: Resolve source deferred" } );
            }
            return new AvTraceFormat(_DeferAttachToContext, args);
        }

        private static AvTraceDetails _SourceRequiresTreeContext;
        public static AvTraceDetails SourceRequiresTreeContext(params object[] args)
        {
            if ( _SourceRequiresTreeContext == null )
            {
                _SourceRequiresTreeContext = new AvTraceDetails(66, new string[] { "{0}: {1} requires tree context" } );
            }
            return new AvTraceFormat(_SourceRequiresTreeContext, args);
        }

        private static AvTraceDetails _AttachToContext;
        public static AvTraceDetails AttachToContext(params object[] args)
        {
            if ( _AttachToContext == null )
            {
                _AttachToContext = new AvTraceDetails(67, new string[] { "{0}: Resolving source {1}" } );
            }
            return new AvTraceFormat(_AttachToContext, args);
        }

        private static AvTraceDetails _PathRequiresTreeContext;
        public static AvTraceDetails PathRequiresTreeContext(params object[] args)
        {
            if ( _PathRequiresTreeContext == null )
            {
                _PathRequiresTreeContext = new AvTraceDetails(68, new string[] { "{0}: Path '{1}' requires namespace information" } );
            }
            return new AvTraceFormat(_PathRequiresTreeContext, args);
        }

        private static AvTraceDetails _NoMentorExtended;
        public static AvTraceDetails NoMentorExtended(params object[] args)
        {
            if ( _NoMentorExtended == null )
            {
                _NoMentorExtended = new AvTraceDetails(69, new string[] { "{0}: Framework mentor not found" } );
            }
            return new AvTraceFormat(_NoMentorExtended, args);
        }

        private static AvTraceDetails _ContextElement;
        public static AvTraceDetails ContextElement(params object[] args)
        {
            if ( _ContextElement == null )
            {
                _ContextElement = new AvTraceDetails(70, new string[] { "{0}: Found data context element: {1} ({2})" } );
            }
            return new AvTraceFormat(_ContextElement, args);
        }

        private static AvTraceDetails _NullDataContext;
        public static AvTraceDetails NullDataContext(params object[] args)
        {
            if ( _NullDataContext == null )
            {
                _NullDataContext = new AvTraceDetails(71, new string[] { "{0}: DataContext is null" } );
            }
            return new AvTraceFormat(_NullDataContext, args);
        }

        private static AvTraceDetails _RelativeSource;
        public static AvTraceDetails RelativeSource(params object[] args)
        {
            if ( _RelativeSource == null )
            {
                _RelativeSource = new AvTraceDetails(72, new string[] { " RelativeSource.{0} found {1}" } );
            }
            return new AvTraceFormat(_RelativeSource, args);
        }

        private static AvTraceDetails _AncestorLookup;
        public static AvTraceDetails AncestorLookup(params object[] args)
        {
            if ( _AncestorLookup == null )
            {
                _AncestorLookup = new AvTraceDetails(73, new string[] { "  Lookup ancestor of type {0}: queried {1}" } );
            }
            return new AvTraceFormat(_AncestorLookup, args);
        }

        private static AvTraceDetails _ElementNameQuery;
        public static AvTraceDetails ElementNameQuery(params object[] args)
        {
            if ( _ElementNameQuery == null )
            {
                _ElementNameQuery = new AvTraceDetails(74, new string[] { "  Lookup name {0}: queried {1}" } );
            }
            return new AvTraceFormat(_ElementNameQuery, args);
        }

        private static AvTraceDetails _ElementNameQueryTemplate;
        public static AvTraceDetails ElementNameQueryTemplate(params object[] args)
        {
            if ( _ElementNameQueryTemplate == null )
            {
                _ElementNameQueryTemplate = new AvTraceDetails(75, new string[] { "  Lookup name {0}: queried template of {1}" } );
            }
            return new AvTraceFormat(_ElementNameQueryTemplate, args);
        }

        private static AvTraceDetails _UseCVS;
        public static AvTraceDetails UseCVS(params object[] args)
        {
            if ( _UseCVS == null )
            {
                _UseCVS = new AvTraceDetails(76, new string[] { "{0}: Use View from {1}" } );
            }
            return new AvTraceFormat(_UseCVS, args);
        }

        private static AvTraceDetails _UseDataProvider;
        public static AvTraceDetails UseDataProvider(params object[] args)
        {
            if ( _UseDataProvider == null )
            {
                _UseDataProvider = new AvTraceDetails(77, new string[] { "{0}: Use Data from {1}" } );
            }
            return new AvTraceFormat(_UseDataProvider, args);
        }

        private static AvTraceDetails _ActivateItem;
        public static AvTraceDetails ActivateItem(params object[] args)
        {
            if ( _ActivateItem == null )
            {
                _ActivateItem = new AvTraceDetails(78, new string[] { "{0}: Activate with root item {1}" } );
            }
            return new AvTraceFormat(_ActivateItem, args);
        }

        private static AvTraceDetails _Deactivate;
        public static AvTraceDetails Deactivate(params object[] args)
        {
            if ( _Deactivate == null )
            {
                _Deactivate = new AvTraceDetails(79, new string[] { "{0}: Deactivate" } );
            }
            return new AvTraceFormat(_Deactivate, args);
        }

        private static AvTraceDetails _GetRawValue;
        public static AvTraceDetails GetRawValue(params object[] args)
        {
            if ( _GetRawValue == null )
            {
                _GetRawValue = new AvTraceDetails(80, new string[] { "{0}: TransferValue - got raw value {1}" } );
            }
            return new AvTraceFormat(_GetRawValue, args);
        }

        private static AvTraceDetails _ConvertDBNull;
        public static AvTraceDetails ConvertDBNull(params object[] args)
        {
            if ( _ConvertDBNull == null )
            {
                _ConvertDBNull = new AvTraceDetails(81, new string[] { "{0}: TransferValue - converted DBNull to {1}" } );
            }
            return new AvTraceFormat(_ConvertDBNull, args);
        }

        private static AvTraceDetails _UserConverter;
        public static AvTraceDetails UserConverter(params object[] args)
        {
            if ( _UserConverter == null )
            {
                _UserConverter = new AvTraceDetails(82, new string[] { "{0}: TransferValue - user's converter produced {1}" } );
            }
            return new AvTraceFormat(_UserConverter, args);
        }

        private static AvTraceDetails _NullConverter;
        public static AvTraceDetails NullConverter(params object[] args)
        {
            if ( _NullConverter == null )
            {
                _NullConverter = new AvTraceDetails(83, new string[] { "{0}: TransferValue - null-value conversion produced {1}" } );
            }
            return new AvTraceFormat(_NullConverter, args);
        }

        private static AvTraceDetails _DefaultConverter;
        public static AvTraceDetails DefaultConverter(params object[] args)
        {
            if ( _DefaultConverter == null )
            {
                _DefaultConverter = new AvTraceDetails(84, new string[] { "{0}: TransferValue - implicit converter produced {1}" } );
            }
            return new AvTraceFormat(_DefaultConverter, args);
        }

        private static AvTraceDetails _FormattedValue;
        public static AvTraceDetails FormattedValue(params object[] args)
        {
            if ( _FormattedValue == null )
            {
                _FormattedValue = new AvTraceDetails(85, new string[] { "{0}: TransferValue - string formatting produced {1}" } );
            }
            return new AvTraceFormat(_FormattedValue, args);
        }

        private static AvTraceDetails _FormattingFailed;
        public static AvTraceDetails FormattingFailed(params object[] args)
        {
            if ( _FormattingFailed == null )
            {
                _FormattingFailed = new AvTraceDetails(86, new string[] { "{0}: TransferValue - string formatting failed, using format '{1}'" } );
            }
            return new AvTraceFormat(_FormattingFailed, args);
        }

        private static AvTraceDetails _BadValueAtTransferExtended;
        public static AvTraceDetails BadValueAtTransferExtended(params object[] args)
        {
            if ( _BadValueAtTransferExtended == null )
            {
                _BadValueAtTransferExtended = new AvTraceDetails(87, new string[] { "{0}: TransferValue - value {1} is not valid for target" } );
            }
            return new AvTraceFormat(_BadValueAtTransferExtended, args);
        }

        private static AvTraceDetails _UseFallback;
        public static AvTraceDetails UseFallback(params object[] args)
        {
            if ( _UseFallback == null )
            {
                _UseFallback = new AvTraceDetails(88, new string[] { "{0}: TransferValue - using fallback/default value {1}" } );
            }
            return new AvTraceFormat(_UseFallback, args);
        }

        private static AvTraceDetails _TransferValue;
        public static AvTraceDetails TransferValue(params object[] args)
        {
            if ( _TransferValue == null )
            {
                _TransferValue = new AvTraceDetails(89, new string[] { "{0}: TransferValue - using final value {1}" } );
            }
            return new AvTraceFormat(_TransferValue, args);
        }

        private static AvTraceDetails _UpdateRawValue;
        public static AvTraceDetails UpdateRawValue(params object[] args)
        {
            if ( _UpdateRawValue == null )
            {
                _UpdateRawValue = new AvTraceDetails(90, new string[] { "{0}: Update - got raw value {1}" } );
            }
            return new AvTraceFormat(_UpdateRawValue, args);
        }

        private static AvTraceDetails _ValidationRuleFailed;
        public static AvTraceDetails ValidationRuleFailed(params object[] args)
        {
            if ( _ValidationRuleFailed == null )
            {
                _ValidationRuleFailed = new AvTraceDetails(91, new string[] { "{0}: Update - {1} failed" } );
            }
            return new AvTraceFormat(_ValidationRuleFailed, args);
        }

        private static AvTraceDetails _UserConvertBack;
        public static AvTraceDetails UserConvertBack(params object[] args)
        {
            if ( _UserConvertBack == null )
            {
                _UserConvertBack = new AvTraceDetails(92, new string[] { "{0}: Update - user's converter produced {1}" } );
            }
            return new AvTraceFormat(_UserConvertBack, args);
        }

        private static AvTraceDetails _DefaultConvertBack;
        public static AvTraceDetails DefaultConvertBack(params object[] args)
        {
            if ( _DefaultConvertBack == null )
            {
                _DefaultConvertBack = new AvTraceDetails(93, new string[] { "{0}: Update - implicit converter produced {1}" } );
            }
            return new AvTraceFormat(_DefaultConvertBack, args);
        }

        private static AvTraceDetails _Update;
        public static AvTraceDetails Update(params object[] args)
        {
            if ( _Update == null )
            {
                _Update = new AvTraceDetails(94, new string[] { "{0}: Update - using final value {1}" } );
            }
            return new AvTraceFormat(_Update, args);
        }

        private static AvTraceDetails _GotEvent;
        public static AvTraceDetails GotEvent(params object[] args)
        {
            if ( _GotEvent == null )
            {
                _GotEvent = new AvTraceDetails(95, new string[] { "{0}: Got {1} event from {2}" } );
            }
            return new AvTraceFormat(_GotEvent, args);
        }

        private static AvTraceDetails _GotPropertyChanged;
        public static AvTraceDetails GotPropertyChanged(params object[] args)
        {
            if ( _GotPropertyChanged == null )
            {
                _GotPropertyChanged = new AvTraceDetails(96, new string[] { "{0}: Got PropertyChanged event from {1} for {2}" } );
            }
            return new AvTraceFormat(_GotPropertyChanged, args);
        }

        private static AvTraceDetails _PriorityTransfer;
        public static AvTraceDetails PriorityTransfer(params object[] args)
        {
            if ( _PriorityTransfer == null )
            {
                _PriorityTransfer = new AvTraceDetails(97, new string[] { "{0}: TransferValue '{1}' from child {2} - {3}" } );
            }
            return new AvTraceFormat(_PriorityTransfer, args);
        }

        private static AvTraceDetails _ChildNotAttached;
        public static AvTraceDetails ChildNotAttached(params object[] args)
        {
            if ( _ChildNotAttached == null )
            {
                _ChildNotAttached = new AvTraceDetails(98, new string[] { "{0}: One or more children have not resolved sources" } );
            }
            return new AvTraceFormat(_ChildNotAttached, args);
        }

        private static AvTraceDetails _GetRawValueMulti;
        public static AvTraceDetails GetRawValueMulti(params object[] args)
        {
            if ( _GetRawValueMulti == null )
            {
                _GetRawValueMulti = new AvTraceDetails(99, new string[] { "{0}: TransferValue - got raw value {1}: {2}" } );
            }
            return new AvTraceFormat(_GetRawValueMulti, args);
        }

        private static AvTraceDetails _UserConvertBackMulti;
        public static AvTraceDetails UserConvertBackMulti(params object[] args)
        {
            if ( _UserConvertBackMulti == null )
            {
                _UserConvertBackMulti = new AvTraceDetails(100, new string[] { "{0}: Update - multiconverter produced value {1}: {2}" } );
            }
            return new AvTraceFormat(_UserConvertBackMulti, args);
        }

        private static AvTraceDetails _GetValue;
        public static AvTraceDetails GetValue(params object[] args)
        {
            if ( _GetValue == null )
            {
                _GetValue = new AvTraceDetails(101, new string[] { "{0}: GetValue at level {1} from {2} using {3}: {4}" } );
            }
            return new AvTraceFormat(_GetValue, args);
        }

        private static AvTraceDetails _SetValue;
        public static AvTraceDetails SetValue(params object[] args)
        {
            if ( _SetValue == null )
            {
                _SetValue = new AvTraceDetails(102, new string[] { "{0}: SetValue at level {1} to {2} using {3}: {4}" } );
            }
            return new AvTraceFormat(_SetValue, args);
        }

        private static AvTraceDetails _ReplaceItemShort;
        public static AvTraceDetails ReplaceItemShort(params object[] args)
        {
            if ( _ReplaceItemShort == null )
            {
                _ReplaceItemShort = new AvTraceDetails(103, new string[] { "{0}: Replace item at level {1} with {2}" } );
            }
            return new AvTraceFormat(_ReplaceItemShort, args);
        }

        private static AvTraceDetails _ReplaceItemLong;
        public static AvTraceDetails ReplaceItemLong(params object[] args)
        {
            if ( _ReplaceItemLong == null )
            {
                _ReplaceItemLong = new AvTraceDetails(104, new string[] { "{0}: Replace item at level {1} with {2}, using accessor {3}" } );
            }
            return new AvTraceFormat(_ReplaceItemLong, args);
        }

        private static AvTraceDetails _GetInfo_Reuse;
        public static AvTraceDetails GetInfo_Reuse(params object[] args)
        {
            if ( _GetInfo_Reuse == null )
            {
                _GetInfo_Reuse = new AvTraceDetails(105, new string[] { "{0}:   Item at level {1} has same type - reuse accessor {2}" } );
            }
            return new AvTraceFormat(_GetInfo_Reuse, args);
        }

        private static AvTraceDetails _GetInfo_Null;
        public static AvTraceDetails GetInfo_Null(params object[] args)
        {
            if ( _GetInfo_Null == null )
            {
                _GetInfo_Null = new AvTraceDetails(106, new string[] { "{0}:   Item at level {1} is null - no accessor" } );
            }
            return new AvTraceFormat(_GetInfo_Null, args);
        }

        private static AvTraceDetails _GetInfo_Cache;
        public static AvTraceDetails GetInfo_Cache(params object[] args)
        {
            if ( _GetInfo_Cache == null )
            {
                _GetInfo_Cache = new AvTraceDetails(107, new string[] { "{0}:   At level {1} using cached accessor for {2}.{3}: {4}" } );
            }
            return new AvTraceFormat(_GetInfo_Cache, args);
        }

        private static AvTraceDetails _GetInfo_Property;
        public static AvTraceDetails GetInfo_Property(params object[] args)
        {
            if ( _GetInfo_Property == null )
            {
                _GetInfo_Property = new AvTraceDetails(108, new string[] { "{0}:   At level {1} - for {2}.{3} found accessor {4}" } );
            }
            return new AvTraceFormat(_GetInfo_Property, args);
        }

        private static AvTraceDetails _GetInfo_Indexer;
        public static AvTraceDetails GetInfo_Indexer(params object[] args)
        {
            if ( _GetInfo_Indexer == null )
            {
                _GetInfo_Indexer = new AvTraceDetails(109, new string[] { "{0}:   At level {1} - for {2}[{3}] found accessor {4}" } );
            }
            return new AvTraceFormat(_GetInfo_Indexer, args);
        }

        private static AvTraceDetails _XmlContextNode;
        public static AvTraceDetails XmlContextNode(params object[] args)
        {
            if ( _XmlContextNode == null )
            {
                _XmlContextNode = new AvTraceDetails(110, new string[] { "{0}: Context for XML binding set to {1}" } );
            }
            return new AvTraceFormat(_XmlContextNode, args);
        }

        private static AvTraceDetails _XmlNewCollection;
        public static AvTraceDetails XmlNewCollection(params object[] args)
        {
            if ( _XmlNewCollection == null )
            {
                _XmlNewCollection = new AvTraceDetails(111, new string[] { "{0}: Building collection from {1}" } );
            }
            return new AvTraceFormat(_XmlNewCollection, args);
        }

        private static AvTraceDetails _XmlSynchronizeCollection;
        public static AvTraceDetails XmlSynchronizeCollection(params object[] args)
        {
            if ( _XmlSynchronizeCollection == null )
            {
                _XmlSynchronizeCollection = new AvTraceDetails(112, new string[] { "{0}: Synchronizing collection with {1}" } );
            }
            return new AvTraceFormat(_XmlSynchronizeCollection, args);
        }

        private static AvTraceDetails _SelectNodes;
        public static AvTraceDetails SelectNodes(params object[] args)
        {
            if ( _SelectNodes == null )
            {
                _SelectNodes = new AvTraceDetails(113, new string[] { "{0}: SelectNodes at {1} using XPath {2}: {3}" } );
            }
            return new AvTraceFormat(_SelectNodes, args);
        }

        private static AvTraceDetails _BeginQuery;
        public static AvTraceDetails BeginQuery(params object[] args)
        {
            if ( _BeginQuery == null )
            {
                _BeginQuery = new AvTraceDetails(114, new string[] { "{0}: Begin query ({1})" } );
            }
            return new AvTraceFormat(_BeginQuery, args);
        }

        private static AvTraceDetails _QueryFinished;
        public static AvTraceDetails QueryFinished(params object[] args)
        {
            if ( _QueryFinished == null )
            {
                _QueryFinished = new AvTraceDetails(115, new string[] { "{0}: Query finished ({1}) with data {2} and error {3}" } );
            }
            return new AvTraceFormat(_QueryFinished, args);
        }

        private static AvTraceDetails _QueryResult;
        public static AvTraceDetails QueryResult(params object[] args)
        {
            if ( _QueryResult == null )
            {
                _QueryResult = new AvTraceDetails(116, new string[] { "{0}: Update result (on UI thread) with data {1}" } );
            }
            return new AvTraceFormat(_QueryResult, args);
        }

        private static AvTraceDetails _XmlLoadSource;
        public static AvTraceDetails XmlLoadSource(params object[] args)
        {
            if ( _XmlLoadSource == null )
            {
                _XmlLoadSource = new AvTraceDetails(117, new string[] { "{0}: Request download ({1}) from {2}" } );
            }
            return new AvTraceFormat(_XmlLoadSource, args);
        }

        private static AvTraceDetails _XmlLoadDoc;
        public static AvTraceDetails XmlLoadDoc(params object[] args)
        {
            if ( _XmlLoadDoc == null )
            {
                _XmlLoadDoc = new AvTraceDetails(118, new string[] { "{0}: Load document from stream" } );
            }
            return new AvTraceFormat(_XmlLoadDoc, args);
        }

        private static AvTraceDetails _XmlLoadInline;
        public static AvTraceDetails XmlLoadInline(params object[] args)
        {
            if ( _XmlLoadInline == null )
            {
                _XmlLoadInline = new AvTraceDetails(119, new string[] { "{0}: Load inline document" } );
            }
            return new AvTraceFormat(_XmlLoadInline, args);
        }

        private static AvTraceDetails _XmlBuildCollection;
        public static AvTraceDetails XmlBuildCollection(params object[] args)
        {
            if ( _XmlBuildCollection == null )
            {
                _XmlBuildCollection = new AvTraceDetails(120, new string[] { "{0}: Build XmlNode collection" } );
            }
            return new AvTraceFormat(_XmlBuildCollection, args);
        }

        /// <summary> Send a single trace output </summary>
        public static void Trace(TraceEventType type, AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.Trace(type, traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        /// <summary> Send a singleton "activity" trace (really, this sends the same trace as both a Start and a Stop) </summary>
        public static void TraceActivityItem(AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.TraceStartStop(traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        public static bool IsEnabled
        {
            get { return _avTrace != null && _avTrace.IsEnabled; }
        }

        /// <summary> Is there a Tracesource?  (See comment on AvTrace.IsEnabledOverride.) </summary>
        public static bool IsEnabledOverride
        {
            get { return _avTrace.IsEnabledOverride; }
        }

        /// <summary> Re-read the configuration for this trace source </summary>
        public static void Refresh()
        {
            _avTrace.Refresh();
        }
	}
    internal static partial class TracePageFormatting
    {
        private static AvTrace _avTrace = new AvTrace(
                delegate() { return PresentationTraceSources.DocumentsSource; },
                delegate() { PresentationTraceSources._DocumentsSource = null; }
                );
        private static AvTraceDetails _FormatPage;
		public static AvTraceDetails FormatPage
        {
            get
            {
                if ( _FormatPage == null )
                {
                    _FormatPage = new AvTraceDetails(1, new string[] { "Formatting page" } );
                }

                return _FormatPage;
            }
        }

        private static AvTraceDetails _PageFormattingError;
		public static AvTraceDetails PageFormattingError
        {
            get
            {
                if ( _PageFormattingError == null )
                {
                    _PageFormattingError = new AvTraceDetails(2, new string[] { "Error. Page formatting engine could not complete the formatting operation." } );
                }

                return _PageFormattingError;
            }
        }

        private static AvTraceDetails _UnableToFreezeFreezableSubProperty;
		public static AvTraceDetails UnableToFreezeFreezableSubProperty
        {
            get
            {
                if ( _UnableToFreezeFreezableSubProperty == null )
                {
                    _UnableToFreezeFreezableSubProperty = new AvTraceDetails(3, new string[] { "CanFreeze is returning false because a DependencyProperty on the Freezable has a value that is a Freezable that has also returned false from CanFreeze" } );
                }

                return _UnableToFreezeFreezableSubProperty;
            }
        }

        private static AvTraceDetails _UnableToFreezeAnimatedProperties;
		public static AvTraceDetails UnableToFreezeAnimatedProperties
        {
            get
            {
                if ( _UnableToFreezeAnimatedProperties == null )
                {
                    _UnableToFreezeAnimatedProperties = new AvTraceDetails(4, new string[] { "CanFreeze is returning false because at least one DependencyProperty on the Freezable is animated." } );
                }

                return _UnableToFreezeAnimatedProperties;
            }
        }

        /// <summary> Send a single trace output </summary>
        public static void Trace(TraceEventType type, AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.Trace(type, traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        /// <summary> Send a singleton "activity" trace (really, this sends the same trace as both a Start and a Stop) </summary>
        public static void TraceActivityItem(AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.TraceStartStop(traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        public static bool IsEnabled
        {
            get { return _avTrace != null && _avTrace.IsEnabled; }
        }

        /// <summary> Is there a Tracesource?  (See comment on AvTrace.IsEnabledOverride.) </summary>
        public static bool IsEnabledOverride
        {
            get { return _avTrace.IsEnabledOverride; }
        }

        /// <summary> Re-read the configuration for this trace source </summary>
        public static void Refresh()
        {
            _avTrace.Refresh();
        }
	}
    internal static partial class TraceResourceDictionary
    {
        private static AvTrace _avTrace = new AvTrace(
                delegate() { return PresentationTraceSources.ResourceDictionarySource; },
                delegate() { PresentationTraceSources._ResourceDictionarySource = null; }
                );
        private static AvTraceDetails _AddResource;
		public static AvTraceDetails AddResource
        {
            get
            {
                if ( _AddResource == null )
                {
                    _AddResource = new AvTraceDetails(1, new string[] { "Resource has been added to ResourceDictionary" } );
                }

                return _AddResource;
            }
        }

        private static AvTraceDetails _RealizeDeferContent;
		public static AvTraceDetails RealizeDeferContent
        {
            get
            {
                if ( _RealizeDeferContent == null )
                {
                    _RealizeDeferContent = new AvTraceDetails(2, new string[] { "Delayed creation of resource" } );
                }

                return _RealizeDeferContent;
            }
        }

        private static AvTraceDetails _FoundResourceOnElement;
		public static AvTraceDetails FoundResourceOnElement
        {
            get
            {
                if ( _FoundResourceOnElement == null )
                {
                    _FoundResourceOnElement = new AvTraceDetails(3, new string[] { "Found resource item on an element" } );
                }

                return _FoundResourceOnElement;
            }
        }

        private static AvTraceDetails _FoundResourceInStyle;
		public static AvTraceDetails FoundResourceInStyle
        {
            get
            {
                if ( _FoundResourceInStyle == null )
                {
                    _FoundResourceInStyle = new AvTraceDetails(4, new string[] { "Found resource item in a style" } );
                }

                return _FoundResourceInStyle;
            }
        }

        private static AvTraceDetails _FoundResourceInTemplate;
		public static AvTraceDetails FoundResourceInTemplate
        {
            get
            {
                if ( _FoundResourceInTemplate == null )
                {
                    _FoundResourceInTemplate = new AvTraceDetails(5, new string[] { "Found resource item in a template" } );
                }

                return _FoundResourceInTemplate;
            }
        }

        private static AvTraceDetails _FoundResourceInThemeStyle;
		public static AvTraceDetails FoundResourceInThemeStyle
        {
            get
            {
                if ( _FoundResourceInThemeStyle == null )
                {
                    _FoundResourceInThemeStyle = new AvTraceDetails(6, new string[] { "Found resource item in a theme style" } );
                }

                return _FoundResourceInThemeStyle;
            }
        }

        private static AvTraceDetails _FoundResourceInApplication;
		public static AvTraceDetails FoundResourceInApplication
        {
            get
            {
                if ( _FoundResourceInApplication == null )
                {
                    _FoundResourceInApplication = new AvTraceDetails(7, new string[] { "Found resource item in application" } );
                }

                return _FoundResourceInApplication;
            }
        }

        private static AvTraceDetails _FoundResourceInTheme;
		public static AvTraceDetails FoundResourceInTheme
        {
            get
            {
                if ( _FoundResourceInTheme == null )
                {
                    _FoundResourceInTheme = new AvTraceDetails(8, new string[] { "Found resource item in theme" } );
                }

                return _FoundResourceInTheme;
            }
        }

        private static AvTraceDetails _ResourceNotFound;
		public static AvTraceDetails ResourceNotFound
        {
            get
            {
                if ( _ResourceNotFound == null )
                {
                    _ResourceNotFound = new AvTraceDetails(9, new string[] { "Resource not found", "ResourceKey" } );
                }

                return _ResourceNotFound;
            }
        }

        private static AvTraceDetails _NewResourceDictionary;
		public static AvTraceDetails NewResourceDictionary
        {
            get
            {
                if ( _NewResourceDictionary == null )
                {
                    _NewResourceDictionary = new AvTraceDetails(10, new string[] { "New resource dictionary set" } );
                }

                return _NewResourceDictionary;
            }
        }

        private static AvTraceDetails _FindResource;
		public static AvTraceDetails FindResource
        {
            get
            {
                if ( _FindResource == null )
                {
                    _FindResource = new AvTraceDetails(11, new string[] { "Searching for resource" } );
                }

                return _FindResource;
            }
        }

        private static AvTraceDetails _SetKey;
		public static AvTraceDetails SetKey
        {
            get
            {
                if ( _SetKey == null )
                {
                    _SetKey = new AvTraceDetails(12, new string[] { "Deferred resource has been added to ResourceDictionary" } );
                }

                return _SetKey;
            }
        }

        /// <summary> Send a single trace output </summary>
        public static void Trace(TraceEventType type, AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.Trace(type, traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        /// <summary> Send a singleton "activity" trace (really, this sends the same trace as both a Start and a Stop) </summary>
        public static void TraceActivityItem(AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.TraceStartStop(traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        public static bool IsEnabled
        {
            get { return _avTrace != null && _avTrace.IsEnabled; }
        }

        /// <summary> Is there a Tracesource?  (See comment on AvTrace.IsEnabledOverride.) </summary>
        public static bool IsEnabledOverride
        {
            get { return _avTrace.IsEnabledOverride; }
        }

        /// <summary> Re-read the configuration for this trace source </summary>
        public static void Refresh()
        {
            _avTrace.Refresh();
        }
	}
    internal static partial class TraceMarkup
    {
        private static AvTrace _avTrace = new AvTrace(
                delegate() { return PresentationTraceSources.MarkupSource; },
                delegate() { PresentationTraceSources._MarkupSource = null; }
                );
        private static AvTraceDetails _AddValueToAddChild;
		public static AvTraceDetails AddValueToAddChild
        {
            get
            {
                if ( _AddValueToAddChild == null )
                {
                    _AddValueToAddChild = new AvTraceDetails(1, new string[] { "Add value to IAddChild" } );
                }

                return _AddValueToAddChild;
            }
        }

        private static AvTraceDetails _AddValueToArray;
		public static AvTraceDetails AddValueToArray
        {
            get
            {
                if ( _AddValueToArray == null )
                {
                    _AddValueToArray = new AvTraceDetails(2, new string[] { "Add value to an array property" } );
                }

                return _AddValueToArray;
            }
        }

        private static AvTraceDetails _AddValueToDictionary;
		public static AvTraceDetails AddValueToDictionary
        {
            get
            {
                if ( _AddValueToDictionary == null )
                {
                    _AddValueToDictionary = new AvTraceDetails(3, new string[] { "Add value to a dictionary property" } );
                }

                return _AddValueToDictionary;
            }
        }

        private static AvTraceDetails _AddValueToList;
		public static AvTraceDetails AddValueToList
        {
            get
            {
                if ( _AddValueToList == null )
                {
                    _AddValueToList = new AvTraceDetails(4, new string[] { "CanFreezeAdd value to a collection property" } );
                }

                return _AddValueToList;
            }
        }

        private static AvTraceDetails _BeginInit;
		public static AvTraceDetails BeginInit
        {
            get
            {
                if ( _BeginInit == null )
                {
                    _BeginInit = new AvTraceDetails(5, new string[] { "Start initialization of object (ISupportInitialize.BeginInit)" } );
                }

                return _BeginInit;
            }
        }

        private static AvTraceDetails _CreateMarkupExtension;
		public static AvTraceDetails CreateMarkupExtension
        {
            get
            {
                if ( _CreateMarkupExtension == null )
                {
                    _CreateMarkupExtension = new AvTraceDetails(6, new string[] { "Create MarkupExtension" } );
                }

                return _CreateMarkupExtension;
            }
        }

        private static AvTraceDetails _CreateObject;
		public static AvTraceDetails CreateObject
        {
            get
            {
                if ( _CreateObject == null )
                {
                    _CreateObject = new AvTraceDetails(7, new string[] { "Create object" } );
                }

                return _CreateObject;
            }
        }

        private static AvTraceDetails _EndInit;
		public static AvTraceDetails EndInit
        {
            get
            {
                if ( _EndInit == null )
                {
                    _EndInit = new AvTraceDetails(8, new string[] { "End initialization of object (ISupportInitialize.EndInit)" } );
                }

                return _EndInit;
            }
        }

        private static AvTraceDetails _Load;
		public static AvTraceDetails Load
        {
            get
            {
                if ( _Load == null )
                {
                    _Load = new AvTraceDetails(9, new string[] { "Load xaml/baml" } );
                }

                return _Load;
            }
        }

        private static AvTraceDetails _ProcessConstructorParameter;
		public static AvTraceDetails ProcessConstructorParameter
        {
            get
            {
                if ( _ProcessConstructorParameter == null )
                {
                    _ProcessConstructorParameter = new AvTraceDetails(10, new string[] { "Convert constructor parameter" } );
                }

                return _ProcessConstructorParameter;
            }
        }

        private static AvTraceDetails _ProvideValue;
		public static AvTraceDetails ProvideValue
        {
            get
            {
                if ( _ProvideValue == null )
                {
                    _ProvideValue = new AvTraceDetails(11, new string[] { "Converted a MarkupExtension" } );
                }

                return _ProvideValue;
            }
        }

        private static AvTraceDetails _SetCPA;
		public static AvTraceDetails SetCPA
        {
            get
            {
                if ( _SetCPA == null )
                {
                    _SetCPA = new AvTraceDetails(12, new string[] { "Set property value to the ContentProperty" } );
                }

                return _SetCPA;
            }
        }

        private static AvTraceDetails _SetPropertyValue;
		public static AvTraceDetails SetPropertyValue
        {
            get
            {
                if ( _SetPropertyValue == null )
                {
                    _SetPropertyValue = new AvTraceDetails(13, new string[] { "Set property value" } );
                }

                return _SetPropertyValue;
            }
        }

        private static AvTraceDetails _ThrowException;
		public static AvTraceDetails ThrowException
        {
            get
            {
                if ( _ThrowException == null )
                {
                    _ThrowException = new AvTraceDetails(14, new string[] { "A xaml exception has been thrown" } );
                }

                return _ThrowException;
            }
        }

        private static AvTraceDetails _TypeConvert;
		public static AvTraceDetails TypeConvert
        {
            get
            {
                if ( _TypeConvert == null )
                {
                    _TypeConvert = new AvTraceDetails(15, new string[] { "Converted value" } );
                }

                return _TypeConvert;
            }
        }

        private static AvTraceDetails _TypeConvertFallback;
		public static AvTraceDetails TypeConvertFallback
        {
            get
            {
                if ( _TypeConvertFallback == null )
                {
                    _TypeConvertFallback = new AvTraceDetails(16, new string[] { "CanFreezeAdd value to a collection property" } );
                }

                return _TypeConvertFallback;
            }
        }

        /// <summary> Send a single trace output </summary>
        public static void Trace(TraceEventType type, AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.Trace(type, traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        /// <summary> Send a singleton "activity" trace (really, this sends the same trace as both a Start and a Stop) </summary>
        public static void TraceActivityItem(AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.TraceStartStop(traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        public static bool IsEnabled
        {
            get { return _avTrace != null && _avTrace.IsEnabled; }
        }

        /// <summary> Is there a Tracesource?  (See comment on AvTrace.IsEnabledOverride.) </summary>
        public static bool IsEnabledOverride
        {
            get { return _avTrace.IsEnabledOverride; }
        }

        /// <summary> Re-read the configuration for this trace source </summary>
        public static void Refresh()
        {
            _avTrace.Refresh();
        }
	}
    internal static partial class TraceHwndHost
    {
        private static AvTrace _avTrace = new AvTrace(
                delegate() { return PresentationTraceSources.HwndHostSource; },
                delegate() { PresentationTraceSources._HwndHostSource = null; }
                );
        private static AvTraceDetails _HwndHostIn3D;
		public static AvTraceDetails HwndHostIn3D
        {
            get
            {
                if ( _HwndHostIn3D == null )
                {
                    _HwndHostIn3D = new AvTraceDetails(1, new string[] { "An HwndHost may not be embedded in a 3D scene." } );
                }

                return _HwndHostIn3D;
            }
        }

        /// <summary> Send a single trace output </summary>
        public static void Trace(TraceEventType type, AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.Trace(type, traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        /// <summary> Send a singleton "activity" trace (really, this sends the same trace as both a Start and a Stop) </summary>
        public static void TraceActivityItem(AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.TraceStartStop(traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        public static bool IsEnabled
        {
            get { return _avTrace != null && _avTrace.IsEnabled; }
        }

        /// <summary> Is there a Tracesource?  (See comment on AvTrace.IsEnabledOverride.) </summary>
        public static bool IsEnabledOverride
        {
            get { return _avTrace.IsEnabledOverride; }
        }

        /// <summary> Re-read the configuration for this trace source </summary>
        public static void Refresh()
        {
            _avTrace.Refresh();
        }
	}
    internal static partial class TraceShell
    {
        private static AvTrace _avTrace = new AvTrace(
                delegate() { return PresentationTraceSources.ShellSource; },
                delegate() { PresentationTraceSources._ShellSource = null; }
                );
        private static AvTraceDetails _NotOnWindows7;
		public static AvTraceDetails NotOnWindows7
        {
            get
            {
                if ( _NotOnWindows7 == null )
                {
                    _NotOnWindows7 = new AvTraceDetails(1, new string[] { "Shell integration features are not being applied because the host OS does not support the feature." } );
                }

                return _NotOnWindows7;
            }
        }

        private static AvTraceDetails _ExplorerTaskbarTimeout;
		public static AvTraceDetails ExplorerTaskbarTimeout
        {
            get
            {
                if ( _ExplorerTaskbarTimeout == null )
                {
                    _ExplorerTaskbarTimeout = new AvTraceDetails(2, new string[] { "Communication with Explorer timed out while trying to update the taskbar item for the window." } );
                }

                return _ExplorerTaskbarTimeout;
            }
        }

        private static AvTraceDetails _ExplorerTaskbarRetrying;
		public static AvTraceDetails ExplorerTaskbarRetrying
        {
            get
            {
                if ( _ExplorerTaskbarRetrying == null )
                {
                    _ExplorerTaskbarRetrying = new AvTraceDetails(3, new string[] { "Making another attempt to update the taskbar." } );
                }

                return _ExplorerTaskbarRetrying;
            }
        }

        private static AvTraceDetails _ExplorerTaskbarNotRunning;
		public static AvTraceDetails ExplorerTaskbarNotRunning
        {
            get
            {
                if ( _ExplorerTaskbarNotRunning == null )
                {
                    _ExplorerTaskbarNotRunning = new AvTraceDetails(4, new string[] { "Halting attempts at Shell integration with the taskbar because it appears that Explorer is not running." } );
                }

                return _ExplorerTaskbarNotRunning;
            }
        }

        private static AvTraceDetails _NativeTaskbarError;
        public static AvTraceDetails NativeTaskbarError(params object[] args)
        {
            if ( _NativeTaskbarError == null )
            {
                _NativeTaskbarError = new AvTraceDetails(5, new string[] { "The native ITaskbarList3 interface failed a method call with error {0}." } );
            }
            return new AvTraceFormat(_NativeTaskbarError, args);
        }

        private static AvTraceDetails _RejectingJumpItemsBecauseCatastrophicFailure;
		public static AvTraceDetails RejectingJumpItemsBecauseCatastrophicFailure
        {
            get
            {
                if ( _RejectingJumpItemsBecauseCatastrophicFailure == null )
                {
                    _RejectingJumpItemsBecauseCatastrophicFailure = new AvTraceDetails(6, new string[] { "Failed to apply items to the JumpList because the native interfaces failed." } );
                }

                return _RejectingJumpItemsBecauseCatastrophicFailure;
            }
        }

        private static AvTraceDetails _RejectingJumpListCategoryBecauseNoRegisteredHandler;
        public static AvTraceDetails RejectingJumpListCategoryBecauseNoRegisteredHandler(params object[] args)
        {
            if ( _RejectingJumpListCategoryBecauseNoRegisteredHandler == null )
            {
                _RejectingJumpListCategoryBecauseNoRegisteredHandler = new AvTraceDetails(7, new string[] { "Rejecting the category {0} from the jump list because this application is not registered for file types contained in the list.  JumpPath items will be removed and the operation will be retried." } );
            }
            return new AvTraceFormat(_RejectingJumpListCategoryBecauseNoRegisteredHandler, args);
        }

        /// <summary> Send a single trace output </summary>
        public static void Trace(TraceEventType type, AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.Trace(type, traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        /// <summary> Send a singleton "activity" trace (really, this sends the same trace as both a Start and a Stop) </summary>
        public static void TraceActivityItem(AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.TraceStartStop(traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        public static bool IsEnabled
        {
            get { return _avTrace != null && _avTrace.IsEnabled; }
        }

        /// <summary> Is there a Tracesource?  (See comment on AvTrace.IsEnabledOverride.) </summary>
        public static bool IsEnabledOverride
        {
            get { return _avTrace.IsEnabledOverride; }
        }

        /// <summary> Re-read the configuration for this trace source </summary>
        public static void Refresh()
        {
            _avTrace.Refresh();
        }
	}
}
