﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

//using System.Xaml;

namespace BamlTools
{
    class KnownElement
    {
        public short BamlNumber { get; private set; }
        public string FullPath { get; private set; }
        public string ShortName { get; private set; }

        public KnownElement(short bamlNumber, string fullPath)
        {
            BamlNumber = bamlNumber;
            FullPath = fullPath;
            ShortName = fullPath.Substring(fullPath.LastIndexOf('.') + 1);
        }
    }

    class KnownElements
    {
        static public KnownElement[] _knownElements;

        static public KnownElement[] Elements
        {
            get
            {
                if (_knownElements == null)
                {
                    InitializeKnownElements();
                }
                return _knownElements;
            }
        }

        static private void InitializeKnownElements()
        {
            _knownElements = new KnownElement[]
        {
            new KnownElement(0,  "Error.Error0"),
            new KnownElement(1,  "System.Windows.Controls.AccessText"),
            new KnownElement(2,  "System.Windows.Controls.AdornedElementPlaceholder"),
            new KnownElement(3,  "System.Windows.Documents.Adorner"),
            new KnownElement(4,  "System.Windows.Documents.AdornerDecorator"),
            new KnownElement(5,  "System.Windows.Documents.AdornerLayer"),
            new KnownElement(6,  "System.Windows.Media.Media3D.AffineTransform3D"),
            new KnownElement(7,  "System.Windows.Media.Media3D.AmbientLight"),
            new KnownElement(8,  "System.Windows.Documents.AnchoredBlock"),
            new KnownElement(9,  "System.Windows.Media.Animation.Animatable"),
            new KnownElement(10,  "System.Windows.Media.Animation.AnimationClock"),
            new KnownElement(11,  "System.Windows.Media.Animation.AnimationTimeline"),
            new KnownElement(12,  "System.Windows.Application"),
            new KnownElement(13,  "System.Windows.Media.ArcSegment"),
            new KnownElement(14,  "System.Windows.Markup.ArrayExtension"),
            new KnownElement(15,  "System.Windows.Media.Media3D.AxisAngleRotation3D"),
            new KnownElement(16,  "System.Windows.Media.Converters.BaseIListConverter"),
            new KnownElement(17,  "System.Windows.Media.Animation.BeginStoryboard"),
            new KnownElement(18,  "System.Windows.Media.Effects.BevelBitmapEffect"),
            new KnownElement(19,  "System.Windows.Media.BezierSegment"),
            new KnownElement(20,  "System.Windows.Data.Binding"),
            new KnownElement(21,  "System.Windows.Data.BindingBase"),
            new KnownElement(22,  "System.Windows.Data.BindingExpression"),
            new KnownElement(23,  "System.Windows.Data.BindingExpressionBase"),
            new KnownElement(24,  "System.Windows.Data.BindingListCollectionView"),
            new KnownElement(25,  "System.Windows.Media.Imaging.BitmapDecoder"),
            new KnownElement(26,  "System.Windows.Media.Effects.BitmapEffect"),
            new KnownElement(27,  "System.Windows.Media.Effects.BitmapEffectCollection"),
            new KnownElement(28,  "System.Windows.Media.Effects.BitmapEffectGroup"),
            new KnownElement(29,  "System.Windows.Media.Effects.BitmapEffectInput"),
            new KnownElement(30,  "System.Windows.Media.Imaging.BitmapEncoder"),
            new KnownElement(31,  "System.Windows.Media.Imaging.BitmapFrame"),
            new KnownElement(32,  "System.Windows.Media.Imaging.BitmapImage"),
            new KnownElement(33,  "System.Windows.Media.Imaging.BitmapMetadata"),
            new KnownElement(34,  "System.Windows.Media.Imaging.BitmapPalette"),
            new KnownElement(35,  "System.Windows.Media.Imaging.BitmapSource"),
            new KnownElement(36,  "System.Windows.Documents.Block"),
            new KnownElement(37,  "System.Windows.Documents.BlockUIContainer"),
            new KnownElement(38,  "System.Windows.Media.Effects.BlurBitmapEffect"),
            new KnownElement(39,  "System.Windows.Media.Imaging.BmpBitmapDecoder"),
            new KnownElement(40,  "System.Windows.Media.Imaging.BmpBitmapEncoder"),
            new KnownElement(41,  "System.Windows.Documents.Bold"),
            new KnownElement(42,  "System.Windows.Media.Converters.BoolIListConverter"),
            new KnownElement(43,  "System.Boolean"),
            new KnownElement(44,  "System.Windows.Media.Animation.BooleanAnimationBase"),
            new KnownElement(45,  "System.Windows.Media.Animation.BooleanAnimationUsingKeyFrames"),
            new KnownElement(46,  "System.ComponentModel.BooleanConverter"),
            new KnownElement(47,  "System.Windows.Media.Animation.BooleanKeyFrame"),
            new KnownElement(48,  "System.Windows.Media.Animation.BooleanKeyFrameCollection"),
            new KnownElement(49,  "System.Windows.Controls.BooleanToVisibilityConverter"),
            new KnownElement(50,  "System.Windows.Controls.Border"),
            new KnownElement(51,  "System.Windows.Controls.BorderGapMaskConverter"),
            new KnownElement(52,  "System.Windows.Media.Brush"),
            new KnownElement(53,  "System.Windows.Media.BrushConverter"),
            new KnownElement(54,  "System.Windows.Controls.Primitives.BulletDecorator"),
            new KnownElement(55,  "System.Windows.Controls.Button"),
            new KnownElement(56,  "System.Windows.Controls.Primitives.ButtonBase"),
            new KnownElement(57,  "System.Byte"),
            new KnownElement(58,  "System.Windows.Media.Animation.ByteAnimation"),
            new KnownElement(59,  "System.Windows.Media.Animation.ByteAnimationBase"),
            new KnownElement(60,  "System.Windows.Media.Animation.ByteAnimationUsingKeyFrames"),
            new KnownElement(61,  "System.ComponentModel.ByteConverter"),
            new KnownElement(62,  "System.Windows.Media.Animation.ByteKeyFrame"),
            new KnownElement(63,  "System.Windows.Media.Animation.ByteKeyFrameCollection"),
            new KnownElement(64,  "System.Windows.Media.Imaging.CachedBitmap"),
            new KnownElement(65,  "System.Windows.Media.Media3D.Camera"),
            new KnownElement(66,  "System.Windows.Controls.Canvas"),
            new KnownElement(67,  "System.Char"),
            new KnownElement(68,  "System.Windows.Media.Animation.CharAnimationBase"),
            new KnownElement(69,  "System.Windows.Media.Animation.CharAnimationUsingKeyFrames"),
            new KnownElement(70,  "System.ComponentModel.CharConverter"),
            new KnownElement(71,  "System.Windows.Media.Converters.CharIListConverter"),
            new KnownElement(72,  "System.Windows.Media.Animation.CharKeyFrame"),
            new KnownElement(73,  "System.Windows.Media.Animation.CharKeyFrameCollection"),
            new KnownElement(74,  "System.Windows.Controls.CheckBox"),
            new KnownElement(75,  "System.Windows.Media.Animation.Clock"),
            new KnownElement(76,  "System.Windows.Media.Animation.ClockController"),
            new KnownElement(77,  "System.Windows.Media.Animation.ClockGroup"),
            new KnownElement(78,  "System.Windows.Data.CollectionContainer"),
            new KnownElement(79,  "System.Windows.Data.CollectionView"),
            new KnownElement(80,  "System.Windows.Data.CollectionViewSource"),
            new KnownElement(81,  "System.Windows.Media.Color"),
            new KnownElement(82,  "System.Windows.Media.Animation.ColorAnimation"),
            new KnownElement(83,  "System.Windows.Media.Animation.ColorAnimationBase"),
            new KnownElement(84,  "System.Windows.Media.Animation.ColorAnimationUsingKeyFrames"),
            new KnownElement(85,  "System.Windows.Media.Imaging.ColorConvertedBitmap"),
            new KnownElement(86,  "System.Windows.ColorConvertedBitmapExtension"),
            new KnownElement(87,  "System.Windows.Media.ColorConverter"),
            new KnownElement(88,  "System.Windows.Media.Animation.ColorKeyFrame"),
            new KnownElement(89,  "System.Windows.Media.Animation.ColorKeyFrameCollection"),
            new KnownElement(90,  "System.Windows.Controls.ColumnDefinition"),
            new KnownElement(91,  "System.Windows.Media.CombinedGeometry"),
            new KnownElement(92,  "System.Windows.Controls.ComboBox"),
            new KnownElement(93,  "System.Windows.Controls.ComboBoxItem"),
            new KnownElement(94,  "System.Windows.Input.CommandConverter"),
            new KnownElement(95,  "System.Windows.ComponentResourceKey"),
            new KnownElement(96,  "System.Windows.Markup.ComponentResourceKeyConverter"),
            new KnownElement(97,  "System.Windows.Media.CompositionTarget"),
            new KnownElement(98,  "System.Windows.Condition"),
            new KnownElement(99,  "System.Windows.Media.ContainerVisual"),
            new KnownElement(100,  "System.Windows.Controls.ContentControl"),
            new KnownElement(101,  "System.Windows.ContentElement"),
            new KnownElement(102,  "System.Windows.Controls.ContentPresenter"),
            new KnownElement(103,  "System.Windows.Markup.ContentPropertyAttribute"),
            new KnownElement(104,  "System.Windows.Markup.ContentWrapperAttribute"),
            new KnownElement(105,  "System.Windows.Controls.ContextMenu"),
            new KnownElement(106,  "System.Windows.Controls.ContextMenuService"),
            new KnownElement(107,  "System.Windows.Controls.Control"),
            new KnownElement(108,  "System.Windows.Controls.ControlTemplate"),
            new KnownElement(109,  "System.Windows.Media.Animation.ControllableStoryboardAction"),
            new KnownElement(110,  "System.Windows.CornerRadius"),
            new KnownElement(111,  "System.Windows.CornerRadiusConverter"),
            new KnownElement(112,  "System.Windows.Media.Imaging.CroppedBitmap"),
            new KnownElement(113,  "System.Globalization.CultureInfo"),
            new KnownElement(114,  "System.ComponentModel.CultureInfoConverter"),
            new KnownElement(115,  "System.Windows.CultureInfoIetfLanguageTagConverter"),
            new KnownElement(116,  "System.Windows.Input.Cursor"),
            new KnownElement(117,  "System.Windows.Input.CursorConverter"),
            new KnownElement(118,  "System.Windows.Media.DashStyle"),
            new KnownElement(119,  "System.Windows.Data.DataChangedEventManager"),
            new KnownElement(120,  "System.Windows.DataTemplate"),
            new KnownElement(121,  "System.Windows.DataTemplateKey"),
            new KnownElement(122,  "System.Windows.DataTrigger"),
            new KnownElement(123,  "System.DateTime"),
            new KnownElement(124,  "System.ComponentModel.DateTimeConverter"),
            new KnownElement(125,  "System.Windows.Markup.DateTimeConverter2"),
            new KnownElement(126,  "System.Decimal"),
            new KnownElement(127,  "System.Windows.Media.Animation.DecimalAnimation"),
            new KnownElement(128,  "System.Windows.Media.Animation.DecimalAnimationBase"),
            new KnownElement(129,  "System.Windows.Media.Animation.DecimalAnimationUsingKeyFrames"),
            new KnownElement(130,  "System.ComponentModel.DecimalConverter"),
            new KnownElement(131,  "System.Windows.Media.Animation.DecimalKeyFrame"),
            new KnownElement(132,  "System.Windows.Media.Animation.DecimalKeyFrameCollection"),
            new KnownElement(133,  "System.Windows.Controls.Decorator"),
            new KnownElement(134,  "System.Windows.Controls.DefinitionBase"),
            new KnownElement(135,  "System.Windows.DependencyObject"),
            new KnownElement(136,  "System.Windows.DependencyProperty"),
            new KnownElement(137,  "System.Windows.Markup.DependencyPropertyConverter"),
            new KnownElement(138,  "System.Windows.DialogResultConverter"),
            new KnownElement(139,  "System.Windows.Media.Media3D.DiffuseMaterial"),
            new KnownElement(140,  "System.Windows.Media.Media3D.DirectionalLight"),
            new KnownElement(141,  "System.Windows.Media.Animation.DiscreteBooleanKeyFrame"),
            new KnownElement(142,  "System.Windows.Media.Animation.DiscreteByteKeyFrame"),
            new KnownElement(143,  "System.Windows.Media.Animation.DiscreteCharKeyFrame"),
            new KnownElement(144,  "System.Windows.Media.Animation.DiscreteColorKeyFrame"),
            new KnownElement(145,  "System.Windows.Media.Animation.DiscreteDecimalKeyFrame"),
            new KnownElement(146,  "System.Windows.Media.Animation.DiscreteDoubleKeyFrame"),
            new KnownElement(147,  "System.Windows.Media.Animation.DiscreteInt16KeyFrame"),
            new KnownElement(148,  "System.Windows.Media.Animation.DiscreteInt32KeyFrame"),
            new KnownElement(149,  "System.Windows.Media.Animation.DiscreteInt64KeyFrame"),
            new KnownElement(150,  "System.Windows.Media.Animation.DiscreteMatrixKeyFrame"),
            new KnownElement(151,  "System.Windows.Media.Animation.DiscreteObjectKeyFrame"),
            new KnownElement(152,  "System.Windows.Media.Animation.DiscretePoint3DKeyFrame"),
            new KnownElement(153,  "System.Windows.Media.Animation.DiscretePointKeyFrame"),
            new KnownElement(154,  "System.Windows.Media.Animation.DiscreteQuaternionKeyFrame"),
            new KnownElement(155,  "System.Windows.Media.Animation.DiscreteRectKeyFrame"),
            new KnownElement(156,  "System.Windows.Media.Animation.DiscreteRotation3DKeyFrame"),
            new KnownElement(157,  "System.Windows.Media.Animation.DiscreteSingleKeyFrame"),
            new KnownElement(158,  "System.Windows.Media.Animation.DiscreteSizeKeyFrame"),
            new KnownElement(159,  "System.Windows.Media.Animation.DiscreteStringKeyFrame"),
            new KnownElement(160,  "System.Windows.Media.Animation.DiscreteThicknessKeyFrame"),
            new KnownElement(161,  "System.Windows.Media.Animation.DiscreteVector3DKeyFrame"),
            new KnownElement(162,  "System.Windows.Media.Animation.DiscreteVectorKeyFrame"),
            new KnownElement(163,  "System.Windows.Controls.DockPanel"),
            new KnownElement(164,  "System.Windows.Controls.Primitives.DocumentPageView"),
            new KnownElement(165,  "System.Windows.Documents.DocumentReference"),
            new KnownElement(166,  "System.Windows.Controls.DocumentViewer"),
            new KnownElement(167,  "System.Windows.Controls.Primitives.DocumentViewerBase"),
            new KnownElement(168,  "System.Double"),
            new KnownElement(169,  "System.Windows.Media.Animation.DoubleAnimation"),
            new KnownElement(170,  "System.Windows.Media.Animation.DoubleAnimationBase"),
            new KnownElement(171,  "System.Windows.Media.Animation.DoubleAnimationUsingKeyFrames"),
            new KnownElement(172,  "System.Windows.Media.Animation.DoubleAnimationUsingPath"),
            new KnownElement(173,  "System.Windows.Media.DoubleCollection"),
            new KnownElement(174,  "System.Windows.Media.DoubleCollectionConverter"),
            new KnownElement(175,  "System.ComponentModel.DoubleConverter"),
            new KnownElement(176,  "System.Windows.Media.Converters.DoubleIListConverter"),
            new KnownElement(177,  "System.Windows.Media.Animation.DoubleKeyFrame"),
            new KnownElement(178,  "System.Windows.Media.Animation.DoubleKeyFrameCollection"),
            new KnownElement(179,  "System.Windows.Media.Drawing"),
            new KnownElement(180,  "System.Windows.Media.DrawingBrush"),
            new KnownElement(181,  "System.Windows.Media.DrawingCollection"),
            new KnownElement(182,  "System.Windows.Media.DrawingContext"),
            new KnownElement(183,  "System.Windows.Media.DrawingGroup"),
            new KnownElement(184,  "System.Windows.Media.DrawingImage"),
            new KnownElement(185,  "System.Windows.Media.DrawingVisual"),
            new KnownElement(186,  "System.Windows.Media.Effects.DropShadowBitmapEffect"),
            new KnownElement(187,  "System.Windows.Duration"),
            new KnownElement(188,  "System.Windows.DurationConverter"),
            new KnownElement(189,  "System.Windows.DynamicResourceExtension"),
            new KnownElement(190,  "System.Windows.DynamicResourceExtensionConverter"),
            new KnownElement(191,  "System.Windows.Shapes.Ellipse"),
            new KnownElement(192,  "System.Windows.Media.EllipseGeometry"),
            new KnownElement(193,  "System.Windows.Media.Effects.EmbossBitmapEffect"),
            new KnownElement(194,  "System.Windows.Media.Media3D.EmissiveMaterial"),
            new KnownElement(195,  "System.ComponentModel.EnumConverter"),
            new KnownElement(196,  "System.Windows.EventManager"),
            new KnownElement(197,  "System.Windows.EventSetter"),
            new KnownElement(198,  "System.Windows.EventTrigger"),
            new KnownElement(199,  "System.Windows.Controls.Expander"),
            new KnownElement(200,  "System.Windows.Expression"),
            new KnownElement(201,  "System.Windows.ExpressionConverter"),
            new KnownElement(202,  "System.Windows.Documents.Figure"),
            new KnownElement(203,  "System.Windows.FigureLength"),
            new KnownElement(204,  "System.Windows.FigureLengthConverter"),
            new KnownElement(205,  "System.Windows.Documents.FixedDocument"),
            new KnownElement(206,  "System.Windows.Documents.FixedDocumentSequence"),
            new KnownElement(207,  "System.Windows.Documents.FixedPage"),
            new KnownElement(208,  "System.Windows.Documents.Floater"),
            new KnownElement(209,  "System.Windows.Documents.FlowDocument"),
            new KnownElement(210,  "System.Windows.Controls.FlowDocumentPageViewer"),
            new KnownElement(211,  "System.Windows.Controls.FlowDocumentReader"),
            new KnownElement(212,  "System.Windows.Controls.FlowDocumentScrollViewer"),
            new KnownElement(213,  "System.Windows.Input.FocusManager"),
            new KnownElement(214,  "System.Windows.Media.FontFamily"),
            new KnownElement(215,  "System.Windows.Media.FontFamilyConverter"),
            new KnownElement(216,  "System.Windows.FontSizeConverter"),
            new KnownElement(217,  "System.Windows.FontStretch"),
            new KnownElement(218,  "System.Windows.FontStretchConverter"),
            new KnownElement(219,  "System.Windows.FontStyle"),
            new KnownElement(220,  "System.Windows.FontStyleConverter"),
            new KnownElement(221,  "System.Windows.FontWeight"),
            new KnownElement(222,  "System.Windows.FontWeightConverter"),
            new KnownElement(223,  "System.Windows.Media.Imaging.FormatConvertedBitmap"),
            new KnownElement(224,  "System.Windows.Controls.Frame"),
            new KnownElement(225,  "System.Windows.FrameworkContentElement"),
            new KnownElement(226,  "System.Windows.FrameworkElement"),
            new KnownElement(227,  "System.Windows.FrameworkElementFactory"),
            new KnownElement(228,  "System.Windows.FrameworkPropertyMetadata"),
            new KnownElement(229,  "System.Windows.FrameworkPropertyMetadataOptions"),
            new KnownElement(230,  "System.Windows.Documents.FrameworkRichTextComposition"),
            new KnownElement(231,  "System.Windows.FrameworkTemplate"),
            new KnownElement(232,  "System.Windows.Documents.FrameworkTextComposition"),
            new KnownElement(233,  "System.Windows.Freezable"),
            new KnownElement(234,  "System.Windows.Media.GeneralTransform"),
            new KnownElement(235,  "System.Windows.Media.GeneralTransformCollection"),
            new KnownElement(236,  "System.Windows.Media.GeneralTransformGroup"),
            new KnownElement(237,  "System.Windows.Media.Geometry"),
            new KnownElement(238,  "System.Windows.Media.Media3D.Geometry3D"),
            new KnownElement(239,  "System.Windows.Media.GeometryCollection"),
            new KnownElement(240,  "System.Windows.Media.GeometryConverter"),
            new KnownElement(241,  "System.Windows.Media.GeometryDrawing"),
            new KnownElement(242,  "System.Windows.Media.GeometryGroup"),
            new KnownElement(243,  "System.Windows.Media.Media3D.GeometryModel3D"),
            new KnownElement(244,  "System.Windows.Ink.GestureRecognizer"),
            new KnownElement(245,  "System.Windows.Media.Imaging.GifBitmapDecoder"),
            new KnownElement(246,  "System.Windows.Media.Imaging.GifBitmapEncoder"),
            new KnownElement(247,  "System.Windows.Media.GlyphRun"),
            new KnownElement(248,  "System.Windows.Media.GlyphRunDrawing"),
            new KnownElement(249,  "System.Windows.Media.GlyphTypeface"),
            new KnownElement(250,  "System.Windows.Documents.Glyphs"),
            new KnownElement(251,  "System.Windows.Media.GradientBrush"),
            new KnownElement(252,  "System.Windows.Media.GradientStop"),
            new KnownElement(253,  "System.Windows.Media.GradientStopCollection"),
            new KnownElement(254,  "System.Windows.Controls.Grid"),
            new KnownElement(255,  "System.Windows.GridLength"),
            new KnownElement(256,  "System.Windows.GridLengthConverter"),
            new KnownElement(257,  "System.Windows.Controls.GridSplitter"),
            new KnownElement(258,  "System.Windows.Controls.GridView"),
            new KnownElement(259,  "System.Windows.Controls.GridViewColumn"),
            new KnownElement(260,  "System.Windows.Controls.GridViewColumnHeader"),
            new KnownElement(261,  "System.Windows.Controls.GridViewHeaderRowPresenter"),
            new KnownElement(262,  "System.Windows.Controls.GridViewRowPresenter"),
            new KnownElement(263,  "System.Windows.Controls.Primitives.GridViewRowPresenterBase"),
            new KnownElement(264,  "System.Windows.Controls.GroupBox"),
            new KnownElement(265,  "System.Windows.Controls.GroupItem"),
            new KnownElement(266,  "System.Guid"),
            new KnownElement(267,  "System.ComponentModel.GuidConverter"),
            new KnownElement(268,  "System.Windows.Media.GuidelineSet"),
            new KnownElement(269,  "System.Windows.Controls.HeaderedContentControl"),
            new KnownElement(270,  "System.Windows.Controls.HeaderedItemsControl"),
            new KnownElement(271,  "System.Windows.HierarchicalDataTemplate"),
            new KnownElement(272,  "System.Windows.Media.HostVisual"),
            new KnownElement(273,  "System.Windows.Documents.Hyperlink"),
            new KnownElement(274,  "System.Windows.Markup.IAddChild"),
            new KnownElement(275,  "System.Windows.Markup.IAddChildInternal"),
            new KnownElement(276,  "System.Windows.Input.ICommand"),
            new KnownElement(277,  "System.Windows.Markup.IComponentConnector"),
            new KnownElement(278,  "System.Windows.Markup.INameScope"),
            new KnownElement(279,  "System.Windows.Markup.IStyleConnector"),
            new KnownElement(280,  "System.Windows.Media.Imaging.IconBitmapDecoder"),
            new KnownElement(281,  "System.Windows.Controls.Image"),
            new KnownElement(282,  "System.Windows.Media.ImageBrush"),
            new KnownElement(283,  "System.Windows.Media.ImageDrawing"),
            new KnownElement(284,  "System.Windows.Media.ImageMetadata"),
            new KnownElement(285,  "System.Windows.Media.ImageSource"),
            new KnownElement(286,  "System.Windows.Media.ImageSourceConverter"),
            new KnownElement(287,  "System.Windows.Media.Imaging.InPlaceBitmapMetadataWriter"),
            new KnownElement(288,  "System.Windows.Controls.InkCanvas"),
            new KnownElement(289,  "System.Windows.Controls.InkPresenter"),
            new KnownElement(290,  "System.Windows.Documents.Inline"),
            new KnownElement(291,  "System.Windows.Documents.InlineCollection"),
            new KnownElement(292,  "System.Windows.Documents.InlineUIContainer"),
            new KnownElement(293,  "System.Windows.Input.InputBinding"),
            new KnownElement(294,  "System.Windows.Input.InputDevice"),
            new KnownElement(295,  "System.Windows.Input.InputLanguageManager"),
            new KnownElement(296,  "System.Windows.Input.InputManager"),
            new KnownElement(297,  "System.Windows.Input.InputMethod"),
            new KnownElement(298,  "System.Windows.Input.InputScope"),
            new KnownElement(299,  "System.Windows.Input.InputScopeConverter"),
            new KnownElement(300,  "System.Windows.Input.InputScopeName"),
            new KnownElement(301,  "System.Windows.Input.InputScopeNameConverter"),
            new KnownElement(302,  "System.Int16"),
            new KnownElement(303,  "System.Windows.Media.Animation.Int16Animation"),
            new KnownElement(304,  "System.Windows.Media.Animation.Int16AnimationBase"),
            new KnownElement(305,  "System.Windows.Media.Animation.Int16AnimationUsingKeyFrames"),
            new KnownElement(306,  "System.ComponentModel.Int16Converter"),
            new KnownElement(307,  "System.Windows.Media.Animation.Int16KeyFrame"),
            new KnownElement(308,  "System.Windows.Media.Animation.Int16KeyFrameCollection"),
            new KnownElement(309,  "System.Int32"),
            new KnownElement(310,  "System.Windows.Media.Animation.Int32Animation"),
            new KnownElement(311,  "System.Windows.Media.Animation.Int32AnimationBase"),
            new KnownElement(312,  "System.Windows.Media.Animation.Int32AnimationUsingKeyFrames"),
            new KnownElement(313,  "System.Windows.Media.Int32Collection"),
            new KnownElement(314,  "System.Windows.Media.Int32CollectionConverter"),
            new KnownElement(315,  "System.ComponentModel.Int32Converter"),
            new KnownElement(316,  "System.Windows.Media.Animation.Int32KeyFrame"),
            new KnownElement(317,  "System.Windows.Media.Animation.Int32KeyFrameCollection"),
            new KnownElement(318,  "System.Windows.Int32Rect"),
            new KnownElement(319,  "System.Windows.Int32RectConverter"),
            new KnownElement(320,  "System.Int64"),
            new KnownElement(321,  "System.Windows.Media.Animation.Int64Animation"),
            new KnownElement(322,  "System.Windows.Media.Animation.Int64AnimationBase"),
            new KnownElement(323,  "System.Windows.Media.Animation.Int64AnimationUsingKeyFrames"),
            new KnownElement(324,  "System.ComponentModel.Int64Converter"),
            new KnownElement(325,  "System.Windows.Media.Animation.Int64KeyFrame"),
            new KnownElement(326,  "System.Windows.Media.Animation.Int64KeyFrameCollection"),
            new KnownElement(327,  "System.Windows.Documents.Italic"),
            new KnownElement(328,  "System.Windows.Controls.ItemCollection"),
            new KnownElement(329,  "System.Windows.Controls.ItemsControl"),
            new KnownElement(330,  "System.Windows.Controls.ItemsPanelTemplate"),
            new KnownElement(331,  "System.Windows.Controls.ItemsPresenter"),
            new KnownElement(332,  "System.Windows.Navigation.JournalEntry"),
            new KnownElement(333,  "System.Windows.Navigation.JournalEntryListConverter"),
            new KnownElement(334,  "System.Windows.Navigation.JournalEntryUnifiedViewConverter"),
            new KnownElement(335,  "System.Windows.Media.Imaging.JpegBitmapDecoder"),
            new KnownElement(336,  "System.Windows.Media.Imaging.JpegBitmapEncoder"),
            new KnownElement(337,  "System.Windows.Input.KeyBinding"),
            new KnownElement(338,  "System.Windows.Input.KeyConverter"),
            new KnownElement(339,  "System.Windows.Input.KeyGesture"),
            new KnownElement(340,  "System.Windows.Input.KeyGestureConverter"),
            new KnownElement(341,  "System.Windows.Media.Animation.KeySpline"),
            new KnownElement(342,  "System.Windows.KeySplineConverter"),
            new KnownElement(343,  "System.Windows.Media.Animation.KeyTime"),
            new KnownElement(344,  "System.Windows.KeyTimeConverter"),
            new KnownElement(345,  "System.Windows.Input.KeyboardDevice"),
            new KnownElement(346,  "System.Windows.Controls.Label"),
            new KnownElement(347,  "System.Windows.Media.Imaging.LateBoundBitmapDecoder"),
            new KnownElement(348,  "System.Windows.LengthConverter"),
            new KnownElement(349,  "System.Windows.Media.Media3D.Light"),
            new KnownElement(350,  "System.Windows.Shapes.Line"),
            new KnownElement(351,  "System.Windows.Documents.LineBreak"),
            new KnownElement(352,  "System.Windows.Media.LineGeometry"),
            new KnownElement(353,  "System.Windows.Media.LineSegment"),
            new KnownElement(354,  "System.Windows.Media.Animation.LinearByteKeyFrame"),
            new KnownElement(355,  "System.Windows.Media.Animation.LinearColorKeyFrame"),
            new KnownElement(356,  "System.Windows.Media.Animation.LinearDecimalKeyFrame"),
            new KnownElement(357,  "System.Windows.Media.Animation.LinearDoubleKeyFrame"),
            new KnownElement(358,  "System.Windows.Media.LinearGradientBrush"),
            new KnownElement(359,  "System.Windows.Media.Animation.LinearInt16KeyFrame"),
            new KnownElement(360,  "System.Windows.Media.Animation.LinearInt32KeyFrame"),
            new KnownElement(361,  "System.Windows.Media.Animation.LinearInt64KeyFrame"),
            new KnownElement(362,  "System.Windows.Media.Animation.LinearPoint3DKeyFrame"),
            new KnownElement(363,  "System.Windows.Media.Animation.LinearPointKeyFrame"),
            new KnownElement(364,  "System.Windows.Media.Animation.LinearQuaternionKeyFrame"),
            new KnownElement(365,  "System.Windows.Media.Animation.LinearRectKeyFrame"),
            new KnownElement(366,  "System.Windows.Media.Animation.LinearRotation3DKeyFrame"),
            new KnownElement(367,  "System.Windows.Media.Animation.LinearSingleKeyFrame"),
            new KnownElement(368,  "System.Windows.Media.Animation.LinearSizeKeyFrame"),
            new KnownElement(369,  "System.Windows.Media.Animation.LinearThicknessKeyFrame"),
            new KnownElement(370,  "System.Windows.Media.Animation.LinearVector3DKeyFrame"),
            new KnownElement(371,  "System.Windows.Media.Animation.LinearVectorKeyFrame"),
            new KnownElement(372,  "System.Windows.Documents.List"),
            new KnownElement(373,  "System.Windows.Controls.ListBox"),
            new KnownElement(374,  "System.Windows.Controls.ListBoxItem"),
            new KnownElement(375,  "System.Windows.Data.ListCollectionView"),
            new KnownElement(376,  "System.Windows.Documents.ListItem"),
            new KnownElement(377,  "System.Windows.Controls.ListView"),
            new KnownElement(378,  "System.Windows.Controls.ListViewItem"),
            new KnownElement(379,  "System.Windows.Localization"),
            new KnownElement(380,  "System.Windows.LostFocusEventManager"),
            new KnownElement(381,  "System.Windows.Markup.MarkupExtension"),
            new KnownElement(382,  "System.Windows.Media.Media3D.Material"),
            new KnownElement(383,  "System.Windows.Media.Media3D.MaterialCollection"),
            new KnownElement(384,  "System.Windows.Media.Media3D.MaterialGroup"),
            new KnownElement(385,  "System.Windows.Media.Matrix"),
            new KnownElement(386,  "System.Windows.Media.Media3D.Matrix3D"),
            new KnownElement(387,  "System.Windows.Media.Media3D.Matrix3DConverter"),
            new KnownElement(388,  "System.Windows.Media.Animation.MatrixAnimationBase"),
            new KnownElement(389,  "System.Windows.Media.Animation.MatrixAnimationUsingKeyFrames"),
            new KnownElement(390,  "System.Windows.Media.Animation.MatrixAnimationUsingPath"),
            new KnownElement(391,  "System.Windows.Media.Media3D.MatrixCamera"),
            new KnownElement(392,  "System.Windows.Media.MatrixConverter"),
            new KnownElement(393,  "System.Windows.Media.Animation.MatrixKeyFrame"),
            new KnownElement(394,  "System.Windows.Media.Animation.MatrixKeyFrameCollection"),
            new KnownElement(395,  "System.Windows.Media.MatrixTransform"),
            new KnownElement(396,  "System.Windows.Media.Media3D.MatrixTransform3D"),
            new KnownElement(397,  "System.Windows.Media.MediaClock"),
            new KnownElement(398,  "System.Windows.Controls.MediaElement"),
            new KnownElement(399,  "System.Windows.Media.MediaPlayer"),
            new KnownElement(400,  "System.Windows.Media.MediaTimeline"),
            new KnownElement(401,  "System.Windows.Controls.Menu"),
            new KnownElement(402,  "System.Windows.Controls.Primitives.MenuBase"),
            new KnownElement(403,  "System.Windows.Controls.MenuItem"),
            new KnownElement(404,  "System.Windows.Controls.MenuScrollingVisibilityConverter"),
            new KnownElement(405,  "System.Windows.Media.Media3D.MeshGeometry3D"),
            new KnownElement(406,  "System.Windows.Media.Media3D.Model3D"),
            new KnownElement(407,  "System.Windows.Media.Media3D.Model3DCollection"),
            new KnownElement(408,  "System.Windows.Media.Media3D.Model3DGroup"),
            new KnownElement(409,  "System.Windows.Media.Media3D.ModelVisual3D"),
            new KnownElement(410,  "System.Windows.Input.ModifierKeysConverter"),
            new KnownElement(411,  "System.Windows.Input.MouseActionConverter"),
            new KnownElement(412,  "System.Windows.Input.MouseBinding"),
            new KnownElement(413,  "System.Windows.Input.MouseDevice"),
            new KnownElement(414,  "System.Windows.Input.MouseGesture"),
            new KnownElement(415,  "System.Windows.Input.MouseGestureConverter"),
            new KnownElement(416,  "System.Windows.Data.MultiBinding"),
            new KnownElement(417,  "System.Windows.Data.MultiBindingExpression"),
            new KnownElement(418,  "System.Windows.MultiDataTrigger"),
            new KnownElement(419,  "System.Windows.MultiTrigger"),
            new KnownElement(420,  "System.Windows.NameScope"),
            new KnownElement(421,  "System.Windows.Navigation.NavigationWindow"),
            new KnownElement(422,  "System.Windows.Markup.NullExtension"),
            new KnownElement(423,  "System.Windows.NullableBoolConverter"),
            new KnownElement(424,  "System.ComponentModel.NullableConverter"),
            new KnownElement(425,  "System.Windows.Media.NumberSubstitution"),
            new KnownElement(426,  "System.Object"),
            new KnownElement(427,  "System.Windows.Media.Animation.ObjectAnimationBase"),
            new KnownElement(428,  "System.Windows.Media.Animation.ObjectAnimationUsingKeyFrames"),
            new KnownElement(429,  "System.Windows.Data.ObjectDataProvider"),
            new KnownElement(430,  "System.Windows.Media.Animation.ObjectKeyFrame"),
            new KnownElement(431,  "System.Windows.Media.Animation.ObjectKeyFrameCollection"),
            new KnownElement(432,  "System.Windows.Media.Media3D.OrthographicCamera"),
            new KnownElement(433,  "System.Windows.Media.Effects.OuterGlowBitmapEffect"),
            new KnownElement(434,  "System.Windows.Controls.Page"),
            new KnownElement(435,  "System.Windows.Documents.PageContent"),
            new KnownElement(436,  "System.Windows.Navigation.PageFunctionBase"),
            new KnownElement(437,  "System.Windows.Controls.Panel"),
            new KnownElement(438,  "System.Windows.Documents.Paragraph"),
            new KnownElement(439,  "System.Windows.Media.Animation.ParallelTimeline"),
            new KnownElement(440,  "System.Windows.Markup.ParserContext"),
            new KnownElement(441,  "System.Windows.Controls.PasswordBox"),
            new KnownElement(442,  "System.Windows.Shapes.Path"),
            new KnownElement(443,  "System.Windows.Media.PathFigure"),
            new KnownElement(444,  "System.Windows.Media.PathFigureCollection"),
            new KnownElement(445,  "System.Windows.Media.PathFigureCollectionConverter"),
            new KnownElement(446,  "System.Windows.Media.PathGeometry"),
            new KnownElement(447,  "System.Windows.Media.PathSegment"),
            new KnownElement(448,  "System.Windows.Media.PathSegmentCollection"),
            new KnownElement(449,  "System.Windows.Media.Animation.PauseStoryboard"),
            new KnownElement(450,  "System.Windows.Media.Pen"),
            new KnownElement(451,  "System.Windows.Media.Media3D.PerspectiveCamera"),
            new KnownElement(452,  "System.Windows.Media.PixelFormat"),
            new KnownElement(453,  "System.Windows.Media.PixelFormatConverter"),
            new KnownElement(454,  "System.Windows.Media.Imaging.PngBitmapDecoder"),
            new KnownElement(455,  "System.Windows.Media.Imaging.PngBitmapEncoder"),
            new KnownElement(456,  "System.Windows.Point"),
            new KnownElement(457,  "System.Windows.Media.Media3D.Point3D"),
            new KnownElement(458,  "System.Windows.Media.Animation.Point3DAnimation"),
            new KnownElement(459,  "System.Windows.Media.Animation.Point3DAnimationBase"),
            new KnownElement(460,  "System.Windows.Media.Animation.Point3DAnimationUsingKeyFrames"),
            new KnownElement(461,  "System.Windows.Media.Media3D.Point3DCollection"),
            new KnownElement(462,  "System.Windows.Media.Media3D.Point3DCollectionConverter"),
            new KnownElement(463,  "System.Windows.Media.Media3D.Point3DConverter"),
            new KnownElement(464,  "System.Windows.Media.Animation.Point3DKeyFrame"),
            new KnownElement(465,  "System.Windows.Media.Animation.Point3DKeyFrameCollection"),
            new KnownElement(466,  "System.Windows.Media.Media3D.Point4D"),
            new KnownElement(467,  "System.Windows.Media.Media3D.Point4DConverter"),
            new KnownElement(468,  "System.Windows.Media.Animation.PointAnimation"),
            new KnownElement(469,  "System.Windows.Media.Animation.PointAnimationBase"),
            new KnownElement(470,  "System.Windows.Media.Animation.PointAnimationUsingKeyFrames"),
            new KnownElement(471,  "System.Windows.Media.Animation.PointAnimationUsingPath"),
            new KnownElement(472,  "System.Windows.Media.PointCollection"),
            new KnownElement(473,  "System.Windows.Media.PointCollectionConverter"),
            new KnownElement(474,  "System.Windows.PointConverter"),
            new KnownElement(475,  "System.Windows.Media.Converters.PointIListConverter"),
            new KnownElement(476,  "System.Windows.Media.Animation.PointKeyFrame"),
            new KnownElement(477,  "System.Windows.Media.Animation.PointKeyFrameCollection"),
            new KnownElement(478,  "System.Windows.Media.Media3D.PointLight"),
            new KnownElement(479,  "System.Windows.Media.Media3D.PointLightBase"),
            new KnownElement(480,  "System.Windows.Media.PolyBezierSegment"),
            new KnownElement(481,  "System.Windows.Media.PolyLineSegment"),
            new KnownElement(482,  "System.Windows.Media.PolyQuadraticBezierSegment"),
            new KnownElement(483,  "System.Windows.Shapes.Polygon"),
            new KnownElement(484,  "System.Windows.Shapes.Polyline"),
            new KnownElement(485,  "System.Windows.Controls.Primitives.Popup"),
            new KnownElement(486,  "System.Windows.PresentationSource"),
            new KnownElement(487,  "System.Windows.Data.PriorityBinding"),
            new KnownElement(488,  "System.Windows.Data.PriorityBindingExpression"),
            new KnownElement(489,  "System.Windows.Controls.ProgressBar"),
            new KnownElement(490,  "System.Windows.Media.Media3D.ProjectionCamera"),
            new KnownElement(491,  "System.Windows.PropertyPath"),
            new KnownElement(492,  "System.Windows.PropertyPathConverter"),
            new KnownElement(493,  "System.Windows.Media.QuadraticBezierSegment"),
            new KnownElement(494,  "System.Windows.Media.Media3D.Quaternion"),
            new KnownElement(495,  "System.Windows.Media.Animation.QuaternionAnimation"),
            new KnownElement(496,  "System.Windows.Media.Animation.QuaternionAnimationBase"),
            new KnownElement(497,  "System.Windows.Media.Animation.QuaternionAnimationUsingKeyFrames"),
            new KnownElement(498,  "System.Windows.Media.Media3D.QuaternionConverter"),
            new KnownElement(499,  "System.Windows.Media.Animation.QuaternionKeyFrame"),
            new KnownElement(500,  "System.Windows.Media.Animation.QuaternionKeyFrameCollection"),
            new KnownElement(501,  "System.Windows.Media.Media3D.QuaternionRotation3D"),
            new KnownElement(502,  "System.Windows.Media.RadialGradientBrush"),
            new KnownElement(503,  "System.Windows.Controls.RadioButton"),
            new KnownElement(504,  "System.Windows.Controls.Primitives.RangeBase"),
            new KnownElement(505,  "System.Windows.Rect"),
            new KnownElement(506,  "System.Windows.Media.Media3D.Rect3D"),
            new KnownElement(507,  "System.Windows.Media.Media3D.Rect3DConverter"),
            new KnownElement(508,  "System.Windows.Media.Animation.RectAnimation"),
            new KnownElement(509,  "System.Windows.Media.Animation.RectAnimationBase"),
            new KnownElement(510,  "System.Windows.Media.Animation.RectAnimationUsingKeyFrames"),
            new KnownElement(511,  "System.Windows.RectConverter"),
            new KnownElement(512,  "System.Windows.Media.Animation.RectKeyFrame"),
            new KnownElement(513,  "System.Windows.Media.Animation.RectKeyFrameCollection"),
            new KnownElement(514,  "System.Windows.Shapes.Rectangle"),
            new KnownElement(515,  "System.Windows.Media.RectangleGeometry"),
            new KnownElement(516,  "System.Windows.Data.RelativeSource"),
            new KnownElement(517,  "System.Windows.Media.Animation.RemoveStoryboard"),
            new KnownElement(518,  "System.Windows.Media.RenderOptions"),
            new KnownElement(519,  "System.Windows.Media.Imaging.RenderTargetBitmap"),
            new KnownElement(520,  "System.Windows.Media.Animation.RepeatBehavior"),
            new KnownElement(521,  "System.Windows.Media.Animation.RepeatBehaviorConverter"),
            new KnownElement(522,  "System.Windows.Controls.Primitives.RepeatButton"),
            new KnownElement(523,  "System.Windows.Controls.Primitives.ResizeGrip"),
            new KnownElement(524,  "System.Windows.ResourceDictionary"),
            new KnownElement(525,  "System.Windows.ResourceKey"),
            new KnownElement(526,  "System.Windows.Media.Animation.ResumeStoryboard"),
            new KnownElement(527,  "System.Windows.Controls.RichTextBox"),
            new KnownElement(528,  "System.Windows.Media.RotateTransform"),
            new KnownElement(529,  "System.Windows.Media.Media3D.RotateTransform3D"),
            new KnownElement(530,  "System.Windows.Media.Media3D.Rotation3D"),
            new KnownElement(531,  "System.Windows.Media.Animation.Rotation3DAnimation"),
            new KnownElement(532,  "System.Windows.Media.Animation.Rotation3DAnimationBase"),
            new KnownElement(533,  "System.Windows.Media.Animation.Rotation3DAnimationUsingKeyFrames"),
            new KnownElement(534,  "System.Windows.Media.Animation.Rotation3DKeyFrame"),
            new KnownElement(535,  "System.Windows.Media.Animation.Rotation3DKeyFrameCollection"),
            new KnownElement(536,  "System.Windows.Input.RoutedCommand"),
            new KnownElement(537,  "System.Windows.RoutedEvent"),
            new KnownElement(538,  "System.Windows.Markup.RoutedEventConverter"),
            new KnownElement(539,  "System.Windows.Input.RoutedUICommand"),
            new KnownElement(540,  "System.Windows.RoutingStrategy"),
            new KnownElement(541,  "System.Windows.Controls.RowDefinition"),
            new KnownElement(542,  "System.Windows.Documents.Run"),
            new KnownElement(543,  "System.Windows.Markup.RuntimeNamePropertyAttribute"),
            new KnownElement(544,  "System.SByte"),
            new KnownElement(545,  "System.ComponentModel.SByteConverter"),
            new KnownElement(546,  "System.Windows.Media.ScaleTransform"),
            new KnownElement(547,  "System.Windows.Media.Media3D.ScaleTransform3D"),
            new KnownElement(548,  "System.Windows.Controls.Primitives.ScrollBar"),
            new KnownElement(549,  "System.Windows.Controls.ScrollContentPresenter"),
            new KnownElement(550,  "System.Windows.Controls.ScrollViewer"),
            new KnownElement(551,  "System.Windows.Documents.Section"),
            new KnownElement(552,  "System.Windows.Media.Animation.SeekStoryboard"),
            new KnownElement(553,  "System.Windows.Controls.Primitives.Selector"),
            new KnownElement(554,  "System.Windows.Controls.Separator"),
            new KnownElement(555,  "System.Windows.Media.Animation.SetStoryboardSpeedRatio"),
            new KnownElement(556,  "System.Windows.Setter"),
            new KnownElement(557,  "System.Windows.SetterBase"),
            new KnownElement(558,  "System.Windows.Shapes.Shape"),
            new KnownElement(559,  "System.Single"),
            new KnownElement(560,  "System.Windows.Media.Animation.SingleAnimation"),
            new KnownElement(561,  "System.Windows.Media.Animation.SingleAnimationBase"),
            new KnownElement(562,  "System.Windows.Media.Animation.SingleAnimationUsingKeyFrames"),
            new KnownElement(563,  "System.ComponentModel.SingleConverter"),
            new KnownElement(564,  "System.Windows.Media.Animation.SingleKeyFrame"),
            new KnownElement(565,  "System.Windows.Media.Animation.SingleKeyFrameCollection"),
            new KnownElement(566,  "System.Windows.Size"),
            new KnownElement(567,  "System.Windows.Media.Media3D.Size3D"),
            new KnownElement(568,  "System.Windows.Media.Media3D.Size3DConverter"),
            new KnownElement(569,  "System.Windows.Media.Animation.SizeAnimation"),
            new KnownElement(570,  "System.Windows.Media.Animation.SizeAnimationBase"),
            new KnownElement(571,  "System.Windows.Media.Animation.SizeAnimationUsingKeyFrames"),
            new KnownElement(572,  "System.Windows.SizeConverter"),
            new KnownElement(573,  "System.Windows.Media.Animation.SizeKeyFrame"),
            new KnownElement(574,  "System.Windows.Media.Animation.SizeKeyFrameCollection"),
            new KnownElement(575,  "System.Windows.Media.SkewTransform"),
            new KnownElement(576,  "System.Windows.Media.Animation.SkipStoryboardToFill"),
            new KnownElement(577,  "System.Windows.Controls.Slider"),
            new KnownElement(578,  "System.Windows.Media.SolidColorBrush"),
            new KnownElement(579,  "System.Windows.Controls.SoundPlayerAction"),
            new KnownElement(580,  "System.Windows.Documents.Span"),
            new KnownElement(581,  "System.Windows.Media.Media3D.SpecularMaterial"),
            new KnownElement(582,  "System.Windows.Controls.SpellCheck"),
            new KnownElement(583,  "System.Windows.Media.Animation.SplineByteKeyFrame"),
            new KnownElement(584,  "System.Windows.Media.Animation.SplineColorKeyFrame"),
            new KnownElement(585,  "System.Windows.Media.Animation.SplineDecimalKeyFrame"),
            new KnownElement(586,  "System.Windows.Media.Animation.SplineDoubleKeyFrame"),
            new KnownElement(587,  "System.Windows.Media.Animation.SplineInt16KeyFrame"),
            new KnownElement(588,  "System.Windows.Media.Animation.SplineInt32KeyFrame"),
            new KnownElement(589,  "System.Windows.Media.Animation.SplineInt64KeyFrame"),
            new KnownElement(590,  "System.Windows.Media.Animation.SplinePoint3DKeyFrame"),
            new KnownElement(591,  "System.Windows.Media.Animation.SplinePointKeyFrame"),
            new KnownElement(592,  "System.Windows.Media.Animation.SplineQuaternionKeyFrame"),
            new KnownElement(593,  "System.Windows.Media.Animation.SplineRectKeyFrame"),
            new KnownElement(594,  "System.Windows.Media.Animation.SplineRotation3DKeyFrame"),
            new KnownElement(595,  "System.Windows.Media.Animation.SplineSingleKeyFrame"),
            new KnownElement(596,  "System.Windows.Media.Animation.SplineSizeKeyFrame"),
            new KnownElement(597,  "System.Windows.Media.Animation.SplineThicknessKeyFrame"),
            new KnownElement(598,  "System.Windows.Media.Animation.SplineVector3DKeyFrame"),
            new KnownElement(599,  "System.Windows.Media.Animation.SplineVectorKeyFrame"),
            new KnownElement(600,  "System.Windows.Media.Media3D.SpotLight"),
            new KnownElement(601,  "System.Windows.Controls.StackPanel"),
            new KnownElement(602,  "System.Windows.Markup.StaticExtension"),
            new KnownElement(603,  "System.Windows.StaticResourceExtension"),
            new KnownElement(604,  "System.Windows.Controls.Primitives.StatusBar"),
            new KnownElement(605,  "System.Windows.Controls.Primitives.StatusBarItem"),
            new KnownElement(606,  "System.Windows.Controls.StickyNoteControl"),
            new KnownElement(607,  "System.Windows.Media.Animation.StopStoryboard"),
            new KnownElement(608,  "System.Windows.Media.Animation.Storyboard"),
            new KnownElement(609,  "System.Windows.Media.StreamGeometry"),
            new KnownElement(610,  "System.Windows.Media.StreamGeometryContext"),
            new KnownElement(611,  "System.Windows.Resources.StreamResourceInfo"),
            new KnownElement(612,  "System.String"),
            new KnownElement(613,  "System.Windows.Media.Animation.StringAnimationBase"),
            new KnownElement(614,  "System.Windows.Media.Animation.StringAnimationUsingKeyFrames"),
            new KnownElement(615,  "System.ComponentModel.StringConverter"),
            new KnownElement(616,  "System.Windows.Media.Animation.StringKeyFrame"),
            new KnownElement(617,  "System.Windows.Media.Animation.StringKeyFrameCollection"),
            new KnownElement(618,  "System.Windows.Ink.StrokeCollection"),
            new KnownElement(619,  "System.Windows.StrokeCollectionConverter"),
            new KnownElement(620,  "System.Windows.Style"),
            new KnownElement(621,  "System.Windows.Input.Stylus"),
            new KnownElement(622,  "System.Windows.Input.StylusDevice"),
            new KnownElement(623,  "System.Windows.Controls.TabControl"),
            new KnownElement(624,  "System.Windows.Controls.TabItem"),
            new KnownElement(625,  "System.Windows.Controls.Primitives.TabPanel"),
            new KnownElement(626,  "System.Windows.Documents.Table"),
            new KnownElement(627,  "System.Windows.Documents.TableCell"),
            new KnownElement(628,  "System.Windows.Documents.TableColumn"),
            new KnownElement(629,  "System.Windows.Documents.TableRow"),
            new KnownElement(630,  "System.Windows.Documents.TableRowGroup"),
            new KnownElement(631,  "System.Windows.Input.TabletDevice"),
            new KnownElement(632,  "System.Windows.TemplateBindingExpression"),
            new KnownElement(633,  "System.Windows.TemplateBindingExpressionConverter"),
            new KnownElement(634,  "System.Windows.TemplateBindingExtension"),
            new KnownElement(635,  "System.Windows.TemplateBindingExtensionConverter"),
            new KnownElement(636,  "System.Windows.TemplateKey"),
            new KnownElement(637,  "System.Windows.Markup.TemplateKeyConverter"),
            new KnownElement(638,  "System.Windows.Controls.TextBlock"),
            new KnownElement(639,  "System.Windows.Controls.TextBox"),
            new KnownElement(640,  "System.Windows.Controls.Primitives.TextBoxBase"),
            new KnownElement(641,  "System.Windows.Input.TextComposition"),
            new KnownElement(642,  "System.Windows.Input.TextCompositionManager"),
            new KnownElement(643,  "System.Windows.TextDecoration"),
            new KnownElement(644,  "System.Windows.TextDecorationCollection"),
            new KnownElement(645,  "System.Windows.TextDecorationCollectionConverter"),
            new KnownElement(646,  "System.Windows.Media.TextEffect"),
            new KnownElement(647,  "System.Windows.Media.TextEffectCollection"),
            new KnownElement(648,  "System.Windows.Documents.TextElement"),
            new KnownElement(649,  "System.Windows.Controls.TextSearch"),
            new KnownElement(650,  "System.Windows.ThemeDictionaryExtension"),
            new KnownElement(651,  "System.Windows.Thickness"),
            new KnownElement(652,  "System.Windows.Media.Animation.ThicknessAnimation"),
            new KnownElement(653,  "System.Windows.Media.Animation.ThicknessAnimationBase"),
            new KnownElement(654,  "System.Windows.Media.Animation.ThicknessAnimationUsingKeyFrames"),
            new KnownElement(655,  "System.Windows.ThicknessConverter"),
            new KnownElement(656,  "System.Windows.Media.Animation.ThicknessKeyFrame"),
            new KnownElement(657,  "System.Windows.Media.Animation.ThicknessKeyFrameCollection"),
            new KnownElement(658,  "System.Windows.Controls.Primitives.Thumb"),
            new KnownElement(659,  "System.Windows.Controls.Primitives.TickBar"),
            new KnownElement(660,  "System.Windows.Media.Imaging.TiffBitmapDecoder"),
            new KnownElement(661,  "System.Windows.Media.Imaging.TiffBitmapEncoder"),
            new KnownElement(662,  "System.Windows.Media.TileBrush"),
            new KnownElement(663,  "System.TimeSpan"),
            new KnownElement(664,  "System.ComponentModel.TimeSpanConverter"),
            new KnownElement(665,  "System.Windows.Media.Animation.Timeline"),
            new KnownElement(666,  "System.Windows.Media.Animation.TimelineCollection"),
            new KnownElement(667,  "System.Windows.Media.Animation.TimelineGroup"),
            new KnownElement(668,  "System.Windows.Controls.Primitives.ToggleButton"),
            new KnownElement(669,  "System.Windows.Controls.ToolBar"),
            new KnownElement(670,  "System.Windows.Controls.Primitives.ToolBarOverflowPanel"),
            new KnownElement(671,  "System.Windows.Controls.Primitives.ToolBarPanel"),
            new KnownElement(672,  "System.Windows.Controls.ToolBarTray"),
            new KnownElement(673,  "System.Windows.Controls.ToolTip"),
            new KnownElement(674,  "System.Windows.Controls.ToolTipService"),
            new KnownElement(675,  "System.Windows.Controls.Primitives.Track"),
            new KnownElement(676,  "System.Windows.Media.Transform"),
            new KnownElement(677,  "System.Windows.Media.Media3D.Transform3D"),
            new KnownElement(678,  "System.Windows.Media.Media3D.Transform3DCollection"),
            new KnownElement(679,  "System.Windows.Media.Media3D.Transform3DGroup"),
            new KnownElement(680,  "System.Windows.Media.TransformCollection"),
            new KnownElement(681,  "System.Windows.Media.TransformConverter"),
            new KnownElement(682,  "System.Windows.Media.TransformGroup"),
            new KnownElement(683,  "System.Windows.Media.Imaging.TransformedBitmap"),
            new KnownElement(684,  "System.Windows.Media.TranslateTransform"),
            new KnownElement(685,  "System.Windows.Media.Media3D.TranslateTransform3D"),
            new KnownElement(686,  "System.Windows.Controls.TreeView"),
            new KnownElement(687,  "System.Windows.Controls.TreeViewItem"),
            new KnownElement(688,  "System.Windows.Trigger"),
            new KnownElement(689,  "System.Windows.TriggerAction"),
            new KnownElement(690,  "System.Windows.TriggerBase"),
            new KnownElement(691,  "System.Windows.Markup.TypeExtension"),
            new KnownElement(692,  "System.Windows.Markup.TypeTypeConverter"),
            new KnownElement(693,  "System.Windows.Documents.Typography"),
            new KnownElement(694,  "System.Windows.UIElement"),
            new KnownElement(695,  "System.UInt16"),
            new KnownElement(696,  "System.ComponentModel.UInt16Converter"),
            new KnownElement(697,  "System.UInt32"),
            new KnownElement(698,  "System.ComponentModel.UInt32Converter"),
            new KnownElement(699,  "System.UInt64"),
            new KnownElement(700,  "System.ComponentModel.UInt64Converter"),
            new KnownElement(701,  "System.Windows.Media.Converters.UShortIListConverter"),
            new KnownElement(702,  "System.Windows.Documents.Underline"),
            new KnownElement(703,  "System.Windows.Controls.Primitives.UniformGrid"),
            new KnownElement(704,  "System.Uri"),
            new KnownElement(705,  "System.UriTypeConverter"),
            new KnownElement(706,  "System.Windows.Controls.UserControl"),
            new KnownElement(707,  "System.Windows.Controls.Validation"),
            new KnownElement(708,  "System.Windows.Vector"),
            new KnownElement(709,  "System.Windows.Media.Media3D.Vector3D"),
            new KnownElement(710,  "System.Windows.Media.Animation.Vector3DAnimation"),
            new KnownElement(711,  "System.Windows.Media.Animation.Vector3DAnimationBase"),
            new KnownElement(712,  "System.Windows.Media.Animation.Vector3DAnimationUsingKeyFrames"),
            new KnownElement(713,  "System.Windows.Media.Media3D.Vector3DCollection"),
            new KnownElement(714,  "System.Windows.Media.Media3D.Vector3DCollectionConverter"),
            new KnownElement(715,  "System.Windows.Media.Media3D.Vector3DConverter"),
            new KnownElement(716,  "System.Windows.Media.Animation.Vector3DKeyFrame"),
            new KnownElement(717,  "System.Windows.Media.Animation.Vector3DKeyFrameCollection"),
            new KnownElement(718,  "System.Windows.Media.Animation.VectorAnimation"),
            new KnownElement(719,  "System.Windows.Media.Animation.VectorAnimationBase"),
            new KnownElement(720,  "System.Windows.Media.Animation.VectorAnimationUsingKeyFrames"),
            new KnownElement(721,  "System.Windows.Media.VectorCollection"),
            new KnownElement(722,  "System.Windows.Media.VectorCollectionConverter"),
            new KnownElement(723,  "System.Windows.VectorConverter"),
            new KnownElement(724,  "System.Windows.Media.Animation.VectorKeyFrame"),
            new KnownElement(725,  "System.Windows.Media.Animation.VectorKeyFrameCollection"),
            new KnownElement(726,  "System.Windows.Media.VideoDrawing"),
            new KnownElement(727,  "System.Windows.Controls.ViewBase"),
            new KnownElement(728,  "System.Windows.Controls.Viewbox"),
            new KnownElement(729,  "System.Windows.Controls.Viewport3D"),
            new KnownElement(730,  "System.Windows.Media.Media3D.Viewport3DVisual"),
            new KnownElement(731,  "System.Windows.Controls.VirtualizingPanel"),
            new KnownElement(732,  "System.Windows.Controls.VirtualizingStackPanel"),
            new KnownElement(733,  "System.Windows.Media.Visual"),
            new KnownElement(734,  "System.Windows.Media.Media3D.Visual3D"),
            new KnownElement(735,  "System.Windows.Media.VisualBrush"),
            new KnownElement(736,  "System.Windows.Media.VisualTarget"),
            new KnownElement(737,  "System.Windows.WeakEventManager"),
            new KnownElement(738,  "System.Windows.Markup.WhitespaceSignificantCollectionAttribute"),
            new KnownElement(739,  "System.Windows.Window"),
            new KnownElement(740,  "System.Windows.Media.Imaging.WmpBitmapDecoder"),
            new KnownElement(741,  "System.Windows.Media.Imaging.WmpBitmapEncoder"),
            new KnownElement(742,  "System.Windows.Controls.WrapPanel"),
            new KnownElement(743,  "System.Windows.Media.Imaging.WriteableBitmap"),
            new KnownElement(744,  "System.Windows.Markup.XamlBrushSerializer"),
            new KnownElement(745,  "System.Windows.Markup.XamlInt32CollectionSerializer"),
            new KnownElement(746,  "System.Windows.Markup.XamlPathDataSerializer"),
            new KnownElement(747,  "System.Windows.Markup.XamlPoint3DCollectionSerializer"),
            new KnownElement(748,  "System.Windows.Markup.XamlPointCollectionSerializer"),
            new KnownElement(749,  "System.Windows.Markup.XamlReader"),
            new KnownElement(750,  "System.Windows.Markup.XamlStyleSerializer"),
            new KnownElement(751,  "System.Windows.Markup.XamlTemplateSerializer"),
            new KnownElement(752,  "System.Windows.Markup.XamlVector3DCollectionSerializer"),
            new KnownElement(753,  "System.Windows.Markup.XamlWriter"),
            new KnownElement(754,  "System.Windows.Data.XmlDataProvider"),
            new KnownElement(755,  "System.Windows.Markup.XmlLangPropertyAttribute"),
            new KnownElement(756,  "System.Windows.Markup.XmlLanguage"),
            new KnownElement(757,  "System.Windows.Markup.XmlLanguageConverter"),
            new KnownElement(758,  "System.Windows.Data.XmlNamespaceMapping"),
            new KnownElement(759,  "System.Windows.Documents.ZoomPercentageConverter"),
        };
        }
    }
}
