package dev.deadzone.socket.messaging

/**
 * Network message constants used by the game.
 */
@Suppress("Unused", "SpellCheckingInspection")
object NetworkMessage {
    // custom definition
    const val JOIN = "join"
    const val JOIN_RESULT = "playerio.joinresult"

    // from game
    const val INIT_COMPLETE = "ic"
    const val ERROR = "err"
    const val BANNED = "ban"
    const val SEND_RESPONS = "r"
    const val SERVER_SHUTDOWN_UPDATE = "ssu"
    const val SERVER_SHUTDOWN_MAINTENANCE = "ssm"
    const val SERVER_ROOM_DISABLED = "srd"
    const val SERVER_SETTINGS = "ssup"
    const val SERVER_NEW_VERSION = "snv"
    const val GAME_READY = "gr"
    const val GAME_LOADING_PROGRESS = "gp"
    const val SERVER_INIT_PROGRESS = "sip"
    const val SIGN_IN_FAILED = "sf"
    const val SCENE_READY = "sr"
    const val SCENE_REQUEST = "srq"
    const val SERVER_UPDATE = "su"
    const val TIME_UPDATE = "tu"
    const val OUT_OF_SYNC = "os"
    const val PURCHASE_COIN = "p"
    const val SAVE = "s"
    const val SAVE_SUCCCESS = "ss"
    const val MISSION_LOOT = "ml"
    const val RESOURCE_UPDATE = "ru"
    const val SURVIVOR_NEW = "sn"
    const val PLAYER_VIEW_REQUEST = "pvr"
    const val PLAYER_ATTACK_REQUEST = "par"
    const val PLAYER_ATTACK_RESPONSE = "parp"
    const val HELP_PLAYER = "hp"
    const val NEW_NOTIFICATIONS = "nn"
    const val UNDER_ATTACK = "ua"
    const val ZOMBIE_ATTACK = "za"
    const val GET_PLAYER_SURVIVOR = "ps"
    const val GET_NEIGHBOR_STATES = "ns"
    const val REQUEST_ZOMBIE_ATTACK = "rza"
    const val REQUEST_SURVIVOR_CHECK = "rsc"
    const val TASK_COMPLETE = "tc"
    const val BUILDING_COMPLETE = "bc"
    const val BUILDING_REPAIR_COMPLETE = "brpc"
    const val MISSION_RETURN_COMPLETE = "mrc"
    const val MISSION_LOCK_COMPLETE = "mlc"
    const val SURVIVOR_INJURY_COMPLETE = "sic"
    const val BATCH_RECYCLE_COMPLETE = "brc"
    const val QUEST_PROGRESS = "qp"
    const val QUEST_DAILY_FAILED = "qdf"
    const val QUEST_ARMOR_GAMES_COMPLETE = "agq"
    const val SURVIVOR_REASSIGNMENT_COMPLETE = "src"
    const val EFFECT_COMPLETE = "ec"
    const val EFFECT_LOCKOUT_COMPLETE = "elc"
    const val COOLDOWN_COMPLETE = "cc"
    const val FLAG_CHANGED = "fc"
    const val UPGRADE_FLAG_CHANGED = "ufc"
    const val MISSION_EVENT = "me"
    const val PVP_LIST_UPDATE = "pvplist"
    const val SCAV_STARTED = "sc =strt"
    const val SCAV_ENDED = "scvend"
    const val FUEL_UPDATE = "fuel"
    const val TRADE_DISABLED = "td"
    const val LINKED_ALLIANCES = "alink"
    const val RESEARCH_COMPLETE = "rscmp"
    const val GLOBAL_QUEST_CONTRIBUTE = "gqcon"
    const val GLOBAL_QUEST_PROGRESS = "gqpr"
    const val BOUNTY_COMPLETE = "bcmp"
    const val BOUNTY_TASK_COMPLETE = "btcmp"
    const val BOUNTY_TASK_CONDITION_COMPLETE = "btccmp"
    const val BOUNTY_UPDATE = "bup"
    const val RPC = "rpc"
    const val RPC_RESPONSE = "rpcr"
}
