/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;

public final class VirtualFileResourceLoader
implements ResourceLoader {
    private final VirtualFile virtualFile;
    private final Set<String> localPaths;

    public VirtualFileResourceLoader(VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("virtualFile");
        }
        this.virtualFile = virtualFile;
        this.localPaths = this.getLocalPaths();
    }

    public String getRootName() {
        return this.virtualFile.getPathName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassSpec getClassSpec(String fileName) throws IOException {
        VirtualFile child = this.virtualFile.getChild(fileName);
        if (child == null) {
            return null;
        }
        ClassSpec classSpec = new ClassSpec();
        InputStream is = child.openStream();
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            VFSUtils.copyStream((InputStream)is, (OutputStream)os);
            classSpec.setBytes(os.toByteArray());
        }
        finally {
            this.safeClose(is);
        }
        CodeSigner[] codeSigners = child.getCodeSigners();
        classSpec.setCodeSource(new CodeSource(new URL("jar", null, -1, child.getName()), codeSigners));
        return classSpec;
    }

    public PackageSpec getPackageSpec(String name) throws IOException {
        PackageSpec spec = new PackageSpec();
        Manifest manifest = VFSUtils.getManifest((VirtualFile)this.virtualFile);
        if (manifest == null) {
            return spec;
        }
        Attributes mainAttribute = manifest.getAttributes(name);
        Attributes entryAttribute = manifest.getAttributes(name);
        spec.setSpecTitle(VirtualFileResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_TITLE, entryAttribute, mainAttribute));
        spec.setSpecVersion(VirtualFileResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VERSION, entryAttribute, mainAttribute));
        spec.setSpecVendor(VirtualFileResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VENDOR, entryAttribute, mainAttribute));
        spec.setImplTitle(VirtualFileResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_TITLE, entryAttribute, mainAttribute));
        spec.setImplVersion(VirtualFileResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VERSION, entryAttribute, mainAttribute));
        spec.setImplVendor(VirtualFileResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VENDOR, entryAttribute, mainAttribute));
        if (Boolean.parseBoolean(VirtualFileResourceLoader.getDefinedAttribute(Attributes.Name.SEALED, entryAttribute, mainAttribute))) {
            spec.setSealBase(this.virtualFile.toURL());
        }
        return spec;
    }

    private static String getDefinedAttribute(Attributes.Name name, Attributes entryAttribute, Attributes mainAttribute) {
        String value;
        String string = value = entryAttribute == null ? null : entryAttribute.getValue(name);
        return value == null ? (mainAttribute == null ? null : mainAttribute.getValue(name)) : value;
    }

    public Resource getResource(String name) {
        try {
            VirtualFile child = this.virtualFile.getChild(name);
            if (child == null) {
                return null;
            }
            return new VirtualResource(child);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String getLibrary(String name) {
        return null;
    }

    public Collection<String> getPaths() {
        return this.localPaths;
    }

    private Set<String> getLocalPaths() {
        HashSet<String> result = new HashSet<String>();
        try {
            List descendants = this.virtualFile.getChildrenRecursively();
            String rootPath = this.virtualFile.getPathName();
            for (VirtualFile descendant : descendants) {
                int inx;
                if (!descendant.isFile()) continue;
                String entryPath = descendant.getPathName().substring(rootPath.length());
                if (entryPath.startsWith("/")) {
                    entryPath = entryPath.substring(1);
                }
                result.add((inx = entryPath.lastIndexOf("/")) > 0 ? entryPath.substring(0, inx) : "");
            }
        }
        catch (IOException ex) {
            throw FrameworkMessages.MESSAGES.illegalArgumentCannotObtainPaths(ex, this.virtualFile);
        }
        if (result.size() == 0) {
            throw FrameworkMessages.MESSAGES.illegalArgumentCannotObtainPaths(null, this.virtualFile);
        }
        return Collections.unmodifiableSet(result);
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class VirtualResource
    implements Resource {
        VirtualFile child;

        VirtualResource(VirtualFile child) {
            assert (child != null) : "Null child";
            this.child = child;
        }

        public String getName() {
            return this.child.getName();
        }

        public URL getURL() {
            try {
                return this.child.toURL();
            }
            catch (IOException ex) {
                throw FrameworkMessages.MESSAGES.illegalStateCannotObtainURL(this.child);
            }
        }

        public InputStream openStream() throws IOException {
            return this.child.openStream();
        }

        public long getSize() {
            return 0L;
        }
    }
}

