/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.SystemServices;
import org.osgi.framework.BundleContext;

public class SystemServicesPlugin
extends AbstractIntegrationService<SystemServices> {
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();

    public SystemServicesPlugin() {
        super(IntegrationServices.SYSTEM_SERVICES_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<SystemServices> builder) {
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedSystemContext);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext startContext) throws StartException {
        super.start(startContext);
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        ((SystemServices)this.getValue()).registerServices(systemContext);
    }

    @Override
    protected SystemServices createServiceValue(StartContext startContext) throws StartException {
        return new SystemServicesImpl();
    }

    public void stop(StopContext context) {
        ((SystemServices)this.getValue()).unregisterServices();
    }

    static class SystemServicesImpl
    implements SystemServices {
        SystemServicesImpl() {
        }

        @Override
        public void registerServices(BundleContext context) {
        }

        @Override
        public void unregisterServices() {
        }
    }
}

