/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.io.IOException;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.BundleStorageImpl;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.BundleStorage;
import org.jboss.osgi.framework.spi.IntegrationServices;

public class BundleStoragePlugin
extends AbstractIntegrationService<BundleStorage> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final boolean firstInit;

    public BundleStoragePlugin(boolean firstInit) {
        super(IntegrationServices.BUNDLE_STORAGE);
        this.firstInit = firstInit;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<BundleStorage> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public void start(StartContext startContext) throws StartException {
        super.start(startContext);
        try {
            BundleStorage bundleStorage = (BundleStorage)this.getValue();
            BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
            bundleStorage.initialize(bundleManager.getProperties(), this.firstInit);
        }
        catch (IOException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    @Override
    protected BundleStorage createServiceValue(StartContext startContext) throws StartException {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        return new BundleStorageImpl(bundleManager);
    }
}

