/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FrameworkModuleLoader;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.StartLevelSupport;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;

public class AbstractBundleAdaptor
extends AbstractElement
implements XBundle,
LockManager.LockableItem {
    private final AtomicInteger bundleState = new AtomicInteger(4);
    private final LockManager.LockSupport bundleLock = LockManager.Factory.addLockSupport(this);
    private final BundleManager bundleManager;
    private final BundleContext context;
    private final XBundleRevision brev;
    private final Module module;
    private BundleActivator bundleActivator;
    private long lastModified;

    public AbstractBundleAdaptor(BundleContext context, Module module, XBundleRevision brev) {
        if (context == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("context");
        }
        if (module == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("module");
        }
        if (brev == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("brev");
        }
        XBundle sysbundle = (XBundle)context.getBundle();
        this.bundleManager = (BundleManager)sysbundle.adapt(BundleManager.class);
        this.context = context;
        this.module = module;
        this.brev = brev;
        this.lastModified = System.currentTimeMillis();
    }

    public long getBundleId() {
        Long bundleId = (Long)this.brev.getAttachment(Long.class);
        return bundleId != null ? bundleId : -1L;
    }

    public String getLocation() {
        String location = this.module.getIdentifier().getName();
        String slot = this.module.getIdentifier().getSlot();
        if (!slot.equals("main")) {
            location = location + ":" + slot;
        }
        return location;
    }

    public String getSymbolicName() {
        String symbolicName = null;
        List icaps = this.brev.getCapabilities("osgi.identity");
        if (icaps.size() > 0) {
            XIdentityCapability icap = (XIdentityCapability)icaps.get(0);
            symbolicName = icap.getSymbolicName();
        } else {
            symbolicName = this.module.getIdentifier().getName();
        }
        return symbolicName;
    }

    public String getCanonicalName() {
        return this.getSymbolicName() + ":" + this.getVersion();
    }

    public int getState() {
        return this.bundleState.get();
    }

    public Version getVersion() {
        Version version = Version.emptyVersion;
        List icaps = this.brev.getCapabilities("osgi.identity");
        if (icaps.size() > 0) {
            XIdentityCapability icap = (XIdentityCapability)icaps.get(0);
            version = icap.getVersion();
        } else {
            String slot = this.module.getIdentifier().getSlot();
            try {
                version = Version.parseVersion((String)slot);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return version;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.module.getClassLoader().loadClass(name);
    }

    public <T> T adapt(Class<T> type) {
        Module result = null;
        if (type == Module.class) {
            result = this.module;
        } else if (type == BundleRevision.class) {
            result = this.brev;
        }
        return (T)result;
    }

    public void start(int options) throws BundleException {
        LockManager lockManager;
        LockManager.LockContext lockContext;
        block12: {
            block11: {
                lockContext = null;
                lockManager = this.getPluginService(IntegrationServices.LOCK_MANAGER, LockManager.class);
                lockContext = lockManager.lockItems(LockManager.Method.START, this);
                if (this.getState() != 32) break block11;
                lockManager.unlockItems(lockContext);
                return;
            }
            this.setPersistentlyStarted(true);
            if (this.startLevelValidForStart()) break block12;
            if ((options & 1) != 0) {
                throw FrameworkMessages.MESSAGES.cannotStartBundleDueToStartLevel();
            }
            int frameworkState = this.bundleManager.getSystemBundle().getState();
            StartLevelSupport plugin = this.getPluginService(Services.START_LEVEL, StartLevelSupport.class);
            Logger.Level level = plugin.isChangingStartLevel() || frameworkState != 32 ? Logger.Level.DEBUG : Logger.Level.INFO;
            FrameworkLogger.LOGGER.log(level, FrameworkMessages.MESSAGES.bundleStartLevelNotValid(this.getStartLevel(), plugin.getStartLevel(), (Bundle)this));
            lockManager.unlockItems(lockContext);
            return;
        }
        try {
            String activatorName;
            this.bundleState.set(8);
            OSGiMetaData metadata = (OSGiMetaData)this.brev.getAttachment(OSGiMetaData.class);
            String string = activatorName = metadata != null ? metadata.getBundleActivator() : null;
            if (this.bundleActivator == null && activatorName != null) {
                Object result = this.loadClass(activatorName).newInstance();
                if (result instanceof BundleActivator) {
                    this.bundleActivator = (BundleActivator)result;
                } else {
                    throw FrameworkMessages.MESSAGES.invalidBundleActivator(activatorName);
                }
            }
            if (this.bundleActivator != null) {
                this.bundleActivator.start(this.context);
            }
            this.setPersistentlyStarted(true);
            this.bundleState.set(32);
            FrameworkLogger.LOGGER.infoBundleStarted((Bundle)this);
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable th) {
            try {
                this.bundleState.set(4);
                throw FrameworkMessages.MESSAGES.cannotStartBundle(th, (Bundle)this);
            }
            catch (Throwable throwable) {
                lockManager.unlockItems(lockContext);
                throw throwable;
            }
        }
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void stop(int options) throws BundleException {
        LockManager lockManager;
        LockManager.LockContext lockContext;
        block7: {
            lockContext = null;
            lockManager = this.getPluginService(IntegrationServices.LOCK_MANAGER, LockManager.class);
            lockContext = lockManager.lockItems(LockManager.Method.STOP, this);
            if (this.getState() == 32) break block7;
            lockManager.unlockItems(lockContext);
            return;
        }
        try {
            if ((options & 1) == 0) {
                this.setPersistentlyStarted(false);
            }
            if (this.bundleActivator != null) {
                this.bundleActivator.stop(this.context);
            }
            this.bundleState.set(4);
            FrameworkLogger.LOGGER.infoBundleStopped((Bundle)this);
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable th) {
            try {
                throw FrameworkMessages.MESSAGES.cannotStopBundle(th, (Bundle)this);
            }
            catch (Throwable throwable) {
                lockManager.unlockItems(lockContext);
                throw throwable;
            }
        }
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void update(InputStream input) throws BundleException {
        throw FrameworkMessages.MESSAGES.unsupportedBundleOpertaion((Bundle)this);
    }

    public void update() throws BundleException {
        throw FrameworkMessages.MESSAGES.unsupportedBundleOpertaion((Bundle)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() throws BundleException {
        LockManager.LockContext lockContext = null;
        LockManager lockManager = this.getPluginService(IntegrationServices.LOCK_MANAGER, LockManager.class);
        try {
            FrameworkWiringLock wireLock = lockManager.getItemForType(FrameworkWiringLock.class);
            lockContext = lockManager.lockItems(LockManager.Method.RESOLVE, wireLock, this);
            XEnvironment env = this.getPluginService(Services.ENVIRONMENT, XEnvironment.class);
            env.uninstallResources(new XResource[]{this.getBundleRevision()});
            FrameworkModuleLoader provider = this.getPluginService(IntegrationServices.FRAMEWORK_MODULE_LOADER, FrameworkModuleLoader.class);
            provider.removeModule(this.brev);
            this.bundleState.set(1);
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable throwable) {
            lockManager.unlockItems(lockContext);
            throw throwable;
        }
    }

    public Dictionary getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary getHeaders(String locale) {
        return new Hashtable();
    }

    public ServiceReference[] getRegisteredServices() {
        return null;
    }

    public ServiceReference[] getServicesInUse() {
        return null;
    }

    public boolean hasPermission(Object permission) {
        return false;
    }

    public URL getResource(String name) {
        return this.getBundleRevision().getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        return this.getBundleRevision().getResources(name);
    }

    public Enumeration getEntryPaths(String path) {
        return this.getBundleRevision().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        return this.getBundleRevision().getEntry(path);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        return this.getBundleRevision().findEntries(path, filePattern, recurse);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public Map getSignerCertificates(int signersType) {
        return Collections.emptyMap();
    }

    public boolean isResolved() {
        return true;
    }

    public boolean isFragment() {
        return this.getBundleRevision().isFragment();
    }

    public XBundleRevision getBundleRevision() {
        return this.brev;
    }

    public List<XBundleRevision> getAllBundleRevisions() {
        return Collections.singletonList(this.brev);
    }

    private int getStartLevel() {
        StartLevelSupport startLevel = this.getPluginService(Services.START_LEVEL, StartLevelSupport.class);
        return startLevel.getBundleStartLevel((Bundle)this);
    }

    private void setPersistentlyStarted(boolean started) {
        StartLevelSupport startLevel = this.getPluginService(Services.START_LEVEL, StartLevelSupport.class);
        startLevel.setBundlePersistentlyStarted(this, started);
    }

    private boolean startLevelValidForStart() {
        StartLevelSupport startLevel = this.getPluginService(Services.START_LEVEL, StartLevelSupport.class);
        return this.getStartLevel() <= startLevel.getStartLevel();
    }

    @Override
    public LockManager.LockSupport getLockSupport() {
        return this.bundleLock;
    }

    private <T> T getPluginService(ServiceName serviceName, Class<T> pluginType) {
        ServiceContainer serviceContainer = this.bundleManager.getServiceContainer();
        ServiceController service = serviceContainer.getRequiredService(serviceName);
        return (T)service.getValue();
    }

    public int hashCode() {
        return (int)this.getBundleId() * 51;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XBundle)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        XBundle other = (XBundle)obj;
        return this.getBundleId() == other.getBundleId();
    }

    public String toString() {
        return this.getCanonicalName();
    }
}

