/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleStateRevision;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.spi.BundleStorage;
import org.jboss.osgi.framework.spi.DeploymentProvider;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.spi.ConstantsHelper;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;

abstract class UserBundleState<R extends UserBundleRevision>
extends AbstractBundleState<R> {
    private final List<R> revisions = new CopyOnWriteArrayList<R>();
    private final ServiceTarget serviceTarget;
    private final ServiceName serviceName;
    private Dictionary<String, String> headersOnUninstall;

    UserBundleState(FrameworkState frameworkState, R brev, ServiceName serviceName, ServiceTarget serviceTarget) {
        super(frameworkState, brev, ((BundleStateRevision)((Object)brev)).getStorageState().getBundleId());
        this.serviceTarget = serviceTarget;
        this.serviceName = serviceName;
        this.addBundleRevision(brev);
    }

    static UserBundleState<?> assertBundleState(Bundle bundle2) {
        bundle2 = AbstractBundleState.assertBundleState(bundle2);
        assert (bundle2 instanceof UserBundleState) : "Not an UserBundleState: " + bundle2;
        return (UserBundleState)bundle2;
    }

    public String getLocation() {
        return ((UserBundleRevision)this.getBundleRevision()).getLocation();
    }

    Deployment getDeployment() {
        return ((UserBundleRevision)this.getBundleRevision()).getDeployment();
    }

    @Override
    boolean isSingleton() {
        return this.getOSGiMetaData().isSingleton();
    }

    ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    abstract void initLazyActivation();

    abstract R createUpdateRevision(Deployment var1, OSGiMetaData var2, StorageState var3) throws BundleException;

    @Override
    public <T> T adapt(Class<T> type) {
        Object result = super.adapt(type);
        if (result == null && type.isAssignableFrom(Deployment.class)) {
            result = this.getDeployment();
        }
        return result;
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        if (this.headersOnUninstall != null) {
            return this.headersOnUninstall;
        }
        return super.getHeaders(locale);
    }

    @Override
    ServiceName getServiceName(int state) {
        if (state == 0) {
            return this.serviceName;
        }
        if (state == 2 || state == 4 || state == 32) {
            return this.serviceName.append(new String[]{ConstantsHelper.bundleState((int)state)});
        }
        return null;
    }

    @Override
    void addBundleRevision(R rev) {
        super.addBundleRevision(rev);
        this.revisions.add(0, rev);
    }

    @Override
    public R getBundleRevision() {
        return (R)((Object)((UserBundleRevision)((Object)super.getBundleRevision())));
    }

    public List<XBundleRevision> getAllBundleRevisions() {
        ArrayList<R> result = new ArrayList<R>(this.revisions);
        return Collections.unmodifiableList(result);
    }

    void clearOldRevisions() {
        BundleStateRevision rev = this.getBundleRevision();
        this.revisions.clear();
        this.revisions.add((R)((Object)rev));
    }

    @Override
    R getBundleRevisionById(int revisionId) {
        for (UserBundleRevision rev : this.revisions) {
            if (rev.getRevisionId() != revisionId) continue;
            return (R)((Object)rev);
        }
        return null;
    }

    boolean hasActiveWires() {
        BundleWiring wiring = this.getBundleRevision().getWiring();
        return wiring != null ? wiring.isInUse() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateInternal(InputStream input) throws BundleException {
        LockManager.LockContext lockContext = null;
        LockManager lockManager = this.getFrameworkState().getLockManager();
        try {
            lockContext = lockManager.lockItems(LockManager.Method.UPDATE, this);
            this.updateInternalNow(input);
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable throwable) {
            lockManager.unlockItems(lockContext);
            throw throwable;
        }
    }

    private void updateInternalNow(InputStream input) throws BundleException {
        int state;
        boolean restart = false;
        if (!(this.isFragment() || (state = this.getState()) != 32 && state != 8 && state != 16)) {
            this.stopInternal(1);
            if (state != 16) {
                restart = true;
            }
        }
        this.removeResolvedService();
        this.changeState(2, 64);
        try {
            this.createUpdateRevision(input);
        }
        catch (BundleException ex) {
            if (restart) {
                this.startInternal(1);
            }
            throw ex;
        }
        catch (Exception ex) {
            BundleException be = new BundleException("Problem updating bundle");
            be.initCause((Throwable)ex);
            if (restart) {
                this.startInternal(1);
            }
            throw be;
        }
        FrameworkEvents eventsPlugin = this.getFrameworkState().getFrameworkEvents();
        eventsPlugin.fireBundleEvent(this, 8);
        if (restart) {
            try {
                this.startInternal(1);
            }
            catch (BundleException e) {
                eventsPlugin.fireFrameworkEvent((Bundle)this, 2, e);
            }
        }
        FrameworkLogger.LOGGER.infoBundleUpdated((Bundle)this);
        this.updateLastModified();
    }

    private void createUpdateRevision(InputStream input) throws Exception {
        VirtualFile rootFile = null;
        if (input == null) {
            String updateLocation = this.getOSGiMetaData().getHeader("Bundle-UpdateLocation");
            if (updateLocation != null) {
                URL updateURL = new URL(updateLocation);
                rootFile = AbstractVFS.toVirtualFile((URL)updateURL);
            } else {
                rootFile = this.getDeployment().getRoot();
            }
        }
        if (rootFile == null && input != null) {
            rootFile = AbstractVFS.toVirtualFile((InputStream)input);
        }
        BundleStorage storagePlugin = this.getFrameworkState().getBundleStorage();
        StorageState storageState = this.createStorageState(storagePlugin, this.getLocation(), rootFile);
        try {
            DeploymentProvider deploymentPlugin = this.getFrameworkState().getDeploymentProvider();
            Deployment dep = deploymentPlugin.createDeployment(storageState);
            OSGiMetaData metadata = deploymentPlugin.createOSGiMetaData(dep);
            dep.addAttachment(OSGiMetaData.class, (Object)metadata);
            dep.addAttachment(Bundle.class, (Object)this);
            R updateRevision = this.createUpdateRevision(dep, metadata, storageState);
            this.addBundleRevision(updateRevision);
            XEnvironment env = this.getFrameworkState().getEnvironment();
            env.installResources(new XResource[]{updateRevision});
        }
        catch (BundleException ex) {
            storagePlugin.deleteStorageState(storageState);
            throw ex;
        }
        catch (RuntimeException ex) {
            storagePlugin.deleteStorageState(storageState);
            throw ex;
        }
    }

    private StorageState createStorageState(BundleStorage storagePlugin, String location, VirtualFile rootFile) throws BundleException {
        StorageState storageState;
        try {
            int startlevel = this.getCoreServices().getStartLevelSupport().getInitialBundleStartLevel();
            storageState = storagePlugin.createStorageState(this.getBundleId(), location, startlevel, rootFile);
        }
        catch (IOException ex) {
            throw FrameworkMessages.MESSAGES.cannotSetupStorage(ex, rootFile);
        }
        return storageState;
    }

    void refresh() throws BundleException {
        this.assertNotUninstalled();
        if (!this.isResolved()) {
            throw FrameworkMessages.MESSAGES.illegalStateRefreshUnresolvedBundle((Bundle)this);
        }
        ModuleManager moduleManager = this.getFrameworkState().getModuleManager();
        BundleStateRevision currentRev = this.getBundleRevision();
        for (XBundleRevision brev : this.getAllBundleRevisions()) {
            UserBundleRevision userRev = UserBundleRevision.assertBundleRevision((BundleRevision)brev);
            XEnvironment env = this.getFrameworkState().getEnvironment();
            if (currentRev != brev) {
                env.uninstallResources(new XResource[]{brev});
                userRev.close();
            }
            if (!(brev instanceof HostBundleRevision)) continue;
            HostBundleRevision hostRev = (HostBundleRevision)brev;
            for (FragmentBundleRevision fragRev : hostRev.getAttachedFragments()) {
                if (fragRev == fragRev.getBundle().getBundleRevision()) continue;
                env.uninstallResources(new XResource[]{fragRev});
                fragRev.close();
            }
            ModuleIdentifier identifier = brev.getModuleIdentifier();
            moduleManager.removeModule(brev, identifier);
        }
        this.removeResolvedService();
        this.clearOldRevisions();
        FrameworkEvents eventsPlugin = this.getFrameworkState().getFrameworkEvents();
        eventsPlugin.fireBundleEvent(this, 64);
        currentRev.refreshRevision();
        this.changeState(2);
    }

    void removeResolvedService() {
        ServiceName resolvedName = this.getServiceName(4);
        this.getBundleManagerPlugin().setServiceMode(resolvedName, ServiceController.Mode.REMOVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void uninstallInternal(int options) {
        this.headersOnUninstall = this.getHeaders(null);
        LockManager.LockContext lockContext = null;
        LockManager lockManager = this.getFrameworkState().getLockManager();
        try {
            FrameworkWiringLock wireLock = lockManager.getItemForType(FrameworkWiringLock.class);
            lockContext = lockManager.lockItems(LockManager.Method.UNINSTALL, wireLock, this);
            this.uninstallInternalNow(options);
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable throwable) {
            lockManager.unlockItems(lockContext);
            throw throwable;
        }
        FrameworkLogger.LOGGER.debugf("Remove service for: %s", this);
        this.getBundleManagerPlugin().setServiceMode(this.getServiceName(2), ServiceController.Mode.REMOVE);
        this.fireBundleEvent(16);
    }

    void uninstallInternalNow(int options) {
        int state = this.getState();
        if (state == 1) {
            return;
        }
        if (!(this.isFragment() || state != 32 && state != 8 && state != 16)) {
            try {
                this.stopInternal(options);
            }
            catch (Exception ex) {
                this.getBundleManagerPlugin().fireFrameworkError((Bundle)this, "stopping bundle: " + this, ex);
            }
        }
        this.changeState(1, 0);
        boolean hasActiveWires = this.hasActiveWires();
        if (!hasActiveWires) {
            this.getBundleManagerPlugin().removeBundle(this, options);
        }
        Set<XBundle> uninstalled = this.getBundleManager().getBundles(1);
        for (XBundle auxState : uninstalled) {
            UserBundleState<?> auxUser = UserBundleState.assertBundleState((Bundle)auxState);
            if (auxUser.hasActiveWires()) continue;
            this.getBundleManagerPlugin().removeBundle(auxUser, options);
        }
        FrameworkLogger.LOGGER.infoBundleUninstalled((Bundle)this);
    }
}

