/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.StartLevelSupport;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public final class StartLevelImpl
implements StartLevelSupport {
    private final BundleManagerPlugin bundleManager;
    private final FrameworkEvents events;
    private final ExecutorService executorService;
    private final AtomicBoolean immediateExecution;
    private AtomicInteger initialBundleStartLevel = new AtomicInteger(1);
    private AtomicInteger startLevel = new AtomicInteger(0);
    private AtomicBoolean changingStartLevel = new AtomicBoolean();

    public StartLevelImpl(BundleManager bundleManager, FrameworkEvents frameworkEvents, ExecutorService executorService, AtomicBoolean immediateExecution) {
        this.bundleManager = BundleManagerPlugin.assertBundleManagerPlugin(bundleManager);
        this.events = frameworkEvents;
        this.executorService = executorService;
        this.immediateExecution = immediateExecution;
    }

    @Override
    public void enableImmediateExecution(boolean enable) {
        this.immediateExecution.set(enable);
    }

    @Override
    public boolean isChangingStartLevel() {
        return this.changingStartLevel.get();
    }

    public int getStartLevel() {
        return this.startLevel.get();
    }

    public synchronized void setStartLevel(final int level) {
        SystemBundleState sysbundle = this.bundleManager.getSystemBundle();
        if (level > this.getStartLevel()) {
            Runnable runner = new Runnable((Bundle)sysbundle){
                final /* synthetic */ Bundle val$sysbundle;
                {
                    this.val$sysbundle = bundle2;
                }

                @Override
                public void run() {
                    FrameworkLogger.LOGGER.infoIncreasingStartLevel(StartLevelImpl.this.getStartLevel(), level);
                    StartLevelImpl.this.increaseStartLevel(level);
                    StartLevelImpl.this.events.fireFrameworkEvent(this.val$sysbundle, 8, null);
                }
            };
            this.executeTask(runner);
        } else if (level < this.getStartLevel()) {
            Runnable runner = new Runnable((Bundle)sysbundle){
                final /* synthetic */ Bundle val$sysbundle;
                {
                    this.val$sysbundle = bundle2;
                }

                @Override
                public void run() {
                    FrameworkLogger.LOGGER.infoDecreasingStartLevel(StartLevelImpl.this.getStartLevel(), level);
                    StartLevelImpl.this.decreaseStartLevel(level);
                    StartLevelImpl.this.events.fireFrameworkEvent(this.val$sysbundle, 8, null);
                }
            };
            this.executeTask(runner);
        }
    }

    public int getBundleStartLevel(Bundle bundle2) {
        if (bundle2 == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        return this.getBundleStartLevelState(bundle2).getLevel();
    }

    public void setBundleStartLevel(Bundle bundle2, int level) {
        if (bundle2 == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        if (bundle2.getBundleId() == 0L) {
            throw FrameworkMessages.MESSAGES.illegalArgumentStartLevelOnSystemBundles();
        }
        final XBundle hostBundle = (XBundle)bundle2;
        this.getBundleStartLevelState(bundle2).setLevel(level);
        if (level <= this.getStartLevel()) {
            if ((bundle2.getState() & 0x28) > 0) {
                return;
            }
            if (this.isBundlePersistentlyStarted(bundle2)) {
                FrameworkLogger.LOGGER.infoStartingBundleDueToStartLevel((Bundle)hostBundle);
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int opts = 1;
                            if (StartLevelImpl.this.isBundleActivationPolicyUsed((Bundle)hostBundle)) {
                                opts |= 2;
                            }
                            hostBundle.start(opts);
                        }
                        catch (BundleException e) {
                            StartLevelImpl.this.events.fireFrameworkEvent((Bundle)hostBundle, 2, e);
                        }
                    }
                };
                this.executeTask(runner);
            }
        } else {
            if ((bundle2.getState() & 0x28) == 0) {
                return;
            }
            FrameworkLogger.LOGGER.infoStoppingBundleDueToStartLevel((Bundle)hostBundle);
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        hostBundle.stop(1);
                    }
                    catch (BundleException e) {
                        StartLevelImpl.this.events.fireFrameworkEvent((Bundle)hostBundle, 2, e);
                    }
                }
            };
            this.executeTask(runner);
        }
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel.get();
    }

    public void setInitialBundleStartLevel(int startlevel) {
        this.initialBundleStartLevel.set(startlevel);
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle2) {
        if (bundle2 == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        return this.getBundleStartLevelState(bundle2).isStarted();
    }

    @Override
    public void setBundlePersistentlyStarted(XBundle bundle2, boolean started) {
        if (bundle2 == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundle");
        }
        this.getBundleStartLevelState((Bundle)bundle2).setStarted(started);
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle2) {
        boolean result = false;
        if (bundle2 instanceof AbstractBundleState) {
            AbstractBundleState<?> bundleState = AbstractBundleState.assertBundleState(bundle2);
            StorageState storageState = bundleState.getStorageState();
            result = storageState.isBundleActivationPolicyUsed();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void increaseStartLevel(int level) {
        try {
            this.changingStartLevel.set(true);
            ArrayList<XBundle> bundles = new ArrayList<XBundle>(this.bundleManager.getBundles());
            Comparator<XBundle> comparator = new Comparator<XBundle>(){

                @Override
                public int compare(XBundle b1, XBundle b2) {
                    return (int)(b1.getBundleId() - b2.getBundleId());
                }
            };
            Collections.sort(bundles, comparator);
            while (this.startLevel.get() < level) {
                this.startLevel.incrementAndGet();
                FrameworkLogger.LOGGER.infoStartingBundlesForStartLevel(this.startLevel.get());
                for (XBundle bundle2 : bundles) {
                    BundleStartLevelState state;
                    if (bundle2.getBundleId() == 0L || bundle2.isFragment() || (state = this.getBundleStartLevelState((Bundle)bundle2)).getLevel() != this.startLevel.get() || !state.isStarted()) continue;
                    try {
                        int opts = 1;
                        if (this.isBundleActivationPolicyUsed((Bundle)bundle2)) {
                            opts |= 2;
                        }
                        bundle2.start(opts);
                    }
                    catch (Throwable e) {
                        this.events.fireFrameworkEvent((Bundle)bundle2, 2, e);
                    }
                }
            }
        }
        finally {
            this.changingStartLevel.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void decreaseStartLevel(int level) {
        try {
            this.changingStartLevel.set(true);
            while (this.startLevel.get() > level) {
                FrameworkLogger.LOGGER.infoStoppingBundlesForStartLevel(level);
                ArrayList<XBundle> bundles = new ArrayList<XBundle>(this.bundleManager.getBundles());
                Comparator<XBundle> comparator = new Comparator<XBundle>(){

                    @Override
                    public int compare(XBundle b1, XBundle b2) {
                        return (int)(b1.getBundleId() - b2.getBundleId());
                    }
                };
                Collections.sort(bundles, comparator);
                Collections.reverse(bundles);
                for (XBundle bundle2 : bundles) {
                    BundleStartLevelState state;
                    if (bundle2.getBundleId() == 0L || bundle2.isFragment() || (state = this.getBundleStartLevelState((Bundle)bundle2)).getLevel() != this.startLevel.get()) continue;
                    try {
                        bundle2.stop(1);
                    }
                    catch (Throwable e) {
                        this.events.fireFrameworkEvent((Bundle)bundle2, 2, e);
                    }
                }
                this.startLevel.decrementAndGet();
            }
        }
        finally {
            this.changingStartLevel.set(false);
        }
    }

    private BundleStartLevelState getBundleStartLevelState(Bundle bundle2) {
        XBundle bundleState;
        if (bundle2 instanceof Framework) {
            return new BundleStartLevelState(bundle2);
        }
        BundleStartLevelState state = null;
        if (bundle2 instanceof XBundle && (state = (BundleStartLevelState)(bundleState = (XBundle)bundle2).getAttachment(BundleStartLevelState.class)) == null) {
            state = new BundleStartLevelState(bundle2);
            bundleState.addAttachment(BundleStartLevelState.class, (Object)state);
        }
        return state;
    }

    private void executeTask(Runnable runner) {
        if (!this.executorService.isShutdown()) {
            if (this.immediateExecution.get()) {
                runner.run();
            } else {
                this.executorService.execute(runner);
            }
        }
    }

    class BundleStartLevelState {
        final Bundle bundle;
        boolean started;
        int level;

        public BundleStartLevelState(Bundle bundle2) {
            this.bundle = bundle2;
            if (bundle2.getBundleId() > 0L) {
                XBundle bundleState = (XBundle)bundle2;
                int n = this.level = !bundleState.isFragment() ? StartLevelImpl.this.getInitialBundleStartLevel() : 0;
                if (bundle2 instanceof HostBundleState) {
                    XBundleRevision brev = bundleState.getBundleRevision();
                    StorageState storageState = ((HostBundleRevision)brev).getStorageState();
                    this.level = storageState.getStartLevel();
                }
            }
        }

        int getLevel() {
            return this.level;
        }

        void setLevel(int level) {
            this.level = level;
            if (this.bundle instanceof HostBundleState) {
                XBundleRevision brev = ((XBundle)this.bundle).getBundleRevision();
                StorageState storageState = ((HostBundleRevision)brev).getStorageState();
                storageState.setStartLevel(level);
            }
        }

        boolean isStarted() {
            return this.started;
        }

        void setStarted(boolean started) {
            this.started = started;
            if (this.bundle instanceof HostBundleState) {
                XBundleRevision brev = ((XBundle)this.bundle).getBundleRevision();
                StorageState storageState = ((HostBundleRevision)brev).getStorageState();
                storageState.setPersistentlyStarted(started);
            }
        }
    }
}

