/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Vector;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.EntriesProvider;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

final class RevisionContent
implements EntriesProvider {
    private final UserBundleRevision userRev;
    private final VirtualFile virtualFile;
    private final String identity;
    private final int contentId;
    private boolean closedMarker;

    RevisionContent(UserBundleRevision brev, OSGiMetaData metadata, long bundleId, int contentId, VirtualFile rootFile) {
        assert (brev != null) : "Null userRev";
        assert (rootFile != null) : "Null rootFile";
        this.userRev = brev;
        this.virtualFile = rootFile;
        this.contentId = contentId;
        String symbolicName = metadata.getBundleSymbolicName();
        if (symbolicName != null) {
            symbolicName = symbolicName.replace(':', '.');
            symbolicName = symbolicName.replace('-', '.');
        } else {
            symbolicName = "anonymous";
        }
        int revisionId = brev.getRevisionId();
        this.identity = symbolicName + "-" + bundleId + "-" + revisionId + "-" + contentId;
        FrameworkLogger.LOGGER.tracef("new RevisionContent: %s", this.identity);
    }

    static RevisionContent findRevisionContent(BundleManagerPlugin bundleManager, String identity) {
        assert (identity != null) : "Null identity";
        String[] parts = identity.split("-");
        assert (parts.length == 4) : "Invalid identity: " + identity;
        long bundleId = Long.parseLong(parts[1]);
        int revisionId = Integer.parseInt(parts[2]);
        int contentId = Integer.parseInt(parts[3]);
        XBundle bundle2 = bundleManager.getBundleById(bundleId);
        if (bundle2 == null) {
            return null;
        }
        AbstractBundleState<?> bundleState = AbstractBundleState.assertBundleState((Bundle)bundle2);
        Object bundleRev = bundleState.getBundleRevisionById(revisionId);
        if (bundleRev == null) {
            return null;
        }
        UserBundleRevision userRev = (UserBundleRevision)((Object)bundleRev);
        RevisionContent revContent = userRev.getContentById(contentId);
        FrameworkLogger.LOGGER.tracef("findRevisionContent: %s => %s", identity, revContent);
        return revContent;
    }

    int getContentId() {
        return this.contentId;
    }

    String getIdentity() {
        return this.identity;
    }

    UserBundleRevision getRevision() {
        return this.userRev;
    }

    VirtualFile getVirtualFile() {
        this.assertNotClosed();
        return this.virtualFile;
    }

    @Override
    public URL getEntry(String path) {
        this.assertNotClosed();
        try {
            VirtualFile child = this.virtualFile.getChild(path);
            return child != null ? this.getBundleURL(child) : null;
        }
        catch (IOException ex) {
            FrameworkLogger.LOGGER.errorCannotGetEntry(ex, path, (BundleRevision)this.userRev);
            return null;
        }
    }

    @Override
    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        this.assertNotClosed();
        try {
            Enumeration urls = this.virtualFile.findEntries(path, pattern, recurse);
            return this.getBundleURLs(urls);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        this.assertNotClosed();
        try {
            Enumeration entryPaths = this.virtualFile.getEntryPaths(path);
            if (entryPaths != null && entryPaths.hasMoreElements()) {
                return entryPaths;
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    void close() {
        VFSUtils.safeClose((Closeable)this.virtualFile);
        this.closedMarker = true;
    }

    private void assertNotClosed() {
        if (this.closedMarker) {
            throw FrameworkMessages.MESSAGES.illegalStateRevisionContentClosed((BundleRevision)this.userRev, this.contentId);
        }
    }

    private Enumeration<URL> getBundleURLs(Enumeration<URL> urls) throws IOException {
        if (urls == null) {
            return null;
        }
        if (!urls.hasMoreElements()) {
            return null;
        }
        Vector<URL> result = new Vector<URL>();
        while (urls.hasMoreElements()) {
            VirtualFile child = AbstractVFS.toVirtualFile((URL)urls.nextElement());
            result.add(this.getBundleURL(child));
        }
        return result.elements();
    }

    URL getBundleURL(final VirtualFile child) throws IOException {
        final String orgPath = child.getPathName();
        URLStreamHandler streamHandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL url) throws IOException {
                String path = url.getPath();
                VirtualFile real = orgPath.equals(path) ? child : RevisionContent.this.virtualFile.getChild(path);
                return real.getStreamURL().openConnection();
            }
        };
        String rootPath = this.virtualFile.getPathName();
        String pathName = child.getPathName().substring(rootPath.length());
        StringBuilder path = new StringBuilder(pathName.length() + 2);
        if (!pathName.startsWith("/")) {
            path.append('/');
        }
        path.append(pathName);
        if (child.isDirectory() && path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        return new URL("bundle", this.identity, -1, path.toString(), streamHandler);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RevisionContent)) {
            return false;
        }
        RevisionContent other = (RevisionContent)obj;
        return this.identity.equals(other.identity);
    }

    public String toString() {
        return "[id=" + this.identity + ",vfile=" + this.virtualFile + "]";
    }
}

