/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.filter.ClassFilter;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.internal.FallbackLoader;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleClassLoader;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.NativeCodeImpl;
import org.jboss.osgi.framework.internal.NativeResourceLoader;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.RevisionContentResourceLoader;
import org.jboss.osgi.framework.spi.FrameworkModuleLoader;
import org.jboss.osgi.framework.spi.FrameworkModuleProvider;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.SystemPaths;
import org.jboss.osgi.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.metadata.NativeLibrary;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceRequirement;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.resource.Capability;

public final class ModuleManagerImpl
implements ModuleManager {
    private final XEnvironment environment;
    private final SystemPaths systemPaths;
    private final FrameworkModuleLoader moduleLoader;
    private final FrameworkModuleProvider moduleProvider;

    public ModuleManagerImpl(XEnvironment env, SystemPaths syspaths, FrameworkModuleProvider moduleProvider, FrameworkModuleLoader moduleLoader) {
        this.environment = env;
        this.systemPaths = syspaths;
        this.moduleProvider = moduleProvider;
        this.moduleLoader = moduleLoader;
    }

    @Override
    public Module getFrameworkModule() {
        return this.moduleProvider.getFrameworkModule();
    }

    @Override
    public ModuleIdentifier getModuleIdentifier(XBundleRevision brev) {
        assert (brev != null) : "Null resource";
        assert (!brev.isFragment()) : "A fragment is not a module";
        ModuleIdentifier identifier = (ModuleIdentifier)brev.getAttachment(ModuleIdentifier.class);
        if (identifier != null) {
            return identifier;
        }
        XIdentityCapability icap = brev.getIdentityCapability();
        Module module = (Module)brev.getAttachment(Module.class);
        identifier = module != null ? module.getIdentifier() : ("system.bundle".equals(icap.getSymbolicName()) ? this.getFrameworkModule().getIdentifier() : this.moduleLoader.getModuleIdentifier(brev));
        return identifier;
    }

    @Override
    public Module getModule(ModuleIdentifier identifier) {
        Module frameworkModule = this.getFrameworkModule();
        if (frameworkModule.getIdentifier().equals(identifier)) {
            return frameworkModule;
        }
        try {
            return this.moduleLoader.getModuleLoader().loadModule(identifier);
        }
        catch (ModuleLoadException ex) {
            return null;
        }
    }

    @Override
    public XBundle getBundleState(Class<?> clazz) {
        assert (clazz != null) : "Null clazz";
        XBundle result = null;
        ClassLoader loader = clazz.getClassLoader();
        if (loader instanceof BundleReference) {
            BundleReference bundleRef = (BundleReference)loader;
            result = (XBundle)bundleRef.getBundle();
        } else if (loader instanceof ModuleClassLoader) {
            Module module = ((ModuleClassLoader)loader).getModule();
            XBundleRevision brev = this.getBundleRevision(module);
            XBundle xBundle = result = brev != null ? brev.getBundle() : null;
        }
        if (result == null) {
            FrameworkLogger.LOGGER.debugf("Cannot obtain bundle for: %s", clazz.getName());
        }
        return result;
    }

    private XBundleRevision getBundleRevision(Module module) {
        XBundleRevision result = null;
        for (XResource res : this.environment.getResources(XEnvironment.ALL_IDENTITY_TYPES)) {
            Module resmod = (Module)res.getAttachment(Module.class);
            if (module != resmod) continue;
            result = (XBundleRevision)res;
            break;
        }
        return result;
    }

    @Override
    public ModuleIdentifier addModule(XBundleRevision brev, List<BundleWire> wires) {
        ModuleIdentifier identifier;
        assert (brev != null) : "Null res";
        assert (wires != null) : "Null wires";
        assert (!brev.isFragment()) : "Fragments cannot be added: " + brev;
        Module module = (Module)brev.getAttachment(Module.class);
        if (module != null) {
            ModuleIdentifier identifier2 = module.getIdentifier();
            FrameworkModuleLoader moduleLoaderPlugin = this.moduleLoader;
            moduleLoaderPlugin.addModule(brev, module);
            return identifier2;
        }
        XIdentityCapability icap = brev.getIdentityCapability();
        if ("system.bundle".equals(icap.getSymbolicName())) {
            identifier = this.getFrameworkModule().getIdentifier();
        } else {
            HostBundleRevision hostRev = HostBundleRevision.assertHostRevision((BundleRevision)brev);
            identifier = this.createHostModule(hostRev, wires);
        }
        return identifier;
    }

    private ModuleIdentifier createHostModule(final HostBundleRevision hostRev, List<BundleWire> wires) {
        HostBundleState hostBundle = hostRev.getBundleState();
        List<RevisionContent> contentRoots = hostRev.getClassPathContent();
        ModuleIdentifier identifier = this.getModuleIdentifier((XBundleRevision)hostRev);
        final ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)identifier);
        final LinkedHashMap<ModuleIdentifier, DependencySpec> moduleDependencies = new LinkedHashMap<ModuleIdentifier, DependencySpec>();
        Set<String> bootPaths = this.systemPaths.getBootDelegationPaths();
        PathFilter bootFilter = this.systemPaths.getBootDelegationFilter();
        PathFilter acceptAll = PathFilters.acceptAll();
        specBuilder.addDependency(DependencySpec.createSystemDependencySpec((PathFilter)bootFilter, (PathFilter)acceptAll, bootPaths));
        LinkedHashMap<BundleRevision, ModuleDependencyHolder> specHolderMap = new LinkedHashMap<BundleRevision, ModuleDependencyHolder>();
        this.processModuleWireList(wires, specHolderMap);
        HashSet allPaths = new HashSet();
        for (ModuleDependencyHolder holder : specHolderMap.values()) {
            moduleDependencies.put(holder.getIdentifier(), holder.create());
        }
        for (DependencySpec dep : moduleDependencies.values()) {
            specBuilder.addDependency(dep);
        }
        for (RevisionContent revContent : contentRoots) {
            RevisionContentResourceLoader resLoader = new RevisionContentResourceLoader(revContent);
            specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resLoader));
            allPaths.addAll(resLoader.getPaths());
        }
        Set<FragmentBundleRevision> fragRevs = hostRev.getAttachedFragments();
        for (FragmentBundleRevision fragRev : fragRevs) {
            for (RevisionContent revContent : fragRev.getClassPathContent()) {
                RevisionContentResourceLoader resLoader = new RevisionContentResourceLoader(revContent);
                specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)resLoader));
                allPaths.addAll(resLoader.getPaths());
            }
        }
        HashSet<String> importedPaths = new HashSet<String>();
        for (ModuleDependencyHolder holder : specHolderMap.values()) {
            Set<String> paths = holder.getImportPaths();
            if (paths == null) continue;
            importedPaths.addAll(paths);
        }
        PathFilter importFilter = acceptAll;
        PathFilter exportFilter = acceptAll;
        if (!importedPaths.isEmpty()) {
            importFilter = PathFilters.not((PathFilter)PathFilters.in(importedPaths));
        }
        PathFilter resImportFilter = PathFilters.acceptAll();
        PathFilter resExportFilter = PathFilters.acceptAll();
        ClassFilter classImportFilter = new ClassFilter(){

            public boolean accept(String className) {
                return true;
            }
        };
        final PathFilter cefPath = this.getExportClassFilter((XResource)hostRev);
        ClassFilter classExportFilter = new ClassFilter(){

            public boolean accept(String className) {
                return cefPath.accept(className);
            }
        };
        FrameworkLogger.LOGGER.tracef("createLocalDependencySpec: [if=%s,ef=%s,rif=%s,ref=%s,cf=%s]", new Object[]{importFilter, exportFilter, resImportFilter, resExportFilter, cefPath});
        DependencySpec localDep = DependencySpec.createLocalDependencySpec((PathFilter)importFilter, (PathFilter)exportFilter, (PathFilter)resImportFilter, (PathFilter)resExportFilter, (ClassFilter)classImportFilter, (ClassFilter)classExportFilter);
        specBuilder.addDependency(localDep);
        this.addNativeResourceLoader(hostRev, specBuilder);
        PathFilter lazyActivationFilter = this.getLazyPackagesFilter(hostBundle);
        specBuilder.setModuleClassLoaderFactory((ModuleClassLoaderFactory)new HostBundleClassLoader.Factory(hostBundle, lazyActivationFilter));
        specBuilder.setFallbackLoader((LocalLoader)new FallbackLoader(hostRev, importedPaths));
        FrameworkModuleLoader.ModuleSpecBuilderContext context = new FrameworkModuleLoader.ModuleSpecBuilderContext(){

            @Override
            public XBundleRevision getBundleRevision() {
                return hostRev;
            }

            @Override
            public ModuleSpec.Builder getModuleSpecBuilder() {
                return specBuilder;
            }

            @Override
            public Map<ModuleIdentifier, DependencySpec> getModuleDependencies() {
                return Collections.unmodifiableMap(moduleDependencies);
            }
        };
        FrameworkModuleLoader moduleLoaderPlugin = this.moduleLoader;
        moduleLoaderPlugin.addIntegrationDependencies(context);
        moduleLoaderPlugin.addModuleSpec((XBundleRevision)hostRev, specBuilder.create());
        return identifier;
    }

    private void processModuleWireList(List<BundleWire> wires, Map<BundleRevision, ModuleDependencyHolder> depBuilderMap) {
        XBundleRevision exporter;
        ArrayList<BundleWire> bundleWires = new ArrayList<BundleWire>();
        ArrayList<BundleWire> packageWires = new ArrayList<BundleWire>();
        for (BundleWire wire : wires) {
            XRequirement req = (XRequirement)wire.getRequirement();
            XBundleRevision importer = (XBundleRevision)wire.getRequirer();
            exporter = (XBundleRevision)wire.getProvider();
            if (exporter == importer) continue;
            if (req.adapt(XPackageRequirement.class) != null) {
                packageWires.add(wire);
                continue;
            }
            if (req.adapt(XResourceRequirement.class) == null) continue;
            bundleWires.add(wire);
        }
        HashSet<String> importedPaths = new HashSet<String>();
        HashSet<XBundleRevision> packageExporters = new HashSet<XBundleRevision>();
        for (BundleWire wire : packageWires) {
            exporter = (XBundleRevision)wire.getProvider();
            packageExporters.add(exporter);
            XRequirement xreq = (XRequirement)wire.getRequirement();
            XPackageRequirement packreq = (XPackageRequirement)xreq.adapt(XPackageRequirement.class);
            ModuleDependencyHolder holder = this.getDependencyHolder(depBuilderMap, exporter);
            String path = VFSUtils.getPathFromPackageName((String)packreq.getPackageName());
            holder.setOptional(packreq.isOptional());
            holder.addImportPath(path);
            importedPaths.add(path);
        }
        PathFilter importedPathsFilter = PathFilters.in(importedPaths);
        for (BundleWire wire : bundleWires) {
            XBundleRevision exporter2 = (XBundleRevision)wire.getProvider();
            if (packageExporters.contains(exporter2)) continue;
            XRequirement xreq = (XRequirement)wire.getRequirement();
            XResourceRequirement resreq = (XResourceRequirement)xreq.adapt(XResourceRequirement.class);
            ModuleDependencyHolder holder = this.getDependencyHolder(depBuilderMap, exporter2);
            holder.setImportFilter(PathFilters.not((PathFilter)importedPathsFilter));
            holder.setOptional(resreq.isOptional());
            boolean reexport = "reexport".equals(resreq.getVisibility());
            if (!reexport) continue;
            HashSet<String> exportedPaths = new HashSet<String>();
            for (Capability auxcap : exporter2.getCapabilities("osgi.wiring.package")) {
                XCapability xcap = (XCapability)auxcap;
                XPackageCapability packcap = (XPackageCapability)xcap.adapt(XPackageCapability.class);
                String path = packcap.getPackageName().replace('.', '/');
                if (importedPaths.contains(path)) continue;
                exportedPaths.add(path);
            }
            PathFilter exportedPathsFilter = PathFilters.in(exportedPaths);
            holder.setImportFilter(exportedPathsFilter);
            holder.setExportFilter(exportedPathsFilter);
        }
    }

    private PathFilter getExportClassFilter(XResource resModule) {
        PathFilter includeFilter = null;
        PathFilter excludeFilter = null;
        for (Capability auxcap : resModule.getCapabilities("osgi.wiring.package")) {
            String excludeDirective;
            XCapability xcap = (XCapability)auxcap;
            XPackageCapability packcap = (XPackageCapability)xcap.adapt(XPackageCapability.class);
            String includeDirective = packcap.getDirective("include");
            if (includeDirective != null) {
                String packageName = packcap.getPackageName();
                String[] patterns = includeDirective.split(",");
                ArrayList<PathFilter> includes = new ArrayList<PathFilter>();
                for (String pattern : patterns) {
                    includes.add(PathFilters.match((String)(packageName + "." + pattern)));
                }
                includeFilter = PathFilters.any(includes);
            }
            if ((excludeDirective = packcap.getDirective("exclude")) == null) continue;
            String packageName = packcap.getPackageName();
            String[] patterns = excludeDirective.split(",");
            ArrayList<PathFilter> excludes = new ArrayList<PathFilter>();
            for (String pattern : patterns) {
                excludes.add(PathFilters.match((String)(packageName + "." + pattern)));
            }
            excludeFilter = PathFilters.not((PathFilter)PathFilters.any(excludes));
        }
        if (includeFilter == null && excludeFilter == null) {
            return PathFilters.acceptAll();
        }
        if (includeFilter == null) {
            includeFilter = PathFilters.acceptAll();
        }
        if (excludeFilter == null) {
            excludeFilter = PathFilters.rejectAll();
        }
        return PathFilters.all((PathFilter[])new PathFilter[]{includeFilter, excludeFilter});
    }

    private PathFilter getLazyPackagesFilter(HostBundleState hostBundle) {
        PathFilter result = PathFilters.acceptAll();
        ActivationPolicyMetaData activationPolicy = hostBundle.getActivationPolicy();
        if (activationPolicy != null) {
            List excludes;
            List includes = activationPolicy.getIncludes();
            if (includes != null) {
                HashSet<String> paths = new HashSet<String>();
                for (String packageName : includes) {
                    paths.add(packageName.replace('.', '/'));
                }
                result = PathFilters.in(paths);
            }
            if ((excludes = activationPolicy.getExcludes()) != null) {
                HashSet<String> paths = new HashSet<String>();
                for (String packageName : excludes) {
                    paths.add(packageName.replace('.', '/'));
                }
                result = includes != null ? PathFilters.all((PathFilter[])new PathFilter[]{result, PathFilters.not((PathFilter)PathFilters.in(paths))}) : PathFilters.not((PathFilter)PathFilters.in(paths));
            }
        }
        return result;
    }

    private void addNativeResourceLoader(HostBundleRevision hostrev, ModuleSpec.Builder specBuilder) {
        Deployment deployment = hostrev.getDeployment();
        this.addNativeResourceLoader(specBuilder, hostrev, deployment);
        if (hostrev instanceof HostBundleRevision) {
            for (FragmentBundleRevision fragRev : hostrev.getAttachedFragments()) {
                this.addNativeResourceLoader(specBuilder, hostrev, fragRev.getDeployment());
            }
        }
    }

    private void addNativeResourceLoader(ModuleSpec.Builder specBuilder, HostBundleRevision hostrev, Deployment deployment) {
        NativeLibraryMetaData libMetaData = (NativeLibraryMetaData)deployment.getAttachment(NativeLibraryMetaData.class);
        if (libMetaData != null) {
            NativeResourceLoader nativeLoader = new NativeResourceLoader();
            for (NativeLibrary library : libMetaData.getNativeLibraries()) {
                String libpath = library.getLibraryPath();
                String libfile = new File(libpath).getName();
                String libname = libfile.substring(0, libfile.lastIndexOf(46));
                NativeCodeImpl.BundleNativeLibraryProvider libProvider = new NativeCodeImpl.BundleNativeLibraryProvider(hostrev, libname, libpath);
                nativeLoader.addNativeLibrary(libProvider);
                if (!libname.startsWith("lib")) continue;
                libname = libname.substring(3);
                libProvider = new NativeCodeImpl.BundleNativeLibraryProvider(hostrev, libname, libpath);
                nativeLoader.addNativeLibrary(libProvider);
            }
            specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)nativeLoader));
        }
    }

    private ModuleDependencyHolder getDependencyHolder(Map<BundleRevision, ModuleDependencyHolder> depBuilderMap, XBundleRevision exporter) {
        ModuleIdentifier exporterId = this.getModuleIdentifier(exporter);
        ModuleDependencyHolder holder = depBuilderMap.get(exporter);
        if (holder == null) {
            holder = new ModuleDependencyHolder(exporterId);
            depBuilderMap.put((BundleRevision)exporter, holder);
        }
        return holder;
    }

    @Override
    public Module loadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        if (this.getFrameworkModule().getIdentifier().equals(identifier)) {
            return this.getFrameworkModule();
        }
        return this.moduleLoader.getModuleLoader().loadModule(identifier);
    }

    @Override
    public void removeModule(XBundleRevision brev, ModuleIdentifier identifier) {
        this.moduleLoader.removeModule(brev);
    }

    private class ModuleDependencyHolder {
        private final ModuleIdentifier identifier;
        private DependencySpec dependencySpec;
        private Set<String> importPaths;
        private PathFilter importFilter;
        private PathFilter exportFilter;
        private boolean optional;

        ModuleDependencyHolder(ModuleIdentifier identifier) {
            this.identifier = identifier;
        }

        ModuleIdentifier getIdentifier() {
            return this.identifier;
        }

        void addImportPath(String path) {
            this.assertNotCreated();
            if (this.importPaths == null) {
                this.importPaths = new HashSet<String>();
            }
            this.importPaths.add(path);
        }

        Set<String> getImportPaths() {
            return this.importPaths;
        }

        void setImportFilter(PathFilter importFilter) {
            this.assertNotCreated();
            this.importFilter = importFilter;
        }

        void setExportFilter(PathFilter exportFilter) {
            this.assertNotCreated();
            this.exportFilter = exportFilter;
        }

        void setOptional(boolean optional) {
            this.assertNotCreated();
            this.optional = optional;
        }

        DependencySpec create() {
            Module frameworkModule;
            if (this.exportFilter == null) {
                this.exportFilter = PathFilters.rejectAll();
            }
            if (this.importFilter == null) {
                this.importFilter = this.importPaths != null ? PathFilters.in(this.importPaths) : PathFilters.acceptAll();
            }
            ModuleLoader depLoader = (frameworkModule = ModuleManagerImpl.this.getFrameworkModule()).getIdentifier().equals(this.identifier) ? frameworkModule.getModuleLoader() : ModuleManagerImpl.this.moduleLoader.getModuleLoader();
            FrameworkLogger.LOGGER.tracef("createModuleDependencySpec: [id=%s,if=%s,ef=%s,loader=%s,optional=%s]", new Object[]{this.identifier, this.importFilter, this.exportFilter, depLoader, this.optional});
            return DependencySpec.createModuleDependencySpec((PathFilter)this.importFilter, (PathFilter)this.exportFilter, (ModuleLoader)depLoader, (ModuleIdentifier)this.identifier, (boolean)this.optional);
        }

        private void assertNotCreated() {
            assert (this.dependencySpec == null) : "DependencySpec already created";
        }
    }
}

