/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.Resource;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.HostBundleState;
import org.jboss.osgi.framework.internal.SystemBundleRevision;
import org.jboss.osgi.framework.internal.URLResource;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.SystemPaths;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

final class FallbackLoader
implements LocalLoader {
    private final ReentrantLock fallbackLock = new ReentrantLock();
    private final AtomicBoolean fallbackEnabled = new AtomicBoolean(true);
    private final HostBundleState hostBundle;
    private final HostBundleRevision hostRev;
    private final Set<String> importedPaths;
    private final FrameworkState frameworkState;
    private final BundleManager bundleManager;
    private static ThreadLocal<Map<String, AtomicInteger>> dynamicLoadAttempts;

    FallbackLoader(HostBundleRevision hostRev, Set<String> importedPaths) {
        assert (hostRev != null) : "Null hostRev";
        assert (importedPaths != null) : "Null importedPaths";
        this.importedPaths = importedPaths;
        this.hostRev = hostRev;
        this.hostBundle = hostRev.getBundleState();
        this.bundleManager = this.hostBundle.getBundleManager();
        this.frameworkState = this.hostBundle.getFrameworkState();
        hostRev.setFallbackLoader(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setEnabled(boolean flag) {
        this.lockFallbackLoader();
        try {
            boolean bl = this.fallbackEnabled.getAndSet(flag);
            return bl;
        }
        finally {
            this.unlockFallbackLoader();
        }
    }

    void lockFallbackLoader() {
        this.fallbackLock.lock();
    }

    void unlockFallbackLoader() {
        this.fallbackLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClassLocal(String className, boolean resolve) {
        XBundleRevision brev = null;
        try {
            this.lockFallbackLoader();
            List<XPackageRequirement> matchingPatterns = this.findMatchingPatterns(className);
            if (!this.fallbackEnabled.get() || matchingPatterns.isEmpty()) {
                Class<?> clazz = null;
                return clazz;
            }
            String pathName = className.replace('.', '/') + ".class";
            brev = this.findRevisionDynamically(pathName, matchingPatterns);
        }
        finally {
            this.unlockFallbackLoader();
        }
        if (brev != null) {
            try {
                ModuleClassLoader moduleClassLoader = brev.getModuleClassLoader();
                return moduleClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                FrameworkLogger.LOGGER.tracef("Cannot load class [%s] from module: %s", className, brev);
                return null;
            }
        }
        return null;
    }

    public Package loadPackageLocal(String name) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource> loadResourceLocal(String resName) {
        XBundleRevision brev = null;
        try {
            this.lockFallbackLoader();
            if (resName.startsWith("/")) {
                resName = resName.substring(1);
            }
            List<XPackageRequirement> matchingPatterns = this.findMatchingPatterns(resName);
            if (!this.fallbackEnabled.get() || matchingPatterns.isEmpty()) {
                List<Resource> list = Collections.emptyList();
                return list;
            }
            brev = this.findRevisionDynamically(resName, matchingPatterns);
            if (brev == null) {
                List<Resource> list = Collections.emptyList();
                return list;
            }
            URL resURL = brev.getEntry(resName);
            if (resURL == null) {
                FrameworkLogger.LOGGER.tracef("Cannot load resource [%s] from module: %s", resName, brev);
                List<Resource> list = Collections.emptyList();
                return list;
            }
            List<Resource> list = Collections.singletonList(new URLResource(resURL));
            return list;
        }
        finally {
            this.unlockFallbackLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XBundleRevision findRevisionDynamically(String resName, List<XPackageRequirement> matchingPatterns) {
        int idx = resName.lastIndexOf(47);
        if (idx < 0) {
            return null;
        }
        String path = resName.substring(0, idx);
        if (this.importedPaths.contains(path)) {
            return null;
        }
        if (dynamicLoadAttempts == null) {
            dynamicLoadAttempts = new ThreadLocal();
        }
        Map<String, AtomicInteger> mapping = dynamicLoadAttempts.get();
        boolean removeThreadLocalMapping = false;
        try {
            AtomicInteger recursiveDepth;
            if (mapping == null) {
                mapping = new HashMap<String, AtomicInteger>();
                dynamicLoadAttempts.set(mapping);
                removeThreadLocalMapping = true;
            }
            if ((recursiveDepth = mapping.get(resName)) == null) {
                recursiveDepth = new AtomicInteger();
                mapping.put(resName, recursiveDepth);
            }
            if (recursiveDepth.incrementAndGet() == 1) {
                XBundleRevision brev = this.findInResolvedRevisions(resName, matchingPatterns);
                if (brev != null && brev != this.hostRev) {
                    XBundleRevision xBundleRevision = brev;
                    return xBundleRevision;
                }
                brev = this.findInUnresolvedRevisions(resName, matchingPatterns);
                if (brev != null && brev != this.hostRev) {
                    XBundleRevision xBundleRevision = brev;
                    return xBundleRevision;
                }
                brev = this.findInSystemRevision(resName, matchingPatterns);
                if (brev != null && brev != this.hostRev) {
                    XBundleRevision xBundleRevision = brev;
                    return xBundleRevision;
                }
            }
        }
        finally {
            if (removeThreadLocalMapping) {
                dynamicLoadAttempts.remove();
            } else {
                AtomicInteger recursiveDepth = mapping.get(resName);
                if (recursiveDepth.decrementAndGet() == 0) {
                    mapping.remove(resName);
                }
            }
        }
        return null;
    }

    private List<XPackageRequirement> findMatchingPatterns(String resName) {
        List<XPackageRequirement> dynamicRequirements = this.getDynamicPackageRequirements((BundleRevision)this.hostRev);
        String pathName = VFSUtils.getPathFromClassName((String)resName);
        List<XPackageCapability> packageCapabilities = this.getPackageCapabilities((BundleRevision)this.hostRev);
        for (XPackageCapability packageCap : packageCapabilities) {
            String packagePath = packageCap.getPackageName().replace('.', '/');
            if (!pathName.equals(packagePath)) continue;
            return Collections.emptyList();
        }
        ArrayList<XPackageRequirement> foundMatch = new ArrayList<XPackageRequirement>();
        for (XPackageRequirement dynreq : dynamicRequirements) {
            String pattern = dynreq.getPackageName();
            if (pattern.equals("*")) {
                foundMatch.add(dynreq);
                continue;
            }
            String patternPath = this.getPatternPath(pattern);
            if (!pathName.startsWith(patternPath)) continue;
            foundMatch.add(dynreq);
        }
        if (!foundMatch.isEmpty()) {
            FrameworkLogger.LOGGER.tracef("Found match for path [%s] with Dynamic-ImportPackage pattern: %s", resName, foundMatch);
        } else {
            FrameworkLogger.LOGGER.tracef("Class [%s] does not match Dynamic-ImportPackage patterns", resName);
        }
        return foundMatch;
    }

    private XBundleRevision findInResolvedRevisions(String resName, List<XPackageRequirement> matchingPatterns) {
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically in resolved modules ...", new Object[0]);
        Set<XBundle> resolved = this.bundleManager.getBundles(36);
        FrameworkLogger.LOGGER.tracef("Resolved modules: %d", resolved.size());
        if (FrameworkLogger.LOGGER.isTraceEnabled()) {
            for (XBundle bundle2 : resolved) {
                FrameworkLogger.LOGGER.tracef("   %s", bundle2);
            }
        }
        if (!resolved.isEmpty()) {
            for (XPackageRequirement pkgreq : matchingPatterns) {
                for (XBundle bundle3 : resolved) {
                    XBundleRevision brev = bundle3.getBundleRevision();
                    if (bundle3.getBundleId() <= 0L || brev.isFragment() || !this.isValidCandidate(resName, pkgreq, brev)) continue;
                    return brev;
                }
            }
        }
        return null;
    }

    private XBundleRevision findInUnresolvedRevisions(String resName, List<XPackageRequirement> matchingPatterns) {
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically in unresolved modules ...", new Object[0]);
        Set<XBundle> unresolved = this.bundleManager.getBundles(2);
        FrameworkLogger.LOGGER.tracef("Unresolved modules: %d", unresolved.size());
        if (FrameworkLogger.LOGGER.isTraceEnabled()) {
            for (XBundle bundle2 : unresolved) {
                FrameworkLogger.LOGGER.tracef("   %s", bundle2);
            }
        }
        for (XBundle bundle2 : unresolved) {
            if (!(bundle2 instanceof AbstractBundleState)) {
                FrameworkLogger.LOGGER.tracef("Ignore invalid bundle type: %s", bundle2);
                continue;
            }
            FrameworkLogger.LOGGER.tracef("Attempt to resolve: %s", bundle2);
            AbstractBundleState.assertBundleState((Bundle)bundle2).ensureResolved(false);
        }
        return this.findInResolvedRevisions(resName, matchingPatterns);
    }

    private XBundleRevision findInSystemRevision(String resName, List<XPackageRequirement> matchingPatterns) {
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically in framework module ...", new Object[0]);
        int lastIndex = resName.lastIndexOf(47);
        String pathName = lastIndex > 0 ? resName.substring(0, lastIndex) : resName;
        SystemPaths systemPaths = this.frameworkState.getSystemPathsPlugin();
        SystemBundleRevision brev = this.frameworkState.getSystemBundle().getBundleRevision();
        return systemPaths.getSystemPaths().contains(pathName) ? brev : null;
    }

    private boolean isValidCandidate(String resName, XPackageRequirement pkgreq, XBundleRevision brev) {
        if (brev == this.hostRev) {
            return false;
        }
        FrameworkLogger.LOGGER.tracef("Attempt to find path dynamically [%s] in %s ...", resName, brev);
        URL resURL = brev.getEntry(resName);
        if (resURL == null) {
            return false;
        }
        XPackageCapability candidateCap = this.getCandidateCapability((BundleRevision)brev, pkgreq);
        return candidateCap != null;
    }

    private XPackageCapability getCandidateCapability(BundleRevision brev, XPackageRequirement packageReq) {
        for (XPackageCapability packageCap : this.getPackageCapabilities(brev)) {
            if (!packageReq.matches((Capability)packageCap)) continue;
            FrameworkLogger.LOGGER.tracef("Matching package capability: %s", packageCap);
            return packageCap;
        }
        return null;
    }

    private String getPatternPath(String pattern) {
        String patternPath = pattern;
        if (pattern.endsWith(".*")) {
            patternPath = pattern.substring(0, pattern.length() - 2);
        }
        patternPath = patternPath.replace('.', '/');
        return patternPath;
    }

    private List<XPackageCapability> getPackageCapabilities(BundleRevision brev) {
        ArrayList<XPackageCapability> result = new ArrayList<XPackageCapability>();
        for (Capability aux : brev.getCapabilities("osgi.wiring.package")) {
            result.add((XPackageCapability)((XCapability)aux).adapt(XPackageCapability.class));
        }
        return result;
    }

    private List<XPackageRequirement> getDynamicPackageRequirements(BundleRevision brev) {
        ArrayList<XPackageRequirement> result = new ArrayList<XPackageRequirement>();
        for (Requirement aux : brev.getRequirements("osgi.wiring.package")) {
            XRequirement xreq = (XRequirement)aux;
            XPackageRequirement preq = (XPackageRequirement)xreq.adapt(XPackageRequirement.class);
            if (!preq.isDynamic()) continue;
            result.add(preq);
        }
        return result;
    }
}

