/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.Closeable;
import java.net.URL;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.ResourceBuilderException;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XBundleRevisionBuilderFactory;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.XResourceBuilderFactory;
import org.jboss.osgi.resolver.spi.AbstractBundleRevision;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.resource.Wiring;

abstract class BundleStateRevision
extends AbstractBundleRevision {
    private final FrameworkState frameworkState;
    private final OSGiMetaData metadata;
    private final StorageState storageState;
    private ModuleClassLoader moduleClassLoader;

    BundleStateRevision(FrameworkState frameworkState, OSGiMetaData metadata, StorageState storageState) throws BundleException {
        assert (frameworkState != null) : "Null frameworkState";
        assert (metadata != null) : "Null metadata";
        assert (storageState != null) : "Null storageState";
        this.frameworkState = frameworkState;
        this.storageState = storageState;
        this.metadata = metadata;
        try {
            final BundleStateRevision brev = this;
            XBundleRevisionBuilderFactory factory = new XBundleRevisionBuilderFactory(){

                public XBundleRevision createResource() {
                    return brev;
                }
            };
            XResourceBuilder builder = XResourceBuilderFactory.create((XResourceBuilderFactory)factory);
            builder.loadFrom(metadata).getResource();
        }
        catch (ResourceBuilderException ex) {
            throw new BundleException(ex.getMessage(), (Throwable)ex);
        }
        this.addAttachment(StorageState.class, storageState);
        this.addAttachment(OSGiMetaData.class, metadata);
    }

    FrameworkState getFrameworkState() {
        return this.frameworkState;
    }

    String getCanonicalName() {
        return this.getSymbolicName() + ":" + this.getVersion();
    }

    int getRevisionId() {
        return this.storageState.getRevisionId();
    }

    OSGiMetaData getOSGiMetaData() {
        return this.metadata;
    }

    StorageState getStorageState() {
        return this.storageState;
    }

    abstract String getLocation();

    abstract Class<?> loadClass(String var1) throws ClassNotFoundException;

    abstract URL getLocalizationEntry(String var1);

    public XBundle getBundle() {
        return (XBundle)this.getAttachment(Bundle.class);
    }

    public ModuleIdentifier getModuleIdentifier() {
        return (ModuleIdentifier)this.getAttachment(ModuleIdentifier.class);
    }

    public synchronized ModuleClassLoader getModuleClassLoader() {
        if (this.moduleClassLoader == null && this.getBundle().isResolved()) {
            ModuleIdentifier identifier = this.getModuleIdentifier();
            try {
                ModuleManager moduleManager = this.getFrameworkState().getModuleManager();
                Module module = moduleManager.loadModule(identifier);
                this.moduleClassLoader = module.getClassLoader();
            }
            catch (ModuleLoadException ex) {
                throw FrameworkMessages.MESSAGES.illegalStateCannotLoadModule(ex, identifier);
            }
        }
        return this.moduleClassLoader;
    }

    void refreshRevision() throws BundleException {
        XEnvironment env = this.getFrameworkState().getEnvironment();
        env.refreshResources(new XResource[]{this});
        this.refreshRevisionInternal();
    }

    synchronized void refreshRevisionInternal() {
        this.removeAttachment(Wiring.class);
        this.removeAttachment(Module.class);
        this.moduleClassLoader = null;
    }

    void close() {
        VFSUtils.safeClose((Closeable)this.storageState.getRootFile());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.getCanonicalName() + "]";
    }
}

