/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.CoreServices;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.ServiceReferenceWrapper;
import org.jboss.osgi.framework.internal.ServiceStateImpl;
import org.jboss.osgi.framework.spi.BundleLifecycle;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.BundleStorage;
import org.jboss.osgi.framework.spi.DeploymentProvider;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.FutureServiceValue;
import org.jboss.osgi.framework.spi.ServiceManager;
import org.jboss.osgi.framework.spi.ServiceState;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

abstract class AbstractBundleContext<T extends AbstractBundleState<?>>
implements BundleContext {
    private final T bundleState;
    private final FrameworkState frameworkState;
    private final BundleManager bundleManager;
    private boolean destroyed;

    AbstractBundleContext(T bundleState) {
        assert (bundleState != null) : "Null bundleState";
        this.bundleState = bundleState;
        this.frameworkState = ((AbstractBundleState)bundleState).getFrameworkState();
        this.bundleManager = ((AbstractBundleState)bundleState).getBundleManager();
    }

    static AbstractBundleContext<?> assertBundleContext(BundleContext context) {
        assert (context != null) : "Null context";
        assert (context instanceof AbstractBundleContext) : "Not an AbstractBundleContext: " + context;
        return (AbstractBundleContext)context;
    }

    void destroy() {
        this.destroyed = true;
    }

    T getBundleState() {
        return this.bundleState;
    }

    BundleManager getBundleManager() {
        return this.bundleManager;
    }

    BundleManagerPlugin getBundleManagerPlugin() {
        return BundleManagerPlugin.assertBundleManagerPlugin(this.bundleManager);
    }

    FrameworkState getFrameworkState() {
        return this.frameworkState;
    }

    public String getProperty(String key) {
        this.checkValidBundleContext();
        this.getBundleManagerPlugin().assertFrameworkCreated();
        Object value = this.getBundleManager().getProperty(key);
        return value instanceof String ? (String)value : null;
    }

    public Bundle getBundle() {
        this.checkValidBundleContext();
        return this.bundleState;
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.installBundleInternal(location, null);
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return this.installBundleInternal(location, input);
    }

    private Bundle installBundleInternal(String location, InputStream input) throws BundleException {
        this.checkValidBundleContext();
        VirtualFile rootFile = null;
        FrameworkState frameworkState = this.getFrameworkState();
        try {
            if (input != null) {
                try {
                    rootFile = AbstractVFS.toVirtualFile((InputStream)input);
                }
                catch (IOException ex) {
                    throw FrameworkMessages.MESSAGES.cannotObtainVirtualFile(ex);
                }
            }
            if (rootFile == null) {
                try {
                    URL url = new URL(location);
                    rootFile = AbstractVFS.toVirtualFile((InputStream)url.openStream());
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (rootFile == null) {
                try {
                    File file = new File(location);
                    if (file.exists()) {
                        rootFile = AbstractVFS.toVirtualFile((URI)file.toURI());
                    }
                }
                catch (IOException ex) {
                    throw FrameworkMessages.MESSAGES.cannotObtainVirtualFileForLocation(ex, location);
                }
            }
            if (rootFile == null) {
                throw FrameworkMessages.MESSAGES.cannotObtainVirtualFileForLocation(null, location);
            }
            DeploymentProvider deploymentPlugin = frameworkState.getDeploymentProvider();
            Deployment dep = deploymentPlugin.createDeployment(location, rootFile);
            return this.installBundle(dep);
        }
        catch (RuntimeException rte) {
            VFSUtils.safeClose(rootFile);
            throw rte;
        }
        catch (BundleException ex) {
            VFSUtils.safeClose(rootFile);
            throw ex;
        }
    }

    Bundle installBundle(Deployment dep) throws BundleException {
        this.checkValidBundleContext();
        FrameworkState frameworkState = this.getFrameworkState();
        BundleManager bundleManager = frameworkState.getBundleManager();
        CoreServices coreServices = frameworkState.getCoreServices();
        try {
            BundleLifecycle bundleLifecycle = coreServices.getBundleLifecycle();
            bundleLifecycle.install(dep);
        }
        catch (BundleException ex) {
            FrameworkLogger.LOGGER.debugf(ex, "Cannot install bundle from deployment: %s", dep);
            throw ex;
        }
        ServiceName serviceName = (ServiceName)dep.getAttachment(ServiceName.class);
        ServiceContainer serviceContainer = bundleManager.getServiceContainer();
        ServiceController controller = serviceContainer.getService(serviceName);
        FutureServiceValue future = new FutureServiceValue(controller);
        try {
            return (Bundle)future.get(30L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof BundleException) {
                throw (BundleException)cause;
            }
            throw FrameworkMessages.MESSAGES.cannotInstallBundleFromDeployment(ex, dep);
        }
    }

    public Bundle getBundle(long id) {
        this.checkValidBundleContext();
        return this.getBundleManager().getBundleById(id);
    }

    public Bundle[] getBundles() {
        this.checkValidBundleContext();
        ArrayList<XBundle> result = new ArrayList<XBundle>();
        for (XBundle bundle2 : this.getBundleManager().getBundles()) {
            result.add(bundle2);
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().addServiceListener((XBundle)this.bundleState, listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        try {
            this.getFrameworkEventsPlugin().addServiceListener((XBundle)this.bundleState, listener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().removeServiceListener((XBundle)this.bundleState, listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().addBundleListener((XBundle)this.bundleState, listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().removeBundleListener((XBundle)this.bundleState, listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().addFrameworkListener((XBundle)this.bundleState, listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        if (listener == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("listener");
        }
        this.getFrameworkEventsPlugin().removeFrameworkListener((XBundle)this.bundleState, listener);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        this.checkValidBundleContext();
        return this.registerService(new String[]{clazz}, service, properties);
    }

    public ServiceRegistration registerService(String[] classNames, Object service, Dictionary properties) {
        if (classNames == null || classNames.length == 0) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("classNames");
        }
        if (service == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("service");
        }
        this.checkValidBundleContext();
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        ServiceState serviceState = serviceManager.registerService((XBundle)this.bundleState, classNames, service, properties);
        return serviceState.getRegistration();
    }

    public ServiceReference getServiceReference(String className) {
        if (className == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("className");
        }
        this.checkValidBundleContext();
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        ServiceState serviceState = serviceManager.getServiceReference((XBundle)this.bundleState, className);
        return serviceState != null ? new ServiceReferenceWrapper(serviceState) : null;
    }

    public ServiceReference[] getServiceReferences(String className, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        List<ServiceState> srefs = serviceManager.getServiceReferences((XBundle)this.bundleState, className, filter, true);
        if (srefs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public ServiceReference[] getAllServiceReferences(String className, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        List<ServiceState> srefs = serviceManager.getServiceReferences((XBundle)this.bundleState, className, filter, false);
        if (srefs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public Object getService(ServiceReference sref) {
        if (sref == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("sref");
        }
        this.checkValidBundleContext();
        ServiceStateImpl serviceState = ServiceStateImpl.assertServiceState(sref);
        ServiceManager serviceManager = this.getFrameworkState().getServiceManagerPlugin();
        Object service = serviceManager.getService((XBundle)this.bundleState, serviceState);
        return service;
    }

    public boolean ungetService(ServiceReference sref) {
        if (sref == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("sref");
        }
        this.checkValidBundleContext();
        ServiceStateImpl serviceState = ServiceStateImpl.assertServiceState(sref);
        return this.getServiceManager().ungetService((XBundle)this.bundleState, serviceState);
    }

    public File getDataFile(String filename) {
        this.checkValidBundleContext();
        BundleStorage storagePlugin = this.getFrameworkState().getBundleStorage();
        return storagePlugin.getDataFile(((AbstractBundleState)this.bundleState).getBundleId(), filename);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        return FrameworkUtil.createFilter((String)filter);
    }

    void checkValidBundleContext() {
        if (this.destroyed) {
            throw FrameworkMessages.MESSAGES.illegalStateInvalidBundleContext((Bundle)this.bundleState);
        }
    }

    private ServiceManager getServiceManager() {
        return this.getFrameworkState().getServiceManagerPlugin();
    }

    private FrameworkEvents getFrameworkEventsPlugin() {
        return this.getFrameworkState().getFrameworkEvents();
    }

    public String toString() {
        return "BundleContext[" + this.bundleState + "]";
    }
}

