/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Set;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.remoting.transport.Transport;

public class ClusteredCacheLoaderInterceptor
extends CacheLoaderInterceptor {
    private CacheMode cacheMode;
    private boolean isWriteSkewConfigured;
    private Transport transport;
    private DistributionManager distributionManager;

    @Inject
    private void injectClusteredCacheLoaderInterceptorDependencies(Transport transport, DistributionManager distributionManager) {
        this.transport = transport;
        this.distributionManager = distributionManager;
    }

    @Start(priority=15)
    private void startClusteredCacheLoaderInterceptor() {
        this.cacheMode = this.cacheConfiguration.clustering().cacheMode();
        this.isWriteSkewConfigured = this.cacheConfiguration.locking().writeSkewCheck() && this.cacheMode.isClustered();
    }

    @Override
    protected boolean forceLoad(Object key, Set<Flag> flags) {
        return this.isWriteSkewConfigured && (this.cacheMode.isReplicated() && this.transport.isCoordinator() || this.cacheMode.isDistributed() && this.distributionManager.getPrimaryLocation(key).equals(this.transport.getAddress()));
    }
}

