/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.oob;

import java.util.Iterator;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.memory.Frame;

public class OOBSplitter {
    private Scheduler scheduler;
    private ConcurrentMap<OOBComponent> insideComponents = new ConcurrentMap();
    private ConcurrentMap<OOBComponent> outsideComponents = new ConcurrentMap();
    private Iterator<OOBComponent> insideRIterator = this.insideComponents.valuesIterator();
    private Iterator<OOBComponent> insideSIterator = this.insideComponents.valuesIterator();
    private Iterator<OOBComponent> outsideRIterator = this.outsideComponents.valuesIterator();
    private Iterator<OOBComponent> outsideSIterator = this.outsideComponents.valuesIterator();
    private InsideMixTask insideMixer;
    private OutsideMixTask outsideMixer;
    private volatile boolean started = false;
    protected long mixCount = 0L;

    public OOBSplitter(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.insideMixer = new InsideMixTask();
        this.outsideMixer = new OutsideMixTask();
    }

    public void addInsideComponent(OOBComponent component) {
        this.insideComponents.put((Object)component.getComponentId(), (Object)component);
    }

    public void addOutsideComponent(OOBComponent component) {
        this.outsideComponents.put((Object)component.getComponentId(), (Object)component);
    }

    public void releaseInsideComponent(OOBComponent component) {
        this.insideComponents.remove((Object)component.getComponentId());
    }

    public void releaseOutsideComponent(OOBComponent component) {
        this.outsideComponents.remove((Object)component.getComponentId());
    }

    public void start() {
        this.mixCount = 0L;
        this.started = true;
        this.scheduler.submit((Task)this.insideMixer, Scheduler.MIXER_MIX_QUEUE);
        this.scheduler.submit((Task)this.outsideMixer, Scheduler.MIXER_MIX_QUEUE);
    }

    public void stop() {
        this.started = false;
        this.insideMixer.cancel();
        this.outsideMixer.cancel();
    }

    private class OutsideMixTask
    extends Task {
        private Frame current;

        public int getQueueNumber() {
            return Scheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            OOBComponent component;
            this.current = null;
            OOBSplitter.this.outsideRIterator = OOBSplitter.this.outsideComponents.valuesIterator();
            while (OOBSplitter.this.outsideRIterator.hasNext()) {
                component = (OOBComponent)OOBSplitter.this.outsideRIterator.next();
                component.perform();
                this.current = component.getData();
                if (this.current == null) continue;
                break;
            }
            if (this.current == null) {
                OOBSplitter.this.scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
                ++OOBSplitter.this.mixCount;
                return 0L;
            }
            OOBSplitter.this.insideSIterator = OOBSplitter.this.insideComponents.valuesIterator();
            while (OOBSplitter.this.insideSIterator.hasNext()) {
                component = (OOBComponent)OOBSplitter.this.insideSIterator.next();
                if (!OOBSplitter.this.insideSIterator.hasNext()) {
                    component.offer(this.current);
                    continue;
                }
                component.offer(this.current.clone());
            }
            OOBSplitter.this.scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
            ++OOBSplitter.this.mixCount;
            return 0L;
        }
    }

    private class InsideMixTask
    extends Task {
        private Frame current;

        public int getQueueNumber() {
            return Scheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            OOBComponent component;
            this.current = null;
            OOBSplitter.this.insideRIterator = OOBSplitter.this.insideComponents.valuesIterator();
            while (OOBSplitter.this.insideRIterator.hasNext()) {
                component = (OOBComponent)OOBSplitter.this.insideRIterator.next();
                component.perform();
                this.current = component.getData();
                if (this.current == null) continue;
                break;
            }
            if (this.current == null) {
                OOBSplitter.this.scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
                ++OOBSplitter.this.mixCount;
                return 0L;
            }
            OOBSplitter.this.outsideSIterator = OOBSplitter.this.outsideComponents.valuesIterator();
            while (OOBSplitter.this.outsideSIterator.hasNext()) {
                component = (OOBComponent)OOBSplitter.this.outsideSIterator.next();
                if (!OOBSplitter.this.outsideSIterator.hasNext()) {
                    component.offer(this.current);
                    continue;
                }
                component.offer(this.current.clone());
            }
            OOBSplitter.this.scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
            ++OOBSplitter.this.mixCount;
            return 0L;
        }
    }
}

