/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.startup;

import java.io.IOException;
import java.text.ParseException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.valves.ValveBase;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.buf.MessageBytes;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.CatalinaMessages;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.session.ConvergedSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSessionKey;
import org.mobicents.servlet.sip.core.session.SessionManagerUtil;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionKey;
import org.mobicents.servlet.sip.startup.SipStandardContext;

final class SipStandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private static final transient Logger logger = Logger.getLogger(SipStandardContextValve.class);
    private SipStandardContext context = null;

    SipStandardContextValve() {
    }

    public String getInfo() {
        return info;
    }

    public void setContainer(Container container) {
        super.setContainer(container);
        this.context = (SipStandardContext)container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        int indexOfSipAppKey;
        Wrapper wrapper;
        MessageBytes requestPathMB = request.getRequestPathMB();
        if (requestPathMB.startsWithIgnoreCase("/META-INF/", 0) || requestPathMB.equalsIgnoreCase("/META-INF") || requestPathMB.startsWithIgnoreCase("/WEB-INF/", 0) || requestPathMB.equalsIgnoreCase("/WEB-INF")) {
            this.notFound((HttpServletResponse)response);
            return;
        }
        boolean reloaded = false;
        while (this.context.getPaused()) {
            reloaded = true;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (reloaded && this.context.getLoader() != null && this.context.getLoader().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
        }
        if ((wrapper = request.getWrapper()) == null) {
            this.notFound((HttpServletResponse)response);
            return;
        }
        if (wrapper.isUnavailable() && (wrapper = (Wrapper)this.container.findChild(wrapper.getName())) == null) {
            this.notFound((HttpServletResponse)response);
            return;
        }
        Object[] instances = this.context.getApplicationEventListeners();
        ServletRequestEvent event = null;
        if (instances != null && instances.length > 0) {
            event = new ServletRequestEvent(((StandardContext)this.container).getServletContext(), (ServletRequest)request.getRequest());
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestInitialized(event);
                    continue;
                }
                catch (Throwable t) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.requestListenerInitException(instances[i].getClass().getName()), t);
                    HttpServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t);
                    return;
                }
            }
        }
        boolean batchStarted = this.context.enterSipAppHa(false);
        String sipApplicationKey = null;
        String queryString = request.getQueryString();
        if (queryString != null && (indexOfSipAppKey = queryString.indexOf("org.mobicents.servlet.sip.ApplicationSessionKey")) != -1) {
            String sipAppKeyParam = queryString.substring(indexOfSipAppKey + "org.mobicents.servlet.sip.ApplicationSessionKey".length() + 1);
            int indexOfPoundSign = sipAppKeyParam.indexOf("&");
            if (indexOfPoundSign != -1) {
                sipAppKeyParam = sipAppKeyParam.substring(0, indexOfPoundSign);
            }
            sipApplicationKey = sipAppKeyParam;
        }
        MobicentsSipApplicationSession sipApplicationSessionImpl = null;
        if (sipApplicationKey != null && sipApplicationKey.length() > 0) {
            try {
                SipApplicationSessionKey sipApplicationSessionKey = SessionManagerUtil.parseSipApplicationSessionKey((String)sipApplicationKey);
                sipApplicationSessionImpl = ((SipManager)this.context.getManager()).getSipApplicationSession((MobicentsSipApplicationSessionKey)sipApplicationSessionKey, false);
                sipApplicationSessionImpl.addHttpSession(request.getSession());
            }
            catch (ParseException pe) {
                logger.error((Object)("Unexpected exception while parsing the sip application session key" + sipApplicationKey), (Throwable)pe);
            }
        } else {
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                this.context.getSipFactoryFacade().storeHttpSession(httpSession);
                ConvergedSession convergedSession = (ConvergedSession)httpSession;
                sipApplicationSessionImpl = convergedSession.getApplicationSession(false);
            }
        }
        this.context.enterSipApp(sipApplicationSessionImpl, null, false, true);
        try {
            wrapper.getPipeline().getFirst().invoke(request, response);
        }
        finally {
            this.context.exitSipApp(sipApplicationSessionImpl, null);
            this.context.exitSipAppHa(null, null, batchStarted);
        }
        this.context.getSipFactoryFacade().removeHttpSession();
        if (instances != null && instances.length > 0) {
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestDestroyed(event);
                    continue;
                }
                catch (Throwable t) {
                    this.container.getLogger().error((Object)CatalinaMessages.MESSAGES.requestListenerDestroyException(instances[i].getClass().getName()), t);
                    HttpServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t);
                }
            }
        }
    }

    public final void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        Wrapper wrapper = request.getWrapper();
        wrapper.getPipeline().getFirst().event(request, response, event);
    }

    protected void notFound(HttpServletResponse response) {
        try {
            response.sendError(404);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

