/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.startup;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.directory.DirContext;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.TimerService;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.security.SecurityUtil;
import org.apache.log4j.Logger;
import org.apache.tomcat.InstanceManager;
import org.jboss.web.CatalinaMessages;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.catalina.CatalinaSipContext;
import org.mobicents.servlet.sip.catalina.CatalinaSipListenersHolder;
import org.mobicents.servlet.sip.catalina.CatalinaSipManager;
import org.mobicents.servlet.sip.catalina.SARDirContext;
import org.mobicents.servlet.sip.catalina.SipDeploymentException;
import org.mobicents.servlet.sip.catalina.SipSecurityConstraint;
import org.mobicents.servlet.sip.catalina.SipServletImpl;
import org.mobicents.servlet.sip.catalina.SipStandardManager;
import org.mobicents.servlet.sip.catalina.annotations.SipInstanceManager;
import org.mobicents.servlet.sip.catalina.security.SipSecurityUtils;
import org.mobicents.servlet.sip.catalina.security.authentication.DigestAuthenticator;
import org.mobicents.servlet.sip.core.MobicentsSipServlet;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipContextEvent;
import org.mobicents.servlet.sip.core.SipContextEventType;
import org.mobicents.servlet.sip.core.SipListeners;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.SipService;
import org.mobicents.servlet.sip.core.descriptor.MobicentsSipServletMapping;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.security.MobicentsSipLoginConfig;
import org.mobicents.servlet.sip.core.security.SipDigestAuthenticator;
import org.mobicents.servlet.sip.core.session.DistributableSipManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionCreationThreadLocal;
import org.mobicents.servlet.sip.core.session.SipSessionsUtilImpl;
import org.mobicents.servlet.sip.core.timers.ProxyTimerService;
import org.mobicents.servlet.sip.core.timers.ProxyTimerServiceImpl;
import org.mobicents.servlet.sip.core.timers.SipApplicationSessionTimerService;
import org.mobicents.servlet.sip.core.timers.SipServletTimerService;
import org.mobicents.servlet.sip.core.timers.StandardSipApplicationSessionTimerService;
import org.mobicents.servlet.sip.core.timers.TimerServiceImpl;
import org.mobicents.servlet.sip.listener.SipConnectorListener;
import org.mobicents.servlet.sip.message.SipFactoryFacade;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.ruby.SipRubyController;
import org.mobicents.servlet.sip.startup.ConvergedApplicationContext;
import org.mobicents.servlet.sip.startup.SipStandardContextValve;

public class SipStandardContext
extends StandardContext
implements CatalinaSipContext {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SipStandardContext.class);
    private transient SipRubyController rubyController;
    private static final String info = "org.mobicents.servlet.sip.startup.SipStandardContext/1.0";
    private static int DEFAULT_LIFETIME = 3;
    protected String applicationName;
    protected String smallIcon;
    protected String largeIcon;
    protected String description;
    protected int proxyTimeout;
    protected int sipApplicationSessionTimeout;
    protected transient SipListeners sipListeners;
    protected transient SipFactoryFacade sipFactoryFacade;
    protected transient SipSessionsUtilImpl sipSessionsUtil;
    protected transient MobicentsSipLoginConfig sipLoginConfig;
    protected transient SipSecurityUtils sipSecurityUtils;
    protected transient SipDigestAuthenticator sipDigestAuthenticator;
    protected transient String securityDomain;
    protected boolean hasDistributableManager;
    protected String namingContextName;
    protected transient Method sipApplicationKeyMethod;
    protected ConcurrencyControlMode concurrencyControlMode;
    protected transient List<String> sipApplicationListeners = new CopyOnWriteArrayList<String>();
    private String servletHandler;
    protected boolean isMainServlet;
    private String mainServlet;
    protected transient List<MobicentsSipServletMapping> sipServletMappings = new ArrayList<MobicentsSipServletMapping>();
    protected transient SipApplicationDispatcher sipApplicationDispatcher = null;
    protected transient Map<String, MobicentsSipServlet> childrenMap;
    protected transient Map<String, MobicentsSipServlet> childrenMapByClassName;
    protected transient SipApplicationSessionTimerService sasTimerService = null;
    protected transient SipServletTimerService timerService = null;
    protected transient ProxyTimerService proxyTimerService = null;
    private transient ThreadLocal<SipApplicationSessionCreationThreadLocal> sipApplicationSessionsAccessedThreadLocal = new ThreadLocal();
    private transient ThreadLocal<Boolean> isManagedThread = new ThreadLocal();

    public SipStandardContext() {
        this.sipApplicationSessionTimeout = DEFAULT_LIFETIME;
        this.pipeline.setBasic((Valve)new SipStandardContextValve());
        this.sipListeners = new CatalinaSipListenersHolder(this);
        this.childrenMap = new HashMap<String, MobicentsSipServlet>();
        this.childrenMapByClassName = new HashMap<String, MobicentsSipServlet>();
        int idleTime = this.getSipApplicationSessionTimeout();
        if (idleTime <= 0) {
            idleTime = 1;
        }
        this.isMainServlet = false;
    }

    public void init() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing the sip context");
        }
        super.init();
        this.prepareServletContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"sip context Initialized");
        }
    }

    protected void prepareServletContext() throws LifecycleException {
        if (this.sipApplicationDispatcher == null) {
            this.setApplicationDispatcher();
        }
        if (this.sipFactoryFacade == null) {
            this.sipFactoryFacade = new SipFactoryFacade((SipFactoryImpl)this.sipApplicationDispatcher.getSipFactory(), (SipContext)this);
        }
        if (this.sipSessionsUtil == null) {
            this.sipSessionsUtil = new SipSessionsUtilImpl((SipContext)this);
        }
        this.getServletContext().setAttribute("javax.servlet.sip.SipFactory", (Object)this.sipFactoryFacade);
        if (this.timerService == null) {
            this.timerService = new TimerServiceImpl(this.sipApplicationDispatcher.getSipService());
        }
        if (this.proxyTimerService == null) {
            this.proxyTimerService = new ProxyTimerServiceImpl();
        }
        if (this.sasTimerService == null || !this.sasTimerService.isStarted()) {
            this.sasTimerService = new StandardSipApplicationSessionTimerService();
        }
        this.getServletContext().setAttribute("javax.servlet.sip.TimerService", (Object)this.timerService);
        this.getServletContext().setAttribute("javax.servlet.sip.supported", Arrays.asList(this.sipApplicationDispatcher.getExtensionsSupported()));
        this.getServletContext().setAttribute("javax.servlet.sip.100rel", (Object)Boolean.TRUE);
        this.getServletContext().setAttribute("javax.servlet.sip.supportedRfcs", Arrays.asList(this.sipApplicationDispatcher.getRfcSupported()));
        this.getServletContext().setAttribute("javax.servlet.sip.SipSessionsUtil", (Object)this.sipSessionsUtil);
        this.getServletContext().setAttribute("javax.servlet.sip.outboundInterfaces", (Object)this.sipApplicationDispatcher.getOutboundInterfaces());
        this.getServletContext().setAttribute("org.mobicents.servlet.sip.SIP_CONNECTORS", (Object)this.sipApplicationDispatcher.getSipService().findSipConnectors());
        this.getServletContext().setAttribute("org.mobicents.servlet.sip.DNS_RESOLVER", (Object)this.sipApplicationDispatcher.getDNSResolver());
    }

    protected void setApplicationDispatcher() throws LifecycleException {
        Service service;
        Container container = this.getParent().getParent();
        if (container instanceof Engine && (service = ((Engine)container).getService()) instanceof SipService) {
            this.sipApplicationDispatcher = ((SipService)service).getSipApplicationDispatcher();
        }
        if (this.sipApplicationDispatcher == null) {
            throw new LifecycleException("cannot find any application dispatcher for this context " + this.name);
        }
    }

    public synchronized void start() throws LifecycleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting the sip context " + this.getName()));
        }
        if (this.initialized) {
            this.prepareServletContext();
        }
        if (this.getResources() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Configuring default Resources");
            }
            try {
                if (this.getDocBase() != null && this.getDocBase().endsWith(".sar") && !new File(this.getBasePath()).isDirectory()) {
                    this.setResources((DirContext)((Object)new SARDirContext()));
                }
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)("Error initializing resources: " + e.getMessage()));
            }
        }
        if (this.manager == null) {
            if (this.getCluster() != null && this.getDistributable()) {
                try {
                    this.manager = this.getCluster().createManager(this.getName());
                }
                catch (Exception ex) {
                    logger.error((Object)"standardContext.clusterFail", (Throwable)ex);
                }
            } else {
                this.setManager(new SipStandardManager());
            }
        }
        if (this.manager instanceof DistributableSipManager) {
            this.hasDistributableManager = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"this context contains a manager that allows applications to work in a distributed environment");
            }
            ((SipManager)this.getManager()).setMobicentsSipFactory(this.sipApplicationDispatcher.getSipFactory());
            ((CatalinaSipManager)this.manager).setContainer((Container)this);
        }
        super.start();
        if (this.getAvailable()) {
            if (!(this.getManager() instanceof DistributableSipManager) && this.getManager() instanceof CatalinaSipManager) {
                ((SipManager)this.getManager()).setMobicentsSipFactory(this.sipApplicationDispatcher.getSipFactory());
                ((CatalinaSipManager)this.manager).setContainer((Container)this);
            }
            if ((this.mainServlet == null || this.mainServlet.length() < 1) && this.childrenMap.size() == 1) {
                this.setMainServlet(this.childrenMap.keySet().iterator().next());
            }
            this.sipSecurityUtils = new SipSecurityUtils(this);
            this.sipDigestAuthenticator = new DigestAuthenticator(this.sipApplicationDispatcher.getSipFactory().getHeaderFactory());
            this.sipApplicationDispatcher.addSipApplication(this.applicationName, (SipContext)this);
            if (this.manager instanceof DistributableSipManager) {
                this.hasDistributableManager = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"this context contains a manager that allows applications to work in a distributed environment");
                }
                ((SipManager)this.getManager()).setMobicentsSipFactory(this.sipApplicationDispatcher.getSipFactory());
                ((CatalinaSipManager)this.manager).setContainer((Container)this);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sip application session timeout for this context is " + this.sipApplicationSessionTimeout + " minutes"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("http session timeout for this context is " + this.getSessionTimeout() + " minutes"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sip context started " + this.getName()));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("sip context " + this.getName() + " didn't started due to errors"));
        }
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ConvergedApplicationContext(this.getBasePath(), this);
            if (this.getAltDDName() != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.getAltDDName());
            }
        }
        return ((ConvergedApplicationContext)this.context).getFacade();
    }

    public boolean contextListenerStart() {
        boolean ok = super.contextListenerStart();
        if (!ok) {
            return ok;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Configuring sip listeners");
        }
        ClassLoader loader = this.getLoader().getClassLoader();
        ok = this.sipListeners.loadListeners(this.findSipApplicationListeners(), loader);
        if (!ok) {
            return ok;
        }
        List servletContextListeners = this.sipListeners.getServletContextListeners();
        if (servletContextListeners != null) {
            ServletContextEvent event = new ServletContextEvent(this.getServletContext());
            for (ServletContextListener servletContextListener : servletContextListeners) {
                if (servletContextListener == null) continue;
                try {
                    this.fireContainerEvent("beforeContextInitialized", servletContextListener);
                    servletContextListener.contextInitialized(event);
                    this.fireContainerEvent("afterContextInitialized", servletContextListener);
                }
                catch (Throwable t) {
                    this.fireContainerEvent("afterContextInitialized", servletContextListener);
                    this.getLogger().error((Object)CatalinaMessages.MESSAGES.errorSendingContextInitializedEvent(servletContextListener.getClass().getName()), t);
                    ok = false;
                }
            }
        }
        return ok;
    }

    public boolean listenerStart() {
        boolean ok = super.listenerStart();
        if (!ok) {
            return ok;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Configuring sip listeners");
        }
        return ok;
    }

    public boolean listenerStop() {
        List servletContextListeners;
        boolean ok = super.listenerStop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending application stop events");
        }
        if ((servletContextListeners = this.sipListeners.getServletContextListeners()) != null) {
            ServletContextEvent event = new ServletContextEvent(this.getServletContext());
            for (ServletContextListener servletContextListener : servletContextListeners) {
                if (servletContextListener == null) continue;
                try {
                    this.fireContainerEvent("beforeContextDestroyed", servletContextListener);
                    servletContextListener.contextDestroyed(event);
                    this.fireContainerEvent("afterContextDestroyed", servletContextListener);
                }
                catch (Throwable t) {
                    this.fireContainerEvent("afterContextDestroyed", servletContextListener);
                    this.getLogger().error((Object)CatalinaMessages.MESSAGES.errorSendingContextDestroyedEvent(servletContextListener.getClass().getName()), t);
                    ok = false;
                }
            }
        }
        this.sipListeners.clean();
        return ok;
    }

    @Override
    public String getBasePath() {
        SipStandardContext container;
        String docBase = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        File file = new File(this.getDocBase());
        if (!file.isAbsolute()) {
            if (container == null) {
                docBase = new File(this.engineBase(), this.getDocBase()).getPath();
            } else {
                String appBase = ((Host)container).getAppBase();
                file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(this.engineBase(), appBase);
                }
                docBase = new File(file, this.getDocBase()).getPath();
            }
        } else {
            docBase = file.getPath();
        }
        return docBase;
    }

    public synchronized void stop() throws LifecycleException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Stopping the sip context " + this.getName()));
        }
        if (this.manager instanceof SipManager) {
            ((SipManager)this.manager).dumpSipSessions();
            ((SipManager)this.manager).dumpSipApplicationSessions();
            logger.warn((Object)("number of active sip sessions : " + ((SipManager)this.manager).getActiveSipSessions()));
            logger.warn((Object)("number of active sip application sessions : " + ((SipManager)this.manager).getActiveSipApplicationSessions()));
        }
        super.stop();
        this.sipListeners.deallocateServletsActingAsListeners();
        this.sipApplicationListeners.clear();
        this.sipServletMappings.clear();
        this.childrenMap.clear();
        this.childrenMapByClassName.clear();
        if (this.sipApplicationDispatcher != null) {
            if (this.applicationName != null) {
                this.sipApplicationDispatcher.removeSipApplication(this.applicationName);
            } else {
                logger.error((Object)("the application name is null for the following context : " + this.name));
            }
        }
        if (this.sasTimerService != null && this.sasTimerService.isStarted()) {
            this.sasTimerService.stop();
        }
        this.sasTimerService = null;
        if (this.timerService != null) {
            this.timerService.stop();
        }
        if (this.proxyTimerService != null) {
            this.proxyTimerService.stop();
        }
        this.timerService = null;
        this.getServletContext().setAttribute("javax.servlet.sip.TimerService", null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sip context stopped " + this.getName()));
        }
    }

    public void loadOnStartup(Container[] containers) {
        super.loadOnStartup(containers);
    }

    public Wrapper createWrapper() {
        return super.createWrapper();
    }

    public void addChild(Container container) {
        if (container instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)container;
            SipServletImpl sipServletImpl = (SipServletImpl)this.childrenMap.get(container.getName());
            if (sipServletImpl != null && !sipServletImpl.getServletClass().equals(wrapper.getServletClass())) {
                throw new SipDeploymentException("Trying to add a servlet with name " + container.getName() + " and servlet class " + wrapper.getServletClass() + " while there is already a SIP Servlet with the same name and a different servlet class " + sipServletImpl.getServletClass());
            }
        }
        if (this.children.get(container.getName()) == null) {
            super.addChild(container);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)(container.getName() + " already present as a Sip Servlet not adding it again"));
        }
    }

    @Override
    public void addChild(SipServletImpl sipServletImpl) {
        SipServletImpl existingServlet = (SipServletImpl)this.childrenMap.get(sipServletImpl.getName());
        if (existingServlet != null) {
            logger.warn((Object)(sipServletImpl.getName() + " servlet already present, removing the previous one. " + "This might be due to the fact that the definition of the servlet " + "is present both in annotations and in sip.xml"));
            this.childrenMap.remove(sipServletImpl.getName());
            this.childrenMapByClassName.remove(sipServletImpl.getServletClass());
            super.removeChild((Container)existingServlet);
        }
        this.childrenMap.put(sipServletImpl.getName(), sipServletImpl);
        this.childrenMapByClassName.put(sipServletImpl.getServletClass(), sipServletImpl);
        super.addChild((Container)sipServletImpl);
    }

    @Override
    public void removeChild(SipServletImpl sipServletImpl) {
        super.removeChild((Container)sipServletImpl);
        this.childrenMap.remove(sipServletImpl.getName());
        this.childrenMapByClassName.remove(sipServletImpl.getServletClass());
    }

    public Map<String, MobicentsSipServlet> getChildrenMap() {
        return this.childrenMap;
    }

    public MobicentsSipServlet findSipServletByName(String name) {
        if (name == null) {
            return null;
        }
        return this.childrenMap.get(name);
    }

    public MobicentsSipServlet findSipServletByClassName(String className) {
        if (className == null) {
            return null;
        }
        return this.childrenMapByClassName.get(className);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationNameHashed() {
        return this.sipApplicationDispatcher.getHashFromApplicationName(this.applicationName);
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public SipListeners getListeners() {
        return this.sipListeners;
    }

    public void setListeners(SipListeners listeners) {
        this.sipListeners = (CatalinaSipListenersHolder)listeners;
    }

    public boolean isMainServlet() {
        return this.isMainServlet;
    }

    public String getMainServlet() {
        return this.mainServlet;
    }

    public void setMainServlet(String mainServlet) {
        this.mainServlet = mainServlet;
        this.servletHandler = mainServlet;
        this.isMainServlet = true;
    }

    public int getProxyTimeout() {
        return this.proxyTimeout;
    }

    public void setProxyTimeout(int proxyTimeout) {
        this.proxyTimeout = proxyTimeout;
    }

    public void addConstraint(SipSecurityConstraint securityConstraint) {
        super.addConstraint((SecurityConstraint)securityConstraint);
    }

    public void removeConstraint(SipSecurityConstraint securityConstraint) {
        super.removeConstraint((SecurityConstraint)securityConstraint);
    }

    @Override
    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setLoginConfig(LoginConfig config) {
        super.setLoginConfig(config);
    }

    public LoginConfig getLoginConfig() {
        return super.getLoginConfig();
    }

    public void setSipLoginConfig(MobicentsSipLoginConfig config) {
        this.sipLoginConfig = config;
    }

    public MobicentsSipLoginConfig getSipLoginConfig() {
        return this.sipLoginConfig;
    }

    public void addSipApplicationListener(String listener) {
        this.sipApplicationListeners.add(listener);
        this.fireContainerEvent("addSipApplicationListener", listener);
    }

    public void removeSipApplicationListener(String listener) {
        this.sipApplicationListeners.remove(listener);
        this.fireContainerEvent("removeSipApplicationListener", listener);
    }

    public String[] findSipApplicationListeners() {
        return this.sipApplicationListeners.toArray(new String[this.sipApplicationListeners.size()]);
    }

    public SipApplicationDispatcher getSipApplicationDispatcher() {
        return this.sipApplicationDispatcher;
    }

    public SipFactoryFacade getSipFactoryFacade() {
        return this.sipFactoryFacade;
    }

    public SipSessionsUtilImpl getSipSessionsUtil() {
        return this.sipSessionsUtil;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public ProxyTimerService getProxyTimerService() {
        return this.proxyTimerService;
    }

    private String getNamingContextName() {
        if (this.namingContextName == null) {
            Container parent = this.getParent();
            if (parent == null) {
                this.namingContextName = this.getName();
            } else {
                Stack<String> stk = new Stack<String>();
                StringBuffer buff = new StringBuffer();
                while (parent != null) {
                    stk.push(parent.getName());
                    parent = parent.getParent();
                }
                while (!stk.empty()) {
                    buff.append("/" + (String)stk.pop());
                }
                buff.append(this.getName());
                this.namingContextName = buff.toString();
            }
        }
        return this.namingContextName;
    }

    public synchronized void setManager(Manager manager) {
        if (this.getManager() != null && !manager.equals(this.getManager())) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("this context already contains a manager " + this.getManager() + " not setting new manager " + manager));
            }
            return;
        }
        if (manager instanceof CatalinaSipManager && this.sipApplicationDispatcher != null) {
            ((SipManager)manager).setMobicentsSipFactory(this.sipApplicationDispatcher.getSipFactory());
            ((CatalinaSipManager)manager).setContainer((Container)this);
        }
        super.setManager(manager);
        if (manager instanceof DistributableSipManager) {
            this.hasDistributableManager = true;
            this.setDistributable(true);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"this context contains a manager that allows applications to work in a distributed environment");
            }
        }
    }

    public Manager getManager() {
        return super.getManager();
    }

    public int getSipApplicationSessionTimeout() {
        return this.sipApplicationSessionTimeout;
    }

    public void setSipApplicationSessionTimeout(int sipApplicationSessionTimeout) {
        this.sipApplicationSessionTimeout = sipApplicationSessionTimeout;
    }

    public Method getSipApplicationKeyMethod() {
        return this.sipApplicationKeyMethod;
    }

    public void setSipApplicationKeyMethod(Method sipApplicationKeyMethod) {
        this.sipApplicationKeyMethod = sipApplicationKeyMethod;
    }

    public String getJbossBasePath() {
        return this.getBasePath();
    }

    public void addSipServletMapping(MobicentsSipServletMapping sipServletMapping) {
        this.sipServletMappings.add(sipServletMapping);
        this.isMainServlet = false;
        if (this.servletHandler == null) {
            this.servletHandler = sipServletMapping.getServletName();
        }
    }

    public List<MobicentsSipServletMapping> findSipServletMappings() {
        return this.sipServletMappings;
    }

    public MobicentsSipServletMapping findSipServletMappings(SipServletRequest sipServletRequest) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking sip Servlet Mapping for following request : " + sipServletRequest));
        }
        for (MobicentsSipServletMapping sipServletMapping : this.sipServletMappings) {
            if (sipServletMapping.getMatchingRule().matches(sipServletRequest)) {
                return sipServletMapping;
            }
            logger.debug((Object)("Following mapping rule didn't match : servletName => " + sipServletMapping.getServletName() + " | expression = " + sipServletMapping.getMatchingRule().getExpression()));
        }
        return null;
    }

    public void removeSipServletMapping(MobicentsSipServletMapping sipServletMapping) {
        this.sipServletMappings.remove(sipServletMapping);
    }

    public final SipManager getSipManager() {
        return (SipManager)this.manager;
    }

    public String getInfo() {
        return info;
    }

    public void enterSipApp(MobicentsSipApplicationSession sipApplicationSession, MobicentsSipSession sipSession, boolean checkIsManagedThread, boolean isContainerManaged) {
        switch (this.concurrencyControlMode) {
            case SipSession: {
                if (sipSession == null) break;
                sipSession.acquire();
                break;
            }
            case SipApplicationSession: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("checkIsManagedThread " + checkIsManagedThread + " , isManagedThread " + this.isManagedThread.get() + ", isContainerManaged " + isContainerManaged));
                }
                if (!checkIsManagedThread || checkIsManagedThread && Boolean.TRUE.equals(this.isManagedThread.get())) {
                    boolean notPresent;
                    if (this.isManagedThread.get() == null) {
                        this.isManagedThread.set(Boolean.TRUE);
                    }
                    if (sipApplicationSession == null) break;
                    SipApplicationSessionCreationThreadLocal sipApplicationSessionCreationThreadLocal = this.sipApplicationSessionsAccessedThreadLocal.get();
                    if (sipApplicationSessionCreationThreadLocal == null) {
                        sipApplicationSessionCreationThreadLocal = new SipApplicationSessionCreationThreadLocal();
                        this.sipApplicationSessionsAccessedThreadLocal.set(sipApplicationSessionCreationThreadLocal);
                    }
                    if ((notPresent = sipApplicationSessionCreationThreadLocal.getSipApplicationSessions().add(sipApplicationSession)) && isContainerManaged) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("acquiring sipApplicationSession=" + sipApplicationSession + " since it is not present in our local thread of accessed sip application sessions "));
                        }
                        sipApplicationSession.acquire();
                        break;
                    }
                    if (!logger.isDebugEnabled()) break;
                    if (!isContainerManaged) {
                        logger.debug((Object)("not acquiring sipApplicationSession=" + sipApplicationSession + " since application specified the container shouldn't manage it "));
                        break;
                    }
                    logger.debug((Object)("not acquiring sipApplicationSession=" + sipApplicationSession + " since it is present in our local thread of accessed sip application sessions "));
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("not acquiring sipApplicationSession=" + sipApplicationSession + " since isManagedThread is " + this.isManagedThread.get()));
                break;
            }
        }
    }

    public void exitSipApp(MobicentsSipApplicationSession sipApplicationSession, MobicentsSipSession sipSession) {
        switch (this.concurrencyControlMode) {
            case SipSession: {
                if (sipSession != null) {
                    sipSession.release();
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("NOT RELEASING SipSession on exit sipApplicationSession=" + sipApplicationSession + " sipSession=" + sipSession + " semaphore=null"));
                break;
            }
            case SipApplicationSession: {
                boolean wasSessionReleased = false;
                SipApplicationSessionCreationThreadLocal sipApplicationSessionCreationThreadLocal = this.sipApplicationSessionsAccessedThreadLocal.get();
                if (sipApplicationSessionCreationThreadLocal != null) {
                    for (MobicentsSipApplicationSession sipApplicationSessionAccessed : this.sipApplicationSessionsAccessedThreadLocal.get().getSipApplicationSessions()) {
                        sipApplicationSessionAccessed.release();
                        if (!sipApplicationSessionAccessed.equals(sipApplicationSession)) continue;
                        wasSessionReleased = true;
                    }
                    this.sipApplicationSessionsAccessedThreadLocal.get().getSipApplicationSessions().clear();
                    this.sipApplicationSessionsAccessedThreadLocal.set(null);
                    this.sipApplicationSessionsAccessedThreadLocal.remove();
                }
                this.isManagedThread.set(null);
                this.isManagedThread.remove();
                if (wasSessionReleased) break;
                if (sipApplicationSession != null) {
                    sipApplicationSession.release();
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("NOT RELEASING SipApplicationSession on exit sipApplicationSession=" + sipApplicationSession + " sipSession=" + sipSession + " semaphore=null"));
                break;
            }
        }
    }

    public boolean enterSipAppHa(boolean startCacheActivity) {
        boolean batchStarted = false;
        return batchStarted;
    }

    public void exitSipAppHa(MobicentsSipServletRequest request, MobicentsSipServletResponse response, boolean batchStarted) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifySipContextListeners(SipContextEvent event) {
        boolean ok = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.childrenMap.size() + " container to notify of " + event.getEventType()));
        }
        if (event.getEventType() == SipContextEventType.SERVLET_INITIALIZED) {
            if (!this.timerService.isStarted()) {
                this.timerService.start();
            }
            if (!this.proxyTimerService.isStarted()) {
                this.proxyTimerService.start();
            }
            if (!this.sasTimerService.isStarted()) {
                this.sasTimerService.start();
            }
        }
        if (this.available) {
            this.enterSipApp(null, null, false, true);
            boolean batchStarted = this.enterSipAppHa(true);
            ArrayList<MobicentsSipServlet> sipServlets = new ArrayList<MobicentsSipServlet>(this.childrenMap.values());
            Collections.sort(sipServlets, new SipServletLoadOnStartupComparator());
            try {
                for (MobicentsSipServlet container : sipServlets) {
                    Servlet sipServlet;
                    Wrapper wrapper;
                    block33: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("container " + container.getName() + ", class : " + container.getClass().getName() + ", load-on-startup : " + container.getLoadOnStartup()));
                        }
                        if (!(container instanceof Wrapper)) continue;
                        wrapper = (Wrapper)container;
                        sipServlet = null;
                        try {
                            sipServlet = wrapper.allocate();
                            if (!(sipServlet instanceof SipServlet)) break block33;
                            boolean servletHandlerWasNull = false;
                            if (this.servletHandler == null) {
                                this.servletHandler = container.getName();
                                servletHandlerWasNull = true;
                            }
                            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                            try {
                                ClassLoader cl = this.getLoader().getClassLoader();
                                Thread.currentThread().setContextClassLoader(cl);
                                this.bindThreadBindingListener();
                                switch (event.getEventType()) {
                                    case SERVLET_INITIALIZED: {
                                        SipServletContextEvent sipServletContextEvent = new SipServletContextEvent(this.getServletContext(), (SipServlet)sipServlet);
                                        List sipServletListeners = this.sipListeners.getSipServletsListeners();
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)(sipServletListeners.size() + " SipServletListener to notify of servlet initialization"));
                                        }
                                        for (SipServletListener sipServletListener : sipServletListeners) {
                                            sipServletListener.servletInitialized(sipServletContextEvent);
                                        }
                                        break;
                                    }
                                    case SIP_CONNECTOR_ADDED: {
                                        this.getServletContext().setAttribute("javax.servlet.sip.outboundInterfaces", (Object)this.sipApplicationDispatcher.getOutboundInterfaces());
                                        this.getServletContext().setAttribute("org.mobicents.servlet.sip.SIP_CONNECTORS", (Object)this.sipApplicationDispatcher.getSipService().findSipConnectors());
                                        List sipConnectorListeners = this.sipListeners.getSipConnectorListeners();
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)(sipConnectorListeners.size() + " SipConnectorListener to notify of sip connector addition"));
                                        }
                                        for (SipConnectorListener sipConnectorListener : sipConnectorListeners) {
                                            sipConnectorListener.sipConnectorAdded((SipConnector)event.getEventObject());
                                        }
                                        break;
                                    }
                                    case SIP_CONNECTOR_REMOVED: {
                                        this.getServletContext().setAttribute("javax.servlet.sip.outboundInterfaces", (Object)this.sipApplicationDispatcher.getOutboundInterfaces());
                                        this.getServletContext().setAttribute("org.mobicents.servlet.sip.SIP_CONNECTORS", (Object)this.sipApplicationDispatcher.getSipService().findSipConnectors());
                                        List sipConnectorListeners = this.sipListeners.getSipConnectorListeners();
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)(sipConnectorListeners.size() + " SipConnectorListener to notify of sip connector removal"));
                                        }
                                        for (SipConnectorListener sipConnectorListener : sipConnectorListeners) {
                                            sipConnectorListener.sipConnectorRemoved((SipConnector)event.getEventObject());
                                        }
                                        break;
                                    }
                                }
                                if (servletHandlerWasNull) {
                                    this.servletHandler = null;
                                }
                            }
                            finally {
                                this.unbindThreadBindingListener();
                                Thread.currentThread().setContextClassLoader(oldClassLoader);
                            }
                        }
                        catch (ServletException e) {
                            logger.error((Object)("Cannot allocate the servlet " + wrapper.getServletClass() + " for notifying the listener " + " of the event " + event.getEventType()), (Throwable)e);
                            ok = false;
                        }
                        catch (Throwable e) {
                            logger.error((Object)("An error occured when notifying the servlet " + wrapper.getServletClass() + " of the event " + event.getEventType()), e);
                            ok = false;
                        }
                    }
                    try {
                        if (sipServlet == null) continue;
                        wrapper.deallocate(sipServlet);
                    }
                    catch (ServletException e) {
                        logger.error((Object)("Deallocate exception for servlet" + wrapper.getName()), (Throwable)e);
                        ok = false;
                    }
                    catch (Throwable e) {
                        logger.error((Object)("Deallocate exception for servlet" + wrapper.getName()), e);
                        ok = false;
                    }
                }
            }
            finally {
                this.exitSipAppHa(null, null, batchStarted);
                this.exitSipApp(null, null);
            }
        }
        return ok;
    }

    public ConcurrencyControlMode getConcurrencyControlMode() {
        return this.concurrencyControlMode;
    }

    public void setConcurrencyControlMode(ConcurrencyControlMode mode) {
        this.concurrencyControlMode = mode;
        if (this.concurrencyControlMode != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Concurrency Control set to " + this.concurrencyControlMode.toString() + " for application " + this.applicationName));
        }
    }

    public SipRubyController getSipRubyController() {
        return this.rubyController;
    }

    public void setSipRubyController(SipRubyController sipRubyController) {
        this.rubyController = sipRubyController;
    }

    public SipApplicationSessionTimerService getSipApplicationSessionTimerService() {
        return this.sasTimerService;
    }

    public boolean hasDistributableManager() {
        return this.hasDistributableManager;
    }

    public String getServletHandler() {
        return this.servletHandler;
    }

    public void setServletHandler(String servletHandler) {
        this.servletHandler = servletHandler;
    }

    public boolean isPackageProtectionEnabled() {
        return SecurityUtil.isPackageProtectionEnabled();
    }

    public ClassLoader getSipContextClassLoader() {
        return this.getLoader().getClassLoader();
    }

    public boolean authorize(MobicentsSipServletRequest request) {
        return this.sipSecurityUtils.authorize(request);
    }

    public SipDigestAuthenticator getDigestAuthenticator() {
        return this.sipDigestAuthenticator;
    }

    @Override
    public SipInstanceManager getSipInstanceManager() {
        return (SipInstanceManager)super.getInstanceManager();
    }

    public void setInstanceManager(InstanceManager instanceManager) {
        super.setInstanceManager(instanceManager);
    }

    public void bindThreadBindingListener() {
        super.getThreadBindingListener().bind();
    }

    public void unbindThreadBindingListener() {
        super.getThreadBindingListener().unbind();
    }

    public void enterSipContext() {
        ClassLoader cl = this.getSipContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        this.bindThreadBindingListener();
    }

    public void exitSipContext(ClassLoader oldClassLoader) {
        this.unbindThreadBindingListener();
        Thread.currentThread().setContextClassLoader(oldClassLoader);
    }

    protected class SipServletLoadOnStartupComparator
    implements Comparator<MobicentsSipServlet> {
        protected SipServletLoadOnStartupComparator() {
        }

        @Override
        public int compare(MobicentsSipServlet o1, MobicentsSipServlet o2) {
            if (o1 != null && o2 != null) {
                if (o1.getLoadOnStartup() > o2.getLoadOnStartup()) {
                    return 1;
                }
                if (o1.getLoadOnStartup() == o2.getLoadOnStartup()) {
                    return 0;
                }
                return -1;
            }
            return 0;
        }
    }
}

