/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.web.WebMessages;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

public class SecurityActions {
    public static final String AUTH_EXCEPTION_KEY = "org.jboss.security.exception";

    public static SecurityContext createSecurityContext(final String domain) {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                try {
                    return SecurityContextFactory.createSecurityContext((String)domain);
                }
                catch (Exception e) {
                    throw WebMessages.MESSAGES.failToCreateSecurityContext((Throwable)e);
                }
            }
        });
    }

    public static void setSecurityContextOnAssociation(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    public static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    public static void clearSecurityContext() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.clearSecurityContext();
                return null;
            }
        });
    }

    public static void pushRunAsIdentity(final RunAsIdentity principal) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw WebMessages.MESSAGES.noSecurityContext();
                }
                sc.setOutgoingRunAs((RunAs)principal);
                return null;
            }
        });
    }

    public static RunAs popRunAsIdentity() {
        return AccessController.doPrivileged(new PrivilegedAction<RunAs>(){

            @Override
            public RunAs run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw WebMessages.MESSAGES.noSecurityContext();
                }
                RunAs principal = sc.getOutgoingRunAs();
                sc.setOutgoingRunAs(null);
                return principal;
            }
        });
    }

    public static void clearAuthException() {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    if (sc != null) {
                        sc.getData().put(SecurityActions.AUTH_EXCEPTION_KEY, null);
                    }
                    return null;
                }
            });
        } else {
            SecurityContext sc = SecurityActions.getSecurityContext();
            if (sc != null) {
                sc.getData().put(AUTH_EXCEPTION_KEY, null);
            }
        }
    }

    public static Throwable getAuthException() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Throwable>(){

                @Override
                public Throwable run() {
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    Throwable exception = null;
                    if (sc != null) {
                        exception = (Throwable)sc.getData().get(SecurityActions.AUTH_EXCEPTION_KEY);
                    }
                    return exception;
                }
            });
        }
        SecurityContext sc = SecurityActions.getSecurityContext();
        Throwable exception = null;
        if (sc != null) {
            exception = (Throwable)sc.getData().get(AUTH_EXCEPTION_KEY);
        }
        return exception;
    }
}

