/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina.security.authentication;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.ProxyAuthorizationHeader;
import javax.sip.header.WWWAuthenticateHeader;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.util.MD5Encoder;
import org.apache.log4j.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.mobicents.servlet.sip.catalina.SipLoginConfig;
import org.mobicents.servlet.sip.catalina.security.CatalinaSipPrincipal;
import org.mobicents.servlet.sip.catalina.security.authentication.AuthenticatorBase;
import org.mobicents.servlet.sip.catalina.security.authentication.MessageDigestResponseAlgorithm;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.security.MobicentsSipLoginConfig;
import org.mobicents.servlet.sip.core.security.SipDigestAuthenticator;
import org.mobicents.servlet.sip.core.security.SipPrincipal;
import org.mobicents.servlet.sip.security.SecurityActions;

public class DigestAuthenticator
extends AuthenticatorBase
implements SipDigestAuthenticator {
    private static final Logger log = Logger.getLogger(DigestAuthenticator.class);
    static final MD5Encoder MD5_ENCODER = new MD5Encoder();
    protected static final String INFO = "org.apache.catalina.authenticator.DigestAuthenticator/1.0";
    private HeaderFactory headerFactory;
    protected static volatile MessageDigest md5Helper;
    protected String key = "Catalina";
    private SipPrincipal principal;

    public DigestAuthenticator(HeaderFactory headerFactory) {
        this.headerFactory = headerFactory;
    }

    @Override
    public String getInfo() {
        return INFO;
    }

    @Override
    public boolean authenticate(MobicentsSipServletRequest request, MobicentsSipServletResponse response, MobicentsSipLoginConfig config, String securityDomain) throws IOException {
        this.principal = null;
        this.principal = request.getUserPrincipal();
        if (this.principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Already authenticated '" + this.principal.getName() + "'"));
            }
            return true;
        }
        String authorization = request.getHeader("authorization");
        if (authorization != null) {
            this.principal = DigestAuthenticator.findPrincipal(request, authorization, this.context.getRealm(), securityDomain);
            if (this.principal != null && this.principal.getPrincipal() != null) {
                String username = this.parseUsername(authorization);
                this.register(request, response, this.principal, "DIGEST", username, null);
                return true;
            }
        }
        String nOnce = this.generateNOnce(request);
        this.setAuthenticateHeader(request, response, config, nOnce);
        response.send();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SipPrincipal findPrincipal(MobicentsSipServletRequest request, String authorization, Realm realm, String securityDomain) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        String tmpAuthorization = authorization.substring(7).trim();
        String[] tokens = tmpAuthorization.split(",");
        String userName = null;
        String realmName = null;
        String nOnce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;
        String method = request.getMethod();
        for (int i = 0; i < tokens.length; ++i) {
            String currentToken = tokens[i];
            if (currentToken.length() == 0) continue;
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if ("username".equals(currentTokenName)) {
                userName = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("realm".equals(currentTokenName)) {
                realmName = DigestAuthenticator.removeQuotes(currentTokenValue, true);
            }
            if ("nonce".equals(currentTokenName)) {
                nOnce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("nc".equals(currentTokenName)) {
                nc = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("cnonce".equals(currentTokenName)) {
                cnonce = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("qop".equals(currentTokenName)) {
                qop = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if ("uri".equals(currentTokenName)) {
                uri = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if (!"response".equals(currentTokenName)) continue;
            response = DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        if (userName == null || realmName == null || nOnce == null || uri == null || response == null) {
            return null;
        }
        String a2 = method + ":" + uri;
        byte[] buffer = null;
        MessageDigest equalSign = md5Helper;
        synchronized (equalSign) {
            buffer = md5Helper.digest(a2.getBytes());
        }
        String md5a2 = MD5Encoder.encode((byte[])buffer);
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Security Domain " + securityDomain + " for Realm " + realmName));
            }
            if (securityDomain == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Security Domain is null using default security domain sip-servlets for Realm " + realmName));
                }
                securityDomain = "sip-servlets";
            }
            sc = SecurityActions.createSecurityContext(securityDomain);
            SecurityActions.setSecurityContextOnAssociation(sc);
        }
        try {
            CatalinaSipPrincipal catalinaSipPrincipal = new CatalinaSipPrincipal(realm.authenticate(userName, response, nOnce, nc, cnonce, qop, realmName, md5a2));
            return catalinaSipPrincipal;
        }
        finally {
            SecurityActions.clearSecurityContext();
            SecurityRolesAssociation.setSecurityRoles(null);
        }
    }

    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        String tmpAuthorization = authorization.substring(7).trim();
        StringTokenizer commaTokenizer = new StringTokenizer(tmpAuthorization, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String currentToken = commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if (!"username".equals(currentTokenName)) continue;
            return DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        return null;
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return "";
    }

    protected static String removeQuotes(String quotedString) {
        return DigestAuthenticator.removeQuotes(quotedString, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateNOnce(MobicentsSipServletRequest request) {
        long currentTime = System.currentTimeMillis();
        String nOnceValue = request.getRemoteAddr() + ":" + currentTime + ":" + this.key;
        byte[] buffer = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(nOnceValue.getBytes());
        }
        nOnceValue = MD5Encoder.encode((byte[])buffer);
        return nOnceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAuthenticateHeader(MobicentsSipServletRequest request, MobicentsSipServletResponse response, MobicentsSipLoginConfig config, String nOnce) {
        String realmName = ((SipLoginConfig)config).getRealmName();
        if (realmName == null) {
            realmName = request.getServerName() + ":" + request.getServerPort();
        }
        byte[] buffer = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(nOnce.getBytes());
        }
        String authenticateHeader = "Digest realm=\"" + realmName + "\", " + "qop=\"auth\", nonce=\"" + nOnce + "\", " + "opaque=\"" + MD5Encoder.encode((byte[])buffer) + "\"";
        if (response.getStatus() == 407) {
            response.setHeader("Proxy-Authenticate", authenticateHeader);
        } else {
            response.setHeader("WWW-Authenticate", authenticateHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationHeader getAuthorizationHeader(String method, String uri, String requestBody, Header authHeader, String username, String password, String nonce, int nc) {
        String response = null;
        boolean isResponseHeader = true;
        WWWAuthenticateHeader wwwAuthenticateHeader = null;
        if (authHeader instanceof WWWAuthenticateHeader) {
            wwwAuthenticateHeader = (WWWAuthenticateHeader)authHeader;
        }
        AuthorizationHeader authorizationHeader = null;
        if (authHeader instanceof AuthorizationHeader) {
            authorizationHeader = (AuthorizationHeader)authHeader;
            isResponseHeader = false;
        }
        String qopList = null;
        qopList = isResponseHeader ? wwwAuthenticateHeader.getQop() : authorizationHeader.getQop();
        String algorithm = null;
        algorithm = isResponseHeader ? wwwAuthenticateHeader.getAlgorithm() : authorizationHeader.getAlgorithm();
        String realm = null;
        realm = isResponseHeader ? wwwAuthenticateHeader.getRealm() : authorizationHeader.getRealm();
        String scheme = null;
        scheme = isResponseHeader ? wwwAuthenticateHeader.getScheme() : authorizationHeader.getScheme();
        String opaque = null;
        opaque = isResponseHeader ? wwwAuthenticateHeader.getOpaque() : authorizationHeader.getOpaque();
        String qop = qopList != null ? "auth" : null;
        String nc_value = String.format("%08x", nc);
        long currentTime = System.currentTimeMillis();
        String nOnceValue = currentTime + ":" + "mobicents" + response;
        byte[] buffer = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(nOnceValue.getBytes());
        }
        String cnonce = MD5Encoder.encode((byte[])buffer);
        try {
            response = MessageDigestResponseAlgorithm.calculateResponse(algorithm, username, realm, password, nonce, nc_value, cnonce, method, uri, requestBody, qop);
        }
        catch (NullPointerException exc) {
            throw new IllegalStateException("The authenticate header was malformatted", exc);
        }
        Object authorization = null;
        try {
            authorization = authHeader instanceof ProxyAuthenticateHeader || authHeader instanceof ProxyAuthorizationHeader ? this.headerFactory.createProxyAuthorizationHeader(scheme) : this.headerFactory.createAuthorizationHeader(scheme);
            authorization.setUsername(username);
            authorization.setRealm(realm);
            authorization.setNonce(nonce);
            authorization.setParameter("uri", uri);
            authorization.setResponse(response);
            if (algorithm != null) {
                authorization.setAlgorithm(algorithm);
            }
            if (opaque != null && opaque.length() > 0) {
                authorization.setOpaque(opaque);
            }
            if (qop != null) {
                authorization.setQop(qop);
                authorization.setCNonce(cnonce);
                authorization.setNonceCount(Integer.parseInt(nc_value, 16));
            }
            authorization.setResponse(response);
        }
        catch (ParseException ex) {
            throw new SecurityException("Failed to create an authorization header!", ex);
        }
        return authorization;
    }

    public SipPrincipal getPrincipal() {
        return this.principal;
    }

    public void logout(Request arg0) throws ServletException {
    }

    public boolean authenticate(Request request, HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(Request request, String username, String password) throws ServletException {
    }

    static {
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

