/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina.security.authentication;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Context;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.security.MobicentsSipLoginConfig;
import org.mobicents.servlet.sip.core.security.SipPrincipal;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;

public abstract class AuthenticatorBase
implements Authenticator {
    private static final Logger log = Logger.getLogger(AuthenticatorBase.class);
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected String algorithm = "MD5";
    protected boolean cache = true;
    protected Context context = null;
    protected MessageDigest digest = null;
    protected String entropy = null;
    protected static final String INFO = "org.apache.catalina.authenticator.AuthenticatorBase/1.0";
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        this.entropy = entropy;
    }

    public String getInfo() {
        return INFO;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    protected abstract boolean authenticate(MobicentsSipServletRequest var1, MobicentsSipServletResponse var2, MobicentsSipLoginConfig var3, String var4) throws IOException;

    protected synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    this.digest = null;
                }
            }
        }
        return this.digest;
    }

    protected synchronized Random getRandom() {
        if (this.random == null) {
            try {
                Class<?> clazz = Class.forName(this.randomClass);
                this.random = (Random)clazz.newInstance();
                long seed = System.currentTimeMillis();
                char[] entropy = this.getEntropy().toCharArray();
                for (int i = 0; i < entropy.length; ++i) {
                    long update = (byte)entropy[i] << i % 8 * 8;
                    seed ^= update;
                }
                this.random.setSeed(seed);
            }
            catch (Exception e) {
                this.random = new Random();
            }
        }
        return this.random;
    }

    protected void register(MobicentsSipServletRequest request, MobicentsSipServletResponse response, SipPrincipal principal, String authType, String username, String password) {
        if (log.isDebugEnabled()) {
            String name = principal == null ? "none" : principal.getName();
            log.debug((Object)("Authenticated '" + name + "' with type '" + authType + "'"));
        }
        request.setUserPrincipal(principal);
        MobicentsSipSession session = request.getSipSession();
        if (session != null) {
            session.setUserPrincipal(principal);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

