/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina.rules.request;

import javax.servlet.sip.SipURI;
import javax.servlet.sip.TelURL;
import javax.servlet.sip.URI;
import org.mobicents.servlet.sip.catalina.rules.request.Extractor;

public class Tel
implements Extractor {
    public Tel(String token) {
        if (!token.equals("uri")) {
            throw new IllegalArgumentException("Invalid expression: tel after " + token);
        }
    }

    @Override
    public Object extract(Object input) {
        URI uri = (URI)input;
        if (uri.isSipURI()) {
            SipURI sipuri = (SipURI)uri;
            if ("phone".equals(sipuri.getParameter("user"))) {
                return this.stripVisuals(sipuri.getUser());
            }
        } else if ("tel".equals(uri.getScheme())) {
            return this.stripVisuals(((TelURL)uri).getPhoneNumber());
        }
        return null;
    }

    private String stripVisuals(String s) {
        StringBuffer buf = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ("-.()".indexOf(c) >= 0) continue;
            buf.append(c);
        }
        return buf.toString();
    }
}

