/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina.rules;

import javax.servlet.sip.SipServletRequest;
import org.mobicents.servlet.sip.catalina.rules.RequestRule;
import org.mobicents.servlet.sip.core.descriptor.MatchingRule;

public class ContainsRule
extends RequestRule
implements MatchingRule {
    private String value;
    private boolean ignoreCase;

    public ContainsRule(String var, String value, boolean ignoreCase) {
        super(var);
        this.value = value;
        if (ignoreCase) {
            this.value = value.toLowerCase();
        }
        this.ignoreCase = ignoreCase;
    }

    public boolean matches(SipServletRequest request) {
        String requestValue = this.getValue(request);
        if (requestValue == null) {
            return false;
        }
        if (this.ignoreCase) {
            requestValue = requestValue.toLowerCase();
        }
        return requestValue.indexOf(this.value) != -1;
    }

    public String getExpression() {
        return "(" + this.getVarName() + " contains " + this.value + ")";
    }
}

