/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina;

import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardEngine;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipService;

public class SipStandardEngine
extends StandardEngine {
    private static final long serialVersionUID = 1L;
    private static final String INFO = "org.mobicents.servlet.sip.startup.SipStandardEngine/1.0";

    public void addChild(Container child) {
        if (child instanceof Host) {
            SipService sipService;
            SipApplicationDispatcher sipApplicationDispatcher;
            Host host = (Host)child;
            String hostName = host.getName();
            String[] aliases = host.findAliases();
            if (this.getService() instanceof SipService && (sipApplicationDispatcher = (sipService = (SipService)this.getService()).getSipApplicationDispatcher()) != null) {
                sipApplicationDispatcher.addHostName(hostName);
                for (String alias : aliases) {
                    sipService.getSipApplicationDispatcher().addHostName(alias);
                }
            }
            if ("org.jboss.web.tomcat.service.deployers.JBossContextConfig".equals(host.getConfigClass())) {
                host.setConfigClass("org.mobicents.servlet.sip.startup.jboss.SipJBossContextConfig");
            }
        }
        super.addChild(child);
    }

    public void removeChild(Container child) {
        if (child instanceof Host) {
            SipService sipService;
            SipApplicationDispatcher sipApplicationDispatcher;
            Host host = (Host)child;
            String hostName = host.getName();
            String[] aliases = host.findAliases();
            if (this.getService() instanceof SipService && (sipApplicationDispatcher = (sipService = (SipService)this.getService()).getSipApplicationDispatcher()) != null) {
                sipApplicationDispatcher.removeHostName(hostName);
                for (String alias : aliases) {
                    sipService.getSipApplicationDispatcher().removeHostName(alias);
                }
            }
        }
        super.removeChild(child);
    }

    public void start() throws LifecycleException {
        SipService sipService;
        SipApplicationDispatcher sipApplicationDispatcher;
        super.start();
        if (this.getService() instanceof SipService && (sipApplicationDispatcher = (sipService = (SipService)this.getService()).getSipApplicationDispatcher()) != null) {
            for (Object child : this.children.values()) {
                Host host = (Host)child;
                String hostName = host.getName();
                String[] aliases = host.findAliases();
                sipApplicationDispatcher.addHostName(hostName);
                for (String alias : aliases) {
                    sipService.getSipApplicationDispatcher().addHostName(alias);
                }
            }
        }
    }
}

