/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.catalina;

import java.util.EventListener;
import javax.servlet.sip.annotation.SipServlet;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.core.MobicentsSipServlet;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.session.SipListenersHolder;

public class CatalinaSipListenersHolder
extends SipListenersHolder {
    private static final Logger logger = Logger.getLogger(CatalinaSipListenersHolder.class);

    public CatalinaSipListenersHolder(SipContext sipContext) {
        super(sipContext);
    }

    public boolean loadListeners(String[] listeners, ClassLoader classLoader) {
        for (String className : listeners) {
            try {
                Class<?> listenerClass = Class.forName(className, false, classLoader);
                EventListener listener = (EventListener)listenerClass.newInstance();
                MobicentsSipServlet sipServletImpl = this.sipContext.findSipServletByClassName(className);
                if (sipServletImpl != null) {
                    listener = (EventListener)sipServletImpl.allocate();
                    this.listenerServlets.put(listener, sipServletImpl);
                } else {
                    SipServlet servlet = listenerClass.getAnnotation(SipServlet.class);
                    if (servlet != null && (sipServletImpl = this.sipContext.findSipServletByName(servlet.name())) != null) {
                        listener = (EventListener)sipServletImpl.allocate();
                        this.listenerServlets.put(listener, sipServletImpl);
                    }
                }
                this.addListenerToBunch(listener);
            }
            catch (Exception e) {
                logger.fatal((Object)("Cannot instantiate listener class " + className), (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

