/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.subsystem;

import java.util.List;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactory;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactoryRegistry;
import org.jboss.as.cmp.subsystem.AbstractKeyGeneratorResourceDefinition;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

abstract class AbstractKeyGeneratorAdd
extends AbstractAddStepHandler {
    AbstractKeyGeneratorAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        final Service<KeyGeneratorFactory> keyGeneratorFactory = this.getKeyGeneratorFactory(context, model);
        ServiceBuilder factoryServiceBuilder = context.getServiceTarget().addService(this.getServiceName(name), keyGeneratorFactory).addDependency(KeyGeneratorFactoryRegistry.SERVICE_NAME, KeyGeneratorFactoryRegistry.class, KeyGeneratorFactoryRegistry.getRegistryInjector(name, keyGeneratorFactory)).addListener((ServiceListener)verificationHandler);
        this.addDependencies(operation, keyGeneratorFactory, (ServiceBuilder<KeyGeneratorFactory>)factoryServiceBuilder);
        ModelNode jndiNode = AbstractKeyGeneratorResourceDefinition.JNDI_NAME.resolveModelAttribute(context, model);
        if (jndiNode.isDefined()) {
            String jndiName = jndiNode.asString();
            ContextListAndJndiViewManagedReferenceFactory valueManagedReferenceFactory = new ContextListAndJndiViewManagedReferenceFactory(){

                public String getJndiViewInstanceValue() {
                    return String.valueOf(this.getReference().getInstance());
                }

                public String getInstanceClassName() {
                    Object value = this.getReference().getInstance();
                    return value != null ? value.getClass().getName() : ContextListManagedReferenceFactory.DEFAULT_INSTANCE_CLASS_NAME;
                }

                public ManagedReference getReference() {
                    return new ValueManagedReference((Value)new ImmediateValue(keyGeneratorFactory.getValue()));
                }
            };
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            BinderService keyGenFactoryBinderService = new BinderService(bindInfo.getBindName());
            ServiceBuilder keyGenFactoryBinderBuilder = context.getServiceTarget().addService(bindInfo.getBinderServiceName(), (Service)keyGenFactoryBinderService).addInjection(keyGenFactoryBinderService.getManagedObjectInjector(), (Object)valueManagedReferenceFactory).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, keyGenFactoryBinderService.getNamingStoreInjector());
            newControllers.add(keyGenFactoryBinderBuilder.install());
        }
        newControllers.add(factoryServiceBuilder.install());
    }

    protected abstract Service<KeyGeneratorFactory> getKeyGeneratorFactory(OperationContext var1, ModelNode var2) throws OperationFailedException;

    protected abstract ServiceName getServiceName(String var1);

    protected void addDependencies(ModelNode operation, Service<KeyGeneratorFactory> keyGeneratorFactory, ServiceBuilder<KeyGeneratorFactory> factoryServiceBuilder) {
    }
}

