/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.lang.reflect.Method;
import org.jboss.as.cmp.CmpMessages;

public final class JDBCValuePropertyMetaData {
    private String propertyName;
    private Class<?> propertyType;
    private String columnName;
    private String sqlType;
    private int jdbcType;
    private boolean notNull;
    private Method getter;
    private Method setter;

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getJDBCType() {
        return this.jdbcType;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    private static String toGetterName(String propertyName) {
        return "get" + JDBCValuePropertyMetaData.upCaseFirstCharacter(propertyName);
    }

    private static String toSetterName(String propertyName) {
        return "set" + JDBCValuePropertyMetaData.upCaseFirstCharacter(propertyName);
    }

    private static String upCaseFirstCharacter(String propertyName) {
        return Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public void setPropertyName(String propertyName, Class<?> classType) {
        this.propertyName = propertyName;
        try {
            this.getter = classType.getMethod(JDBCValuePropertyMetaData.toGetterName(propertyName), new Class[0]);
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.getterNotFoundForValue(propertyName, classType.getName());
        }
        this.propertyType = this.getter.getReturnType();
        try {
            this.setter = classType.getMethod(JDBCValuePropertyMetaData.toSetterName(propertyName), this.propertyType);
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.setterNotFoundForValue(propertyName, classType.getName());
        }
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setNotNul(boolean notNull) {
        this.notNull = notNull;
    }

    public void setJdbcType(int jdbcType) {
        this.jdbcType = jdbcType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }
}

