/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javassist.util.proxy.ProxyFactory;
import org.hibernate.Session;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.tools.Pair;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;

public class Tools {
    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <E> Set<E> newHashSet() {
        return new HashSet();
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static boolean entitiesEqual(SessionImplementor session, String entityName, Object obj1, Object obj2) {
        Object id1 = Tools.getIdentifier(session, entityName, obj1);
        Object id2 = Tools.getIdentifier(session, entityName, obj2);
        return Tools.objectsEqual(id1, id2);
    }

    public static Object getIdentifier(SessionImplementor session, String entityName, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)obj;
            return hibernateProxy.getHibernateLazyInitializer().getIdentifier();
        }
        return session.getEntityPersister(entityName, obj).getIdentifier(obj, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getTargetFromProxy(SessionFactoryImplementor sessionFactoryImplementor, HibernateProxy proxy) {
        if (!proxy.getHibernateLazyInitializer().isUninitialized() || Tools.activeProxySession(proxy)) {
            return proxy.getHibernateLazyInitializer().getImplementation();
        }
        SessionImplementor sessionImplementor = proxy.getHibernateLazyInitializer().getSession();
        Session tempSession = sessionImplementor == null ? sessionFactoryImplementor.openTemporarySession() : sessionImplementor.getFactory().openTemporarySession();
        try {
            Object target;
            Object object = target = tempSession.get(proxy.getHibernateLazyInitializer().getEntityName(), proxy.getHibernateLazyInitializer().getIdentifier());
            return object;
        }
        finally {
            tempSession.close();
        }
    }

    private static boolean activeProxySession(HibernateProxy proxy) {
        Session session = (Session)proxy.getHibernateLazyInitializer().getSession();
        return session != null && session.isOpen() && session.isConnected();
    }

    public static <T> Class<T> getTargetClassIfProxied(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        if (ProxyFactory.isProxyClass(clazz)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    public static boolean objectsEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    public static boolean arraysEqual(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null || array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (!(array1[i] != null ? !array1[i].equals(array2[i]) : array2[i] != null)) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> iteratorToList(Iterator<T> iter) {
        ArrayList<T> ret = new ArrayList<T>();
        while (iter.hasNext()) {
            ret.add(iter.next());
        }
        return ret;
    }

    public static boolean iteratorsContentEqual(Iterator iter1, Iterator iter2) {
        while (iter1.hasNext() && iter2.hasNext()) {
            if (iter1.next().equals(iter2.next())) continue;
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }

    public static <T> List<Pair<Integer, T>> listToIndexElementPairList(List<T> list) {
        ArrayList<Pair<Integer, T>> ret = new ArrayList<Pair<Integer, T>>();
        Iterator<T> listIter = list.iterator();
        for (int i = 0; i < list.size(); ++i) {
            ret.add(Pair.make(i, listIter.next()));
        }
        return ret;
    }

    public static String getProperty(Properties properties, String propertyName, String legacyPropertyName, String defaultValue) {
        String value = properties.getProperty(propertyName, null);
        if (value == null) {
            return properties.getProperty(legacyPropertyName, defaultValue);
        }
        return value;
    }

    public static Class getEntityClass(SessionImplementor sessionImplementor, Session session, String entityName) {
        EntityPersister entityPersister = sessionImplementor.getFactory().getEntityPersister(entityName);
        return entityPersister.getMappedClass();
    }

    public static Object[] mapToArray(Map<String, Object> data, String[] keys) {
        Object[] ret = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            ret[i] = data.get(keys[i]);
        }
        return ret;
    }

    public static XProperty getProperty(XClass clazz, String propertyName) {
        XProperty property = Tools.getProperty(clazz, propertyName, "field");
        if (property == null) {
            property = Tools.getProperty(clazz, propertyName, "property");
        }
        return property;
    }

    public static XProperty getProperty(XClass clazz, String propertyName, String accessType) {
        for (XProperty property : clazz.getDeclaredProperties(accessType)) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }
}

