/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event;

import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.event.BaseEnversEventListener;
import org.hibernate.envers.synchronization.AuditProcess;
import org.hibernate.envers.synchronization.work.ModWorkUnit;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class EnversPostUpdateEventListenerImpl
extends BaseEnversEventListener
implements PostUpdateEventListener {
    protected EnversPostUpdateEventListenerImpl(AuditConfiguration enversConfiguration) {
        super(enversConfiguration);
    }

    public void onPostUpdate(PostUpdateEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getAuditConfiguration().getEntCfg().isVersioned(entityName)) {
            this.checkIfTransactionInProgress((SessionImplementor)event.getSession());
            AuditProcess auditProcess = this.getAuditConfiguration().getSyncManager().get(event.getSession());
            Object[] newDbState = this.postUpdateDBState(event);
            ModWorkUnit workUnit = new ModWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.getAuditConfiguration(), event.getId(), event.getPersister(), newDbState, event.getOldState());
            auditProcess.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event.getPersister(), entityName, newDbState, event.getOldState(), (SessionImplementor)event.getSession());
            }
        }
    }

    private Object[] postUpdateDBState(PostUpdateEvent event) {
        Object[] newDbState = (Object[])event.getState().clone();
        if (event.getOldState() != null) {
            EntityPersister entityPersister = event.getPersister();
            for (int i = 0; i < entityPersister.getPropertyNames().length; ++i) {
                if (entityPersister.getPropertyUpdateability()[i]) continue;
                newDbState[i] = event.getOldState()[i];
            }
        }
        return newDbState;
    }
}

