/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer.test;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.mobicents.tools.sip.balancer.BalancerRunner;
import org.mobicents.tools.sip.balancer.test.BlackholeAppServer;

public class SipBalancerUdpTest {
    static final String inviteRequest = "INVITE sip:joe@company.com SIP/2.0\r\nTo: sip:joe@company.com\r\nFrom: sip:caller@university.edu ;tag=1234\r\nCall-ID: 0ha0isnda977644900765@10.0.0.1\r\nCSeq: 9 INVITE\r\nVia: SIP/2.0/UDP 135.180.130.133\r\nContent-Type: application/sdp\r\n\r\nv=0\r\no=mhandley 29739 7272939 IN IP4 126.5.4.3\r\nc=IN IP4 135.180.130.88\r\nm=video 3227 RTP/AVP 31\r\nm=audio 4921 RTP/AVP 12\r\na=rtpmap:31 LPC\r\n";
    static byte[] inviteRequestBytes = "INVITE sip:joe@company.com SIP/2.0\r\nTo: sip:joe@company.com\r\nFrom: sip:caller@university.edu ;tag=1234\r\nCall-ID: 0ha0isnda977644900765@10.0.0.1\r\nCSeq: 9 INVITE\r\nVia: SIP/2.0/UDP 135.180.130.133\r\nContent-Type: application/sdp\r\n\r\nv=0\r\no=mhandley 29739 7272939 IN IP4 126.5.4.3\r\nc=IN IP4 135.180.130.88\r\nm=video 3227 RTP/AVP 31\r\nm=audio 4921 RTP/AVP 12\r\na=rtpmap:31 LPC\r\n".getBytes();
    static final String ringing = "SIP/2.0 180 Ringing\nTo: <sip:LittleGuy@there.com>;tag=5432\nVia: SIP/2.0/UDP 127.0.0.1:5065;branch=z9hG4bK-3530-488ff2840f609639903eff914df9870f202e2zsd,SIP/2.0/UDP 127.0.0.1:5060;branch=z9hG4bK-3530-488ff2840f609639903eff914df9870f202e2,SIP/2.0/UDP 127.0.0.1:5033;branch=z9hG4bK-3530-488ff2840f609639903eff914df9870f\nRecord-Route: <sip:127.0.0.1:5065;transport=udp;lr>,<sip:127.0.0.1:5060;transport=udp;lr>\nCSeq: 1 INVITE\nCall-ID: 202e236d75a43c17b234a992873c3c74@127.0.0.1\nFrom: <sip:BigGuy@here.com>;tag=12345\nContent-Length: 0\n";
    static byte[] ringingBytes = "SIP/2.0 180 Ringing\nTo: <sip:LittleGuy@there.com>;tag=5432\nVia: SIP/2.0/UDP 127.0.0.1:5065;branch=z9hG4bK-3530-488ff2840f609639903eff914df9870f202e2zsd,SIP/2.0/UDP 127.0.0.1:5060;branch=z9hG4bK-3530-488ff2840f609639903eff914df9870f202e2,SIP/2.0/UDP 127.0.0.1:5033;branch=z9hG4bK-3530-488ff2840f609639903eff914df9870f\nRecord-Route: <sip:127.0.0.1:5065;transport=udp;lr>,<sip:127.0.0.1:5060;transport=udp;lr>\nCSeq: 1 INVITE\nCall-ID: 202e236d75a43c17b234a992873c3c74@127.0.0.1\nFrom: <sip:BigGuy@here.com>;tag=12345\nContent-Length: 0\n".getBytes();
    BalancerRunner balancer;
    int numNodes = 2;
    BlackholeAppServer server;
    static InetAddress localhost;
    static int callIdByteStart;
    private static long n;

    protected void setUp() throws Exception {
        this.balancer = new BalancerRunner();
        Properties properties = new Properties();
        properties.setProperty("javax.sip.STACK_NAME", "SipBalancerForwarder");
        properties.setProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT", "off");
        properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "0");
        properties.setProperty("gov.nist.javax.sip.DEBUG_LOG", "logs/sipbalancerforwarderdebug.txt");
        properties.setProperty("gov.nist.javax.sip.SERVER_LOG", "logs/sipbalancerforwarder.xml");
        properties.setProperty("gov.nist.javax.sip.THREAD_POOL_SIZE", "100");
        properties.setProperty("gov.nist.javax.sip.REENTRANT_LISTENER", "true");
        properties.setProperty("gov.nist.javax.sip.CANCEL_CLIENT_TRANSACTION_CHECKED", "false");
        properties.setProperty("host", "127.0.0.1");
        properties.setProperty("externalHost", "127.0.0.1");
        properties.setProperty("internalHost", "127.0.0.1");
        properties.setProperty("internalPort", "5065");
        properties.setProperty("externalPort", "5060");
        properties.setProperty("usePrettyEncoding", "true");
        this.balancer.start(properties);
        this.server = new BlackholeAppServer("blackhole", 18452, "127.0.0.1");
        this.server.start();
        Thread.sleep(5000L);
    }

    private static void modCallId() {
        SipBalancerUdpTest.inviteRequestBytes[SipBalancerUdpTest.callIdByteStart] = (byte)(++n & 0xFFL);
        SipBalancerUdpTest.inviteRequestBytes[SipBalancerUdpTest.callIdByteStart + 1] = (byte)(n >> 8 & 0xFFL);
        SipBalancerUdpTest.inviteRequestBytes[SipBalancerUdpTest.callIdByteStart + 2] = (byte)(n >> 16 & 0xFFL);
    }

    public void testInvitePerformanceLong() {
        this.testMessagePerformance(600000, 100000, inviteRequestBytes);
    }

    public void testInvitePerformance10sec() {
        this.testMessagePerformance(10000, 100, inviteRequestBytes);
    }

    public void testInvitePerformanceDiffCallId10sec() {
        this.testDiffCallIdPerformance(10000, 100);
    }

    public void testRingingPerformance10sec() {
        this.testMessagePerformance(10000, 100, ringingBytes);
    }

    private void testMessagePerformance(int timespan, int maxLostPackets, byte[] bytes) {
        try {
            DatagramSocket socket = new DatagramSocket(33276, localhost);
            long sentPackets = 0L;
            long startTime = System.currentTimeMillis();
            while (true) {
                boolean thereIsStillTime;
                boolean diffNotTooBig = sentPackets - this.server.numPacketsReceived < (long)maxLostPackets;
                boolean bl = thereIsStillTime = System.currentTimeMillis() - startTime < (long)timespan;
                if (!thereIsStillTime) break;
                if (diffNotTooBig) {
                    socket.send(new DatagramPacket(bytes, bytes.length, localhost, 5060));
                    ++sentPackets;
                    continue;
                }
                Thread.sleep(1L);
            }
            System.out.println("Packets sent in " + timespan + " ms are " + sentPackets + "(making " + (double)sentPackets / ((double)timespan / 1000.0) + " initial requests per second)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void testDiffCallIdPerformance(int timespan, int maxLostPackets) {
        try {
            DatagramSocket socket = new DatagramSocket(33276, localhost);
            long sentPackets = 0L;
            long startTime = System.currentTimeMillis();
            while (true) {
                boolean thereIsStillTime;
                boolean diffNotTooBig = sentPackets - this.server.numPacketsReceived < (long)maxLostPackets;
                boolean bl = thereIsStillTime = System.currentTimeMillis() - startTime < (long)timespan;
                if (!thereIsStillTime) break;
                if (diffNotTooBig) {
                    socket.send(new DatagramPacket(inviteRequestBytes, inviteRequestBytes.length, localhost, 5060));
                    SipBalancerUdpTest.modCallId();
                    ++sentPackets;
                    continue;
                }
                Thread.sleep(1L);
            }
            System.out.println("Packets sent in " + timespan + " ms are " + sentPackets + "(making " + (double)sentPackets / ((double)timespan / 1000.0) + " initial requests per second)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void tearDown() throws Exception {
        this.server.stop();
        this.balancer.stop();
    }

    public static void main(String[] args) {
        try {
            SipBalancerUdpTest test = new SipBalancerUdpTest();
            test.setUp();
            String timeString = "10";
            if (args.length > 0) {
                timeString = args[0];
            }
            Integer time = Integer.parseInt(timeString);
            Integer maxDiff = Integer.parseInt(args[0]);
            test.testMessagePerformance(time * 1000, maxDiff, inviteRequestBytes);
            test.tearDown();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        callIdByteStart = -1;
        try {
            localhost = InetAddress.getByName("127.0.0.1");
            byte[] callid = "0ha0isn".getBytes();
            for (int q = 0; q < 1000; ++q) {
                int found = -1;
                int w = 0;
                while (w < callid.length && callid[w] == inviteRequestBytes[q + w]) {
                    found = w++;
                }
                if (found <= 0) continue;
                callIdByteStart = q;
                break;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        n = 0L;
    }
}

