/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer.test;

import java.util.HashSet;
import java.util.Properties;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.address.AddressFactory;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;

public class ProtocolObjects {
    public final AddressFactory addressFactory;
    public final MessageFactory messageFactory;
    public final HeaderFactory headerFactory;
    public final SipStack sipStack;
    private int logLevel = 32;
    String logFileDirectory = "logs/";
    public final String transport;
    private boolean isStarted;

    public ProtocolObjects(String stackname, String pathname, String transport, boolean autoDialog, String outboundProxy) {
        this.transport = transport;
        SipFactory sipFactory = SipFactory.getInstance();
        sipFactory.resetFactory();
        sipFactory.setPathName(pathname);
        Properties properties = new Properties();
        properties.setProperty("javax.sip.STACK_NAME", stackname);
        if (outboundProxy != null) {
            properties.setProperty("javax.sip.OUTBOUND_PROXY", outboundProxy + "/" + transport);
        }
        properties.setProperty("gov.nist.javax.sip.DEBUG_LOG", this.logFileDirectory + stackname + "debuglog.txt");
        properties.setProperty("gov.nist.javax.sip.SERVER_LOG", this.logFileDirectory + stackname + "log.xml");
        properties.setProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT", autoDialog ? "on" : "off");
        properties.setProperty("javax.sip.FORKABLE_EVENTS", "foo");
        properties.setProperty("gov.nist.javax.sip.THREAD_POOL_SIZE", "4");
        properties.setProperty("gov.nist.javax.sip.REENTRANT_LISTENER", "true");
        properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", Integer.valueOf(this.logLevel).toString());
        try {
            this.sipStack = sipFactory.createSipStack(properties);
            System.out.println("createSipStack " + this.sipStack);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            throw new RuntimeException("Stack failed to initialize");
        }
        try {
            this.headerFactory = sipFactory.createHeaderFactory();
            this.addressFactory = sipFactory.createAddressFactory();
            this.messageFactory = sipFactory.createMessageFactory();
        }
        catch (SipException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public synchronized void destroy() {
        HashSet<SipProvider> hashSet = new HashSet<SipProvider>();
        for (SipProvider sipProvider : hashSet) {
            hashSet.add(sipProvider);
        }
        for (SipProvider sipProvider : hashSet) {
            for (int j = 0; j < 5; ++j) {
                try {
                    this.sipStack.deleteSipProvider(sipProvider);
                    continue;
                }
                catch (ObjectInUseException ex) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        this.sipStack.stop();
    }

    public void start() throws Exception {
        if (this.isStarted) {
            return;
        }
        this.sipStack.start();
        this.isStarted = true;
    }
}

