/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer.test;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.sip.SipProvider;
import org.mobicents.tools.sip.balancer.NodeRegisterRMIStub;
import org.mobicents.tools.sip.balancer.SIPNode;
import org.mobicents.tools.sip.balancer.test.ProtocolObjects;

public class BlackholeAppServer {
    public ProtocolObjects protocolObjects;
    Timer timer;
    int port;
    String name;
    SIPNode appServerNode;
    public boolean sendHeartbeat = true;
    String lbAddress;
    int lbRMIport;
    int lbSIPext;
    int lbSIPint;
    public SipProvider sipProvider;
    DatagramSocket socket;
    public long numPacketsReceived;
    DatagramPacket packet = new DatagramPacket(new byte[1000], 1000);
    Thread thread;

    public BlackholeAppServer(String appServer, int port, String lbAddress, int lbRMI, int lbSIPext, int lbSIPint) {
        this.port = port;
        this.name = appServer;
        this.lbAddress = lbAddress;
        this.lbRMIport = lbRMI;
        this.lbSIPext = lbSIPext;
        this.lbSIPint = lbSIPint;
    }

    public BlackholeAppServer(String appServer, int port) {
        this(appServer, port, "127.0.0.1");
    }

    public BlackholeAppServer(String appServer, int port, String address) {
        this(appServer, port, address, 2000, 5060, 5065);
    }

    public void start() {
        this.timer = new Timer();
        try {
            this.socket = new DatagramSocket(this.port, InetAddress.getByName(this.lbAddress));
            this.thread = new Thread(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            BlackholeAppServer.this.socket.receive(BlackholeAppServer.this.packet);
                            ++BlackholeAppServer.this.numPacketsReceived;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            };
            this.thread.start();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.appServerNode = new SIPNode(this.name, "127.0.0.1");
        this.appServerNode.getProperties().put("udpPort", Integer.valueOf(this.port));
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ArrayList<SIPNode> nodes = new ArrayList<SIPNode>();
                nodes.add(BlackholeAppServer.this.appServerNode);
                BlackholeAppServer.this.sendKeepAliveToBalancers(nodes);
            }
        }, 1000L, 1000L);
    }

    public void stop() {
        try {
            this.thread.interrupt();
            this.thread.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.timer.cancel();
        this.socket.close();
        if (this.protocolObjects != null) {
            this.protocolObjects.sipStack.stop();
        }
        this.protocolObjects = null;
    }

    private void sendKeepAliveToBalancers(ArrayList<SIPNode> info) {
        if (this.sendHeartbeat) {
            Thread.currentThread().setContextClassLoader(NodeRegisterRMIStub.class.getClassLoader());
            try {
                Registry registry = LocateRegistry.getRegistry(this.lbAddress, this.lbRMIport);
                NodeRegisterRMIStub reg = (NodeRegisterRMIStub)registry.lookup("SIPBalancer");
                reg.handlePing(info);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void sendCleanShutdownToBalancers() {
        ArrayList<SIPNode> nodes = new ArrayList<SIPNode>();
        nodes.add(this.appServerNode);
        this.sendCleanShutdownToBalancers(nodes);
    }

    public void sendCleanShutdownToBalancers(ArrayList<SIPNode> info) {
        Thread.currentThread().setContextClassLoader(NodeRegisterRMIStub.class.getClassLoader());
        try {
            Registry registry = LocateRegistry.getRegistry(this.lbAddress, this.lbRMIport);
            NodeRegisterRMIStub reg = (NodeRegisterRMIStub)registry.lookup("SIPBalancer");
            reg.forceRemoval(info);
            this.stop();
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

