/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.Via;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.DefaultBalancerAlgorithm;
import org.mobicents.tools.sip.balancer.SIPNode;

public class WorstCaseUdpTestAffinityAlgorithm
extends DefaultBalancerAlgorithm {
    protected ConcurrentHashMap<String, SIPNode> txToNode = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Long> txTimestamps = new ConcurrentHashMap();
    protected boolean earlyDialogWorstCase = false;
    static int y = 0;
    private static Logger logger = Logger.getLogger((String)WorstCaseUdpTestAffinityAlgorithm.class.getCanonicalName());
    protected String headerName = "Call-ID";
    protected ConcurrentHashMap<String, SIPNode> callIdMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Long> callIdTimestamps = new ConcurrentHashMap();
    protected AtomicInteger nextNodeCounter = new AtomicInteger(0);
    protected int maxCallIdleTime = 500;
    protected boolean groupedFailover = false;
    protected Timer cacheEvictionTimer = new Timer();

    public synchronized SIPNode getNodeA(String tx) {
        return this.txToNode.get(tx);
    }

    public synchronized void setNodeA(String tx, SIPNode node) {
        this.txToNode.put(tx, node);
        this.txTimestamps.put(tx, System.currentTimeMillis());
    }

    @Override
    public SIPNode processAssignedExternalRequest(Request request, SIPNode assignedNode) {
        String callId = ((SIPHeader)request.getHeader(this.headerName)).getValue();
        CSeqHeader cs = (CSeqHeader)request.getHeader("CSeq");
        long cseq = cs.getSeqNumber();
        if (this.callIdMap.get(callId) != null) {
            assignedNode = this.callIdMap.get(callId);
        }
        ViaHeader via = (ViaHeader)request.getHeader("Via");
        String transport = via.getTransport().toLowerCase();
        RouteHeader route = (RouteHeader)request.getHeader("Route");
        SipURI uri = null;
        uri = route != null ? (SipURI)route.getAddress().getURI() : (SipURI)request.getRequestURI();
        try {
            String originalhostid;
            SipURI ruri;
            String rurihostid;
            SIPNode newNode = this.nextAvailableNode();
            if (newNode == null) {
                for (SIPNode node : this.invocationContext.nodes) {
                    if (node.equals(assignedNode)) continue;
                    newNode = node;
                }
            }
            SIPNode node = newNode;
            uri.setHost(node.getIp());
            Integer port = (Integer)node.getProperties().get(transport + "Port");
            uri.setPort(port.intValue());
            this.callIdMap.put(callId, node);
            this.setNodeA(callId + cseq, node);
            if (request.getRequestURI().isSipURI() && (rurihostid = (ruri = (SipURI)request.getRequestURI()).getHost() + ruri.getPort()).equals(originalhostid = assignedNode.getIp() + assignedNode.getProperties().get(transport + "Port"))) {
                ruri.setPort(port.intValue());
                ruri.setHost(node.getIp());
            }
            return node;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return assignedNode;
        }
    }

    @Override
    public void processInternalRequest(Request request) {
        logger.debug((Object)"internal request");
    }

    @Override
    public void processInternalResponse(Response request) {
        logger.debug((Object)"internal response");
    }

    @Override
    public void processExternalResponse(Response response) {
        String callId;
        SIPNode node2;
        BalancerContext balancerContext = this.getBalancerContext();
        Via via = (Via)response.getHeader("Via");
        String transport = via.getTransport().toLowerCase();
        String host = via.getHost();
        boolean found = false;
        for (SIPNode node2 : this.invocationContext.nodes) {
            if (!node2.getIp().equals(host)) continue;
            found = true;
        }
        if (!found) {
            callId = ((SIPHeader)response.getHeader(this.headerName)).getValue();
            node2 = this.callIdMap.get(callId);
            if (node2 == null || !this.invocationContext.nodes.contains(node2)) {
                node2 = this.selectNewNode(node2, callId);
                try {
                    via.setHost(node2.getIp());
                    String transportProperty = transport + "Port";
                    Integer port = (Integer)node2.getProperties().get(transportProperty);
                    if (port == null) {
                        throw new RuntimeException("No transport found for node " + node2 + " " + transportProperty);
                    }
                    via.setPort(port.intValue());
                }
                catch (Exception e) {
                    throw new RuntimeException("Error", e);
                }
                if (!"UDP".equalsIgnoreCase(transport)) {
                    via.setRPort();
                }
            }
        } else if (this.earlyDialogWorstCase && response.getStatusCode() > 100) {
            callId = ((SIPHeader)response.getHeader(this.headerName)).getValue();
            node2 = this.callIdMap.get(callId);
            for (int q = 0; q < 3; ++q) {
                SIPNode other = this.selectNewNode(node2, callId);
                if (other == null || other.equals(node2)) continue;
                node2 = other;
                break;
            }
            try {
                via.setHost(node2.getIp());
                String transportProperty = transport + "Port";
                Integer port = (Integer)node2.getProperties().get(transportProperty);
                if (port == null) {
                    throw new RuntimeException("No transport found for node " + node2 + " " + transportProperty);
                }
                via.setPort(port.intValue());
            }
            catch (Exception e) {
                throw new RuntimeException("Error", e);
            }
            if (!"UDP".equalsIgnoreCase(transport)) {
                via.setRPort();
            }
        }
    }

    @Override
    public SIPNode processExternalRequest(Request request) {
        String callId = ((SIPHeader)request.getHeader(this.headerName)).getValue();
        CSeqHeader cs = (CSeqHeader)request.getHeader("CSeq");
        long cseq = cs.getSeqNumber();
        SIPNode node = this.callIdMap.get(callId);
        this.callIdTimestamps.put(callId, System.currentTimeMillis());
        BalancerContext balancerContext = this.getBalancerContext();
        if (node == null) {
            node = this.nextAvailableNode();
            if (node == null) {
                return null;
            }
            this.callIdMap.put(callId, node);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No node found in the affinity map. It is null. We select new node: " + node));
            }
        } else if (!this.invocationContext.nodes.contains(node)) {
            node = this.selectNewNode(node, callId);
        } else {
            SIPNode n;
            Iterator<SIPNode> i$;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The assigned node in the affinity map is still alive: " + node));
            }
            if (!request.getMethod().equals("ACK") && (i$ = this.invocationContext.nodes.iterator()).hasNext() && !(n = i$.next()).equals(node)) {
                node = n;
            }
        }
        this.setNodeA(callId + cseq, node);
        this.callIdMap.put(callId, node);
        return node;
    }

    protected SIPNode selectNewNode(SIPNode node, String callId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The assigned node has died. This is the dead node: " + node));
        }
        if (this.groupedFailover) {
            SIPNode oldNode = node;
            if ((node = this.leastBusyTargetNode(oldNode)) == null) {
                return null;
            }
            this.groupedFailover(oldNode, node);
        } else {
            node = this.nextAvailableNode();
            if (node == null) {
                return null;
            }
            this.callIdMap.put(callId, node);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("So, we must select new node: " + node));
        }
        return node;
    }

    protected synchronized SIPNode nextAvailableNode() {
        BalancerContext balancerContext = this.getBalancerContext();
        if (this.invocationContext.nodes.size() == 0) {
            return null;
        }
        int nextNode = this.nextNodeCounter.incrementAndGet();
        return this.invocationContext.nodes.get(nextNode %= this.invocationContext.nodes.size());
    }

    protected synchronized SIPNode leastBusyTargetNode(SIPNode deadNode) {
        BalancerContext balancerContext = this.getBalancerContext();
        HashMap<SIPNode, Integer> nodeUtilization = new HashMap<SIPNode, Integer>();
        for (SIPNode node : this.callIdMap.values()) {
            Integer n = (Integer)nodeUtilization.get(node);
            if (n == null) {
                nodeUtilization.put(node, 0);
                continue;
            }
            nodeUtilization.put(node, n + 1);
        }
        int minUtil = Integer.MAX_VALUE;
        SIPNode minUtilNode = null;
        for (SIPNode node : nodeUtilization.keySet()) {
            Integer util = (Integer)nodeUtilization.get(node);
            if (node.equals(deadNode) || util >= minUtil) continue;
            minUtil = util;
            minUtilNode = node;
        }
        logger.info((Object)("Least busy node selected " + minUtilNode + " with " + minUtil + " calls"));
        return minUtilNode;
    }

    @Override
    public void init() {
        String maxTimeInCacheString = this.getProperties().getProperty("callIdAffinityMaxTimeInCache");
        if (maxTimeInCacheString != null) {
            this.maxCallIdleTime = Integer.parseInt(maxTimeInCacheString);
        }
        logger.info((Object)("Call Idle Time is " + this.maxCallIdleTime + " seconds. Inactive calls will be evicted."));
        String earlyDialogWorstCaseString = this.getProperties().getProperty("earlyDialogWorstCase");
        if (earlyDialogWorstCaseString != null) {
            this.earlyDialogWorstCase = Boolean.parseBoolean(earlyDialogWorstCaseString);
        }
        logger.info((Object)("Early dialog worst case is " + this.earlyDialogWorstCase));
        final WorstCaseUdpTestAffinityAlgorithm thisAlgorithm = this;
        this.cacheEvictionTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WorstCaseUdpTestAffinityAlgorithm worstCaseUdpTestAffinityAlgorithm = thisAlgorithm;
                    synchronized (worstCaseUdpTestAffinityAlgorithm) {
                        ArrayList<String> oldCalls = new ArrayList<String>();
                        for (String key : WorstCaseUdpTestAffinityAlgorithm.this.callIdTimestamps.keySet()) {
                            long time = WorstCaseUdpTestAffinityAlgorithm.this.callIdTimestamps.get(key);
                            if (System.currentTimeMillis() - time <= (long)(1000 * WorstCaseUdpTestAffinityAlgorithm.this.maxCallIdleTime)) continue;
                            oldCalls.add(key);
                        }
                        for (String key : oldCalls) {
                            WorstCaseUdpTestAffinityAlgorithm.this.callIdMap.remove(key);
                            WorstCaseUdpTestAffinityAlgorithm.this.callIdTimestamps.remove(key);
                        }
                        if (oldCalls.size() > 0) {
                            logger.info((Object)("Reaping idle calls... Evicted " + oldCalls.size() + " calls."));
                        }
                        oldCalls = new ArrayList();
                        for (String key : WorstCaseUdpTestAffinityAlgorithm.this.txTimestamps.keySet()) {
                            long time = WorstCaseUdpTestAffinityAlgorithm.this.txTimestamps.get(key);
                            if (System.currentTimeMillis() - time <= (long)(1000 * WorstCaseUdpTestAffinityAlgorithm.this.maxCallIdleTime)) continue;
                            oldCalls.add(key);
                        }
                        for (String key : oldCalls) {
                            WorstCaseUdpTestAffinityAlgorithm.this.txToNode.remove(key);
                            WorstCaseUdpTestAffinityAlgorithm.this.txTimestamps.remove(key);
                        }
                        if (oldCalls.size() > 0) {
                            logger.info((Object)("Reaping idle transactions... Evicted " + oldCalls.size() + " calls."));
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to clean up old calls. If you continue to se this message frequestly and the memory is growing, report this problem.", (Throwable)e);
                }
            }
        }, 0L, 6000L);
        String groupFailoverProperty = this.getProperties().getProperty("callIdAffinityGroupFailover");
        if (groupFailoverProperty != null) {
            this.groupedFailover = Boolean.parseBoolean(groupFailoverProperty);
        }
        logger.info((Object)("Grouped failover is set to " + this.groupedFailover));
    }

    @Override
    public void assignToNode(String id, SIPNode node) {
        this.callIdMap.put(id, node);
        this.callIdTimestamps.put(id, System.currentTimeMillis());
    }

    @Override
    public void jvmRouteSwitchover(String fromJvmRoute, String toJvmRoute) {
        block7: {
            try {
                SIPNode oldNode = this.getBalancerContext().jvmRouteToSipNode.get(fromJvmRoute);
                SIPNode newNode = this.getBalancerContext().jvmRouteToSipNode.get(toJvmRoute);
                if (oldNode != null && newNode != null) {
                    int updatedRoutes = 0;
                    for (String key : this.callIdMap.keySet()) {
                        SIPNode n = this.callIdMap.get(key);
                        if (!n.equals(oldNode)) continue;
                        this.callIdMap.replace(key, newNode);
                        ++updatedRoutes;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Switchover occured where fromJvmRoute=" + fromJvmRoute + " and toJvmRoute=" + toJvmRoute + " with " + updatedRoutes + " updated routes."));
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)("Switchover failed where fromJvmRoute=" + fromJvmRoute + " and toJvmRoute=" + toJvmRoute));
                }
            }
            catch (Throwable t) {
                if (!logger.isInfoEnabled()) break block7;
                logger.info((Object)("Switchover failed where fromJvmRoute=" + fromJvmRoute + " and toJvmRoute=" + toJvmRoute));
                logger.info((Object)"This is not a fatal failure, logging the reason for the failure ", t);
            }
        }
    }

    public synchronized void groupedFailover(SIPNode oldNode, SIPNode newNode) {
        block7: {
            try {
                if (oldNode != null && newNode != null) {
                    int updatedRoutes = 0;
                    for (String key : this.callIdMap.keySet()) {
                        SIPNode n = this.callIdMap.get(key);
                        if (!n.equals(oldNode)) continue;
                        this.callIdMap.replace(key, newNode);
                        ++updatedRoutes;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Switchover occured where oldNode=" + oldNode + " and newNode=" + newNode + " with " + updatedRoutes + " updated routes."));
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)("Switchover failed where fromJvmRoute=" + oldNode + " and toJvmRoute=" + newNode));
                }
            }
            catch (Throwable t) {
                if (!logger.isInfoEnabled()) break block7;
                logger.info((Object)("Switchover failed where fromJvmRoute=" + oldNode + " and toJvmRoute=" + newNode));
                logger.info((Object)"This is not a fatal failure, logging the reason for the failure ", t);
            }
        }
    }
}

