/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;

public class UDPPacketForwarder {
    int fromPort;
    int toPort;
    String bindAddress;
    boolean running;
    DatagramSocket fromSocket;
    Thread worker;
    String destinations;
    public LinkedList<String> sipMessages;
    public HashSet<String> sipMessageWithoutRetrans;
    static long next = 0L;

    public UDPPacketForwarder(int fromPort, String destinations, String bind) {
        this.fromPort = fromPort;
        this.bindAddress = bind;
        this.destinations = destinations;
        this.sipMessages = new LinkedList();
        this.sipMessageWithoutRetrans = new HashSet();
    }

    public void setDestinations(String destinations) {
        this.destinations = destinations;
    }

    public void start() {
        try {
            this.fromSocket = new DatagramSocket(this.fromPort, InetAddress.getByName(this.bindAddress));
            this.running = true;
            this.worker = new Thread(){

                @Override
                public void run() {
                    while (UDPPacketForwarder.this.running) {
                        DatagramPacket packet = new DatagramPacket(new byte[3000], 3000);
                        try {
                            String port;
                            String host;
                            String dest;
                            int semi;
                            UDPPacketForwarder.this.fromSocket.receive(packet);
                            String sipMessage = new String(packet.getData());
                            UDPPacketForwarder.this.sipMessages.add(sipMessage);
                            UDPPacketForwarder.this.sipMessageWithoutRetrans.add(sipMessage);
                            ArrayList<String> list = new ArrayList<String>();
                            for (String dest2 : UDPPacketForwarder.this.destinations.split(",")) {
                                if (dest2.length() <= 2) continue;
                                list.add(dest2);
                            }
                            int size = list.size();
                            if ((semi = (dest = (String)list.get((int)(next++ % (long)size))).indexOf(58)) > 0) {
                                host = dest.substring(0, semi);
                                port = dest.substring(semi + 1);
                            } else {
                                host = dest;
                                port = "5060";
                            }
                            packet.setPort(Integer.parseInt(port));
                            UDPPacketForwarder.this.fromSocket.send(packet);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            this.worker.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Error", e);
        }
    }

    public void stop() {
        this.running = false;
        try {
            this.worker.interrupt();
            this.fromSocket.close();
            this.fromSocket = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

