/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SIPNode
implements Serializable,
Comparable<SIPNode> {
    private static final long serialVersionUID = -4959114432342926569L;
    private String hostName = null;
    private String ip = null;
    private long timeStamp = System.currentTimeMillis();
    private HashMap<String, Serializable> properties = new HashMap();

    public SIPNode(String hostName, String ip) {
        this.hostName = hostName;
        this.ip = ip;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getIp() {
        return this.ip;
    }

    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void updateTimerStamp() {
        this.timeStamp = System.currentTimeMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        for (String key : this.properties.keySet()) {
            result = 31 * result + this.properties.get(key).hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        Set<Map.Entry<String, Serializable>> set2;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SIPNode other = (SIPNode)obj;
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        Set<Map.Entry<String, Serializable>> set1 = this.properties.entrySet();
        if (!set1.containsAll(set2 = other.getProperties().entrySet())) {
            return false;
        }
        return set2.containsAll(set1);
    }

    public String toString() {
        String result = "SIPNode hostname[" + this.hostName + "] ip[" + this.ip + "] ";
        for (String key : this.properties.keySet()) {
            result = result + key + "[" + this.properties.get(key) + "] ";
        }
        return result;
    }

    public String toStringWithoutJvmroute() {
        String result = "SIPNode hostname[" + this.hostName + "] ip[" + this.ip + "] ";
        for (String key : this.properties.keySet()) {
            if (key.equals("jvmRoute")) continue;
            result = result + key + "[" + this.properties.get(key) + "] ";
        }
        return result;
    }

    @Override
    public int compareTo(SIPNode sipNode) {
        return this.toStringWithoutJvmroute().compareTo(sipNode.toStringWithoutJvmroute());
    }
}

